/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.CopyFromInterface;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.DataSourceImpl;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.AccessPathToOlapData;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.metadata.physical.OlapServer;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.Server;
import com.sas.iquery.metadata.physical.StructuredData;
import com.sas.iquery.metadata.physical.oma.OMACube;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.OLAPException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DataSourceCubeImpl
extends DataSourceImpl
implements DataSourceCube,
CopyFromInterface {
    private AccessPath _accessPath;
    private Cube _cube;
    private static final Logger _logger = LogManager.getLogger(DataSourceCubeImpl.class);

    public DataSourceCubeImpl() {
    }

    DataSourceCubeImpl(AbstractBusinessModel businessModel) {
        super(businessModel);
    }

    DataSourceCubeImpl(AbstractBusinessModel businessModel, AccessPathToOlapData inputAccessPath, Cube inputCube) throws MetadataException {
        super(businessModel);
        Preconditions.ensureNonNull(inputAccessPath, "inputAccessPath");
        Preconditions.ensureNonNull(inputCube, "inputCube");
        this.setAccessPath(inputAccessPath);
        this._cube = inputCube;
        this.setLabel(this._cube.getLabel());
        this.setDescription(this._cube.getDescription());
    }

    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        if (this._accessPath instanceof AccessPathToOlapData) {
            intoList.add(this._accessPath.getServer());
            intoList.add(this._accessPath.getSchema());
        } else {
            intoList.add(this._accessPath);
        }
        intoList.add(this._cube);
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._cube == null) {
            reasons.add(new Reason((Object)this, 2, 39, "DataSourceCubeImpl.NoCubeDefinedForDataSource.fmt.txt", this.getIdentityString()));
        }
    }

    @Override
    protected void checksForCopyingFromObject(Object obj) throws MetadataException {
        super.checksForCopyingFromObject(obj);
        DataSourceCubeImpl fromCube = (DataSourceCubeImpl)obj;
        AccessPathToOlapData fromAccessPath = fromCube.getAccessPath();
        if (!this._accessPath.equals(fromAccessPath) || this._cube != fromCube._cube) {
            MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("DataSourceCubeImpl.CannotCopyBetweenCubeDataSourceHavingDifferentServerSchemaOrCube.txt", new Object[0]);
            throw new MetadataException(formatter);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataSourceCubeImpl dsc = (DataSourceCubeImpl)super.clone();
        return dsc;
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        Server server = (Server)((Object)riHolder.consumeObject("Server", null));
        Schema schema = (Schema)((Object)riHolder.consumeObject("Schema", null));
        AccessPath accessPath = (AccessPath)riHolder.consumeObject("AccessPath", null);
        this._accessPath = server != null && schema != null ? new AccessPathToOlapData(server, schema) : accessPath;
        this._cube = (Cube)((Object)riHolder.consumeObject("Cube"));
    }

    @Override
    public void copyFrom(Object obj) throws MetadataException {
        this._copyFrom(obj);
    }

    @Override
    public AccessPath getAbstractAccessPath() {
        return this.getAccessPath();
    }

    @Override
    public AccessPathToOlapData getAccessPath() {
        return (AccessPathToOlapData)this._accessPath.copy();
    }

    @Override
    @Nonnull
    public List<AccessPath> getAccessPaths() {
        AccessPathToOlapData path = this.getAccessPath();
        assert (path != null);
        return Collections.singletonList(path);
    }

    @Override
    public Cube getCube() {
        return this._cube;
    }

    @Override
    public String getCubeName() throws MetadataException {
        return this._cube.getCubeName();
    }

    @Override
    public String getCubeType() throws MetadataException {
        return this._cube.getCubeType();
    }

    @Override
    protected String getDefaultIDPrefix() {
        return "DSC_";
    }

    @Override
    protected String getDefinitionElementName() {
        return "DataSourceCube";
    }

    @Override
    public List<Dimension> getDimensions() throws MetadataException {
        return this._cube.getDimensions();
    }

    @Override
    public List<Measure> getMeasures() throws MetadataException {
        return this._cube.getMeasures();
    }

    @Override
    public OlapSchema getOwningOlapSchema() throws MetadataException {
        return this._cube.getOwningOlapSchema();
    }

    @Override
    public StructureOfData getStructure() {
        StructureOfData sod = this._cube instanceof StructuredData ? ((StructuredData)((Object)this._cube)).getStructure() : StructureOfData.OLAP;
        return sod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDrillThroughEnabled() throws MetadataException {
        block28: {
            retValue = false;
            businessModel = this.getBusinessModel();
            computationalLocale = LocaleUtilities.getDefaultComputationalLocale(businessModel);
            olapConnection = null;
            meta = null;
            try {
                policy = new RetrievalPolicy();
                policy.getConnectionConfiguration().setConnectionLifetime(0);
                olapConnection = OLAPConnectionInfoUtil.getConnection(businessModel, policy, computationalLocale);
                ** GOTO lbl-1000
            }
            catch (IQueryServicesException e) {
                messageFormatter = IQModelImplUtilities.getMessageFormatter("DataSourceTableImpl.NoMetadataInterfaceRetrieval.fmt.txt", new Object[]{this.getServer().getLabel()});
                if (DataSourceCubeImpl._logger.isEnabled(Level.WARN)) {
                    DataSourceCubeImpl._logger.warn(messageFormatter.toString(), (Throwable)e);
                }
                var8_12 = false;
                if (meta != null) {
                    BusinessQueryOLAPUtil.releaseMetadataInterface(meta);
                }
                if (olapConnection == null) return var8_12;
                ConnectionResources.close(olapConnection);
                return var8_12;
            }
            {
                block26: {
                    block24: {
                        block25: {
                            catch (Throwable var11_25) {
                                if (meta != null) {
                                    BusinessQueryOLAPUtil.releaseMetadataInterface(meta);
                                }
                                if (olapConnection == null) throw var11_25;
                                ConnectionResources.close(olapConnection);
                                throw var11_25;
                            }
lbl-1000:
                            // 1 sources

                            {
                                if (olapConnection != null) break block24;
                                if (DataSourceCubeImpl._logger.isEnabled(Level.WARN)) {
                                    msg = IQDataServicesResourceBundle.getStringResource("OLAPConnectionInfoUtilBadDataSource.txt");
                                    e = new MetadataException(msg);
                                    DataSourceCubeImpl._logger.warn(msg, (Throwable)e);
                                }
                                msg = false;
                                if (meta == null) break block25;
                            }
                            BusinessQueryOLAPUtil.releaseMetadataInterface(meta);
                        }
                        if (olapConnection == null) return msg;
                        ConnectionResources.close(olapConnection);
                        return msg;
                    }
                    cube = this.getCube();
                    constructor = "IGNOREISESSION";
                    try {
                        meta = olapConnection.createMetadataInterface(businessModel, constructor, cube, false, false, null);
                    }
                    catch (GenerationException e) {
                        if (DataSourceCubeImpl._logger.isEnabled(Level.WARN)) {
                            mf = IQModelImplUtilities.getMessageFormatter("DataSourceTableImpl.NoMetadataInterfaceRetrieval.fmt.txt", new Object[]{this.getServer().getLabel()});
                            DataSourceCubeImpl._logger.warn(mf.toString(), (Throwable)e);
                        }
                        mf = false;
                        if (meta != null) {
                            BusinessQueryOLAPUtil.releaseMetadataInterface(meta);
                        }
                        if (olapConnection == null) return mf;
                        ConnectionResources.close(olapConnection);
                        return mf;
                    }
                    catch (ExecutionException e) {}
                    {
                        if (DataSourceCubeImpl._logger.isEnabled(Level.WARN)) {
                            messageFormatter = IQModelImplUtilities.getMessageFormatter("DataSourceTableImpl.NoMetadataInterfaceRetrieval.fmt.txt", new Object[]{this.getServer().getLabel()});
                            DataSourceCubeImpl._logger.warn(messageFormatter.toString(), (Throwable)e);
                        }
                        messageFormatter = false;
                        if (meta == null) break block26;
                    }
                    BusinessQueryOLAPUtil.releaseMetadataInterface(meta);
                }
                if (olapConnection == null) return messageFormatter;
                ConnectionResources.close(olapConnection);
                return messageFormatter;
            }
            {
                block27: {
                    try {
                        f = new Filter();
                        f.setCubeName(this.getCubeName());
                        cubes = meta.getCubes(f);
                        if (cubes != null && cubes.length > 0) {
                            retValue = cubes[0].isDrillThroughEnabled();
                            break block27;
                        }
                        if (DataSourceCubeImpl._logger.isEnabled(Level.WARN)) {
                            messageFormatter = IQModelImplUtilities.getMessageFormatter("DataSourceTableImpl.NoCubesFoundForName.fmt.txt", new Object[]{this.getCubeName()});
                            DataSourceCubeImpl._logger.warn(messageFormatter.toString());
                        }
                    }
                    catch (OLAPException e) {
                        if (DataSourceCubeImpl._logger.isEnabled(Level.WARN)) {
                            messageFormatter = IQModelImplUtilities.getMessageFormatter("DataSourceTableImpl.NoMetadataInterfaceRetrieval.fmt.txt", new Object[]{this.getLabel()});
                            DataSourceCubeImpl._logger.warn(messageFormatter.toString(), (Throwable)e);
                        }
                        var9_23 = false;
                        if (meta != null) {
                            BusinessQueryOLAPUtil.releaseMetadataInterface(meta);
                        }
                        if (olapConnection == null) return var9_23;
                        ConnectionResources.close(olapConnection);
                        return var9_23;
                    }
                }
                if (meta == null) break block28;
            }
            BusinessQueryOLAPUtil.releaseMetadataInterface(meta);
        }
        if (olapConnection == null) return retValue;
        ConnectionResources.close(olapConnection);
        return retValue;
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        OlapServer server = (OlapServer)((Object)DataSourceCubeImpl.v1_readItemUnderSubelement(thisElement, readingContext, "Server", new Class[]{OlapServer.class}));
        OlapSchema schema = (OlapSchema)((Object)DataSourceCubeImpl.v1_readItemUnderSubelement(thisElement, readingContext, "Schema", new Class[]{OlapSchema.class}));
        this._cube = (Cube)((Object)DataSourceCubeImpl.v1_readItemUnderSubelement(thisElement, readingContext, "Cube", new Class[]{Cube.class}));
        if (schema == null) {
            schema = this._cube.getOwningOlapSchema();
        }
        this._accessPath = new AccessPathToOlapData(server, schema);
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        if (this._accessPath instanceof AccessPathToOlapData) {
            Schema newSchema;
            Schema oldSchema;
            Server newServer;
            Server oldServer = this._accessPath.getServer();
            if (oldServer != (newServer = (Server)DataSourceCubeImpl.replace(oldServer, oldObject, newObject))) {
                this._accessPath.setServer(newServer);
            }
            if ((oldSchema = this._accessPath.getSchema()) != (newSchema = (Schema)DataSourceCubeImpl.replace(oldSchema, oldObject, newObject))) {
                this._accessPath.setSchema(newSchema);
            }
        } else {
            this._accessPath = (AccessPath)DataSourceCubeImpl.replace(this._accessPath, oldObject, newObject);
        }
        this._cube = (Cube)DataSourceCubeImpl.replace(this._cube, oldObject, newObject);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this.changeableCheck();
        super.replaceResource(oldResource, newResource, model, recursive);
        this._accessPath = (AccessPath)Utils.replaceResource(this._accessPath, oldResource, newResource, model, recursive);
        this._cube = (Cube)Utils.replaceResource(this._cube, oldResource, newResource, model, recursive);
    }

    @Override
    public void setAccessPath(AccessPathToOlapData path) throws MetadataException {
        Preconditions.ensureNonNull(path, "cube access path");
        this._accessPath = path.copy();
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        if (this._accessPath instanceof AccessPathToOlapData) {
            Server server = this._accessPath.getServer();
            Schema schema = this._accessPath.getSchema();
            DataSourceCubeImpl.writeRelatedObject(server, thisElement, writingContext, "Server");
            DataSourceCubeImpl.writeRelatedObject(schema, thisElement, writingContext, "Schema");
        } else {
            DataSourceCubeImpl.writeRelatedObject(this._accessPath, thisElement, writingContext, "AccessPath");
            writingContext.adjustModelVersion(ModelVersion.VERSION_94);
        }
        DataSourceCubeImpl.writeRelatedObject(this._cube, thisElement, writingContext, "Cube");
    }

    @Override
    public boolean isOLAPCubeBuilt() {
        boolean returnValue = false;
        if (this._cube instanceof OMACube) {
            returnValue = this._cube.isOLAPCubeBuilt();
        }
        return returnValue;
    }
}

