/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.IQueryServicesIllegalStateException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.LocalizableNamedObjectInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataUnresolvedException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.CopyFromInterface;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemExtendedType;
import com.sas.iquery.metadata.business.FolderItem;
import com.sas.iquery.metadata.business.Lookup;
import com.sas.iquery.metadata.business.LookupByDataItem;
import com.sas.iquery.metadata.business.LookupByQuery;
import com.sas.iquery.metadata.business.LookupList;
import com.sas.iquery.metadata.business.LookupNotAllowed;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractDataItem;
import com.sas.iquery.metadata.business.impl.AbstractEnumerationObject;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.OlapDataItemSortCriteria;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.expr.AbstractTimeValueExpression;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.DataItemContainerExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.OLAPResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNode;
import com.sas.iquery.metadata.expr.iqtextparser.ParserUtil;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifier;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.CalculatedMember;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.NamedSet;
import com.sas.iquery.metadata.physical.OlapItem;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.serverprop.Category;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.metadata.serverprop.ParameterType;
import com.sas.iquery.metadata.serverprop.ServerAttribute;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.metadata.serverprop.formats.SASFormatAttributes;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescription;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptionUtil;
import com.sas.iquery.metadata.serverprop.formats.SASFormatException;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.session.SessionContextInterface;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.util.LocalizableString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DataItemImpl
extends AbstractDataItem
implements DataItem,
RootDataItem,
FolderItem,
CopyFromInterface {
    private ExpressionInterface expression;
    private String format;
    private DataItemActionType sortDirection = DataItemActionType.SORT_NONE;
    private OlapDataItemSortCriteria sortCriteria;
    public DataItemActionType groupFormatting = DataItemActionType.GROUP_FORMATTING_BY_DEFAULT_BEHAVIOR;
    public DataItemActionType sortFormatting = DataItemActionType.SORT_FORMATTING_BY_DEFAULT_BEHAVIOR;
    private DataItemActionType usage;
    private boolean formattingForced;
    private List<DataItemActionType> validActions = new ArrayList<DataItemActionType>(0);
    private List<DataItemActionType> _disabledActions = new ArrayList<DataItemActionType>(0);
    private List<Function> validAggregationTypes = new ArrayList<Function>(0);
    private List<Function> _disabledAggregationTypes = new ArrayList<Function>(0);
    private Function aggregationType;
    private List<StepInterface> steps = new ArrayList<StepInterface>(0);
    private String resultSetID;
    private Lookup lookupType = LookupByDataItem.VALUE;
    private DataItemExtendedType extendedType = DataItemExtendedType.NONE;
    private StructureOfDataItem dataItemStructure;
    private List<String> memberProperties = new ArrayList<String>(0);
    private com.sas.iquery.metadata.physical.Level startingLevel = null;
    private String labelStartingLevel = null;
    private Function defaultInitialAggregation = null;
    private static final Logger _logger = LogManager.getLogger(DataItemImpl.class);
    private static final Level WARN_LEVEL = Level.WARN;
    private static final Level ERROR_LEVEL = Level.ERROR;
    private static final String LOOKUP_BY_THIS_DATAITEM = "ByThis";
    private static final String LOOKUP_BY_STATIC_LIST = "LookupList";
    private static final DataItemActionType[] unAggrColumnActions = new DataItemActionType[]{DataItemActionType.SORT_ASCENDING, DataItemActionType.SORT_DESCENDING, DataItemActionType.SORT_NONE, DataItemActionType.STEP_RANK, DataItemActionType.USAGE_DETAIL, DataItemActionType.USAGE_CATEGORY, DataItemActionType.USAGE_AGGREGATE, DataItemActionType.OTHER_LOOKUP, DataItemActionType.OTHER_FORMAT, DataItemActionType.SORT_FORMATTING_BY_DEFAULT_BEHAVIOR, DataItemActionType.SORT_FORMATTING_BY_FORMATTED_VALUES, DataItemActionType.SORT_FORMATTING_BY_UNFORMATTED_VALUES, DataItemActionType.GROUP_FORMATTING_BY_DEFAULT_BEHAVIOR, DataItemActionType.GROUP_FORMATTING_BY_FORMATTED_VALUES, DataItemActionType.GROUP_FORMATTING_BY_UNFORMATTED_VALUES};
    private static final List<DataItemActionType> VALID_ACTIONS_FOR_UNAGGREGATED_COLUMN_BASED_DATA_ITEMS = Collections.unmodifiableList(Arrays.asList(unAggrColumnActions));
    private static final DataItemActionType[] aggrColumnActions = new DataItemActionType[]{DataItemActionType.SORT_ASCENDING, DataItemActionType.SORT_DESCENDING, DataItemActionType.SORT_NONE, DataItemActionType.STEP_RANK, DataItemActionType.USAGE_AGGREGATE, DataItemActionType.OTHER_LOOKUP, DataItemActionType.OTHER_FORMAT, DataItemActionType.SORT_FORMATTING_BY_DEFAULT_BEHAVIOR, DataItemActionType.SORT_FORMATTING_BY_FORMATTED_VALUES, DataItemActionType.SORT_FORMATTING_BY_UNFORMATTED_VALUES};
    private static final List<DataItemActionType> VALID_ACTIONS_FOR_AGGREGATED_COLUMN_BASED_DATA_ITEMS = Collections.unmodifiableList(Arrays.asList(aggrColumnActions));
    private static final DataItemActionType[] aggFotActions = new DataItemActionType[]{DataItemActionType.SORT_ASCENDING, DataItemActionType.SORT_DESCENDING, DataItemActionType.SORT_NONE, DataItemActionType.STEP_RANK, DataItemActionType.USAGE_DETAIL, DataItemActionType.USAGE_AGGREGATE, DataItemActionType.OTHER_LOOKUP, DataItemActionType.OTHER_FORMAT, DataItemActionType.SORT_FORMATTING_BY_DEFAULT_BEHAVIOR, DataItemActionType.SORT_FORMATTING_BY_FORMATTED_VALUES, DataItemActionType.SORT_FORMATTING_BY_UNFORMATTED_VALUES};
    private static final List<DataItemActionType> VALID_ACTIONS_FOR_FRACTION_OF_TOTAL_DATA_ITEMS = Collections.unmodifiableList(Arrays.asList(aggFotActions));
    private static final DataItemActionType[] constantColumnActions = new DataItemActionType[]{DataItemActionType.SORT_ASCENDING, DataItemActionType.SORT_DESCENDING, DataItemActionType.SORT_NONE, DataItemActionType.STEP_RANK, DataItemActionType.USAGE_DETAIL, DataItemActionType.USAGE_CATEGORY, DataItemActionType.USAGE_AGGREGATE, DataItemActionType.OTHER_FORMAT, DataItemActionType.SORT_FORMATTING_BY_DEFAULT_BEHAVIOR, DataItemActionType.SORT_FORMATTING_BY_FORMATTED_VALUES, DataItemActionType.SORT_FORMATTING_BY_UNFORMATTED_VALUES, DataItemActionType.GROUP_FORMATTING_BY_DEFAULT_BEHAVIOR, DataItemActionType.GROUP_FORMATTING_BY_FORMATTED_VALUES, DataItemActionType.GROUP_FORMATTING_BY_UNFORMATTED_VALUES};
    private static final List<DataItemActionType> VALID_ACTIONS_FOR_CONSTANT_COLUMN_BASED_DATA_ITEMS = Collections.unmodifiableList(Arrays.asList(constantColumnActions));
    private static final DataItemActionType[] dimensionActions = new DataItemActionType[]{DataItemActionType.STEP_MEMBER_FILTER, DataItemActionType.STEP_MEMBER_PROPERTY_FILTER, DataItemActionType.STEP_DATE_FILTER, DataItemActionType.STEP_DATABASED_FILTER, DataItemActionType.STEP_RANK, DataItemActionType.STEP_NAVIGATE, DataItemActionType.SORT_ASCENDING, DataItemActionType.SORT_DESCENDING, DataItemActionType.SORT_HIERARCHICAL_ASCENDING, DataItemActionType.SORT_HIERARCHICAL_DESCENDING, DataItemActionType.SORT_NONE, DataItemActionType.SORT_CRITERIA, DataItemActionType.USAGE_DETAIL, DataItemActionType.USAGE_CATEGORY, DataItemActionType.USAGE_AGGREGATE, DataItemActionType.OTHER_CALCULATED_MEMBER};
    private static final List<DataItemActionType> VALID_ACTIONS_FOR_OLAP_DIMENSION_BASED_DATA_ITEMS = Collections.unmodifiableList(Arrays.asList(dimensionActions));
    private static final DataItemActionType[] hierarchyActions = new DataItemActionType[]{DataItemActionType.STEP_MEMBER_FILTER, DataItemActionType.STEP_MEMBER_PROPERTY_FILTER, DataItemActionType.STEP_DATE_FILTER, DataItemActionType.STEP_DATABASED_FILTER, DataItemActionType.STEP_RANK, DataItemActionType.STEP_NAVIGATE, DataItemActionType.SORT_ASCENDING, DataItemActionType.SORT_DESCENDING, DataItemActionType.SORT_HIERARCHICAL_ASCENDING, DataItemActionType.SORT_HIERARCHICAL_DESCENDING, DataItemActionType.SORT_NONE, DataItemActionType.SORT_CRITERIA, DataItemActionType.USAGE_DETAIL, DataItemActionType.USAGE_CATEGORY, DataItemActionType.USAGE_AGGREGATE, DataItemActionType.OTHER_CALCULATED_MEMBER};
    private static final List<DataItemActionType> VALID_ACTIONS_FOR_OLAP_HIERARCHY_BASED_DATA_ITEMS = Collections.unmodifiableList(Arrays.asList(hierarchyActions));
    private static final DataItemActionType[] levelActions = new DataItemActionType[]{DataItemActionType.STEP_MEMBER_FILTER, DataItemActionType.STEP_DATABASED_FILTER, DataItemActionType.STEP_RANK, DataItemActionType.STEP_MEMBER_PROPERTY_FILTER, DataItemActionType.STEP_DATE_FILTER, DataItemActionType.SORT_ASCENDING, DataItemActionType.SORT_DESCENDING, DataItemActionType.SORT_HIERARCHICAL_ASCENDING, DataItemActionType.SORT_HIERARCHICAL_DESCENDING, DataItemActionType.SORT_NONE, DataItemActionType.SORT_CRITERIA, DataItemActionType.USAGE_DETAIL, DataItemActionType.USAGE_CATEGORY, DataItemActionType.USAGE_AGGREGATE, DataItemActionType.OTHER_CALCULATED_MEMBER};
    private static final List<DataItemActionType> VALID_ACTIONS_FOR_OLAP_LEVEL_BASED_DATA_ITEMS = Collections.unmodifiableList(Arrays.asList(levelActions));
    private static final DataItemActionType[] measureActions = new DataItemActionType[]{DataItemActionType.USAGE_AGGREGATE, DataItemActionType.USAGE_DETAIL, DataItemActionType.OTHER_FORMAT};
    private static final List<DataItemActionType> VALID_ACTIONS_FOR_OLAP_MEASURE_BASED_DATA_ITEMS = Collections.unmodifiableList(Arrays.asList(measureActions));
    private static final DataItemActionType[] namedSetActions = new DataItemActionType[]{DataItemActionType.STEP_MEMBER_FILTER, DataItemActionType.STEP_MEMBER_PROPERTY_FILTER, DataItemActionType.STEP_DATE_FILTER, DataItemActionType.STEP_DATABASED_FILTER, DataItemActionType.STEP_RANK, DataItemActionType.STEP_NAVIGATE, DataItemActionType.SORT_ASCENDING, DataItemActionType.SORT_DESCENDING, DataItemActionType.SORT_HIERARCHICAL_ASCENDING, DataItemActionType.SORT_HIERARCHICAL_DESCENDING, DataItemActionType.SORT_NONE, DataItemActionType.SORT_CRITERIA, DataItemActionType.USAGE_CATEGORY, DataItemActionType.USAGE_AGGREGATE};
    private static final List<DataItemActionType> VALID_ACTIONS_FOR_OLAP_NAMEDSET_BASED_DATA_ITEMS = Collections.unmodifiableList(Arrays.asList(namedSetActions));
    private static final DataItemActionType[] calculatedMemberActions = new DataItemActionType[]{DataItemActionType.STEP_MEMBER_FILTER, DataItemActionType.STEP_MEMBER_PROPERTY_FILTER, DataItemActionType.STEP_DATE_FILTER, DataItemActionType.STEP_DATABASED_FILTER, DataItemActionType.STEP_RANK, DataItemActionType.STEP_NAVIGATE, DataItemActionType.SORT_ASCENDING, DataItemActionType.SORT_DESCENDING, DataItemActionType.SORT_HIERARCHICAL_ASCENDING, DataItemActionType.SORT_HIERARCHICAL_DESCENDING, DataItemActionType.SORT_NONE, DataItemActionType.SORT_CRITERIA, DataItemActionType.USAGE_CATEGORY, DataItemActionType.USAGE_AGGREGATE, DataItemActionType.OTHER_CALCULATED_MEMBER};
    private static final List<DataItemActionType> VALID_ACTIONS_FOR_OLAP_CALCULATED_MEMBER_BASED_DATA_ITEMS = Collections.unmodifiableList(Arrays.asList(calculatedMemberActions));

    DataItemImpl(AbstractBusinessModel businessModel) {
        super(businessModel);
        this.resultSetID = super.getIntraModelID();
    }

    public DataItemImpl() {
    }

    @Override
    protected String getDefaultIDPrefix() {
        return "DII_";
    }

    @Override
    public StructureOfDataItem getStructure() {
        this.unresolvedCheck();
        return this.dataItemStructure;
    }

    @Override
    public String getResultSetID() {
        this.unresolvedCheck();
        return this.resultSetID;
    }

    @Override
    public void setResultSetID(String id) throws MetadataException {
        this.changeableCheck();
        Preconditions.ensureNonNull(id, "ID");
        if (!this.isValidResultSetID(id, this)) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItem.InvalidResultID.fmt.txt", id));
        }
        this.resultSetID = id;
        this.fireChangeEvent("The data item's resultset ID has changed.");
    }

    @Override
    public void setFormat(String inputFormat) throws MetadataException {
        if (inputFormat == null && this.format == null) {
            return;
        }
        if (inputFormat != null) {
            inputFormat = inputFormat.trim();
        }
        if (inputFormat != null && this.format != null && inputFormat.equals(this.format)) {
            return;
        }
        this.changeableCheck();
        if (!this.isActionSupported(DataItemActionType.OTHER_FORMAT)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItem.FormatNotAllowed.fmt.txt", this.getIdentityString()));
        }
        DataItemImpl.setFormatCheck(this, inputFormat);
        this.format = inputFormat;
        this.fireChangeEvent("The data item's format changed.");
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    static boolean isFormatConsideredEmpty(String argFormat) {
        boolean empty = false;
        if (argFormat == null || argFormat.length() == 0) {
            empty = true;
        }
        return empty;
    }

    @Override
    public boolean isValidFormat(String inputFormat) {
        return DataItemImpl.isValidFormat(inputFormat, this.expression, this.usage, this.aggregationType);
    }

    static boolean isValidFormat(String inputFormat, ExpressionInterface expression, DataItemActionType usage, Function aggregationFuntion) {
        boolean valid = true;
        if (inputFormat != null && inputFormat.length() > 0 && expression != null) {
            valid = DataItemImpl.isValidFormatForType(inputFormat, expression, usage, aggregationFuntion);
        }
        return valid;
    }

    public static boolean isValidFormatForType(String inputFormat, ExpressionInterface expression, DataItemActionType usage, Function aggregationFuntion) {
        int dataItemType;
        boolean valid = true;
        try {
            dataItemType = IQModelImplUtilities.getExpressionTypeFactoringInAggregation(expression, usage, aggregationFuntion);
        }
        catch (MetadataUnresolvedException e) {
            BusinessModelResource unresolvedRes = e.getUnresolvedResource();
            String idString = unresolvedRes.getIdentityString();
            MessageFormatter warnMsg = IQMetadataResourceBundle.getMessageFormatter("DataItemImpl.UnresolvedResourceValidatingFmt.fmt.txt", expression == null ? "null" : idString);
            if (_logger.isEnabled(WARN_LEVEL)) {
                _logger.warn(warnMsg.toString(), (Throwable)e);
            }
            return true;
        }
        if (inputFormat != null && inputFormat.length() != 0) {
            if (inputFormat.charAt(0) == '$') {
                if (dataItemType != 3) {
                    valid = false;
                }
            } else if (dataItemType == 1 || dataItemType == 9 || dataItemType == 3 || dataItemType == 10 || dataItemType == 0) {
                valid = false;
            }
            if (inputFormat.indexOf(46) == -1) {
                valid = false;
            }
        }
        return valid;
    }

    @Override
    public void setLookupType(@Nonnull Lookup lookupType) throws MetadataException {
        this.changeableCheck();
        Preconditions.ensureNonNull(lookupType);
        if (!this.isActionSupported(DataItemActionType.OTHER_LOOKUP)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemModLookInvalid.txt", new Object[0]));
        }
        this.lookupType = lookupType;
        this.fireChangeEvent("The data item's lookup type changed.");
    }

    @Override
    public Lookup getLookupType() {
        this.unresolvedCheck();
        return this.lookupType;
    }

    @Override
    public ExpressionInterface getExpression() {
        this.unresolvedCheck();
        return this.expression;
    }

    @Override
    public void setExpression(ExpressionInterface inputExpr) throws MetadataException {
        List<?> resources;
        if (inputExpr == this) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemExpressionCyclicReference.fmt.txt", this, inputExpr));
        }
        ExpressionInterface previousExpr = this.expression;
        if (inputExpr != null && !(inputExpr instanceof FractionOfTotalExpression)) {
            this.checkForBothMeasuresAndCategories(inputExpr);
        }
        this.changeableCheck();
        if (inputExpr != null && (resources = inputExpr.getResources(this.getClass(), 65535)).contains(this)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemExpressionCyclicReference.fmt.txt", this, inputExpr));
        }
        if (!(inputExpr == null || inputExpr instanceof Column || inputExpr instanceof Dimension || inputExpr instanceof Hierarchy || inputExpr instanceof com.sas.iquery.metadata.physical.Level || inputExpr instanceof Measure || inputExpr instanceof DataItem && this.getBusModel().getStructure().isRelational() || inputExpr instanceof ConstantExpression && this.getBusModel().getStructure().isRelational() || inputExpr instanceof StringExpression || inputExpr instanceof FunctionCall || inputExpr instanceof FractionOfTotalExpression || inputExpr instanceof TimeExpressionMeasure || inputExpr instanceof NamedSet || inputExpr instanceof CalculatedMember)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemUnsupportedExpression.fmt.txt", inputExpr.getClass().getName()));
        }
        this.expression = inputExpr;
        this.initDuringSettingExpression();
        if (previousExpr != null) {
            previousExpr.removeListener(this);
        }
        if (inputExpr != null) {
            inputExpr.addListener(this);
        }
        this.fireChangeEvent("The data item's expression changed.");
    }

    private void checkForBothMeasuresAndCategories(ExpressionInterface expression) throws MetadataException {
        if (!this.isValidForBothMeasuresAndCategories(expression)) {
            Reason reason = new Reason((Object)this, 2, 105, "DataItemMeasureNonMeasure.fmt.txt", expression);
            MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("DataItemMeasureNonMeasure.fmt.txt", expression);
            throw new MetadataException(messageFormatter, Collections.singletonList(reason));
        }
    }

    private boolean usesBothCategoryAndMeasure(ExpressionInterface expr) {
        boolean measureUsed = false;
        boolean nonMeasureUsed = false;
        List<BusinessModelResource> resources = expr.getResources(BusinessModelResource.class, 0);
        for (BusinessModelResource resource : resources) {
            if (resource instanceof DataItem && !((DataItem)resource).isUnresolved()) {
                DataItemActionType actionType = ((DataItem)resource).getUsage();
                if (actionType == DataItemActionType.USAGE_AGGREGATE) {
                    measureUsed = true;
                    continue;
                }
                nonMeasureUsed = true;
                continue;
            }
            if (!(resource instanceof Column)) continue;
            nonMeasureUsed = true;
        }
        boolean bothUsed = false;
        if (nonMeasureUsed && measureUsed) {
            bothUsed = true;
        }
        return bothUsed;
    }

    private boolean isValidForBothMeasuresAndCategories(ExpressionInterface expr) throws MetadataException {
        boolean isValid;
        block6: {
            isValid = true;
            if (expr != null && !(expr instanceof FractionOfTotalExpression) && this.getBusModel().getStructure().isRelational() && this.usesBothCategoryAndMeasure(expr)) {
                isValid = false;
                String expressionText = StringExpressionUtil.getInstance().getText(expr);
                boolean keepComments = false;
                boolean enableTuples = true;
                boolean enableSets = false;
                boolean enableObjRefs = false;
                ParsedNode node = null;
                try {
                    node = ParserUtil.parseCalculation(expressionText, keepComments, enableTuples, enableSets, enableObjRefs);
                    if (!this.containsUnAggregatedPhysicalResources(node)) {
                        isValid = true;
                    } else if (this.containsCaseStatement(node)) {
                        isValid = true;
                    }
                }
                catch (RuntimeException t) {
                    if (!_logger.isEnabled(WARN_LEVEL)) break block6;
                    _logger.warn("Error parsing expression: " + t.getMessage() + "\n Parsing Options = {Preserve Comments: " + (keepComments ? "enabled" : "disabled") + ", Tuples Syntax: " + (enableTuples ? "enabled" : "disabled") + ", Sets Syntax " + (enableSets ? "enabled" : "disabled") + ", Object References: " + (enableObjRefs ? "enabled" : "disabled") + "}\n*** COULD NOT PARSE [" + expressionText + "]", (Throwable)t);
                }
            }
        }
        return isValid;
    }

    private boolean containsCaseStatement(ParsedNode node) {
        boolean caseFound = false;
        int nodeType = node.getType();
        switch (nodeType) {
            case 327729: {
                caseFound = true;
                break;
            }
            case 327728: {
                caseFound = true;
                break;
            }
            default: {
                ParsedNode[] children = node.getChildren();
                for (int i = 0; children != null && i < children.length && !caseFound; ++i) {
                    ParsedNode child = children[i];
                    caseFound = this.containsCaseStatement(child);
                }
            }
        }
        return caseFound;
    }

    private void initDuringSettingExpression() throws MetadataException {
        String currentFormat;
        this.dataItemStructure = this.getStructure(this.expression);
        this._disabledActions.clear();
        if (this.dataItemStructure == StructureOfDataItem.STRUCTURE_COLUMN || this.dataItemStructure == StructureOfDataItem.STRUCTURE_DIMENSION || this.dataItemStructure == StructureOfDataItem.STRUCTURE_HIERARCHY) {
            this.usage = DataItemActionType.USAGE_DETAIL;
        } else if (this.dataItemStructure == StructureOfDataItem.STRUCTURE_LEVEL || this.dataItemStructure == StructureOfDataItem.STRUCTURE_CALCULATED_MEMBER || this.dataItemStructure == StructureOfDataItem.STRUCTURE_NAMED_SET) {
            this.usage = DataItemActionType.USAGE_CATEGORY;
        } else if (this.dataItemStructure == StructureOfDataItem.STRUCTURE_MEASURE) {
            this.usage = DataItemActionType.USAGE_AGGREGATE;
        }
        this.initializeValidActionsAndAggregations();
        this.sortDirection = DataItemActionType.SORT_NONE;
        if (this.expression instanceof FractionOfTotalExpression) {
            this.usage = DataItemActionType.USAGE_AGGREGATE;
            if (this.aggregationType == null) {
                this.aggregationType = this.getDefaultInitialAggregation(this.validAggregationTypes);
            }
        } else {
            this.aggregationType = null;
        }
        this._disabledAggregationTypes = new ArrayList<Function>(0);
        if (!this.validActions.contains(this.usage)) {
            if (this.validActions.contains(DataItemActionType.USAGE_DETAIL)) {
                this.usage = DataItemActionType.USAGE_DETAIL;
            } else if (this.validActions.contains(DataItemActionType.USAGE_CATEGORY)) {
                this.usage = DataItemActionType.USAGE_CATEGORY;
            } else if (this.validActions.contains(DataItemActionType.USAGE_AGGREGATE)) {
                this.usage = DataItemActionType.USAGE_AGGREGATE;
                if (this.aggregationType == null) {
                    this.aggregationType = this.getDefaultInitialAggregation(this.validAggregationTypes);
                }
            }
        }
        if (!this.isValidFormat(currentFormat = this.getFormat())) {
            this.format = null;
        }
    }

    @Override
    protected void checksForCopyingFromObject(Object obj) throws MetadataException {
        super.checksForCopyingFromObject(obj);
        DataItemImpl from = (DataItemImpl)obj;
        if (!IQModelImplUtilities.same(this.getStructure(), from.getStructure())) {
            MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("DataItemImpl.CannotCopyBetweenDataItemsHavingDifferingStructures.fmt.txt", this.getStructure(), from.getStructure());
            throw new MetadataException(messageFormatter);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Lookup lookup;
        DataItemImpl newDataItem = (DataItemImpl)super.clone();
        if (this.expression != null && !(this.expression instanceof BusinessModelResource)) {
            newDataItem.expression = (ExpressionInterface)this.expression.clone();
        }
        newDataItem._disabledActions = new ArrayList<DataItemActionType>(this._disabledActions);
        newDataItem.validActions = new ArrayList<DataItemActionType>(this.validActions);
        newDataItem.validAggregationTypes = new ArrayList<Function>(this.validAggregationTypes);
        newDataItem._disabledAggregationTypes = new ArrayList<Function>(this._disabledAggregationTypes);
        if (this.sortCriteria != null) {
            newDataItem.sortCriteria = (OlapDataItemSortCriteria)this.sortCriteria.clone();
        }
        if ((lookup = this.getLookupType()) != null) {
            lookup = (Lookup)lookup.clone();
        }
        newDataItem.lookupType = lookup;
        newDataItem.steps = new ArrayList<StepInterface>();
        for (StepInterface step : this.steps) {
            if (step == null) continue;
            if (step instanceof AbstractModelItem) {
                step = (StepInterface)((AbstractModelItem)((Object)step)).clone();
                newDataItem.steps.add(step);
                step.addListener(newDataItem);
                continue;
            }
            throw new CloneNotSupportedException(IQMetadataResourceBundle.getMessageString("StepFactory.CannotCloneStep.fmt.txt", this.getIdentityString()));
        }
        return newDataItem;
    }

    @Override
    public int getExpressionType() {
        this.unresolvedCheck();
        int expressionType = 0;
        if (this.expression != null) {
            expressionType = this.isFormattingForced() ? 3 : IQModelImplUtilities.getExpressionTypeFactoringInAggregation(this.expression, this.usage, this.aggregationType);
        }
        return expressionType;
    }

    @Override
    public int getExpressionTypeIgnoringFormattingForced() {
        return IQModelImplUtilities.getExpressionTypeFactoringInAggregation(this.expression, this.usage, this.aggregationType);
    }

    private int getExpressionOnlyType() {
        int expressionType = 0;
        if (this.expression != null) {
            expressionType = this.expression.getExpressionType();
        }
        return expressionType;
    }

    @Override
    public DataItemExtendedType getExtendedType() {
        return this.extendedType;
    }

    @Override
    public void setExtendedType(DataItemExtendedType type) throws MetadataException {
        this.changeableCheck();
        Preconditions.ensureNonNull(type, "type");
        this.extendedType = type;
        this.fireChangeEvent("The data item's extended type changed.");
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this.changeableCheck();
        if (!this.isUnresolved()) {
            this.expression = (ExpressionInterface)Utils.replaceResource(this.expression, oldResource, newResource, model, recursive);
            if (this.steps != null) {
                for (int i = 0; i < this.steps.size(); ++i) {
                    StepInterface obj = this.steps.get(i);
                    if (!(obj instanceof BusinessModelResourceReferencer)) continue;
                    BusinessModelResourceReferencer refr = obj;
                    refr.replaceResource(oldResource, newResource, model, recursive);
                }
            }
        }
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this.expression == null) {
            reasons.add(new Reason((Object)this, 2, 16, "DataItemNoExpression.fmt.txt", this.getIdentityString()));
        } else {
            try {
                if (!this.isValidForBothMeasuresAndCategories(this.expression)) {
                    reasons.add(new Reason((Object)this, 2, 105, "DataItemMeasureNonMeasure.fmt.txt", new Object[0]));
                }
            }
            catch (MetadataException e) {
                reasons.add(new Reason((Object)this, 2, 105, e));
            }
        }
        if (!this.isValidFormat(this.format)) {
            reasons.add(new Reason((Object)this, 2, 27, "DataItem.InvalidFormat.fmt.txt", this.format, this.getLabel()));
        }
        if (!this.isValidUsage(this.usage)) {
            reasons.add(new Reason((Object)this, 2, 70, "DataItem.InvalidUsage.fmt.txt", this.usage, this.getLabel()));
        }
        try {
            boolean isValidResultSetID = this.isValidResultSetID(this.resultSetID, this);
            if (!isValidResultSetID) {
                reasons.add(new Reason((Object)this, 2, 229, "DataItem.InvalidResultID.fmt.txt", this.resultSetID));
            }
        }
        catch (MetadataException e) {
            reasons.add(new Reason((Object)this, 2, 229, e));
        }
    }

    protected boolean isValidUsage(DataItemActionType usage) {
        boolean returnValue = true;
        if (usage == null || !this.isActionSupported(usage)) {
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    protected String getDefinitionElementName() {
        return "DataItem";
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setAttr(thisElement, "fmt", this.format);
        if (this.sortDirection != null && this.sortDirection != DataItemActionType.SORT_NONE) {
            IQModelImplUtilities.setEnumAttr(thisElement, "sortDirection", this.sortDirection);
        }
        if (this.groupFormatting != null && this.groupFormatting != DataItemActionType.GROUP_FORMATTING_BY_DEFAULT_BEHAVIOR) {
            IQModelImplUtilities.setEnumAttr(thisElement, "groupFormatting", this.groupFormatting);
            writingContext.adjustModelVersion(ModelVersion.VERSION_93a);
        }
        if (this.sortFormatting != null && this.sortFormatting != DataItemActionType.SORT_FORMATTING_BY_DEFAULT_BEHAVIOR) {
            IQModelImplUtilities.setEnumAttr(thisElement, "sortFormatting", this.sortFormatting);
            writingContext.adjustModelVersion(ModelVersion.VERSION_93a);
        }
        if (this.usage != writingContext.getMissingDataItemUsage()) {
            IQModelImplUtilities.setEnumAttr(thisElement, "usage", this.usage);
        }
        IQModelImplUtilities.setBooleanAttr(thisElement, "formattingForced", this.formattingForced, false);
        if (this.extendedType != null && this.extendedType != DataItemExtendedType.NONE) {
            IQModelImplUtilities.setEnumAttr(thisElement, "extendedType", this.extendedType);
        }
        if (!this.getBusModel().getStructure().isRelational() || this.dataItemStructure != StructureOfDataItem.STRUCTURE_COLUMN) {
            IQModelImplUtilities.setEnumAttr(thisElement, "structure", this.dataItemStructure);
        }
        if (!IQModelImplUtilities.same(this.resultSetID, this.getIntraModelID())) {
            IQModelImplUtilities.setAttr(thisElement, "rsID", this.resultSetID);
        }
        if (this.aggregationType != null) {
            IQModelImplUtilities.setAttr(thisElement, "aggrFtn", this.aggregationType.getID());
        }
        DataItemImpl.writeDisabledActions(this._disabledActions, thisElement);
        if (this._disabledActions != null) {
            for (DataItemActionType dataItemActionType : this._disabledActions) {
                DataItemActionType action = dataItemActionType;
                if (!DataItemActionType.ALL_GROUP_FORMATTING_ACTIONS.contains(action) && !DataItemActionType.ALL_SORT_FORMATTING_ACTIONS.contains(action)) continue;
                writingContext.adjustModelVersion(ModelVersion.VERSION_93a);
                break;
            }
        }
        DataItemImpl.writeDisabledAggregateFunctions(this._disabledAggregationTypes, thisElement);
        DataItemImpl.writeLookup(this.lookupType, thisElement, writingContext);
        DataItemImpl.writeRelatedObject(this.expression, thisElement, writingContext, "Expr");
        DataItemImpl.writeRelatedObjects(this.steps, thisElement, writingContext, "Steps");
        DataItemImpl.writeRelatedObject(this.sortCriteria, thisElement, writingContext, "SortCriteria");
        IQModelImplUtilities.setCommaSeparatedStringAttr(thisElement, "memberProperties", this.memberProperties);
        DataItemImpl.writeRelatedObject(this.startingLevel, thisElement, writingContext, "StartingLevel");
        IQModelImplUtilities.setAttr(thisElement, "startingLevelName", this.labelStartingLevel);
    }

    static void writeDisabledActions(List actions, Element element) throws MetadataException {
        if (actions != null && actions.size() > 0) {
            IQModelImplUtilities.setEnumListAttr(element, "disabledActions", actions);
        }
    }

    static void writeLookup(Lookup lookup, Element thisElement, WritingContext writingContext) throws MetadataException {
        if (lookup != null && !(lookup instanceof LookupNotAllowed)) {
            if (lookup instanceof LookupByDataItem) {
                IQModelImplUtilities.setAttr(thisElement, "lookupValues", LOOKUP_BY_THIS_DATAITEM);
            } else if (lookup instanceof LookupList) {
                IQModelImplUtilities.setAttr(thisElement, "lookupValues", LOOKUP_BY_STATIC_LIST);
                DataItemImpl.writeRelatedObject(lookup, thisElement, writingContext, "Lookup");
            } else if (lookup instanceof LookupByQuery) {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("LookupByQueryPersistenceNotSupported.txt", new Object[0]));
            }
        }
    }

    static Lookup consumeLookupAttrs(AttributesProvider attrsProvider) {
        Lookup out = LookupNotAllowed.VALUE;
        String attrValue = attrsProvider.consumeAttr("lookupValues");
        if (attrValue != null) {
            if (attrValue.equals(LOOKUP_BY_THIS_DATAITEM)) {
                out = LookupByDataItem.VALUE;
            } else if (attrValue.equals(LOOKUP_BY_STATIC_LIST)) {
                out = new LookupList();
            }
        }
        return out;
    }

    static List<DataItemActionType> consumeDisabledActions(AttributesProvider attrsProvider) {
        List<DataItemActionType> out = AbstractEnumerationObject.consumeCommaList(attrsProvider, "disabledActions", DataItemActionType.class);
        if (out == null) {
            out = new ArrayList<DataItemActionType>(0);
        }
        return out;
    }

    static void writeDisabledAggregateFunctions(List aggrFunctions, Element element) throws MetadataException {
        int disabledFtnsCount;
        if (aggrFunctions != null && (disabledFtnsCount = aggrFunctions.size()) > 0) {
            StringBuffer buf = new StringBuffer(disabledFtnsCount * 20);
            ArrayList<Function> disabledFtns = new ArrayList<Function>(Arrays.asList(ServerProperties.sortFunctionsListByLabel(aggrFunctions)));
            for (int i = 0; i < disabledFtnsCount; ++i) {
                Function aggrFtn = (Function)disabledFtns.get(i);
                buf.append(aggrFtn.getID());
                if (i == disabledFtnsCount - 1) continue;
                buf.append(',');
            }
            IQModelImplUtilities.setAttr(element, "disabledAggrFtns", buf.toString());
        }
    }

    static ArrayList consumeDisabledAggregateFunctions(AttributesProvider attrsProvider) throws SAXException {
        return attrsProvider.consumeListOfCommaSeparatedFunctions("disabledAggrFtns");
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        StructureOfData struct;
        super.consumeAttributes(attrsProvider);
        this.format = attrsProvider.consumeAttr("fmt");
        this.sortDirection = DataItemActionType.consumeValue(attrsProvider, "sortDirection", DataItemActionType.SORT_NONE);
        this.groupFormatting = DataItemActionType.consumeValue(attrsProvider, "groupFormatting", DataItemActionType.GROUP_FORMATTING_BY_DEFAULT_BEHAVIOR);
        this.sortFormatting = DataItemActionType.consumeValue(attrsProvider, "sortFormatting", DataItemActionType.SORT_FORMATTING_BY_DEFAULT_BEHAVIOR);
        this.usage = DataItemActionType.consumeValue(attrsProvider, "usage", null);
        if (this.usage == null) {
            this.usage = attrsProvider.getDataItemUsageWhenMissing();
        }
        this.formattingForced = attrsProvider.consumeBooleanAttr("formattingForced", false);
        this.extendedType = DataItemExtendedType.consumeValue(attrsProvider, "extendedType", DataItemExtendedType.NONE);
        this.dataItemStructure = StructureOfDataItem.consumeValue(attrsProvider, "structure", null);
        if (this.dataItemStructure == null && (struct = this.getBusModel().trustedGetStructureDuringRead()) != null && struct.isRelational()) {
            this.dataItemStructure = StructureOfDataItem.STRUCTURE_COLUMN;
        }
        this.resultSetID = attrsProvider.consumeAttr("rsID");
        if (this.resultSetID == null) {
            this.resultSetID = this.getIntraModelID();
        }
        this.aggregationType = attrsProvider.consumeFunction("aggrFtn");
        this._disabledActions = DataItemImpl.consumeDisabledActions(attrsProvider);
        this._disabledAggregationTypes = DataItemImpl.consumeDisabledAggregateFunctions(attrsProvider);
        this.lookupType = DataItemImpl.consumeLookupAttrs(attrsProvider);
        this.memberProperties = attrsProvider.consumeCommaSeparatedStringAsList("memberProperties");
        this.labelStartingLevel = attrsProvider.consumeAttr("startingLevelName");
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this.expression = (ExpressionInterface)((Object)riHolder.consumeObject("Expr"));
        Lookup elementLookupInfo = (Lookup)riHolder.consumeObject("Lookup");
        if (elementLookupInfo != null) {
            this.lookupType = elementLookupInfo;
        }
        this.steps = riHolder.consumeObjects("Steps", StepInterface.class);
        this.sortCriteria = (OlapDataItemSortCriteria)riHolder.consumeObject("SortCriteria");
        this.startingLevel = (com.sas.iquery.metadata.physical.Level)((Object)riHolder.consumeObject("StartingLevel"));
    }

    void initializeValidActionsAndAggregations() throws MetadataException {
        boolean expressionContainsAggregation = this.expressionContainsAggregation();
        this.initializeValidActions(expressionContainsAggregation);
        this.initializeValidAggregationTypes(expressionContainsAggregation);
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        String extendedTypePersistentForm;
        Element sortCriteriaListElement;
        Element supportedAggregationTypesElement;
        Element actionElement;
        super.readDefinitionV1(thisElement, readingContext);
        this.expression = (ExpressionInterface)((Object)DataItemImpl.v1_readItemUnderSubelement(thisElement, readingContext, "Expr", new Class[]{ExpressionInterface.class}));
        String structure = IQModelImplUtilities.getAttr(thisElement, "dataItemStruct");
        this.dataItemStructure = structure != null ? StructureOfDataItem.fromPersistentForm(structure) : this.getStructure(this.expression);
        this.initializeValidActionsAndAggregations();
        this.format = IQModelImplUtilities.getAttr(thisElement, "format");
        this.labelStartingLevel = IQModelImplUtilities.getAttr(thisElement, "startingLevelName");
        this.sortDirection = DataItemActionType.fromPersistentForm(IQModelImplUtilities.getAttr(thisElement, "sortType"));
        this.usage = DataItemActionType.fromPersistentForm(IQModelImplUtilities.getAttr(thisElement, "usageType"));
        this.formattingForced = IQModelImplUtilities.getBooleanAttr(thisElement, "formattingForced", false);
        String aggFunctionID = IQModelImplUtilities.getAttr(thisElement, "aggregateFunction");
        this.aggregationType = aggFunctionID != null ? ServerProperties.getFunctionByFullID(aggFunctionID) : null;
        this.resultSetID = IQModelImplUtilities.getAttr(thisElement, "resultSetID");
        if (this.resultSetID == null) {
            this.resultSetID = this.getIntraModelID();
        }
        if ((actionElement = IQModelImplUtilities.getFirstSubelementNamed(thisElement, "SupportedActions")) != null && actionElement.hasAttributes()) {
            NamedNodeMap map = actionElement.getAttributes();
            int mapCount = map.getLength();
            for (int index = 0; index < mapCount; ++index) {
                Boolean value;
                String nodeName;
                DataItemActionType action;
                Node attrNode = map.item(index);
                if (attrNode.getNodeType() != 2 || (action = DataItemActionType.fromPersistentForm(nodeName = attrNode.getNodeName())) == null || (value = IQModelImplUtilities.getBooleanAttr(actionElement, nodeName)).booleanValue()) continue;
                this._disabledActions.add(action);
            }
        }
        if ((supportedAggregationTypesElement = IQModelImplUtilities.getFirstSubelementNamed(thisElement, "SupportedAggregateFunctions")) != null && supportedAggregationTypesElement.hasAttributes()) {
            NamedNodeMap map = supportedAggregationTypesElement.getAttributes();
            int mapCount = map.getLength();
            for (int index = 0; index < mapCount; ++index) {
                Boolean value;
                String nodeName;
                Function ftn;
                Node attrNode = map.item(index);
                if (attrNode.getNodeType() != 2 || (ftn = ServerProperties.getFunctionByFullID(nodeName = attrNode.getNodeName())) == null || (value = IQModelImplUtilities.getBooleanAttr(supportedAggregationTypesElement, nodeName)).booleanValue()) continue;
                this._disabledAggregationTypes.add(ftn);
            }
        }
        if ((sortCriteriaListElement = IQModelImplUtilities.getFirstSubelementNamed(thisElement, "SortCriteriaList")) != null) {
            ArrayList<String[]> readSortCriteria = new ArrayList<String[]>();
            List<Element> criteriaElements = IQModelImplUtilities.getSubelements(sortCriteriaListElement);
            Iterator<Element> iterator = criteriaElements.iterator();
            while (iterator.hasNext()) {
                Element element;
                Element oneCriteriaElement = element = iterator.next();
                ArrayList<String> oneCriteria = new ArrayList<String>();
                int index = 0;
                while (index != -1) {
                    String attrValue = IQModelImplUtilities.getAttr(oneCriteriaElement, "crit" + index);
                    if (attrValue == null) {
                        index = -1;
                        continue;
                    }
                    oneCriteria.add(attrValue);
                    ++index;
                }
                String[] array = new String[oneCriteria.size()];
                for (int i = 0; i < oneCriteria.size(); ++i) {
                    array[i] = (String)oneCriteria.get(i);
                }
                readSortCriteria.add(array);
            }
            if (readSortCriteria.size() > 0) {
                this.sortCriteria = new OlapDataItemSortCriteria(readSortCriteria);
            }
        }
        this.steps = DataItemImpl.v1_readItemListUnderSubelement(thisElement, readingContext, "Steps", new Class[]{StepInterface.class});
        this.lookupType = (Lookup)DataItemImpl.v1_readItemUnderSubelement(thisElement, readingContext, "Lookup", new Class[]{Lookup.class});
        if (this.lookupType == null) {
            this.lookupType = LookupByDataItem.VALUE;
        }
        this.extendedType = (extendedTypePersistentForm = IQModelImplUtilities.getAttr(thisElement, "extendedType")) != null ? DataItemExtendedType.fromPersistentForm(extendedTypePersistentForm) : DataItemExtendedType.NONE;
        Element memberPropsElement = IQModelImplUtilities.getFirstSubelementNamed(thisElement, "MemberProperties");
        if (memberPropsElement != null) {
            this.memberProperties = IQModelImplUtilities.getMultiValueAttr(memberPropsElement, "memberProps");
        }
        this.startingLevel = (com.sas.iquery.metadata.physical.Level)((Object)DataItemImpl.v1_readItemUnderSubelement(thisElement, readingContext, "StartingLevel", new Class[]{com.sas.iquery.metadata.physical.Level.class}));
    }

    @Override
    public boolean isCalculatedItem() {
        this.unresolvedCheck();
        return this.expression instanceof StringExpression && ((StringExpression)this.expression).isCalculatedItem() || this.expression instanceof TimeExpressionMeasure || this.expression instanceof FunctionCall || this.expression instanceof DataItem;
    }

    @Override
    @Nonnull
    public List<DataItemActionType> getSupportedActionsList() {
        ArrayList<DataItemActionType> outList;
        this.unresolvedCheck();
        if (this._disabledActions.size() == 0) {
            outList = new ArrayList<DataItemActionType>(this.validActions);
        } else {
            outList = new ArrayList();
            int size = this.validActions.size();
            for (int i = 0; i < size; ++i) {
                DataItemActionType action = this.validActions.get(i);
                if (this._disabledActions.contains(action)) continue;
                outList.add(action);
            }
        }
        return outList;
    }

    @Override
    public List<DataItemActionType> getValidActions() {
        this.unresolvedCheck();
        return ListUtils.newList(this.validActions);
    }

    @Override
    public boolean isActionSupported(DataItemActionType actionType) {
        this.unresolvedCheck();
        Preconditions.ensureNonNull(actionType, "actionType");
        return this.validActions.contains(actionType) && !this._disabledActions.contains(actionType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setActionSupported(DataItemActionType actionType, boolean actionSupported) throws MetadataException {
        this.changeableCheck();
        Preconditions.ensureNonNull(this.expression, "expression");
        if (this.expression == null) {
            throw new IQueryServicesIllegalStateException(IQMetadataResourceBundle.getMessageFormatter("DataItemExpressionNull.fmt.txt", this));
        }
        Preconditions.ensureNonNull(actionType, "actionType");
        if (actionSupported) {
            if (!this.validActions.contains(actionType)) throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemActionTypeInvalid.fmt.txt", actionType));
            this._disabledActions.remove(actionType);
        } else if (this.validActions.contains(actionType) && !this._disabledActions.contains(actionType)) {
            this._disabledActions.add(actionType);
        }
        this.fireChangeEvent("The data item's supported actions changed.");
    }

    @Override
    public void setSortCriteria(List<String[]> criteria) throws MetadataException {
        this.changeableCheck();
        if (!this.isActionSupported(DataItemActionType.SORT_CRITERIA)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemSortCriteriaNotEnabled.txt", new Object[0]));
        }
        this.sortCriteria = new OlapDataItemSortCriteria(criteria);
        this.fireChangeEvent("The data item's sort criteria changed.");
    }

    @Override
    public List<String[]> getSortCriteria() {
        this.unresolvedCheck();
        List<String[]> out = this.sortCriteria != null ? this.sortCriteria.get() : new ArrayList<String[]>(0);
        return out;
    }

    @Override
    public DataItemActionType getSortDirection() {
        this.unresolvedCheck();
        return this.sortDirection;
    }

    @Override
    public void setLabel(String label) throws MetadataException {
        this.changeableCheck();
        List<Reason> reasons = DataItemImpl.getReasonsLabelNotValid(this, label);
        if (!reasons.isEmpty()) {
            Reason reason = reasons.get(0);
            if (reason.getSubReason() == 251) {
                MetadataException exception = new MetadataException(IQMetadataResourceBundle.getMessageFormatter("AbstractBusinessModel.InvalidLabelChars.txt", new Object[0]));
                throw exception;
            }
            MetadataException exception = new MetadataException(null, reasons);
            throw exception;
        }
        super.setLabel(label);
    }

    @Override
    public List<Reason> getReasonsLabelNotValid(String label) throws MetadataException {
        return DataItemImpl.getReasonsLabelNotValid(this, label);
    }

    public static List<Reason> getReasonsLabelNotValid(DataItem item, String label) throws MetadataException {
        ArrayList<Reason> reasons = new ArrayList<Reason>();
        if (!item.isReadOnly()) {
            if (!item.isUnresolved()) {
                Reason reason;
                ServerAttribute captionLabelValidCharsRuleAttr;
                String rules;
                BusinessModel model = item.getBusinessModel();
                ServerProperties sp = model.getServerProperties();
                if (sp == null) {
                    throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("AbstractBusinessModel.ServerPropertiesNotFound.txt", new Object[0]));
                }
                ServerAttribute captionMaxLengthAttr = ServerAttribute.CAPTION_LABEL_MAX_LENGTH;
                String m = sp.getServerAttributeValue(captionMaxLengthAttr);
                if (m != null) {
                    int maxLength = Integer.parseInt(m, 10);
                    if (label != null && label.length() > maxLength) {
                        Reason reason2 = new Reason((Object)item, 5, 110, "DataItem.TooLongLabel.fmt.txt", Integer.toString(maxLength));
                        reasons.add(reason2);
                    }
                }
                if ((rules = sp.getServerAttributeValue(captionLabelValidCharsRuleAttr = ServerAttribute.CAPTION_LABEL_VALID_CHARS_RULE_ATTR)) != null && (reason = sp.validateByRules(label, rules)) != null) {
                    reasons.add(reason);
                }
            } else {
                Reason reason = new Reason((Object)item, 5, 22, "BusinessModelUnresolvedCheck.txt", new Object[0]);
                reasons.add(reason);
            }
        } else {
            Reason reason = new Reason((Object)item, 5, 109, "BusinessModelImplReadOnlyErrror.txt", new Object[0]);
            reasons.add(reason);
        }
        return reasons;
    }

    @Override
    public void setSortDirection(DataItemActionType inputSortDirection) throws MetadataException {
        this.changeableCheck();
        if (this.expression == null) {
            throw new IQueryServicesIllegalStateException(IQMetadataResourceBundle.getMessageFormatter("DataItemExpressionNullForSortDirection.fmt.txt", this));
        }
        Preconditions.ensureNonNullWithMessage(inputSortDirection, "DataItemNullSortDirection.txt", "inputSortDirection");
        if (!DataItemActionType.ALL_SORT_TYPE_ACTIONS.contains(inputSortDirection)) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItem.InvalidDataItemActionType.txt", new Object[0]));
        }
        if (!this.isActionSupported(inputSortDirection)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemSortDirectionNotEnabled.txt", new Object[0]));
        }
        this.sortDirection = inputSortDirection;
        this.fireChangeEvent("The data item's sort direction changed.");
    }

    @Override
    public DataItemActionType getUsage() {
        this.unresolvedCheck();
        return this.usage;
    }

    @Override
    public void setUsage(DataItemActionType inputUsage) throws MetadataException {
        this.changeableCheck();
        if (_logger.isDebugEnabled()) {
            _logger.debug("DataItemImpl.setUsage(" + inputUsage + ")");
        }
        if (inputUsage != null) {
            if (this.expression == null) {
                throw new IQueryServicesIllegalStateException(IQMetadataResourceBundle.getMessageFormatter("DataItemExpressionNullForUsage.fmt.txt", this));
            }
            if (!DataItemActionType.ALL_USAGE_ACTIONS.contains(inputUsage)) {
                throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItem.InvalidDataItemActionType.txt", new Object[0]));
            }
            if (!this.isActionSupported(inputUsage)) {
                MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("DataItemUsageNotEnabled.fmt.txt", inputUsage, this.getIdentityString());
                throw new MetadataException(messageFormatter);
            }
        }
        this.usage = inputUsage;
        this.fireChangeEvent("The data item's usage changed.");
    }

    @Override
    public boolean isFormattingForced() {
        return this.formattingForced;
    }

    @Override
    public void setFormattingForced(boolean value) throws MetadataException {
        this.changeableCheck();
        if (this.getStructure() != StructureOfDataItem.STRUCTURE_COLUMN) {
            StructureOfDataItem structure = this.getStructure();
            int choiceIndex = 1;
            if (structure == StructureOfDataItem.STRUCTURE_HIERARCHY) {
                choiceIndex = 2;
            } else if (structure == StructureOfDataItem.STRUCTURE_LEVEL) {
                choiceIndex = 3;
            } else if (structure == StructureOfDataItem.STRUCTURE_MEASURE) {
                choiceIndex = 4;
            } else if (structure == StructureOfDataItem.STRUCTURE_NAMED_SET) {
                choiceIndex = 5;
            } else if (structure == StructureOfDataItem.STRUCTURE_CALCULATED_MEMBER) {
                choiceIndex = 6;
            }
            MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("DataItem.FormattingForcedNotAllowed.fmt.txt", this.getLabel(), choiceIndex);
            throw new MetadataException(messageFormatter);
        }
        this.formattingForced = value;
        this.fireChangeEvent("This data item's attribute \"formatting forced\" has changed.");
    }

    @Override
    public Function getAggregationType() {
        this.unresolvedCheck();
        return this.aggregationType;
    }

    @Override
    public void setAggregationType(Function inputAggregationType) throws MetadataException {
        this.changeableCheck();
        if (this.expression == null) {
            throw new IQueryServicesIllegalStateException(IQMetadataResourceBundle.getMessageFormatter("DataItemExpressionNullAggregation.fmt.txt", this));
        }
        if (inputAggregationType != null && !this.isAggregationTypeSupported(inputAggregationType)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemAggregationNotEnabled.fmt.txt", inputAggregationType, this.getIdentityString()));
        }
        this.aggregationType = inputAggregationType;
        this.fireChangeEvent("The data item's aggregation type changed.");
    }

    @Override
    @Nonnull
    public List<Function> getValidAggregationTypes() {
        this.unresolvedCheck();
        return ListUtils.newList(this.validAggregationTypes);
    }

    @Override
    @Nonnull
    public List<Function> getSupportedAggregationTypesList() {
        List<Function> outList;
        this.unresolvedCheck();
        if (this._disabledAggregationTypes.size() == 0) {
            outList = ListUtils.newList(this.validAggregationTypes);
        } else {
            int size = this.validAggregationTypes.size();
            outList = ListUtils.newList(size);
            for (int i = 0; i < size; ++i) {
                Function aggrFtn = this.validAggregationTypes.get(i);
                if (this._disabledAggregationTypes.contains(aggrFtn)) continue;
                outList.add(aggrFtn);
            }
        }
        return outList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAggregationTypeSupported(Function aggregationType, boolean aggregationTypeSupported) throws MetadataException {
        this.changeableCheck();
        if (_logger.isDebugEnabled()) {
            String msg = "DataItem.setAggregtaionTypeSupported(" + aggregationType + ", " + String.valueOf(aggregationTypeSupported);
            _logger.debug(msg);
        }
        if (aggregationTypeSupported) {
            if (!this.validAggregationTypes.contains(aggregationType)) throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemAggregationNotValidOrSupport.fmt.txt", aggregationType));
            this._disabledAggregationTypes.remove(aggregationType);
        } else if (this.validAggregationTypes.contains(aggregationType) && !this._disabledAggregationTypes.contains(aggregationType)) {
            if (aggregationType == this.aggregationType) {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItem.CannotDisableUsedAggregateFunction.fmt.txt", aggregationType, this.getIdentityString()));
            }
            this._disabledAggregationTypes.add(aggregationType);
        }
        this.fireChangeEvent("The data item's list of supported/enabled aggregation types changed.");
    }

    @Override
    public boolean isAggregationTypeSupported(Function aggregationType) {
        this.unresolvedCheck();
        return this.validAggregationTypes.contains(aggregationType) && !this._disabledAggregationTypes.contains(aggregationType);
    }

    @Override
    public List<String> getMemberProperties() throws MetadataException {
        return ListUtils.newList(this.memberProperties);
    }

    @Override
    public com.sas.iquery.metadata.physical.Level getStartingLevel() throws MetadataException {
        return this.startingLevel;
    }

    @Override
    public String getStartingLevelName() throws MetadataException {
        return this.labelStartingLevel;
    }

    @Override
    public void setMemberProperties(List<String> properties) throws MetadataException {
        this.memberProperties = ListUtils.newList(properties);
        Preconditions.ensureNonNullTypedElements(this.memberProperties, String.class);
        if (!(this.expression instanceof Hierarchy) && !(this.expression instanceof OLAPResourceAwareStringExpression)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemExpressionInvalidForMemberProps.txt", new Object[0]));
        }
        this.fireChangeEvent("The data item's list of member properties has changed.");
    }

    @Override
    public void setStartingLevel(com.sas.iquery.metadata.physical.Level level) throws MetadataException {
        if (!(this.expression instanceof Hierarchy)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemExpressionInvalidForStartingLevel.txt", new Object[0]));
        }
        this.startingLevel = level;
        this.labelStartingLevel = null;
        this.fireChangeEvent("The data item's list of member properties has changed.");
    }

    @Override
    public void setStartingLevelName(String levelName) throws MetadataException {
        if (!(this.expression instanceof Hierarchy)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemExpressionInvalidForStartingLevel.txt", new Object[0]));
        }
        this.labelStartingLevel = levelName;
        this.startingLevel = null;
        this.fireChangeEvent("The data item's starting level name has changed.");
    }

    private Function getDefaultInitialAggregation(List<Function> supportedAggs) {
        Function ret = this.defaultInitialAggregation;
        if (!(supportedAggs == null || supportedAggs.size() <= 0 || this.defaultInitialAggregation != null && supportedAggs.contains(this.defaultInitialAggregation))) {
            ret = supportedAggs.get(0);
        }
        return ret;
    }

    private void initializeValidAggregationTypes(boolean expressionContainsAggregation) throws MetadataException {
        this.defaultInitialAggregation = null;
        List<Function> functions = new ArrayList<Function>();
        BusinessModel businessModel = this.getBusinessModel();
        ServerProperties serverProperties = null;
        try {
            serverProperties = businessModel.getServerProperties();
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        if (serverProperties != null) {
            if (expressionContainsAggregation) {
                functions.clear();
            } else if (this.expression instanceof FunctionCall && ((FunctionCall)this.expression).getFunctionSignature() != null && ((FunctionCall)this.expression).getFunctionSignature().getReturnType() == ParameterType.PARM_ANY) {
                LinkedHashSet<Function> set = new LinkedHashSet<Function>();
                set.addAll(serverProperties.getAggregationFunctions(ParameterType.PARM_NUMERIC));
                set.addAll(serverProperties.getAggregationFunctions(ParameterType.PARM_CHAR));
                functions = new ArrayList(set);
            } else {
                int expType = this.getExpressionOnlyType();
                if (expType != 0) {
                    functions = expType == 2 ? serverProperties.getAggregationFunctions(ParameterType.PARM_NUMERIC) : serverProperties.getAggregationFunctions(ParameterType.PARM_CHAR);
                }
            }
            if (expressionContainsAggregation || this.isExpressionConstant() || this.expression instanceof StringExpression) {
                boolean isFunctionListChanged = false;
                if (this.expression instanceof FractionOfTotalExpression) {
                    Function fotNumAgg = serverProperties.getFunctionByNameID(FunctionNameID.INTERNAL_AGGREGATION);
                    if (fotNumAgg != null) {
                        functions.add(0, fotNumAgg);
                        isFunctionListChanged = true;
                        this.defaultInitialAggregation = fotNumAgg;
                    }
                } else {
                    boolean addInternalAggs = true;
                    if (!expressionContainsAggregation && this.isSingleQualifiedColumnBasedRase(this.expression)) {
                        addInternalAggs = false;
                    }
                    if (addInternalAggs) {
                        Function internalAggNon;
                        Function internalAggAdd = serverProperties.getFunctionByNameID(FunctionNameID.INTERNAL_AGGREGATION_ADDITIVE);
                        if (internalAggAdd != null) {
                            functions.add(0, internalAggAdd);
                            isFunctionListChanged = true;
                            this.defaultInitialAggregation = internalAggAdd;
                        }
                        if ((internalAggNon = serverProperties.getFunctionByNameID(FunctionNameID.INTERNAL_AGGREGATION)) != null) {
                            functions.add(0, internalAggNon);
                            isFunctionListChanged = true;
                            this.defaultInitialAggregation = internalAggNon;
                        }
                    }
                }
                if (isFunctionListChanged) {
                    functions = Arrays.asList(ServerProperties.sortFunctionsListByLabel(functions));
                }
            }
        }
        this.validAggregationTypes = functions;
    }

    private boolean isExpressionConstant() {
        boolean returnValue = true;
        if (this.expression != null) {
            List<BusinessModelResource> resources = this.expression.getResources(BusinessModelResource.class, 65535);
            if (this.expression instanceof BusinessModelResource) {
                resources.add((BusinessModelResource)((Object)this.expression));
            }
            for (BusinessModelResource resource : resources) {
                if (resource instanceof Prompt) continue;
                returnValue = false;
                break;
            }
        }
        return returnValue;
    }

    private boolean expressionContainsAggregation() throws MetadataException {
        return this.containsAggregation(this.expression);
    }

    private boolean containsAggregation(ExpressionInterface expr) throws MetadataException {
        boolean returnValue = false;
        if (!(expr == null || expr instanceof Column || this.isSingleQualifiedColumnBasedRase(expr) || expr instanceof OlapItem || expr instanceof AbstractTimeValueExpression)) {
            if (expr instanceof DataItem) {
                DataItem item = (DataItem)expr;
                if (item.isUnresolved()) {
                    returnValue = true;
                } else {
                    try {
                        if (item.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
                            returnValue = true;
                        } else {
                            StructureOfDataItem itemStruct = item.getStructure();
                            if (itemStruct != null && itemStruct.isOLAP()) {
                                returnValue = itemStruct == StructureOfDataItem.STRUCTURE_MEASURE;
                            }
                        }
                    }
                    catch (MetadataUnresolvedException e) {
                        returnValue = true;
                    }
                }
            } else if (expr instanceof FunctionCall) {
                FunctionCall functionCall = (FunctionCall)expr;
                Function function = functionCall.getFunction();
                if (function != null) {
                    Category category = function.getCategory();
                    boolean bl = returnValue = category == Category.CAT_COUNTING_AGGREGATE || category == Category.CAT_NONCOUNTING_AGGREGATE || category == Category.CAT_AGGREGATE;
                }
                if (!returnValue) {
                    ExpressionInterface argExpression;
                    List<ExpressionInterface> args = functionCall.getArguments();
                    Iterator<ExpressionInterface> iterator = args.iterator();
                    while (iterator.hasNext() && !(returnValue = this.containsAggregation(argExpression = iterator.next()))) {
                    }
                }
            } else if (expr instanceof FractionOfTotalExpression) {
                returnValue = true;
            } else if (expr instanceof TimeExpressionMeasure) {
                returnValue = true;
            } else {
                try {
                    String text;
                    AbstractBusinessModel abm;
                    StructureOfData sod;
                    List<ExpressionInterface> childExpressions = expr.getResources(ExpressionInterface.class, 0);
                    Iterator<ExpressionInterface> it = childExpressions.iterator();
                    while (it.hasNext() && !returnValue) {
                        ExpressionInterface childExpr = it.next();
                        returnValue = this.containsAggregation(childExpr);
                    }
                    if (!returnValue && (sod = (abm = (AbstractBusinessModel)this.getModel()).getStructure()).isRelational() && (text = StringExpressionUtil.getInstance().getText(expr, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, abm)) != null) {
                        ServerProperties serverProperties = abm.getServerProperties();
                        if (serverProperties == null) {
                            SessionContextInterface session = abm.getSession();
                            IntelligentQueryMetadataServiceInterface service = abm.getMetadataService();
                            serverProperties = service.getPropertiesForServer(session, "saswks9_");
                        }
                        if (serverProperties != null) {
                            returnValue = serverProperties.containsAggregateFunction(text);
                        }
                    }
                }
                catch (MetadataUnresolvedException e) {
                    _logger.warn("Unresolved Resource Encountered while trying to check for embedded aggregates", (Throwable)e);
                    returnValue = false;
                }
            }
        }
        return returnValue;
    }

    private boolean isSingleQualifiedColumnBasedRase(ExpressionInterface expr) {
        ExpressionIdentifier id;
        ResourceAwareStringExpression rase;
        List<ExpressionIdentifier> identifiers;
        boolean ret = false;
        if (expr instanceof ResourceAwareStringExpression && (identifiers = (rase = (ResourceAwareStringExpression)expr).getExpressionIdentifiers()) != null && identifiers.size() == 1 && identifiers.get(0) instanceof ExpressionIdentifier && (id = identifiers.get(0)).getBusinessModelResource() instanceof QualifiedColumn) {
            ret = true;
        }
        return ret;
    }

    private void initializeValidActions(boolean expressionContainsAggregation) {
        if (this.dataItemStructure == StructureOfDataItem.STRUCTURE_COLUMN) {
            this.validActions = this.expression instanceof FractionOfTotalExpression ? VALID_ACTIONS_FOR_FRACTION_OF_TOTAL_DATA_ITEMS : (this.expression instanceof ConstantExpression ? VALID_ACTIONS_FOR_CONSTANT_COLUMN_BASED_DATA_ITEMS : (expressionContainsAggregation ? VALID_ACTIONS_FOR_AGGREGATED_COLUMN_BASED_DATA_ITEMS : VALID_ACTIONS_FOR_UNAGGREGATED_COLUMN_BASED_DATA_ITEMS));
        } else if (this.dataItemStructure == StructureOfDataItem.STRUCTURE_DIMENSION) {
            this.validActions = VALID_ACTIONS_FOR_OLAP_DIMENSION_BASED_DATA_ITEMS;
        } else if (this.dataItemStructure == StructureOfDataItem.STRUCTURE_HIERARCHY) {
            this.validActions = VALID_ACTIONS_FOR_OLAP_HIERARCHY_BASED_DATA_ITEMS;
        } else if (this.dataItemStructure == StructureOfDataItem.STRUCTURE_LEVEL) {
            this.validActions = VALID_ACTIONS_FOR_OLAP_LEVEL_BASED_DATA_ITEMS;
        } else if (this.dataItemStructure == StructureOfDataItem.STRUCTURE_MEASURE) {
            this.validActions = VALID_ACTIONS_FOR_OLAP_MEASURE_BASED_DATA_ITEMS;
        } else if (this.dataItemStructure == StructureOfDataItem.STRUCTURE_NAMED_SET) {
            this.validActions = VALID_ACTIONS_FOR_OLAP_NAMEDSET_BASED_DATA_ITEMS;
        } else if (this.dataItemStructure == StructureOfDataItem.STRUCTURE_CALCULATED_MEMBER) {
            this.validActions = VALID_ACTIONS_FOR_OLAP_CALCULATED_MEMBER_BASED_DATA_ITEMS;
        }
    }

    @Override
    public boolean containsUserTypedAggregation() throws MetadataException {
        boolean rval = this.expression instanceof DataItemContainerExpression ? ((DataItemContainerExpression)this.expression).containsUserTypedAggregation() : false;
        return rval;
    }

    @Override
    public List<DataItem> getLeafDataItems() {
        LinkedHashSet<DataItem> leafItems = new LinkedHashSet<DataItem>();
        if (!IQModelImplUtilities.isAggregationDefinedInExpression(this)) {
            leafItems.add(this);
        } else if (this.expression instanceof DataItemContainerExpression) {
            leafItems.addAll(((DataItemContainerExpression)this.expression).getLeafDataItems());
            if (leafItems.size() == 0) {
                leafItems.add(this);
            }
        } else {
            leafItems.add(this);
        }
        return new ArrayList<DataItem>(leafItems);
    }

    public static void setFormatCheck(DataItem item, String format) throws MetadataException {
        if (format == null) {
            return;
        }
        if (format.trim().length() == 0) {
            return;
        }
        try {
            SASFormatDescriptionUtil.getFormatAttributes(format);
        }
        catch (Exception t) {
            MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("DataItem.InvalidFormat.fmt.txt", format, item);
            throw new MetadataException(messageFormatter, (Throwable)t);
        }
    }

    void baseItemOnResource(PhysicalResource physicalResource) throws MetadataException {
        this.baseItemOnResource(physicalResource, null);
    }

    void baseItemOnResource(PhysicalResource physicalResource, Properties options) throws MetadataException {
        String description;
        String name = null;
        String trueVal = "1";
        boolean initCap = true;
        boolean replaceUnderscores = true;
        boolean useLabels = true;
        boolean MLS_Id = false;
        if (options != null && !options.isEmpty()) {
            String val = options.getProperty("INIT_CAP");
            initCap = val == null || val.equals("1");
            val = options.getProperty("REPLACE_UNDERSCORES");
            replaceUnderscores = val == null || val.equals("1");
            val = options.getProperty("USE_LABELS");
            useLabels = val == null || val.equals("1");
            val = options.getProperty("MLS_ID");
            MLS_Id = val != null && val.equals("1");
        }
        BusinessModel model = this.getBusinessModel();
        Locale viewerLocale = LocaleUtilities.getDefaultViewerLocale(model);
        if (physicalResource instanceof LocalizableNamedObjectInterface) {
            LocalizableNamedObjectInterface lno = (LocalizableNamedObjectInterface)((Object)physicalResource);
            LocalizableString labels = lno.getLabels();
            this.setLabels(labels);
            name = lno.getLabel(viewerLocale);
        }
        if (physicalResource instanceof QualifiedColumn) {
            QualifiedColumn column = (QualifiedColumn)physicalResource;
            this.setExpression(column);
            this.setFormat(column.getSasFormat());
            this.setDateTimeTypeIfNeeded();
            name = useLabels ? this.convertName(column.getLabel(), -1, initCap, replaceUnderscores) : this.convertName(column.getSasName(), -1, initCap, replaceUnderscores);
            this.createAndSetIntraModelID(this.getBusinessModel(), name);
            this.setLabel(name);
            if (column.getSasName() != null && column.getSasName().length() > 0) {
                description = IQMetadataResourceBundle.getMessageString("DataItemImpl.PhysicalColumnDesc.fmt.txt", column.getSasName());
                this.setDescription(description);
            } else {
                this.setDescription(column.getLabel());
            }
            this.configureAggregateFunction();
            int expressionType = this.getExpression().getExpressionType();
            if (column.getSasType().equals("N") && !column.isForeignKey() && !column.isUniqueKey() && expressionType != 4 && expressionType != 5 && expressionType != 6) {
                this.setUsage(DataItemActionType.USAGE_AGGREGATE);
            } else {
                this.setUsage(DataItemActionType.USAGE_CATEGORY);
            }
            this.setLookupType(new LookupNotAllowed());
        } else if (physicalResource instanceof Measure) {
            Measure measure = (Measure)physicalResource;
            this.setExpression(measure);
            if (name == null) {
                name = MLS_Id ? measure.getLabel() : measure.getMeasureCaption();
            }
            name = this.convertName(name, this.getOlapLabelLengthLimit(), initCap, replaceUnderscores);
            this.createAndSetIntraModelID(this.getBusinessModel(), name);
            this.setLabel(this.convertName(measure.getMeasureCaption(), this.getOlapLabelLengthLimit(), initCap, replaceUnderscores));
            description = IQMetadataResourceBundle.getMessageString("DataItemImpl.CubeMeasureDesc.fmt.txt", measure.getLabel());
            this.setDescription(description);
            this.setFormat(measure.getSasFormat());
            this.setUsage(DataItemActionType.USAGE_AGGREGATE);
        } else if (physicalResource instanceof Hierarchy) {
            Hierarchy hierarchy = (Hierarchy)physicalResource;
            this.setExpression(hierarchy);
            name = MLS_Id ? hierarchy.getLabel() : hierarchy.getHierarchyCaption();
            name = this.convertName(name, this.getOlapLabelLengthLimit(), initCap, replaceUnderscores);
            this.createAndSetIntraModelID(this.getBusinessModel(), name);
            this.setLabel(this.convertName(hierarchy.getHierarchyCaption(), this.getOlapLabelLengthLimit(), initCap, replaceUnderscores));
            description = IQMetadataResourceBundle.getMessageString("DataItemImpl.CubeHierarchyDesc.fmt.txt", hierarchy.getLabel());
            this.setDescription(description);
            this.setUsage(DataItemActionType.USAGE_CATEGORY);
        } else if (physicalResource instanceof NamedSet) {
            NamedSet nameSet = (NamedSet)physicalResource;
            this.setExpression(nameSet);
            name = MLS_Id ? nameSet.getLabel() : nameSet.getDescription();
            name = this.convertName(name, this.getOlapLabelLengthLimit(), initCap, replaceUnderscores);
            this.createAndSetIntraModelID(this.getBusinessModel(), name);
            this.setLabel(this.convertName(nameSet.getDescription(), this.getOlapLabelLengthLimit(), initCap, replaceUnderscores));
            description = IQMetadataResourceBundle.getMessageString("DataItemImpl.CubeNamedSetDesc.fmt.txt", nameSet.getLabel());
            this.setDescription(description);
            this.setUsage(DataItemActionType.USAGE_CATEGORY);
        } else if (physicalResource instanceof CalculatedMember) {
            CalculatedMember calMember = (CalculatedMember)physicalResource;
            this.setExpression(calMember);
            name = MLS_Id ? calMember.getLabel() : calMember.getDescription();
            name = this.convertName(name, this.getOlapLabelLengthLimit(), initCap, replaceUnderscores);
            this.createAndSetIntraModelID(this.getBusinessModel(), name);
            this.setLabel(this.convertName(calMember.getDescription(), this.getOlapLabelLengthLimit(), initCap, replaceUnderscores));
            description = IQMetadataResourceBundle.getMessageString("DataItemImpl.CubeCalculatedMemberDesc.fmt.txt", calMember.getLabel());
            this.setDescription(description);
            this.setUsage(DataItemActionType.USAGE_CATEGORY);
        } else {
            MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("DataItemImpl.BadPhysicalResource.txt", new Object[0]);
            ArrayMessageFormatter amf = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, messageFormatter, physicalResource.getIdentityString());
            throw new MetadataException(amf);
        }
    }

    private void setDateTimeTypeIfNeeded() throws MetadataException {
        SASFormatAttributes formatAttrs = null;
        String format = this.getFormat();
        try {
            SASFormatDescription formatDescription;
            if (format != null && format.length() > 0) {
                formatAttrs = SASFormatDescriptionUtil.getFormatAttributes(format);
            }
            if (formatAttrs != null && (formatDescription = SASFormatDescriptionUtil.getFormatDescription(formatAttrs.getBaseFormatName())) != null) {
                int exprType = 0;
                if (formatDescription.isDate()) {
                    exprType = 4;
                } else if (formatDescription.isTime()) {
                    exprType = 5;
                } else if (formatDescription.isDateTime()) {
                    exprType = 6;
                }
                if (exprType != 0) {
                    String exprText = StringExpressionUtil.getInstance().getText(this.getExpression(), ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, this.getBusinessModel());
                    ExpressionInterface expression = StringExpressionUtil.getInstance().newExpression(this.getBusinessModel(), exprText, exprType, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE);
                    this.setExpression(expression);
                }
            }
        }
        catch (SASFormatException e) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            throw new MetadataException(e);
        }
    }

    private String convertName(String name, int lengthLimit, boolean initCap, boolean replaceUnderscores) {
        String newName = name;
        if (replaceUnderscores) {
            newName = newName.replace('_', ' ');
        }
        if (initCap) {
            newName = newName.toLowerCase();
            StringTokenizer tokenizer = new StringTokenizer(newName, " ", false);
            String newNewName = "";
            while (tokenizer.hasMoreTokens()) {
                String word = tokenizer.nextToken();
                word = word.substring(0, 1).toUpperCase() + word.substring(1);
                newNewName = newNewName + word;
                if (!tokenizer.hasMoreTokens()) continue;
                newNewName = newNewName + " ";
            }
            newName = newNewName;
        }
        if (lengthLimit > 0) {
            int maxSize = Math.min(lengthLimit, newName.length());
            newName = newName.substring(0, maxSize);
        }
        return newName;
    }

    private void createAndSetIntraModelID(BusinessModel businessModel, String seed) throws MetadataException {
        if (seed.length() == 0) {
            seed = "_";
        }
        String newid = businessModel.generateIntraModelID(seed);
        this.setIntraModelID(newid);
    }

    protected void configureAggregateFunction() throws MetadataException {
        ServerProperties serverProperties = this.getBusinessModel().getServerProperties();
        if (serverProperties != null) {
            int type = this.getExpressionType();
            StructureOfDataItem itemStruct = this.getStructure();
            if (itemStruct == StructureOfDataItem.STRUCTURE_COLUMN) {
                Function countFunction = serverProperties.getFunctionByNameID(FunctionNameID.COUNT);
                Function sumFunction = serverProperties.getFunctionByNameID(FunctionNameID.SUM);
                Function newAggFunction = null;
                newAggFunction = type == 2 ? sumFunction : countFunction;
                if (!this.isAggregationTypeSupported(newAggFunction)) {
                    List<Function> supportedAggs = this.getSupportedAggregationTypesList();
                    newAggFunction = this.getDefaultInitialAggregation(supportedAggs);
                }
                this.setAggregationType(newAggFunction);
            }
        }
    }

    private int getOlapLabelLengthLimit() throws MetadataException {
        int maxLength = -1;
        String maxLengthString = this.getBusinessModel().getServerProperties().getServerAttributeValue(ServerAttribute.CAPTION_LABEL_MAX_LENGTH);
        if (maxLengthString != null && maxLengthString.length() > 0) {
            maxLength = Integer.parseInt(maxLengthString);
            maxLength -= 2;
            if (_logger.isDebugEnabled()) {
                _logger.debug("max captionLabel is " + maxLength);
            }
        }
        return maxLength;
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        if (this.expression != null) {
            intoList.add(this.expression);
        }
        if (this.startingLevel != null) {
            intoList.add(this.startingLevel);
        }
        if (this.steps != null && this.steps.size() > 0) {
            intoList.addAll(this.steps);
        }
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this.expression = (ExpressionInterface)DataItemImpl.replace(this.expression, oldObject, newObject);
        this.startingLevel = (com.sas.iquery.metadata.physical.Level)DataItemImpl.replace(this.startingLevel, oldObject, newObject);
        DataItemImpl.replaceInList(this.steps, oldObject, newObject);
    }

    @Override
    public void copyFrom(Object obj) throws MetadataException {
        this._copyFrom(obj);
    }

    protected final void setStepsTrusted(List steps) {
        this.steps = steps;
    }

    protected final List getStepsTrusted() {
        return this.steps;
    }

    @Override
    public boolean hasSteps() {
        boolean hasSteps = this.steps.size() > 0;
        return hasSteps;
    }

    private boolean containsUnAggregatedPhysicalResources(ParsedNode node) throws MetadataException {
        boolean unAggregatedResourceFound = false;
        int nodeType = node.getType();
        ParsedNode[] children = node.getChildren();
        int startChildCheckAt = 0;
        if (children != null && children.length != 0) {
            switch (nodeType) {
                case 327690: 
                case 327691: 
                case 327692: {
                    break;
                }
                case 327730: 
                case 327731: {
                    break;
                }
                case 327712: {
                    BusinessModel model = this.getBusinessModel();
                    if (children == null || children.length == 0 || children[0] == null) {
                        unAggregatedResourceFound = true;
                        break;
                    }
                    String id = children[0].toString();
                    BusinessItem bmi = model.getBusinessItemByID(id);
                    if (bmi instanceof DataItem) {
                        boolean userTyped;
                        boolean isFot;
                        boolean isAggr;
                        DataItem dataItem = (DataItem)bmi;
                        boolean bl = isAggr = dataItem.getUsage() == DataItemActionType.USAGE_AGGREGATE;
                        if (isAggr || (isFot = dataItem.getExpression() instanceof FractionOfTotalExpression) || (userTyped = dataItem.containsUserTypedAggregation())) break;
                        unAggregatedResourceFound = true;
                        break;
                    }
                    unAggregatedResourceFound = true;
                    break;
                }
                case 327728: {
                    startChildCheckAt = 1;
                }
                default: {
                    for (int i = startChildCheckAt; i < children.length && !unAggregatedResourceFound; ++i) {
                        ParsedNode child = children[i];
                        unAggregatedResourceFound = this.containsUnAggregatedPhysicalResources(child);
                    }
                }
            }
        }
        return unAggregatedResourceFound;
    }

    @Override
    public DataItemActionType getGroupFormatting() throws MetadataException {
        return this.groupFormatting;
    }

    @Override
    public void setGroupFormatting(DataItemActionType formattingActionType) throws MetadataException, IllegalArgumentException {
        this.changeableCheck();
        if (_logger.isDebugEnabled()) {
            _logger.debug("DataItemImpl.setGroupFormatting(" + formattingActionType + ")");
        }
        if (formattingActionType != null) {
            if (this.expression == null) {
                throw new IQueryServicesIllegalStateException(IQMetadataResourceBundle.getMessageFormatter("DataItem.GroupFormattingIsNull.fmt.txt", this));
            }
            if (!DataItemActionType.ALL_GROUP_FORMATTING_ACTIONS.contains(formattingActionType)) {
                throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItem.InvalidDataItemActionType.txt", new Object[0]));
            }
            if (!this.isActionSupported(formattingActionType)) {
                MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("DataItem.GroupFormattingNotEnabled.fmt.txt", formattingActionType, this.getIdentityString());
                throw new MetadataException(messageFormatter);
            }
        }
        if (this.groupFormatting != formattingActionType) {
            DataItemActionType oldFormatting = this.groupFormatting;
            this.groupFormatting = formattingActionType;
            this.fireChangeEvent("The data item's gorup formatting changed.", oldFormatting, formattingActionType);
        }
    }

    @Override
    public DataItemActionType getSortFormatting() throws MetadataException {
        return this.sortFormatting;
    }

    @Override
    public void setSortFormatting(DataItemActionType formattingActionType) throws MetadataException, IllegalArgumentException {
        this.changeableCheck();
        if (_logger.isDebugEnabled()) {
            _logger.debug("DataItemImpl.setSortFormatting(" + formattingActionType + ")");
        }
        if (formattingActionType != null) {
            if (this.expression == null) {
                throw new IQueryServicesIllegalStateException(IQMetadataResourceBundle.getMessageFormatter("DataItem.SortFormattingIsNull.fmt.txt", this));
            }
            if (!DataItemActionType.ALL_SORT_FORMATTING_ACTIONS.contains(formattingActionType)) {
                throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItem.InvalidDataItemActionType.txt", new Object[0]));
            }
            if (!this.isActionSupported(formattingActionType)) {
                MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("DataItem.SortFormattingNotEnabled.fmt.txt", formattingActionType, this.getIdentityString());
                throw new MetadataException(messageFormatter);
            }
        }
        if (this.sortFormatting != formattingActionType) {
            DataItemActionType oldFormatting = this.sortFormatting;
            this.sortFormatting = formattingActionType;
            this.fireChangeEvent("The data item's sort formatting changed.", oldFormatting, formattingActionType);
        }
    }

    @Override
    public PropertyList getLocalizableProperties(Locale locale) throws MetadataException {
        return super.newLocalizableProperties(locale, this);
    }

    @Override
    public void setLocalizableProperties(Locale locale, PropertyMap map) throws MetadataException {
        super.setLocalizableProperties(locale, this, map);
    }

    @Override
    protected LocalizableString _getLabels() {
        LocalizableNamedObjectInterface lnoi;
        LocalizableString expressionsLabels;
        ExpressionInterface obj;
        LocalizableString labels = super._getLabels();
        if ((labels == null || labels.getLocales() == null || labels.getLocales().isEmpty()) && (obj = this.getExpression()) instanceof LocalizableNamedObjectInterface && (expressionsLabels = (lnoi = (LocalizableNamedObjectInterface)((Object)obj)).getLabels()) != null && expressionsLabels.getLocales() != null && !expressionsLabels.getLocales().isEmpty()) {
            for (Locale locale : expressionsLabels.getLocales()) {
                String text = expressionsLabels.getText(locale);
                labels.setText(text, locale);
            }
            Locale defaultLocale = expressionsLabels.getDefaultLocale();
            labels.setDefaultLocale(defaultLocale);
        }
        return labels;
    }
}

