/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.FilterCascadeInterface;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.FolderItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModelObject;
import com.sas.iquery.metadata.business.impl.AbstractLocalizableBusinessModelObject;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.FilterItemImpl;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.util.Preconditions;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CompoundFilterImpl
extends AbstractLocalizableBusinessModelObject
implements CompoundFilter,
FolderItem {
    private FilterItem _left = null;
    private ConditionalRelationType _relationType = null;
    private FilterItem _right = null;
    private boolean _negate = false;
    private List _filterCascades = null;
    private static final boolean NOXML_NEGATE = false;
    private static final ConditionalRelationType NOXML_CONDITION = null;
    private static final Class<?>[] VALID_FILTER_TYPES = new Class[]{FilterItem.class};

    public CompoundFilterImpl() {
    }

    CompoundFilterImpl(AbstractBusinessModel businessModel) {
        super(businessModel);
    }

    @Override
    protected String getDefaultIDPrefix() {
        return "CFI_";
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(@Nonnull BusinessModelResource oldResource, @Nonnull BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this.changeableCheck();
        Preconditions.ensureNonNull(oldResource);
        Preconditions.ensureNonNull(newResource);
        this._left = (FilterItem)Utils.replaceResource(this._left, oldResource, newResource, model, recursive);
        this._right = (FilterItem)Utils.replaceResource(this._right, oldResource, newResource, model, recursive);
        if (this._filterCascades != null) {
            for (int i = 0; i < this._filterCascades.size(); ++i) {
                FilterCascadeInterface cascade = (FilterCascadeInterface)this._filterCascades.get(i);
                FilterCascadeInterface newCascade = (FilterCascadeInterface)Utils.replaceResource(cascade, oldResource, newResource, model, recursive);
                this._filterCascades.set(i, newCascade);
            }
        }
    }

    @Override
    public ConditionalRelationType getRelationType() {
        return this._relationType;
    }

    @Override
    public void setRelationType(ConditionalRelationType relationType) {
        this.changeableCheck();
        this._relationType = relationType;
    }

    @Override
    public void setLeftFilter(FilterItem lhs) {
        this.changeableCheck();
        this._left = lhs;
    }

    @Override
    public FilterItem getLeftFilter() {
        return this._left;
    }

    @Override
    public void setRightFilter(FilterItem rhs) {
        this.changeableCheck();
        this._right = rhs;
    }

    @Override
    public FilterItem getRightFilter() {
        return this._right;
    }

    @Override
    public boolean isNegated() {
        return this._negate;
    }

    @Override
    public void setIsNegated(boolean flag) {
        this.changeableCheck();
        this._negate = flag;
    }

    public void setCascades(List filterCascades) {
        this.changeableCheck();
        if (filterCascades != null) {
            IQModelImplUtilities.ensureProperArgumentTypes(filterCascades, new Class[]{FilterCascadeInterface.class});
        }
        this._filterCascades = filterCascades;
    }

    public List getCascades(boolean recursive) {
        ArrayList cascades = new ArrayList();
        if (this._filterCascades != null) {
            Utils.addButNoDuplicates(cascades, this._filterCascades);
        }
        if (recursive) {
            if (this._left != null) {
                Utils.addButNoDuplicates(cascades, this._left.getCascades(recursive));
            }
            if (this._right != null) {
                Utils.addButNoDuplicates(cascades, this._right.getCascades(recursive));
            }
        }
        return cascades;
    }

    public List getPrompts(int searchCriteria) {
        ArrayList prompts = new ArrayList();
        if (this._left != null) {
            Utils.addButNoDuplicates(prompts, this._left.getPrompts(searchCriteria));
        }
        if (this._right != null) {
            Utils.addButNoDuplicates(prompts, this._right.getPrompts(searchCriteria));
        }
        return prompts;
    }

    @Override
    @Nonnull
    public List<DataItem> getDataItems(int searchCritera) {
        LinkedHashSet<DataItem> dataItems = new LinkedHashSet<DataItem>(this._left.getDataItems(searchCritera));
        dataItems.addAll(this._right.getDataItems(searchCritera));
        return new ArrayList<DataItem>(dataItems);
    }

    @Override
    public ExpressionInterface getExpression() {
        CompoundConditionalExpression condExpr = new CompoundConditionalExpression();
        condExpr.setRelationType(this._relationType);
        condExpr.setIsNegated(this._negate);
        if (this._left != null) {
            condExpr.setLeftExpression(this._left.getExpression());
        }
        if (this._right != null) {
            condExpr.setRightExpression(this._right.getExpression());
        }
        if (this._filterCascades != null) {
            condExpr.setCascades(this._filterCascades);
        }
        return condExpr;
    }

    @Override
    public void setExpression(ExpressionInterface condExpr) throws MetadataException {
        throw new MetadataException(IQModelImplUtilities.getMessageFormatter("CompoundFilterImplBadClass.txt", new Object[0]));
    }

    @Override
    protected String getDefinitionElementName() {
        return "CompoundFilter";
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setBooleanAttr(thisElement, "negate", this._negate, false);
        IQModelImplUtilities.setEnumAttr(thisElement, "operator", this._relationType, NOXML_CONDITION);
        CompoundFilterImpl.writeRelatedObject(this._left, thisElement, writingContext, "LeftFilter");
        CompoundFilterImpl.writeRelatedObject(this._right, thisElement, writingContext, "RightFilter");
        CompoundFilterImpl.writeRelatedObjects(this._filterCascades, thisElement, writingContext, "FilterCascades");
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._negate = attrsProvider.consumeBooleanAttr("negate", false);
        this._relationType = ConditionalRelationType.consumeValue(attrsProvider, "operator", NOXML_CONDITION);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._left = (FilterItem)((Object)riHolder.consumeObject("LeftFilter"));
        this._right = (FilterItem)((Object)riHolder.consumeObject("RightFilter"));
        this._filterCascades = riHolder.consumeObjects("FilterCascades", FilterCascadeInterface.class);
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._negate = IQModelImplUtilities.getBooleanAttr(thisElement, "neg", false);
        this._relationType = ConditionalRelationType.fromPersistentForm(IQModelImplUtilities.getAttr(thisElement, "op"));
        this._left = (FilterItem)((Object)CompoundFilterImpl.v1_readItemUnderSubelement(thisElement, readingContext, "LeftFilter", VALID_FILTER_TYPES));
        this._right = (FilterItem)((Object)CompoundFilterImpl.v1_readItemUnderSubelement(thisElement, readingContext, "RightFilter", VALID_FILTER_TYPES));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FilterItem rightFilter;
        CompoundFilterImpl clone = (CompoundFilterImpl)super.clone();
        FilterItem leftFilter = this.getLeftFilter();
        if (leftFilter.isHidden()) {
            clone._left = (FilterItem)leftFilter.clone();
        }
        if ((rightFilter = this.getRightFilter()).isHidden()) {
            clone._right = (FilterItem)rightFilter.clone();
        }
        if (this._filterCascades != null) {
            clone._filterCascades = new ArrayList(this._filterCascades.size());
            Collections.copy(clone._filterCascades, this._filterCascades);
        }
        return clone;
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (!this.isUnresolved()) {
            String inValid = null;
            if (this._left != null && this._right != null) {
                if (this._relationType == null) {
                    inValid = "CompoundFilterImplRelationTypeNull.fmt.txt";
                }
            } else if (this._relationType != null) {
                inValid = "CompoundFilterImplRelationTypeNotNull.fmt.txt";
            } else if (this._left == null && this._right == null) {
                inValid = "CompoundFilterImplRelationOperandNull.fmt.txt";
            }
            if (inValid != null) {
                Reason reason = new Reason((Object)this, 2, 4, inValid, this.getIdentityString());
                reasons.add(reason);
            }
        }
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        if (this._left != null) {
            intoList.add(this._left);
        }
        if (this._right != null) {
            intoList.add(this._right);
        }
        if (this._filterCascades != null) {
            intoList.addAll(this._filterCascades);
        }
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._left = (FilterItem)CompoundFilterImpl.replace(this._left, oldObject, newObject);
        this._right = (FilterItem)CompoundFilterImpl.replace(this._right, oldObject, newObject);
        CompoundFilterImpl.replaceInList(this._filterCascades, oldObject, newObject);
    }

    @Override
    boolean isBasedOn(BusinessQuery query) {
        return this._left != null && ((AbstractBusinessModelObject)((Object)this._left)).isBasedOn(query) || this._right != null && ((AbstractBusinessModelObject)((Object)this._right)).isBasedOn(query);
    }

    public List getImmediateSubqueries() {
        IdentityList out = new IdentityList(1);
        this.addImmediateSubqueriesFor(this._left, out);
        this.addImmediateSubqueriesFor(this._right, out);
        return out.toList();
    }

    private void addImmediateSubqueriesFor(Object obj, IdentityList to) {
        if (obj instanceof FilterItemImpl) {
            to.addAll(((FilterItemImpl)obj).getImmediateSubqueries());
        } else if (obj instanceof CompoundFilterImpl) {
            to.addAll(((CompoundFilterImpl)obj).getImmediateSubqueries());
        }
    }

    public void copyFrom(Object obj) throws MetadataException {
        this._copyFrom(obj);
    }

    @Override
    public PropertyList getLocalizableProperties(Locale locale) throws MetadataException {
        return super.newLocalizableProperties(locale, this);
    }

    @Override
    public void setLocalizableProperties(Locale locale, PropertyMap map) throws MetadataException {
        super.setLocalizableProperties(locale, this, map);
    }

    @Override
    public String getLocalizationPrependKey() {
        return "FilterItems";
    }
}

