/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public final class CommaSeparatedString {
    private String _commaSeparatedStringValue;
    private String[] _componentValues;
    private static final State START = new State(){

        @Override
        public State go(Reader in, StringBuffer out) throws IOException {
            in.mark(1);
            int c = in.read();
            if (c == 34) {
                return Q;
            }
            in.reset();
            return UQ;
        }
    };
    private static final State UQ = new State(){

        @Override
        public State go(Reader in, StringBuffer out) throws IOException {
            while (true) {
                in.mark(1);
                int c = in.read();
                if (c == -1 || c == 44) {
                    in.reset();
                    return END;
                }
                out.append((char)c);
            }
        }
    };
    private static final State Q = new State(){

        @Override
        public State go(Reader in, StringBuffer out) throws IOException {
            while (true) {
                int c;
                if ((c = in.read()) == -1) {
                    in.reset();
                    return END;
                }
                if (c == 34) {
                    return QQ;
                }
                out.append((char)c);
            }
        }
    };
    private static final State QQ = new State(){

        @Override
        public State go(Reader in, StringBuffer out) throws IOException {
            in.mark(1);
            int c = in.read();
            if (c == 34) {
                out.append((char)c);
                return Q;
            }
            in.reset();
            return END;
        }
    };
    private static final State END = null;

    private CommaSeparatedString() {
    }

    public static String combine(String[] componentValues) {
        CommaSeparatedString css = new CommaSeparatedString();
        css.combineComponentValues(componentValues);
        return css.getCombinedValue();
    }

    public static String combine(List<String> componentValues) {
        String[] componentValuesArray = componentValues.toArray(new String[componentValues.size()]);
        return CommaSeparatedString.combine(componentValuesArray);
    }

    public static String[] split(String commaSeparatedStringValue) throws IOException {
        CommaSeparatedString css = new CommaSeparatedString();
        css.splitCombinedValue(commaSeparatedStringValue);
        return css.getComponentValues();
    }

    public static List<String> splitAsList(String commaSeparatedStringValue) throws IOException {
        String[] componentValues = CommaSeparatedString.split(commaSeparatedStringValue);
        ArrayList<String> outList = new ArrayList<String>(componentValues.length);
        for (int i = 0; i < componentValues.length; ++i) {
            outList.add(componentValues[i]);
        }
        return outList;
    }

    private String getCombinedValue() {
        return this._commaSeparatedStringValue;
    }

    private String[] getComponentValues() {
        return this._componentValues;
    }

    private void combineComponentValues(String[] componentValues) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < componentValues.length; ++i) {
            String value = componentValues[i];
            buf.append(this.computeRepresentationWithinCombinedValue(value));
            if (i >= componentValues.length - 1) continue;
            buf.append(',');
        }
        this._commaSeparatedStringValue = buf.toString();
        this._componentValues = componentValues;
    }

    protected String computeRepresentationWithinCombinedValue(String componentValue) {
        String out = componentValue;
        if (this.needsEncoding(componentValue)) {
            out = this.encode(componentValue);
        }
        return out;
    }

    protected boolean needsEncoding(String componentValue) {
        boolean hasCommaOrDoubleQuote = false;
        for (int i = 0; i < componentValue.length() && !hasCommaOrDoubleQuote; ++i) {
            char c = componentValue.charAt(i);
            if (c != ',' && c != '\"') continue;
            hasCommaOrDoubleQuote = true;
        }
        return hasCommaOrDoubleQuote;
    }

    protected String encode(String componentValue) {
        StringBuffer buf = new StringBuffer();
        buf.append('\"');
        int len = componentValue.length();
        for (int i = 0; i < len; ++i) {
            char c = componentValue.charAt(i);
            if (c == '\"') {
                buf.append("\"\"");
                continue;
            }
            buf.append(c);
        }
        buf.append('\"');
        return buf.toString();
    }

    protected void splitCombinedValue(String combinedValue) throws IOException {
        int c;
        ArrayList<String> componentValues = new ArrayList<String>();
        StringBuffer sbComponentValue = new StringBuffer();
        BufferedReader reader = new BufferedReader(new StringReader(combinedValue));
        ((Reader)reader).mark(0);
        ((Reader)reader).reset();
        do {
            sbComponentValue.setLength(0);
            this.readNextComponentValue(reader, sbComponentValue);
            componentValues.add(sbComponentValue.toString());
        } while ((c = ((Reader)reader).read()) != -1);
        this._componentValues = componentValues.toArray(new String[componentValues.size()]);
        this._commaSeparatedStringValue = combinedValue;
    }

    protected void readNextComponentValue(Reader in, StringBuffer out) throws IOException {
        for (State state = START; state != END; state = state.go(in, out)) {
        }
    }

    private static abstract class State {
        protected static final char DOUBLE_QUOTE = '\"';

        private State() {
        }

        public abstract State go(Reader var1, StringBuffer var2) throws IOException;
    }
}

