/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ColumnManager;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.DataSourceTableImpl2;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.V2ResourceResolver;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.inmemory.InMemoryColumn;
import com.sas.iquery.metadata.physical.oma.OMAColumn;
import com.sas.iquery.metadata.physical.oma.OMATable;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ColumnManagerImpl2
extends AbstractModelItem
implements ColumnManager,
Cloneable {
    private DataSourceTableImpl2 _dataSource;
    private static final boolean DEFAULTVALUE_AUTO_KEEP_NEW_COLUMNS = true;
    private boolean _autoKeepNewColumns = true;
    private List<Column> _omittedColumns = new ArrayList<Column>(0);
    private List _keptColumns = new ArrayList(0);
    private String _persistedOmittedCols = "";
    private static final Logger _logger = LogManager.getLogger(ColumnManagerImpl2.class);

    ColumnManagerImpl2() {
    }

    ColumnManagerImpl2(DataSourceTableImpl2 dst) {
        Preconditions.ensureNonNull(dst, "dst");
        this._dataSource = dst;
    }

    @Override
    public DataSourceTable getDataSource() {
        return this._dataSource;
    }

    void init() throws MetadataException {
        this._keptColumns = this.getInitialKeptColumns();
        this._omittedColumns = ListUtils.newList(0);
        this.fireChangeEvent("The set of columns has changed in the data source.");
    }

    private List getInitialKeptColumns() throws MetadataException {
        List out;
        Table physTable = this.getPhysicalTable();
        if (physTable != null) {
            IdentityList physCols = this._dataSource.getPhysicalColumnsForQualifiedColumns();
            List<Column> availablePhysCols = DataSourceTableImpl2.getColumnsUsingJomaCache(physTable);
            physCols.addAll(availablePhysCols);
            out = physCols.toList();
        } else {
            out = ListUtils.newList(0);
        }
        return out;
    }

    @Override
    public boolean getAutoKeepNewColumns() throws MetadataException {
        return this._autoKeepNewColumns;
    }

    @Override
    public void setAutoKeepNewColumns(boolean autoKeep) throws MetadataException {
        this.changeableCheck();
        this._dataSource.columnsNotManagedCheck();
        if (this._autoKeepNewColumns != autoKeep) {
            this._autoKeepNewColumns = autoKeep;
            this.fireChangeEvent("The switch that controls whether new columns are auto kept or auto omitted has changed.");
        }
    }

    @Override
    public void keep(Column column) throws MetadataException {
        this.changeableCheck();
        this._dataSource.columnsNotManagedCheck();
        this.verifyInputPhysicalColumn(column);
        this.doKeep(column);
    }

    @Override
    public void keep(Collection columns) throws MetadataException {
        this.changeableCheck();
        this._dataSource.columnsNotManagedCheck();
        columns = ColumnManagerImpl2.getDefensiveList(columns);
        this.verifyInputPhysicalColumns(columns);
        for (Column col : columns) {
            this.doKeep(col);
        }
    }

    private static List getDefensiveList(Collection c) {
        List out = c == null ? ListUtils.newList(0) : ListUtils.newList(c);
        return out;
    }

    private void doKeep(Column column) {
        boolean columnsChanged = this._omittedColumns.remove(column);
        if (!this._keptColumns.contains(column)) {
            this._keptColumns.add(column);
            columnsChanged = true;
        }
        if (columnsChanged) {
            this.fireChangeEvent("The set of columns has changed in the data source.");
        }
    }

    @Override
    public void omit(Column column) throws MetadataException {
        this.changeableCheck();
        this._dataSource.columnsNotManagedCheck();
        this.verifyInputPhysicalColumn(column);
        this.doOmit(column);
    }

    @Override
    public void omit(Collection columns) throws MetadataException {
        this.changeableCheck();
        this._dataSource.columnsNotManagedCheck();
        columns = ColumnManagerImpl2.getDefensiveList(columns);
        this.verifyInputPhysicalColumns(columns);
        for (Column col : columns) {
            this.doOmit(col);
        }
    }

    private void doOmit(Column column) {
        boolean columnsChanged = this._keptColumns.remove(column);
        if (!this._omittedColumns.contains(column)) {
            this._omittedColumns.add(column);
            columnsChanged = true;
        }
        if (columnsChanged) {
            this.fireChangeEvent("The set of columns has changed in the data source.");
        }
    }

    @Override
    public List getKeptColumns() {
        return ListUtils.newList(this._keptColumns);
    }

    @Override
    public List getOmittedColumns() {
        return ListUtils.newList(this._omittedColumns);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ColumnManagerImpl2 clone = (ColumnManagerImpl2)super.clone();
        this._omittedColumns = ListUtils.newList(clone._omittedColumns);
        this._keptColumns = ListUtils.newList(clone._keptColumns);
        return clone;
    }

    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        intoList.addAll(this._keptColumns);
    }

    protected void accumulateDirectlyReferencedItemsInNonDownwardDefinition(List intoList) {
        intoList.add(this._dataSource);
    }

    @Override
    protected String getDefinitionElementName() {
        return "ColumnMgr";
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        ColumnManagerImpl2.replaceInList(this._omittedColumns, oldObject, newObject);
        ColumnManagerImpl2.replaceInList(this._keptColumns, oldObject, newObject);
        ColumnManagerImpl2.replace(this._dataSource, oldObject, newObject);
    }

    List autoAddNewPhysicalColumns() throws MetadataException {
        ArrayList<Column> returnedColumnsAdded = new ArrayList<Column>();
        Table physTable = this.getPhysicalTable();
        List<Object> availableCols = physTable != null && !physTable.isUnresolved() ? DataSourceTableImpl2.getColumnsUsingJomaCache(physTable) : new ArrayList(0);
        if (availableCols.size() > 0) {
            List<Column> addToList = this._autoKeepNewColumns ? this._keptColumns : this._omittedColumns;
            List otherList = this._autoKeepNewColumns ? this._omittedColumns : this._keptColumns;
            for (Column column : availableCols) {
                if (addToList.contains(column) || otherList.contains(column)) continue;
                addToList.add(column);
                returnedColumnsAdded.add(column);
            }
        }
        return returnedColumnsAdded;
    }

    private Table getPhysicalTable() {
        return this._dataSource.getTable();
    }

    private void verifyInputPhysicalColumn(Object obj) throws MetadataException {
        if (obj != null) {
            IQModelImplUtilities.ensureProperArgumentType(obj, new Class[]{OMAColumn.class, InMemoryColumn.class});
            Column col = (Column)obj;
            Table table = col.getOwningTable();
            Table dstPhysTable = this._dataSource.getTable();
            if (table != dstPhysTable) {
                MessageFormatter error = IQModelImplUtilities.getMessageFormatter("ColumnManagerImpl.PhysicalColumnAndTableDataSourceUseDifferentTable.fmt.txt", col, this._dataSource);
                throw new MetadataException(error);
            }
        } else {
            MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("ColumnManagerImpl.InputColumnMustBeProvided.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(formatter);
        }
    }

    private void verifyInputPhysicalColumns(Collection objs) throws MetadataException {
        for (Object obj : objs) {
            this.verifyInputPhysicalColumn(obj);
        }
    }

    void validateToSetOnDST() throws MetadataException {
        this.validateState();
        List<Column> usedColumns = this._dataSource.getUsedPhysicalColumns();
        for (Column omittedCol : this._omittedColumns) {
            if (!usedColumns.contains(omittedCol)) continue;
            MessageFormatter error = IQModelImplUtilities.getMessageFormatter("ColumnManagerImpl.UsedColumnCannotBeOmitted.fmt.txt", omittedCol);
            throw new MetadataException(error);
        }
    }

    private void validateState() throws MetadataException {
        if (this._dataSource == null) {
            MessageFormatter error = IQModelImplUtilities.getMessageFormatter("ColumnManagerImpl.ColumnManagerHasNoDataSource.txt", new Object[0]);
            throw new MetadataException(error);
        }
        Table dstPhysTable = this._dataSource.getTable();
        if (dstPhysTable == null) {
            MessageFormatter error = IQModelImplUtilities.getMessageFormatter("ColumnManagerImpl.DataSourceHasNoPhysicalTable.fmt.txt", this._dataSource.getIdentityString());
            throw new MetadataException(error);
        }
        List<Column> cols = ListUtils.newList(this._omittedColumns);
        cols.addAll(this._keptColumns);
        for (Column physCol : cols) {
            Table physTable = physCol.getOwningTable();
            if (physTable == dstPhysTable) continue;
            MessageFormatter error = IQModelImplUtilities.getMessageFormatter("ColumnManagerImpl.ManagedColumnsAndDataSourceUseDifferentTables.fmt.txt", this._dataSource.getIdentityString());
            throw new MetadataException(error);
        }
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setBooleanAttr(thisElement, "autoKeepNewColumns", this._autoKeepNewColumns, true);
        ColumnManagerImpl2.writeRelatedObjects(this._keptColumns, thisElement, writingContext, "KeptColumns");
        if (this._omittedColumns.size() > 0) {
            String omittedColsAttr = this.createOmittedColsAttr();
            IQModelImplUtilities.setAttr(thisElement, "omittedColumns", omittedColsAttr);
        }
    }

    private String createOmittedColsAttr() throws MetadataException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._omittedColumns.size(); ++i) {
            Column col = this._omittedColumns.get(i);
            if (sb.length() != 0) {
                sb.append(';');
            }
            sb.append(col.getSasName());
            sb.append(',');
            sb.append(col.getSasType());
        }
        return sb.toString();
    }

    void resolveOmittedColumns(Table physicalTable) throws MetadataException {
        if (physicalTable instanceof OMATable) {
            OMATable omaTable = (OMATable)physicalTable;
            this._omittedColumns = this.parseAndResolveOmittedColumns(omaTable, this._persistedOmittedCols);
        }
    }

    private List parseAndResolveOmittedColumns(OMATable resolveColsWithinTable, String writtenOmittedCols) throws MetadataException {
        ArrayList resolvedCols = new ArrayList();
        List<Column> resolveWithinColumns = DataSourceTableImpl2.getColumnsUsingJomaCache(resolveColsWithinTable);
        this.parseAndResolveOmittedColumnsOfType(resolveColsWithinTable, resolveWithinColumns, writtenOmittedCols, resolvedCols);
        return resolvedCols;
    }

    private void parseAndResolveOmittedColumnsOfType(OMATable resolveColsWithinTable, List resolveWithinColumns, String writtenOmittedColumnNames, List accumulateColumns) throws MetadataException {
        if (writtenOmittedColumnNames.length() > 0) {
            StringTokenizer st = new StringTokenizer(writtenOmittedColumnNames, ";");
            while (st.hasMoreTokens()) {
                String sasColumnName;
                String token = st.nextToken();
                int iComma = token.indexOf(44);
                String sasColumnType = "C";
                if (iComma == -1) {
                    sasColumnName = token;
                } else {
                    sasColumnName = token.substring(0, iComma);
                    sasColumnType = token.substring(iComma + 1);
                }
                OMAColumn col = this.getColumn(resolveColsWithinTable, resolveWithinColumns, sasColumnName, sasColumnType);
                accumulateColumns.add(col);
            }
        }
    }

    private OMAColumn getColumn(OMATable resolveColsWithinTable, List resolveWithinColumns, String sasColumnName, String sasColumnType) throws MetadataException {
        OMAColumn out = V2ResourceResolver.findColumn(resolveWithinColumns, sasColumnName, sasColumnType);
        if (out == null) {
            out = new OMAColumn();
            out.setOwningTable(resolveColsWithinTable);
            out.setExternalReferenceInfo(sasColumnName, "N".equalsIgnoreCase(sasColumnType));
        }
        return out;
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._autoKeepNewColumns = attrsProvider.consumeBooleanAttr("autoKeepNewColumns", true);
        this._persistedOmittedCols = attrsProvider.consumeAttr("omittedColumns", "");
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._keptColumns = riHolder.consumeObjects("KeptColumns", OMAColumn.class);
    }

    void setOwningTable(DataSourceTableImpl2 table) {
        this._dataSource = table;
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        List keptCols = null;
        try {
            if (this._dataSource != null && this._dataSource.getColumnsAreManaged() && this._dataSource.isLive() && this._dataSource.isIMLETable()) {
                keptCols = this.getKeptColumns();
            }
        }
        catch (MetadataException e) {
            _logger.debug("Exception gotten asking on ColumnManager.getKeptColumns() determining usability of the column manager.", (Throwable)e);
        }
        if (keptCols != null) {
            if (keptCols.size() > 0) {
                for (AbstractModelItem colItem : keptCols) {
                    if (!colItem.isUnresolved()) continue;
                    String sasColumnName = "";
                    try {
                        sasColumnName = ((Column)((Object)colItem)).getSasName();
                    }
                    catch (MetadataException e) {
                        _logger.debug("Exception gotten asking for column name", (Throwable)e);
                    }
                    Reason reason = new Reason((Object)colItem, 2, 237, "ColumnManagerImpl.KeptColumnIsUnresolved.fmt.txt", sasColumnName, this._dataSource);
                    reasons.add(reason);
                }
            } else {
                reasons.add(new Reason((Object)this, 2, 236, "ColumnManagerImpl.NoKeptColumnsInIMLEDataSource.fmt.txt", this._dataSource.getIdentityString()));
            }
        }
    }

    @Override
    public void deleteOmittedColumn(Column column) throws MetadataException {
        this.changeableCheck();
        this._dataSource.columnsNotManagedCheck();
        this.verifyInputPhysicalColumn(column);
        this.doOmittedDelete(column);
    }

    private void doOmittedDelete(Column column) throws MetadataException {
        List<Column> usedColumns;
        if (this._omittedColumns.contains(column) && column.isUnresolved() && this._dataSource != null && !(usedColumns = this._dataSource.getUsedPhysicalColumns()).contains(column)) {
            this._omittedColumns.remove(column);
        }
    }
}

