/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.business.CascadeRule;
import com.sas.iquery.metadata.business.CascadeRuleItem;
import com.sas.iquery.metadata.business.CascadeRuleSet;
import com.sas.iquery.metadata.business.impl.CascadeRuleItemImpl;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class CascadeRuleSetImpl
implements CascadeRuleSet {
    private final Map<CascadeRuleItem, CascadeRule> _cascadeRules = new LinkedHashMap<CascadeRuleItem, CascadeRule>();

    protected CascadeRuleSetImpl() {
    }

    @Override
    public Collection<CascadeRule> getRules() {
        return Collections.unmodifiableCollection(this._cascadeRules.values());
    }

    @Override
    public CascadeRule getRuleBasedOn(PromptDefinitionInterface prompt, PromptValuesInterface promptValues) {
        return this._cascadeRules.get(new CascadeRuleItemImpl(prompt, promptValues));
    }

    @Nullable
    protected CascadeRule addCascade(@Nullable CascadeRule rule) {
        CascadeRule oldRule = null;
        if (rule != null) {
            oldRule = this._cascadeRules.put(rule.getItem(), rule);
        }
        return oldRule;
    }

    @Nonnull
    protected Collection<CascadeRule> addAllCascadeRules(@Nonnull Collection<CascadeRule> rules) {
        ArrayList<CascadeRule> oldRules = new ArrayList<CascadeRule>();
        if (rules != null) {
            for (CascadeRule rule : rules) {
                CascadeRule oldRule = this._cascadeRules.put(rule.getItem(), rule);
                if (oldRule == null) continue;
                oldRules.add(oldRule);
            }
        }
        return oldRules;
    }
}

