/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelReferenceInfo;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AbstractModelReference;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.services.information.metadata.PathUrl;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class BusinessModelReferenceInfoImpl
extends AbstractModelReference
implements BusinessModelReferenceInfo {
    private String location;
    private String locationType = "unknown";

    public BusinessModelReferenceInfoImpl(BusinessModel busModel, String ID, String loc, String locType) {
        super((AbstractModel)((Object)busModel), ID);
        this.location = loc;
        this.locationType = locType;
    }

    public BusinessModelReferenceInfoImpl() {
    }

    protected BusinessModelReferenceInfoImpl(AbstractModel model, String ID) {
        super(model, ID);
    }

    @Override
    public boolean equals(Object obj) {
        boolean same = false;
        if (obj instanceof BusinessModelReferenceInfoImpl) {
            BusinessModelReferenceInfoImpl that = (BusinessModelReferenceInfoImpl)obj;
            same = super.equals(that) && IQModelImplUtilities.same(this.getAbsolutePathPersistentLocation(), that.getAbsolutePathPersistentLocation()) && IQModelImplUtilities.same(this.locationType, that.locationType);
        }
        return same;
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public String getPersistentLocation() {
        return this.location;
    }

    String getAbsolutePathPersistentLocation() {
        String out = this.location;
        if (this.location != null && this.location.startsWith("SBIP://")) {
            PathUrl path = new PathUrl(this.location);
            out = path.getAbsolutePath();
        }
        return out;
    }

    @Override
    public String getPersistentLocationType() {
        return this.locationType;
    }

    @Override
    public void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this.location = IQModelImplUtilities.getAttr(thisElement, "location");
        this.locationType = IQModelImplUtilities.getAttr(thisElement, "locationType");
    }

    @Override
    public BusinessModel getBusinessModel() {
        return (BusinessModel)((Object)this.getReferencedContainer());
    }

    @Override
    public String getID() {
        return this.getReferencedContainerIdentity();
    }

    @Override
    protected String getDefinitionElementName() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getReferencedContainerIdentityAttributeName() {
        return "bmid";
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
    }
}

