/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.Association;
import com.sas.iquery.metadata.business.AssociationItem;
import com.sas.iquery.metadata.business.AssociationLevel;
import com.sas.iquery.metadata.business.AssociationMatrix;
import com.sas.iquery.metadata.business.AssociationType;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractLocalizableBusinessModelObject;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AssociationImpl;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AssociationMatrixImpl
extends AbstractLocalizableBusinessModelObject
implements AssociationMatrix {
    public AssociationType _defaultMeasureToMeasure = AssociationType.DEPENDENT;
    public AssociationType _defaultMeasureToCategory = AssociationType.DEPENDENT;
    public AssociationType _defaultCategoryToMeasure = AssociationType.DEPENDENT;
    public AssociationType _defaultMeasureToFilter = AssociationType.DEPENDENT;
    private List<Association> _associationList = new ArrayList<Association>();

    AssociationMatrixImpl() {
    }

    AssociationMatrixImpl(AbstractBusinessModel businessModel) {
        super(businessModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociationType getAssociationType(AssociationItem sourceItem, AssociationItem targetItem) {
        AssociationType result = AssociationType.NONE;
        List<Association> list = this._associationList;
        synchronized (list) {
            for (Association association : this._associationList) {
                if (association.getSourceItem() != sourceItem || association.getTargetItem() != targetItem) continue;
                result = association.getAssociationType();
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Association> getAssociations(AssociationItem sourceItem, AssociationLevel level) {
        ArrayList<Association> returnList = new ArrayList<Association>();
        if (level != AssociationLevel.DEFAULT) {
            List<Association> list = this._associationList;
            synchronized (list) {
                for (Association association : this._associationList) {
                    if (association.getSourceItem() != sourceItem) continue;
                    returnList.add(association);
                }
            }
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Association> getAssociationsBasedOn(AssociationItem item) throws MetadataException {
        ArrayList<Association> results = new ArrayList<Association>();
        boolean isDataSource = item instanceof DataSource;
        ArrayList<ModelItem> basedOnResources = new ArrayList<ModelItem>();
        basedOnResources.add(item);
        if (isDataSource) {
            if (item instanceof DataSourceTable) {
                basedOnResources.addAll(((DataSourceTable)((Object)item)).getColumns());
            } else if (item instanceof DataSourceCube) {
                DataSourceCube cubeResource = (DataSourceCube)((Object)item);
                for (Dimension dim : cubeResource.getDimensions()) {
                    basedOnResources.add(dim);
                    for (Hierarchy hierarchy : dim.getHierarchies()) {
                        basedOnResources.add(hierarchy);
                        basedOnResources.addAll(hierarchy.getLevels());
                    }
                }
                basedOnResources.addAll(cubeResource.getMeasures());
            }
        }
        List<Association> list = this._associationList;
        synchronized (list) {
            block5: for (Association association : this._associationList) {
                List<BusinessModelResource> resources = null;
                resources = association instanceof AbstractModelItem ? ((AbstractModelItem)((Object)association)).getResources(BusinessModelResource.class, 65535, true) : association.getResources(BusinessModelResource.class, 65535);
                for (Object e : basedOnResources) {
                    if (!resources.contains(e)) continue;
                    results.add(association);
                    continue block5;
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAssociation(Association associationToRemove) {
        this.changeableCheck();
        List<Association> list = this._associationList;
        synchronized (list) {
            Iterator<Association> it = this._associationList.iterator();
            while (it.hasNext()) {
                Association association = it.next();
                if (association != associationToRemove) continue;
                it.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Association> removeAssociation(AssociationItem sourceItem, AssociationItem targetItem) {
        this.changeableCheck();
        ArrayList<Association> removedAssociations = new ArrayList<Association>();
        List<Association> list = this._associationList;
        synchronized (list) {
            Iterator<Association> it = this._associationList.iterator();
            while (it.hasNext()) {
                Association association = it.next();
                if (association.getSourceItem() != sourceItem || association.getTargetItem() != targetItem) continue;
                removedAssociations.add(association);
                it.remove();
            }
        }
        return removedAssociations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.changeableCheck();
        List<Association> list = this._associationList;
        synchronized (list) {
            this._associationList.clear();
        }
    }

    @Override
    public void addAssociation(AssociationItem item1, AssociationItem item2, AssociationType type) {
        this.changeableCheck();
        this._associationList.add(new AssociationImpl(item1, item2, type));
    }

    @Override
    public AssociationType getDefaultMeasureToMeasureType() {
        return this._defaultMeasureToMeasure;
    }

    @Override
    public AssociationType getDefaultMeasureToCategoryType() {
        return this._defaultMeasureToCategory;
    }

    @Override
    public AssociationType getDefaultCategoryToMeasureType() {
        return this._defaultCategoryToMeasure;
    }

    @Override
    public AssociationType getDefaultMeasureToFilterType() {
        return this._defaultMeasureToFilter;
    }

    @Override
    public void setDefaultMeasureToMeasureType(AssociationType defaultMeasureToMeasure) {
        this.changeableCheck();
        this._defaultMeasureToMeasure = defaultMeasureToMeasure;
    }

    @Override
    public void setDefaultMeasureToCategoryType(AssociationType defaultMeasureToCategory) {
        this.changeableCheck();
        this._defaultMeasureToCategory = defaultMeasureToCategory;
    }

    @Override
    public void setDefaultCategoryToMeasureType(AssociationType defaultCategoryToMeasure) {
        this.changeableCheck();
        this._defaultCategoryToMeasure = defaultCategoryToMeasure;
    }

    @Override
    public void setDefaultMeasureToFilterType(AssociationType defaultMeasureToFilter) {
        this.changeableCheck();
        this._defaultMeasureToFilter = defaultMeasureToFilter;
    }

    @Override
    protected String getDefaultIDPrefix() {
        return "AMI_";
    }

    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        intoList.addAll(this._associationList);
    }

    @Override
    protected String getDefinitionElementName() {
        return "AssociationMatrix";
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        AssociationMatrixImpl.replaceInList(this._associationList, oldObject, newObject);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this.changeableCheck();
        if (!this.isUnresolved() && !this._associationList.isEmpty()) {
            for (Association association : this._associationList) {
                association.replaceResource(oldResource, newResource, model, recursive);
            }
        }
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        writingContext.adjustModelVersion(ModelVersion.VERSION_93a);
        if (this._defaultMeasureToMeasure != AssociationType.DEPENDENT) {
            IQModelImplUtilities.setAttr(thisElement, "dMM", this._defaultMeasureToMeasure.toString());
        }
        if (this._defaultCategoryToMeasure != AssociationType.DEPENDENT) {
            IQModelImplUtilities.setAttr(thisElement, "dCM", this._defaultCategoryToMeasure.toString());
        }
        if (this._defaultMeasureToCategory != AssociationType.DEPENDENT) {
            IQModelImplUtilities.setAttr(thisElement, "dMC", this._defaultMeasureToCategory.toString());
        }
        if (this._defaultMeasureToFilter != AssociationType.DEPENDENT) {
            IQModelImplUtilities.setAttr(thisElement, "dMF", this._defaultMeasureToFilter.toString());
        }
        AssociationMatrixImpl.writeRelatedObjects(this._associationList, thisElement, writingContext, "Associations");
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsHolder) throws SAXException {
        super.consumeAttributes(attrsHolder);
        String value = attrsHolder.consumeAttr("dMM");
        this._defaultMeasureToMeasure = value == null ? AssociationType.DEPENDENT : AssociationType.valueOf(value);
        value = attrsHolder.consumeAttr("dMC");
        this._defaultMeasureToCategory = value == null ? AssociationType.DEPENDENT : AssociationType.valueOf(value);
        value = attrsHolder.consumeAttr("dCM");
        this._defaultCategoryToMeasure = value == null ? AssociationType.DEPENDENT : AssociationType.valueOf(value);
        value = attrsHolder.consumeAttr("dMF");
        this._defaultMeasureToFilter = value == null ? AssociationType.DEPENDENT : AssociationType.valueOf(value);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._associationList = riHolder.consumeObjects("Associations", Association.class);
    }

    @Override
    public PropertyList getLocalizableProperties(Locale locale) throws MetadataException {
        return null;
    }

    @Override
    public void setLocalizableProperties(Locale locale, PropertyMap map) throws MetadataException {
    }
}

