/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.Association;
import com.sas.iquery.metadata.business.AssociationItem;
import com.sas.iquery.metadata.business.AssociationType;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

final class AssociationImpl
extends AbstractModelItem
implements Association {
    private AssociationItem _sourceItem;
    private AssociationItem _targetItem;
    private AssociationType _type = AssociationType.DEPENDENT;

    AssociationImpl() {
    }

    public AssociationImpl(AssociationItem baseItem, AssociationItem otherItem, AssociationType type) {
        this._sourceItem = baseItem;
        this._targetItem = otherItem;
        if (this._type != null) {
            this._type = type;
        }
    }

    @Override
    public AssociationItem getSourceItem() {
        return this._sourceItem;
    }

    @Override
    public AssociationItem getTargetItem() {
        return this._targetItem;
    }

    @Override
    public AssociationType getAssociationType() {
        return this._type;
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._sourceItem);
        intoList.add(this._targetItem);
    }

    @Override
    protected String getDefaultIDPrefix() {
        return "AI_";
    }

    @Override
    protected String getDefinitionElementName() {
        return "Association";
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._sourceItem = (AssociationItem)AssociationImpl.replace(this._sourceItem, oldObject, newObject);
        this._targetItem = (AssociationItem)AssociationImpl.replace(this._targetItem, oldObject, newObject);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this._sourceItem = (AssociationItem)Utils.replaceResource(this._sourceItem, oldResource, newResource, model, recursive);
        this._targetItem = (AssociationItem)Utils.replaceResource(this._targetItem, oldResource, newResource, model, recursive);
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        writingContext.adjustModelVersion(ModelVersion.VERSION_93a);
        if (this._type != AssociationType.DEPENDENT) {
            IQModelImplUtilities.setAttr(thisElement, "type", this._type.toString());
        }
        AssociationImpl.writeRelatedObject(this._sourceItem, thisElement, writingContext, "SourceItem");
        AssociationImpl.writeRelatedObject(this._targetItem, thisElement, writingContext, "TargetItem");
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsHolder) throws SAXException {
        super.consumeAttributes(attrsHolder);
        String value = attrsHolder.consumeAttr("type");
        this._type = value == null ? AssociationType.DEPENDENT : AssociationType.valueOf(value);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._sourceItem = (AssociationItem)((Object)riHolder.consumeObject("SourceItem"));
        this._targetItem = (AssociationItem)((Object)riHolder.consumeObject("TargetItem"));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Type: ").append((Object)this._type);
        buffer.append("\tbaseItem: ").append(this._sourceItem);
        buffer.append("\totherItem: ").append(this._targetItem);
        return buffer.toString();
    }
}

