/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModelObject;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.OMAResource;
import com.sas.iquery.metadata.physical.OMAResourceFactory;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.metadata.physical.RelationalSchema;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.jfs.JFSResourceImpl;
import com.sas.iquery.metadata.physical.oma.OMAColumn;
import com.sas.iquery.metadata.physical.oma.OMACube;
import com.sas.iquery.metadata.physical.oma.OMADimension;
import com.sas.iquery.metadata.physical.oma.OMAHierarchy;
import com.sas.iquery.metadata.physical.oma.OMALevel;
import com.sas.iquery.metadata.physical.oma.OMAMeasure;
import com.sas.iquery.metadata.physical.oma.OMAOlapSchema;
import com.sas.iquery.metadata.physical.oma.OMARelationalSchema;
import com.sas.iquery.metadata.physical.oma.OMAResourceImpl;
import com.sas.iquery.metadata.physical.oma.OMASASLibrary;
import com.sas.iquery.metadata.physical.oma.OMASASWorkspaceServer;
import com.sas.iquery.metadata.physical.oma.OMASoftwareServer;
import com.sas.iquery.metadata.physical.oma.OMATable;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Measure;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

public abstract class AbstractExternalResourceResolver {
    private Map resourceMap = new HashMap();
    private static boolean debugEnabled = System.getProperty("jomaDebug") != null;
    private boolean _doResolve = true;
    private ReadingContext _readingContext;
    private static final Logger _logger = LogManager.getLogger(AbstractExternalResourceResolver.class);
    private static final Class<?>[] TYPE_RESOLUTION_ORDER = new Class[]{Column.class, Table.class, RelationalSchema.class, com.sas.iquery.metadata.physical.Measure.class, com.sas.iquery.metadata.physical.Level.class, Hierarchy.class, Dimension.class, Cube.class, OlapSchema.class, SoftwareServer.class};
    private static final String RELATIONAL_SCHEMA_TEMPLATE = "<XMLSelect search=\"RelationalSchema[{0}]\"/> <Templates>   <RelationalSchema><Tables search=\"{1}\"/><DeployedComponents/></RelationalSchema>   <PhysicalTable><Columns/></PhysicalTable>   <ServerContext><UsingComponents/></ServerContext>   <LogicalServer><ServiceTypes/></LogicalServer></Templates>";
    private static final String OLAP_SCHEMA_TEMPLATE = "<XMLSelect search=\"OLAPSchema[{0}]\"/><Templates>   <OLAPSchema><Cubes search=\"{1}\"/><DeployedComponents/></OLAPSchema>   <Cube><Dimensions/><Measures/><Notes/></Cube>   <Dimension><Cubes/><Hierarchies/><Levels/></Dimension>   <ServerContext><UsingComponents/></ServerContext>   <LogicalServer><ServiceTypes/></LogicalServer>   <Measure><OwningDimension/></Measure>   <Hierarchy><Levels/></Hierarchy></Templates>";
    private static final String SERVER_TEMPLATE = "<XMLSelect search=\"ServerContext[{0}]\"/><Templates>   <ServerContext><UsingComponents/></ServerContext>   <LogicalServer><ServiceTypes/></LogicalServer></Templates>";

    protected AbstractExternalResourceResolver(ReadingContext readingContext) {
        this._readingContext = readingContext;
    }

    protected void bindJFSResources() throws MetadataException {
        SessionContextInterface session = this._readingContext.getSession();
        Map unresolvedJFSResourceMap = this._readingContext.getImportDefinitionsOfType(JFSResourceImpl.class);
        for (Map.Entry entry : unresolvedJFSResourceMap.entrySet()) {
            String persistenceID = (String)entry.getKey();
            JFSResourceImpl unresolvedJFSResource = (JFSResourceImpl)entry.getValue();
            JFSResourceImpl boundJFSResource = unresolvedJFSResource.resolveWithRepository(session, (ServerInterface)this._readingContext.getMetadataServer());
            if (boundJFSResource == null) continue;
            this._readingContext.addResolvedDefinition(persistenceID, boundJFSResource);
        }
    }

    protected void bindToExternalBusinessModelObjects() throws MetadataException {
        Map unresolvedBMOResourceMap = this._readingContext.getImportDefinitionsOfType(AbstractBusinessModelObject.class);
        for (Map.Entry entry : unresolvedBMOResourceMap.entrySet()) {
            String persistenceID = (String)entry.getKey();
            AbstractBusinessModelObject unresolvedBMOResource = (AbstractBusinessModelObject)entry.getValue();
            AbstractBusinessModelObject resolvedBMOResource = unresolvedBMOResource.resolve(this._readingContext);
            if (resolvedBMOResource == null) continue;
            this._readingContext.addResolvedDefinition(persistenceID, resolvedBMOResource);
        }
    }

    protected List<Element> getPhysicalSubelementsStartingWith(Element element, String prefix) {
        List<Element> kidElements = IQModelImplUtilities.getKidElements(element);
        ArrayList<Element> outElements = new ArrayList<Element>(kidElements.size());
        for (Element kidElement : kidElements) {
            String tagName;
            String id = IQModelImplUtilities.getAttr(kidElement, "prid");
            if (id == null || !(tagName = kidElement.getTagName()).startsWith(prefix)) continue;
            outElements.add(kidElement);
        }
        outElements.trimToSize();
        return outElements;
    }

    protected void bindOMAResources() throws MetadataException, RemoteException, ServiceException, MdException {
        SessionContextInterface session = this._readingContext.getSession();
        Map unresolvedOMAResourcesMap = this._readingContext.getImportDefinitionsOfType(OMAResource.class);
        List omrResourcesFound = this.runQueriesToGetOmrObjects(session, unresolvedOMAResourcesMap);
        Map boundResources = this.bindOMAResources(unresolvedOMAResourcesMap, omrResourcesFound, session);
        for (Map.Entry entry : boundResources.entrySet()) {
            String persistenceID = (String)entry.getKey();
            OMAResourceImpl omaResource = (OMAResourceImpl)entry.getValue();
            if (omaResource.isUnresolved()) continue;
            this._readingContext.addResolvedDefinition(persistenceID, omaResource);
        }
    }

    protected Map bindOMAResources(Map<String, OMAResourceImpl> pridToUnresolvedResource, List<Root> omrResourcesAvailable, SessionContextInterface session) throws RemoteException, MetadataException, MdException {
        HashMap<OMAResourceImpl, OMAResourceImpl> unresolvedToBoundResources = new HashMap<OMAResourceImpl, OMAResourceImpl>();
        for (int i = 0; i < TYPE_RESOLUTION_ORDER.length; ++i) {
            Class<?> typeThisTrip = TYPE_RESOLUTION_ORDER[i];
            for (OMAResourceImpl resource : pridToUnresolvedResource.values()) {
                OMAResourceImpl container;
                if (!typeThisTrip.isInstance(resource) || unresolvedToBoundResources.containsKey(resource)) continue;
                OMAResourceImpl boundResource = null;
                if (resource instanceof OMAColumn) {
                    boundResource = this.bindColumn((OMAColumn)resource, unresolvedToBoundResources, omrResourcesAvailable, session);
                } else if (resource instanceof OMATable) {
                    boundResource = this.bindTable((OMATable)resource, unresolvedToBoundResources, omrResourcesAvailable, session);
                } else if (resource instanceof OMARelationalSchema) {
                    boundResource = this.bindRelationalSchema((OMARelationalSchema)resource, unresolvedToBoundResources, omrResourcesAvailable, session);
                } else if (resource instanceof OMAMeasure) {
                    boundResource = this.bindMeasure((OMAMeasure)resource, unresolvedToBoundResources, omrResourcesAvailable, session);
                } else if (resource instanceof OMALevel) {
                    boundResource = this.bindLevel((OMALevel)resource, unresolvedToBoundResources, omrResourcesAvailable, session);
                } else if (resource instanceof OMAHierarchy) {
                    boundResource = this.bindHierarchy((OMAHierarchy)resource, unresolvedToBoundResources, omrResourcesAvailable, session);
                } else if (resource instanceof OMADimension) {
                    boundResource = this.bindDimension((OMADimension)resource, unresolvedToBoundResources, omrResourcesAvailable, session);
                } else if (resource instanceof OMACube) {
                    boundResource = this.bindCube((OMACube)resource, unresolvedToBoundResources, omrResourcesAvailable, session);
                } else if (resource instanceof OMAOlapSchema) {
                    boundResource = this.bindOlapSchema((OMAOlapSchema)resource, unresolvedToBoundResources, omrResourcesAvailable, session);
                } else if (resource instanceof OMASoftwareServer) {
                    boundResource = this.bindServer((OMASoftwareServer)resource, unresolvedToBoundResources, omrResourcesAvailable, session);
                } else {
                    throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelResourceList.UnableToBind.UnknownObjectType.fmt.txt", resource.getIdentityString(), resource.getClass().getName()));
                }
                if (boundResource.isUnresolved()) {
                    if (!boundResource.duplicatesFoundDuringResolution() || !_logger.isDebugEnabled()) continue;
                    Object[] msgArgs = new Object[]{boundResource.getIdentityString()};
                    String msg = IQModelImplUtilities.getMessage("BusinessModelResourceList.UnableToBind.DuplicatesFound.fmt.txt", msgArgs);
                    _logger.debug(msg);
                    continue;
                }
                if (!this._doResolve || (container = boundResource.getResourceContainer()) != null && container.isUnresolved() || !_logger.isDebugEnabled()) continue;
                Object[] msgArgs = new Object[]{boundResource.getIdentityString()};
                String msg = IQModelImplUtilities.getMessage("BusinessModelResourceList.FailedToFindRepositoryObject.fmt.txt", msgArgs);
                _logger.debug(msg);
            }
        }
        HashMap<String, OMAResourceImpl> boundResources = new HashMap<String, OMAResourceImpl>();
        for (Map.Entry<String, OMAResourceImpl> entry : pridToUnresolvedResource.entrySet()) {
            String prid = entry.getKey();
            OMAResourceImpl unresolvedResource = pridToUnresolvedResource.get(prid);
            OMAResourceImpl boundResource = (OMAResourceImpl)unresolvedToBoundResources.get(unresolvedResource);
            boundResources.put(prid, boundResource);
        }
        return boundResources;
    }

    protected OMAColumn bindColumn(OMAColumn unresolvedColumn, Map<OMAResourceImpl, OMAResourceImpl> unresolvedToBoundResources, List<Root> omrResourcesAvailable, SessionContextInterface session) throws RemoteException, MetadataException, MdException {
        OMAColumn outColumn = (OMAColumn)unresolvedToBoundResources.get(unresolvedColumn);
        if (outColumn == null) {
            OMATable owningTable = (OMATable)unresolvedColumn.getOwningTable();
            OMATable boundTable = this.bindTable(owningTable, unresolvedToBoundResources, omrResourcesAvailable, session);
            if (boundTable.isUnresolved()) {
                if (!boundTable.getColumns().contains(unresolvedColumn)) {
                    this.unexpectedConditionFound();
                }
                outColumn = unresolvedColumn;
            } else {
                PhysicalTable omrTable = (PhysicalTable)boundTable.getOMAObject();
                List<Column> columns = (List<Column>)this.resourceMap.get(omrTable);
                if (columns == null) {
                    columns = boundTable.getColumns(false);
                    if (!debugEnabled) {
                        this.resourceMap.put(omrTable, columns);
                    }
                }
                Iterator it = columns.iterator();
                while (it.hasNext() && outColumn == null) {
                    OMAColumn col = (OMAColumn)it.next();
                    if (!IQModelImplUtilities.sameIgnoreCase(col.getSasName(), unresolvedColumn.getSasName()) || !IQModelImplUtilities.sameIgnoreCase(col.getSasType(), unresolvedColumn.getSasType())) continue;
                    outColumn = col;
                }
                if (outColumn == null) {
                    outColumn = unresolvedColumn;
                    outColumn.setOwningTable(boundTable);
                }
            }
            unresolvedToBoundResources.put(unresolvedColumn, outColumn);
        }
        return outColumn;
    }

    protected OMATable bindTable(OMATable unresolvedTable, Map<OMAResourceImpl, OMAResourceImpl> unresolvedToBoundResources, List<Root> omrResourcesAvailable, SessionContextInterface session) throws RemoteException, MetadataException, MdException {
        OMATable outTable = (OMATable)unresolvedToBoundResources.get(unresolvedTable);
        if (outTable == null) {
            OMARelationalSchema owningSchema = (OMARelationalSchema)unresolvedTable.getRelationalSchema();
            OMARelationalSchema boundSchema = this.bindRelationalSchema(owningSchema, unresolvedToBoundResources, omrResourcesAvailable, session);
            if (boundSchema.isUnresolved()) {
                if (!boundSchema.getContainedTables().contains(unresolvedTable)) {
                    this.unexpectedConditionFound();
                }
                outTable = unresolvedTable;
            } else {
                com.sas.metadata.remote.RelationalSchema omrRelationalSchema = (com.sas.metadata.remote.RelationalSchema)boundSchema.getOMAObject();
                PhysicalTable foundTable = null;
                boolean duplicate = false;
                List<PhysicalTable> tables = (List<PhysicalTable>)this.resourceMap.get(omrRelationalSchema);
                if (tables == null) {
                    tables = AssociationListUtil.filteredSnapshot(omrRelationalSchema.getTables(), PhysicalTable.class);
                    if (!debugEnabled) {
                        this.resourceMap.put(omrRelationalSchema, tables);
                    }
                }
                for (PhysicalTable pt : tables) {
                    if (!IQModelImplUtilities.sameIgnoreCase(pt.getName(), unresolvedTable.getLabel())) continue;
                    if (foundTable != null) {
                        duplicate = true;
                        unresolvedTable.setDuplicatesFoundDuringResolution(true);
                    }
                    foundTable = pt;
                }
                if (duplicate || foundTable == null) {
                    outTable = unresolvedTable;
                    outTable.setOwningRelationalSchema(boundSchema);
                } else {
                    outTable = (OMATable)OMAResourceFactory.getReposObject(foundTable, session, this._readingContext.getMetadataServer());
                }
            }
            unresolvedToBoundResources.put(unresolvedTable, outTable);
        }
        return outTable;
    }

    protected OMARelationalSchema bindRelationalSchema(OMARelationalSchema unresolvedRelationalSchema, Map<OMAResourceImpl, OMAResourceImpl> unresolvedToBoundResources, List<Root> omrResourcesAvailable, SessionContextInterface session) throws RemoteException, MetadataException, MdException {
        OMARelationalSchema outRelationalSchema = (OMARelationalSchema)unresolvedToBoundResources.get(unresolvedRelationalSchema);
        if (outRelationalSchema == null) {
            com.sas.metadata.remote.RelationalSchema foundRelationalSchema = null;
            boolean duplicate = false;
            for (Root omrObject : omrResourcesAvailable) {
                if ((omrObject instanceof com.sas.metadata.remote.SASLibrary && unresolvedRelationalSchema instanceof SASLibrary || omrObject instanceof DatabaseSchema && unresolvedRelationalSchema instanceof com.sas.iquery.metadata.physical.DatabaseSchema) && IQModelImplUtilities.sameIgnoreCase(omrObject.getName(), unresolvedRelationalSchema.getLabel())) {
                    if (foundRelationalSchema != null) {
                        duplicate = true;
                        unresolvedRelationalSchema.setDuplicatesFoundDuringResolution(true);
                    }
                    foundRelationalSchema = (com.sas.metadata.remote.RelationalSchema)omrObject;
                }
                if (!duplicate) continue;
                break;
            }
            outRelationalSchema = duplicate || foundRelationalSchema == null ? unresolvedRelationalSchema : (OMARelationalSchema)OMAResourceFactory.getReposObject(foundRelationalSchema, session, this._readingContext.getMetadataServer());
            unresolvedToBoundResources.put(unresolvedRelationalSchema, outRelationalSchema);
        }
        return outRelationalSchema;
    }

    protected OMAMeasure bindMeasure(OMAMeasure unresolvedMeasure, Map<OMAResourceImpl, OMAResourceImpl> unresolvedToBoundResources, List<Root> omrResourcesAvailable, SessionContextInterface session) throws RemoteException, MetadataException, MdException {
        OMAMeasure outMeasure = (OMAMeasure)unresolvedToBoundResources.get(unresolvedMeasure);
        if (outMeasure == null) {
            OMACube owningCube = (OMACube)unresolvedMeasure.getOwningCube();
            OMACube boundCube = this.bindCube(owningCube, unresolvedToBoundResources, omrResourcesAvailable, session);
            if (boundCube.isUnresolved()) {
                if (!boundCube.getMeasures().contains(unresolvedMeasure)) {
                    this.unexpectedConditionFound();
                }
                outMeasure = unresolvedMeasure;
            } else {
                com.sas.metadata.remote.Cube omrCube = (com.sas.metadata.remote.Cube)boundCube.getOMAObject();
                Measure foundMeasure = null;
                boolean duplicate = false;
                ArrayList measures = new ArrayList(omrCube.getMeasures());
                for (Measure measure : measures) {
                    if (!IQModelImplUtilities.sameIgnoreCase(measure.getName(), unresolvedMeasure.getLabel())) continue;
                    if (foundMeasure != null) {
                        duplicate = true;
                        unresolvedMeasure.setDuplicatesFoundDuringResolution(true);
                    }
                    foundMeasure = measure;
                }
                if (duplicate || foundMeasure == null) {
                    outMeasure = unresolvedMeasure;
                    outMeasure.setOwningCube(boundCube);
                } else {
                    outMeasure = (OMAMeasure)OMAResourceFactory.getReposObject(foundMeasure, session, this._readingContext.getMetadataServer());
                }
            }
            unresolvedToBoundResources.put(unresolvedMeasure, outMeasure);
        }
        return outMeasure;
    }

    protected OMALevel bindLevel(OMALevel unresolvedLevel, Map<OMAResourceImpl, OMAResourceImpl> unresolvedToBoundResources, List<Root> omrResourcesAvailable, SessionContextInterface session) throws RemoteException, MetadataException, MdException {
        OMALevel outLevel = (OMALevel)unresolvedToBoundResources.get(unresolvedLevel);
        if (outLevel == null) {
            OMADimension owningDimension = (OMADimension)unresolvedLevel.getOwningDimension();
            OMADimension boundDimension = this.bindDimension(owningDimension, unresolvedToBoundResources, omrResourcesAvailable, session);
            if (boundDimension.isUnresolved()) {
                if (!boundDimension.getLevels().contains(unresolvedLevel)) {
                    this.unexpectedConditionFound();
                }
                outLevel = unresolvedLevel;
            } else {
                com.sas.metadata.remote.Dimension omrDimension = (com.sas.metadata.remote.Dimension)boundDimension.getOMAObject();
                Level foundLevel = null;
                boolean duplicate = false;
                ArrayList levels = new ArrayList(omrDimension.getLevels());
                for (Level level : levels) {
                    if (!IQModelImplUtilities.sameIgnoreCase(level.getName(), unresolvedLevel.getLabel())) continue;
                    if (foundLevel != null) {
                        duplicate = true;
                        unresolvedLevel.setDuplicatesFoundDuringResolution(true);
                    }
                    foundLevel = level;
                }
                if (duplicate || foundLevel == null) {
                    outLevel = unresolvedLevel;
                    outLevel.setOwningDimension(boundDimension);
                } else {
                    outLevel = (OMALevel)OMAResourceFactory.getReposObject(foundLevel, session, this._readingContext.getMetadataServer());
                }
            }
            unresolvedToBoundResources.put(unresolvedLevel, outLevel);
        }
        return outLevel;
    }

    protected OMAHierarchy bindHierarchy(OMAHierarchy unresolvedHierarchy, Map<OMAResourceImpl, OMAResourceImpl> unresolvedToBoundResources, List<Root> omrResourcesAvailable, SessionContextInterface session) throws RemoteException, MetadataException, MdException {
        OMAHierarchy outHierarchy = (OMAHierarchy)unresolvedToBoundResources.get(unresolvedHierarchy);
        if (outHierarchy == null) {
            OMADimension owningDimension = (OMADimension)unresolvedHierarchy.getOwningDimension();
            OMADimension boundDimension = this.bindDimension(owningDimension, unresolvedToBoundResources, omrResourcesAvailable, session);
            if (boundDimension.isUnresolved()) {
                if (!boundDimension.getHierarchies().contains(unresolvedHierarchy)) {
                    this.unexpectedConditionFound();
                }
                outHierarchy = unresolvedHierarchy;
            } else {
                com.sas.metadata.remote.Dimension omrDimension = (com.sas.metadata.remote.Dimension)boundDimension.getOMAObject();
                com.sas.metadata.remote.Hierarchy foundHierarchy = null;
                boolean duplicate = false;
                ArrayList dimensions = new ArrayList(omrDimension.getHierarchies());
                for (com.sas.metadata.remote.Hierarchy hier : dimensions) {
                    if (!IQModelImplUtilities.sameIgnoreCase(hier.getName(), unresolvedHierarchy.getLabel())) continue;
                    if (foundHierarchy != null) {
                        duplicate = true;
                        unresolvedHierarchy.setDuplicatesFoundDuringResolution(true);
                    }
                    foundHierarchy = hier;
                }
                if (duplicate || foundHierarchy == null) {
                    outHierarchy = unresolvedHierarchy;
                    outHierarchy.setOwningDimension(boundDimension);
                } else {
                    outHierarchy = (OMAHierarchy)OMAResourceFactory.getReposObject(foundHierarchy, session, this._readingContext.getMetadataServer());
                }
            }
            unresolvedToBoundResources.put(unresolvedHierarchy, outHierarchy);
        }
        return outHierarchy;
    }

    protected OMADimension bindDimension(OMADimension unresolvedDimension, Map<OMAResourceImpl, OMAResourceImpl> unresolvedToBoundResources, List<Root> omrResourcesAvailable, SessionContextInterface session) throws RemoteException, MetadataException, MdException {
        OMADimension outDimension = (OMADimension)unresolvedToBoundResources.get(unresolvedDimension);
        if (outDimension == null) {
            OMACube owningCube = (OMACube)unresolvedDimension.getOwningCube();
            OMACube boundCube = this.bindCube(owningCube, unresolvedToBoundResources, omrResourcesAvailable, session);
            if (boundCube.isUnresolved()) {
                if (!boundCube.getDimensions().contains(unresolvedDimension)) {
                    this.unexpectedConditionFound();
                }
                outDimension = unresolvedDimension;
            } else {
                com.sas.metadata.remote.Cube omrCube = (com.sas.metadata.remote.Cube)boundCube.getOMAObject();
                com.sas.metadata.remote.Dimension foundDimension = null;
                boolean duplicate = false;
                ArrayList dimensions = new ArrayList(omrCube.getDimensions());
                for (com.sas.metadata.remote.Dimension dim : dimensions) {
                    if (!IQModelImplUtilities.sameIgnoreCase(dim.getName(), unresolvedDimension.getLabel())) continue;
                    if (foundDimension != null) {
                        duplicate = true;
                        unresolvedDimension.setDuplicatesFoundDuringResolution(true);
                    }
                    foundDimension = dim;
                }
                if (duplicate || foundDimension == null) {
                    outDimension = unresolvedDimension;
                    outDimension.setOwningCube(boundCube);
                } else {
                    outDimension = (OMADimension)OMAResourceFactory.getReposObject(foundDimension, session, this._readingContext.getMetadataServer());
                    outDimension.setOwningCube(boundCube);
                }
            }
            unresolvedToBoundResources.put(unresolvedDimension, outDimension);
        }
        return outDimension;
    }

    protected OMACube bindCube(OMACube unresolvedCube, Map<OMAResourceImpl, OMAResourceImpl> unresolvedToBoundResources, List<Root> omrResourcesAvailable, SessionContextInterface session) throws RemoteException, MetadataException, MdException {
        OMACube outCube = (OMACube)unresolvedToBoundResources.get(unresolvedCube);
        if (outCube == null) {
            OMAOlapSchema owningOlapSchema = (OMAOlapSchema)unresolvedCube.getOwningOlapSchema();
            OMAOlapSchema boundOlapSchema = this.bindOlapSchema(owningOlapSchema, unresolvedToBoundResources, omrResourcesAvailable, session);
            if (boundOlapSchema.isUnresolved()) {
                if (!boundOlapSchema.getCubes().contains(unresolvedCube)) {
                    this.unexpectedConditionFound();
                }
                outCube = unresolvedCube;
            } else {
                OLAPSchema omrOlapSchema = (OLAPSchema)boundOlapSchema.getOMAObject();
                com.sas.metadata.remote.Cube foundCube = null;
                boolean duplicate = false;
                List<com.sas.metadata.remote.Cube> cubes = AssociationListUtil.filteredSnapshot(omrOlapSchema.getCubes(), com.sas.metadata.remote.Cube.class);
                for (com.sas.metadata.remote.Cube cube : cubes) {
                    if (!IQModelImplUtilities.sameIgnoreCase(cube.getName(), unresolvedCube.getLabel())) continue;
                    if (foundCube != null) {
                        duplicate = true;
                        unresolvedCube.setDuplicatesFoundDuringResolution(true);
                    }
                    foundCube = cube;
                }
                if (duplicate || foundCube == null) {
                    outCube = unresolvedCube;
                    outCube.setOwningOlapSchema(boundOlapSchema);
                } else {
                    outCube = (OMACube)OMAResourceFactory.getReposObject(foundCube, session, this._readingContext.getMetadataServer());
                }
            }
            unresolvedToBoundResources.put(unresolvedCube, outCube);
        }
        return outCube;
    }

    protected OMAOlapSchema bindOlapSchema(OMAOlapSchema unresolvedOlapSchema, Map<OMAResourceImpl, OMAResourceImpl> unresolvedToBoundResources, List<Root> omrResourcesAvailable, SessionContextInterface session) throws RemoteException, MetadataException, MdException {
        OMAOlapSchema outOlapSchema = (OMAOlapSchema)unresolvedToBoundResources.get(unresolvedOlapSchema);
        if (outOlapSchema == null) {
            OLAPSchema foundOlapSchema = null;
            boolean duplicate = false;
            for (Root omrObject : omrResourcesAvailable) {
                if (IQModelImplUtilities.sameIgnoreCase(omrObject.getName(), unresolvedOlapSchema.getLabel())) {
                    if (foundOlapSchema != null) {
                        duplicate = true;
                        unresolvedOlapSchema.setDuplicatesFoundDuringResolution(true);
                    }
                    foundOlapSchema = (OLAPSchema)omrObject;
                }
                if (!duplicate) continue;
                break;
            }
            outOlapSchema = duplicate || foundOlapSchema == null ? unresolvedOlapSchema : (OMAOlapSchema)OMAResourceFactory.getReposObject(foundOlapSchema, session, this._readingContext.getMetadataServer());
            unresolvedToBoundResources.put(unresolvedOlapSchema, outOlapSchema);
        }
        return outOlapSchema;
    }

    protected OMASoftwareServer bindServer(OMASoftwareServer unresolvedServer, Map<OMAResourceImpl, OMAResourceImpl> unresolvedToBoundResources, List<Root> omrResourcesAvailable, SessionContextInterface session) throws RemoteException, MetadataException, MdException {
        OMASoftwareServer outServer = (OMASoftwareServer)unresolvedToBoundResources.get(unresolvedServer);
        if (outServer == null) {
            ServerContext foundServerContext = null;
            boolean duplicateServerContext = false;
            Iterator<Root> it = omrResourcesAvailable.iterator();
            while (it.hasNext() && !duplicateServerContext) {
                Root omrObject = it.next();
                if (!(omrObject instanceof ServerContext) || !IQModelImplUtilities.sameIgnoreCase(omrObject.getName(), unresolvedServer.getLabel())) continue;
                if (foundServerContext != null) {
                    duplicateServerContext = true;
                    unresolvedServer.setDuplicatesFoundDuringResolution(true);
                }
                foundServerContext = (ServerContext)omrObject;
            }
            if (!duplicateServerContext && foundServerContext != null) {
                boolean wantRelationalServer = unresolvedServer instanceof OMASASWorkspaceServer;
                outServer = OMAResourceFactory.getOMAServerObject(foundServerContext, session, this._readingContext.getMetadataServer(), wantRelationalServer);
            }
            if (outServer == null) {
                outServer = unresolvedServer;
            }
            unresolvedToBoundResources.put(unresolvedServer, outServer);
        }
        return outServer;
    }

    protected void unexpectedConditionFound() throws MetadataException {
        if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
            _logger.error(IQModelImplUtilities.getMessage("BusinessModelResourceList.UnexpectedConditionFound.txt", new Object[0]));
        }
        throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelResourceList.UnexpectedConditionFound.txt", new Object[0]));
    }

    protected List runQueriesToGetOmrObjects(SessionContextInterface session, Map omaUnresolvedResources) throws MetadataException, RemoteException, ServiceException, MdException {
        List<Object> outOmrObjects = null;
        List<OMAResourceImpl> unresolvedResourceList = ListUtils.newList(omaUnresolvedResources.values());
        String serverName = this.getServerName(unresolvedResourceList);
        String schemaTemplate = this.createOMASchemaTemplate(unresolvedResourceList);
        if (schemaTemplate != null) {
            int omrFlags = 284;
            List smartObjects = null;
            if (!this._doResolve) {
                smartObjects = new ArrayList();
            } else {
                MetadataServerInterface metadataServer = this._readingContext.getMetadataServer();
                smartObjects = IQModelImplUtilities.generalSearch((ServerInterface)metadataServer, omrFlags, schemaTemplate, "Root", null);
            }
            outOmrObjects = IQModelImplUtilities.unwrapOMRSmartObjects(smartObjects);
            Collection<ServerContext> servers = this.getServersWithName(serverName, outOmrObjects);
            if (servers.size() == 0) {
                servers = this.getServersWithNameFromMetadataServer(serverName, session);
            }
            if (servers.size() != 0) {
                outOmrObjects.addAll(servers);
            }
        } else {
            outOmrObjects = new ArrayList();
        }
        return outOmrObjects;
    }

    protected String getServerName(List unresolvedResourceList) {
        String outServerName = null;
        Iterator it = unresolvedResourceList.iterator();
        while (it.hasNext() && outServerName == null) {
            Object obj = it.next();
            if (!(obj instanceof SoftwareServer)) continue;
            SoftwareServer softwareServer = (SoftwareServer)obj;
            outServerName = softwareServer.getLabel();
        }
        return outServerName;
    }

    protected Set<ServerContext> getServersWithName(String serverName, List<? extends CMetadata> omrObjects) throws MdException, RemoteException {
        LinkedHashSet<ServerContext> servers = new LinkedHashSet<ServerContext>();
        if (serverName != null) {
            for (CMetadata cMetadata : omrObjects) {
                if (!(cMetadata instanceof DeployedDataPackage)) continue;
                DeployedDataPackage ddp = (DeployedDataPackage)cMetadata;
                ArrayList deployedComponents = new ArrayList(ddp.getDeployedComponents());
                for (DeployedComponent dc : deployedComponents) {
                    ServerContext sc;
                    if (!(dc instanceof ServerContext) || !serverName.equals((sc = (ServerContext)dc).getName())) continue;
                    servers.add(sc);
                }
            }
        }
        return servers;
    }

    protected List<ServerContext> getServersWithNameFromMetadataServer(String serverName, SessionContextInterface session) throws RemoteException, MetadataException, ServiceException {
        ArrayList<ServerContext> servers = new ArrayList<ServerContext>();
        if (serverName != null) {
            String template = IQModelImplUtilities.replaceFirst(SERVER_TEMPLATE, "{0}", this.getNameClause(serverName));
            int omrFlags = 8476;
            MetadataServerInterface metadataServer = this._readingContext.getMetadataServer();
            List smartObjects = IQModelImplUtilities.generalSearch((ServerInterface)metadataServer, omrFlags, template, "ServerContext", null);
            List<Root> jomaObjects = IQModelImplUtilities.unwrapOMRSmartObjects(smartObjects);
            servers.addAll(jomaObjects);
        }
        return servers;
    }

    /*
     * WARNING - void declaration
     */
    protected String createOMASchemaTemplate(List<OMAResourceImpl> resourcesToGet) throws MetadataException, RemoteException, ServiceException, MdException {
        String outTemplate = null;
        LinkedHashSet<String> schemaNames = new LinkedHashSet<String>();
        LinkedHashSet<String> tableNames = new LinkedHashSet<String>();
        for (OMAResourceImpl oMAResourceImpl : resourcesToGet) {
            String string;
            if (oMAResourceImpl instanceof OMATable) {
                String schemaLabel;
                Object schema;
                OMATable oMATable = (OMATable)oMAResourceImpl;
                String tableLabel = oMATable.getLabel();
                if (tableLabel != null) {
                    tableNames.add(tableLabel);
                }
                if ((schema = (OMARelationalSchema)oMATable.getRelationalSchema()) == null || (schemaLabel = ((OMAResourceImpl)schema).getLabel()) == null) continue;
                schemaNames.add(schemaLabel);
                continue;
            }
            if (!(oMAResourceImpl instanceof OMASASLibrary) || (string = oMAResourceImpl.getLabel()) == null) continue;
            schemaNames.add(string);
        }
        StringBuffer sbSchemaNames = new StringBuffer();
        for (String string : schemaNames) {
            if (sbSchemaNames.length() > 0) {
                sbSchemaNames.append(" OR ");
            }
            sbSchemaNames.append(this.getNameClause(string));
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String tableNm : tableNames) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" OR ");
            }
            stringBuffer.append(this.getNameClause(tableNm));
        }
        if (stringBuffer.length() > 0 || sbSchemaNames.length() > 0) {
            String string;
            String string3 = RELATIONAL_SCHEMA_TEMPLATE;
            string3 = IQModelImplUtilities.replaceFirst(string3, "{0}", sbSchemaNames.toString());
            outTemplate = string = IQModelImplUtilities.replaceFirst(string3, "{1}", stringBuffer.toString());
        }
        if (outTemplate == null) {
            void var7_20;
            Object var7_19 = null;
            String cubeLabel = null;
            for (OMAResourceImpl resource : resourcesToGet) {
                if (!(resource instanceof OMACube)) continue;
                OMACube cube = (OMACube)resource;
                cubeLabel = cube.getLabel();
                OMAOlapSchema olapSchema = (OMAOlapSchema)cube.getOwningOlapSchema();
                String string = olapSchema.getLabel();
            }
            if (cubeLabel != null && var7_20 != null) {
                String olapSchemaTemplate = OLAP_SCHEMA_TEMPLATE;
                olapSchemaTemplate = IQModelImplUtilities.replaceFirst(olapSchemaTemplate, "{0}", this.getNameClause((String)var7_20));
                outTemplate = olapSchemaTemplate = IQModelImplUtilities.replaceFirst(olapSchemaTemplate, "{1}", this.getNameClause(cubeLabel));
            }
        }
        return outTemplate;
    }

    private String getNameClause(String label) {
        return "@Name='" + label + "'";
    }

    public void setDoResolve(boolean doResolve) {
        this._doResolve = doResolve;
    }
}

