/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractLocalizableBusinessModelObject;
import com.sas.iquery.metadata.business.step.CompoundStep;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberPropertiesFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeRangeFilter;
import com.sas.iquery.metadata.business.step.olap.PromptedTimeRangeFilter;
import com.sas.iquery.metadata.business.step.olap.StepManager;
import com.sas.iquery.metadata.business.step.relational.DataItemRankFilter;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDataItem
extends AbstractLocalizableBusinessModelObject
implements DataItem {
    private static final Logger _logger = LogManager.getLogger(AbstractDataItem.class);

    public AbstractDataItem() {
    }

    public AbstractDataItem(AbstractBusinessModel model) {
        super(model);
    }

    protected abstract void setStepsTrusted(List<? extends StepInterface> var1);

    protected abstract List<StepInterface> getStepsTrusted();

    @Override
    public void addStep(StepInterface step) throws MetadataException {
        this.changeableCheck();
        this.checkStep(step);
        StepManager.addStep(step, this.getStepsTrusted());
        step.addListener(this);
        this.fireChangeEvent("The data item's steps changed.");
    }

    @Override
    public StepInterface getStep(int stepNumber) {
        this.unresolvedCheck();
        return StepManager.getStep(stepNumber, this.getStepsTrusted());
    }

    @Override
    public List<StepInterface> getSteps() {
        this.unresolvedCheck();
        return this.getSteps(false);
    }

    @Override
    public List<StepInterface> getSteps(boolean includeBaseDataItems) {
        this.unresolvedCheck();
        return ListUtils.newList(this.getStepsTrusted());
    }

    @Override
    public void setSteps(List<? extends StepInterface> inputSteps) throws MetadataException {
        this.changeableCheck();
        inputSteps = ListUtils.newList(inputSteps);
        Utils.ensureProperArgumentTypes(inputSteps, new Class[]{StepInterface.class});
        for (int i = 0; i < inputSteps.size(); ++i) {
            StepInterface stp = inputSteps.get(i);
            this.checkStep(stp);
        }
        Utils.removeListenerOnTheseObjects(this, this.getStepsTrusted());
        StepManager.setSteps(inputSteps, this.getStepsTrusted());
        Utils.addListenerOnTheseObjects(this, inputSteps);
        this.fireChangeEvent("The data item's steps changed.");
    }

    @Override
    public void removeStep(int stepNumber) {
        this.changeableCheck();
        StepInterface stepToRemove = StepManager.getStep(stepNumber, this.getStepsTrusted());
        StepManager.removeStep(stepNumber, this.getStepsTrusted());
        if (stepToRemove != null) {
            stepToRemove.removeListener(this);
        }
        this.fireChangeEvent("The data item's steps changed.");
    }

    protected void checkStep(StepInterface step) throws MetadataException {
        this.checkStep(null, step);
    }

    private void checkStep(StepInterface rootStep, StepInterface step) throws MetadataException {
        if (step instanceof com.sas.iquery.metadata.business.step.olap.DataItemRankFilter || step instanceof DataItemRankFilter) {
            this.checkStepType(rootStep, step, DataItemActionType.STEP_RANK);
        } else if (step instanceof DataItemMemberFilter) {
            this.checkStepType(rootStep, step, DataItemActionType.STEP_MEMBER_FILTER);
        } else if (step instanceof DataItemTimeFilter || step instanceof DataItemTimeRangeFilter || step instanceof PromptedTimeRangeFilter) {
            this.checkStepType(rootStep, step, DataItemActionType.STEP_DATE_FILTER);
        } else if (step instanceof DataItemMemberPropertiesFilter) {
            this.checkStepType(rootStep, step, DataItemActionType.STEP_MEMBER_PROPERTY_FILTER);
        } else if (step instanceof DataItemDataBasedFilter) {
            this.checkStepType(rootStep, step, DataItemActionType.STEP_DATABASED_FILTER);
        } else if (step instanceof DataItemNavigationFilter) {
            this.checkStepType(rootStep, step, DataItemActionType.STEP_NAVIGATE);
        } else if (step instanceof CompoundStep) {
            CompoundStep cs = (CompoundStep)step;
            List<StepInterface> compoundSteps = cs.getSteps();
            int endOfSteps = compoundSteps.size();
            for (int stepNumber = 0; stepNumber < endOfSteps; ++stepNumber) {
                StepInterface childStep = compoundSteps.get(stepNumber);
                if (rootStep == null) {
                    rootStep = step;
                }
                this.checkStep(rootStep, childStep);
            }
        } else {
            MessageFormatter invalidStepMsg = step == null ? (rootStep == null ? IQModelImplUtilities.getMessageFormatter("DataItem.BadStepNull.fmt.txt", this) : IQModelImplUtilities.getMessageFormatter("DataItem.BadChildStepNull.fmt.txt", this, rootStep)) : (rootStep == null ? IQModelImplUtilities.getMessageFormatter("DataItem.BadStepUnknownType.fmt.txt", this, step, step.getClass().getName()) : IQModelImplUtilities.getMessageFormatter("DataItem.BadChildStepUnknownType.fmt.txt", this, rootStep, step, step.getClass().getName()));
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(invalidStepMsg.toString());
            }
            throw new MetadataException(invalidStepMsg);
        }
    }

    private void checkStepType(StepInterface rootStep, StepInterface step, DataItemActionType type) throws MetadataException {
        if (!this.isActionSupported(type)) {
            MessageFormatter msg = rootStep == null ? IQModelImplUtilities.getMessageFormatter("DataItem.BadStepActionType.fmt.txt", this, step, type) : IQModelImplUtilities.getMessageFormatter("DataItem.BadChildStepActionType.fmt.txt", this, rootStep, step, type);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg.toString());
            }
            throw new MetadataException(msg);
        }
    }

    @Override
    public String getLocalizationPrependKey() {
        return "DataItems";
    }
}

