/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.NamedObjectInterface;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.Association;
import com.sas.iquery.metadata.business.AssociationItem;
import com.sas.iquery.metadata.business.AssociationMatrix;
import com.sas.iquery.metadata.business.AssociationRule;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.BusinessGroup;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessModelReferenceInfo;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessRule;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.DataSourceRelationalQuery;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.DrillThroughToDetail;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportProperties;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.business.ExportType;
import com.sas.iquery.metadata.business.FilterCascadeRule;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Governing;
import com.sas.iquery.metadata.business.InformationMapFactory;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.LasrRule;
import com.sas.iquery.metadata.business.LasrType;
import com.sas.iquery.metadata.business.LocalizableModelObject;
import com.sas.iquery.metadata.business.MapFolder;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.QualifiedLevel;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.RequiredDataSources;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.RunStoredProcess;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModelObject;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModelItemWithIdentity;
import com.sas.iquery.metadata.business.impl.AbstractModelReference;
import com.sas.iquery.metadata.business.impl.AssociationMatrixImpl;
import com.sas.iquery.metadata.business.impl.AssociationRuleImpl;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.BusinessModelReferenceInfoImpl;
import com.sas.iquery.metadata.business.impl.CompoundFilterImpl;
import com.sas.iquery.metadata.business.impl.DataItemImpl;
import com.sas.iquery.metadata.business.impl.DataItemReferenceImpl;
import com.sas.iquery.metadata.business.impl.DataSourceCubeImpl;
import com.sas.iquery.metadata.business.impl.DataSourceImpl;
import com.sas.iquery.metadata.business.impl.DataSourceRelationalQueryImpl;
import com.sas.iquery.metadata.business.impl.DataSourceTableImpl2;
import com.sas.iquery.metadata.business.impl.DrillThroughToDetailImpl;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.business.impl.FilterCascadeRuleImpl;
import com.sas.iquery.metadata.business.impl.FilterItemImpl;
import com.sas.iquery.metadata.business.impl.GoverningImpl;
import com.sas.iquery.metadata.business.impl.GroupImpl;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.business.impl.JoinImpl;
import com.sas.iquery.metadata.business.impl.LasrRuleImpl;
import com.sas.iquery.metadata.business.impl.MapFolderImpl;
import com.sas.iquery.metadata.business.impl.OMRTemplates;
import com.sas.iquery.metadata.business.impl.PromptImpl;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.ReadingContextV2;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.RequiredDataSourcesImpl;
import com.sas.iquery.metadata.business.impl.RunStoredProcessImpl;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.OLAPResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.AccessPathToOlapData;
import com.sas.iquery.metadata.physical.AccessPathToRelationalData;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.OMAResourceFactory;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.metadata.physical.OlapServer;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.RelationalServer;
import com.sas.iquery.metadata.physical.SASOlapServer;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.Server;
import com.sas.iquery.metadata.physical.StoredProcess;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.inmemory.InMemoryQueryTable;
import com.sas.iquery.metadata.physical.inmemory.InMemoryServer;
import com.sas.iquery.metadata.physical.oma.OMASoftwareServer;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.ExportUtilities;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.util.LocalizableString;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class AbstractBusinessModel
extends AbstractModel
implements BusinessModel,
MultiLocaleProperties {
    public static final String INVALID_LABEL_CHARS = "\\ /";
    private IntelligentQueryMetadataServiceInterface metadataService;
    private ServerProperties serverProperties;
    private StructureOfData _structureDuringRead;
    private List<DataSource> _dataSources = new ArrayList<DataSource>();
    private List<BusinessRule> _businessRules = new ArrayList<BusinessRule>();
    private List<BusinessItem> _businessItems = new ArrayList<BusinessItem>();
    private List<BusinessGroup> _businessGroups = new ArrayList<BusinessGroup>();
    private List<BusinessModelObject> _unresolvedReferencedItemsWhenUnresolved = new ArrayList<BusinessModelObject>();
    private String serverPropertiesID;
    private List<BusinessQuery> _queries = new ArrayList<BusinessQuery>();
    private Locale _computationalLocale = null;
    private MapFolderImpl rootMapFolder;
    private HashMap<BusinessItem, MapFolder> items = new LinkedHashMap<BusinessItem, MapFolder>();
    private HashMap<MapFolder, List<BusinessItem>> folders = new LinkedHashMap<MapFolder, List<BusinessItem>>();
    private static final Logger _logger = LogManager.getLogger(AbstractBusinessModel.class);
    private static final Logger _persistRFSLogger = LogManager.getLogger((String)"com.sas.iquery.metadata.persist.readflow.summary");
    private static final String DEFAULT_BMID_PREFIX = "GenericBusinessModelID";
    private static final String USED = "used";
    private boolean externalReferencesRead = false;
    public static final String LOCALIZATION_KEY_DESCRIPTION = "Description";
    public static final String LOCALIZATION_KEY_LABEL = "Label";
    public static final String LOCALIZATION_KEY_NESTED_PROMPTS = "Prompts";
    public static final String LOCALIZATION_KEY_NESTED_DATA_ITEMS = "DataItems";
    public static final String LOCALIZATION_KEY_NESTED_FILTER_ITEMS = "FilterItems";
    public static final String LOCALIZATION_KEY_NESTED_DATA_SOURCES = "DataSources";
    public static final String LOCALIZATION_KEY_COMPUTATIONAL_LOCALE = "ComputationalLocale";
    public static final String LOCALIZATION_KEY_NESTED_MAP_FOLDERS = "Folders";
    public static final String LOCALIZATION_KEY_NESTED_BUSINESS_GROUP = "BusinessGroup";

    AbstractBusinessModel() {
    }

    public AbstractBusinessModel(@Nonnull SessionContextInterface session, @Nonnull IntelligentQueryMetadataServiceInterface service) {
        super(session);
        Preconditions.ensureNonNull(session, "session");
        Preconditions.ensureNonNull(service, "service");
        this.metadataService = service;
        this.rootMapFolder = new MapFolderImpl(this);
        this.addMapFolder(this.rootMapFolder);
    }

    public AbstractBusinessModel(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, Locale locale) {
        this(session, service);
        if (locale == null) {
            locale = LocaleUtilities.getDefaultComputationalLocale(session);
        }
        this._computationalLocale = locale;
    }

    public AbstractBusinessModel(@Nonnull AbstractBusinessModel newParentModel) {
        super(newParentModel);
        Preconditions.ensureNonNull(newParentModel, "newParentModel");
        this.metadataService = newParentModel.getMetadataService();
        this.rootMapFolder = new MapFolderImpl(this);
        this.addMapFolder(this.rootMapFolder);
    }

    @Override
    public BusinessModel getParentBusinessModel() {
        return (BusinessModel)((Object)this.getParent());
    }

    private AbstractBusinessModel getParentModel() {
        return (AbstractBusinessModel)this.getParent();
    }

    @Override
    public void removeChild(BusinessModel child) {
        if (child instanceof AbstractBusinessModel) {
            super.removeChild((AbstractBusinessModel)child);
        }
    }

    protected void reParentLinkage(AbstractBusinessModel newParent) throws MetadataException {
        super.reParentLinkage(newParent);
    }

    @Override
    protected String getDefaultIDPrefix() {
        return DEFAULT_BMID_PREFIX;
    }

    @Override
    public abstract BusinessModelReferenceInfo getReferenceInfo();

    boolean isBasedUpon(BusinessModel anotherBusinessModel) {
        BusinessModel prevModel;
        for (prevModel = this; prevModel != null && anotherBusinessModel != prevModel; prevModel = prevModel.getParentBusinessModel()) {
        }
        return prevModel != null;
    }

    @Override
    public void setLabel(String label) throws MetadataException {
        this.changeableCheck();
        if (!this.isValidLabel(label)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("MapFolder.InvalidLabel.fmt.txt", label, INVALID_LABEL_CHARS));
        }
        super.setLabel(label.trim());
    }

    @Override
    public boolean isValidLabel(String label) {
        if (label == null) {
            return false;
        }
        label = label.trim();
        for (int i = 0; i < label.length(); ++i) {
            char cur = label.charAt(i);
            if (cur != '/' && cur != '\\') continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return !this.isChangeable();
    }

    @Override
    public void setReadOnly() {
        try {
            this.setReadOnly(true);
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
    }

    public void setReadOnly(boolean inputReadOnly) throws MetadataException {
        List<BusinessModelObject> allObjects = this.getAllContainedObjects();
        for (BusinessModelObject bmo : allObjects) {
            AbstractBusinessModelObject abmo = (AbstractBusinessModelObject)bmo;
            abmo.setIsChangeable(!inputReadOnly);
        }
    }

    @Override
    public BusinessModel getBaseModel() {
        return this.getParentBusinessModel();
    }

    @Override
    public boolean isPersistable() {
        return this.getReasonsNotPersistable().size() == 0;
    }

    @Override
    protected void accumulateReasonsNotPersistable(List<Reason> reasons) {
        super.accumulateReasonsNotPersistable(reasons);
        List<BusinessModelObject> objsWithInvalidIDs = this.getObjectsWithConflictingIDs();
        for (BusinessModelObject bmo : objsWithInvalidIDs) {
            Reason reason = new Reason((Object)bmo, 1, 1, "BusinessModelImplIDNullOrConflicts.fmt.txt", bmo.getLabel());
            reasons.add(reason);
        }
        List<BusinessModelObject> allObjects = this.getAllContainedObjects();
        for (BusinessModelObject bmo : allObjects) {
            AbstractBusinessModelObject abmo = (AbstractBusinessModelObject)bmo;
            List<Reason> rs = abmo.getReasonsNotPersistable();
            if (rs.isEmpty()) continue;
            reasons.addAll(rs);
        }
    }

    BusinessModel getBusinessModelWithID(@Nonnull String ID) throws MetadataException, IllegalArgumentException {
        Preconditions.ensureNonNull(ID, "ID");
        BusinessModel foundBM = null;
        for (BusinessModel currentBM = this; currentBM != null; currentBM = currentBM.getBaseModel()) {
            String currentBMID = currentBM.getID();
            if (currentBMID == null || !currentBMID.equals(ID)) continue;
            if (foundBM != null) {
                MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("BusinessModelImplMultipleModelsInChain.fmt.txt", ID);
                Reason reason = new Reason((Object)this, 8, 25, msg);
                throw new MetadataException(msg, Collections.singletonList(reason));
            }
            foundBM = currentBM;
        }
        return foundBM;
    }

    @Override
    public Locale getDataLocale() {
        return this.getComputationalLocale();
    }

    @Override
    public Locale getComputationalLocale() {
        Locale result = null;
        BusinessModel parent = this.getParentBusinessModel();
        result = this._computationalLocale == null && parent != null ? parent.getComputationalLocale() : this._computationalLocale;
        return result;
    }

    @Override
    public void setComputationalLocale(Locale newLocale) {
        this._computationalLocale = newLocale;
    }

    private void setUniqueIntraModelID(List<String> idsInUse, DataItem item) throws MetadataException {
        String id = item.getIntraModelID();
        String newId = this.getUniqueIntraModelID(id, idsInUse, 2);
        idsInUse.add(newId);
        if (!newId.equals(id)) {
            item.setIntraModelID(newId);
        }
    }

    @Override
    public RootDataItem newDataItem(PhysicalResource physicalResource) throws MetadataException {
        this.changeableCheck();
        DataItemImpl item = new DataItemImpl(this);
        item.baseItemOnResource(physicalResource);
        return item;
    }

    @Override
    @Nonnull
    public List<DataItem> newDataItems(DataSource dataSource) throws MetadataException {
        return this.newDataItems(dataSource, null);
    }

    @Override
    @Nonnull
    public List<DataItem> newDataItems(DataSource dataSource, Properties options) throws MetadataException {
        ArrayList<DataItem> returnList;
        block6: {
            List<String> idsInUse;
            block5: {
                this.changeableCheck();
                returnList = new ArrayList<DataItem>();
                idsInUse = this.getAllContainedIntraModelIDs();
                if (!(dataSource instanceof DataSourceTable)) break block5;
                List<Column> columns = ((DataSourceTable)dataSource).getColumns();
                for (Column column : columns) {
                    RootDataItem item = this.newDataItem(column, options);
                    this.setUniqueIntraModelID(idsInUse, item);
                    returnList.add(item);
                }
                break block6;
            }
            if (!(dataSource instanceof DataSourceCube)) break block6;
            DataSourceCube cube = (DataSourceCube)dataSource;
            List<Dimension> dims = cube.getDimensions();
            for (int d = 0; d < dims.size(); ++d) {
                Dimension dim = dims.get(d);
                if (dim.getDimensionType() == 1) {
                    List<Measure> meas = cube.getMeasures();
                    for (int m = 0; m < meas.size(); ++m) {
                        RootDataItem item = this.newDataItem(meas.get(m), options);
                        this.setUniqueIntraModelID(idsInUse, item);
                        returnList.add(item);
                    }
                    continue;
                }
                List<Hierarchy> hiers = dim.getHierarchies();
                for (int h = 0; h < hiers.size(); ++h) {
                    Hierarchy hier = hiers.get(h);
                    RootDataItem item = this.newDataItem(hier, options);
                    this.setUniqueIntraModelID(idsInUse, item);
                    returnList.add(item);
                }
            }
        }
        return returnList;
    }

    @Override
    public DataSourceCube newDataSourceCube(String reposName, String serverName, String schemaName, String cubeName) throws MetadataException {
        return this.newDataSourceCube(serverName, schemaName, cubeName);
    }

    @Override
    public DataSourceCube newDataSourceCube(String serverName, String schemaName, String cubeName) throws MetadataException {
        this.changeableCheck();
        if (serverName == null || schemaName == null || cubeName == null) {
            MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.AllArgumentsMustBeSpecifiedForServerBasedCubeDataSource.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(errorMsg);
        }
        serverName = serverName.trim();
        schemaName = schemaName.trim();
        cubeName = cubeName.trim();
        DataSourceCube dataSource = null;
        SASOlapServer olapServer = null;
        OlapSchema olapSchema = null;
        Cube myCube = null;
        String template = OMRTemplates.getOLAPResourceResolutionTemplate(serverName, Arrays.asList(schemaName), Arrays.asList(cubeName), new ArrayList());
        try {
            MetadataServerInterface metadataServer = IQModelImplUtilities.getMetadataServerAuthenticatedWith(this.getSession());
            List serverContextSmartObjects = IQModelImplUtilities.generalSearch((ServerInterface)metadataServer, 0, template, "ServerContext", null);
            ServerContext context = null;
            if (serverContextSmartObjects.size() >= 1) {
                List<Root> serverContexts = IQModelImplUtilities.unwrapOMRSmartObjects(serverContextSmartObjects);
                for (Root root : serverContexts) {
                    SASOlapServer thisOlapServer;
                    if (!(root instanceof ServerContext) || !serverName.equalsIgnoreCase((thisOlapServer = (SASOlapServer)((Object)OMAResourceFactory.getOMAServerObject(context = (ServerContext)root, this.getSession(), metadataServer, false))).getLabel())) continue;
                    olapServer = thisOlapServer;
                    break;
                }
            }
            if (olapServer == null) {
                MessageFormatter message = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.ServerNotFound.fmt.txt", serverName);
                throw new MetadataException(message);
            }
            AssociationList packages = context.getDataPackages();
            OLAPSchema jomaOlapschema = null;
            if (packages.size() >= 1) {
                for (Object ddpackage : packages) {
                    if (!schemaName.equalsIgnoreCase(ddpackage.getName()) || !(ddpackage instanceof OLAPSchema)) continue;
                    jomaOlapschema = (OLAPSchema)ddpackage;
                    olapSchema = (OlapSchema)((Object)OMAResourceFactory.getReposObject((CMetadata)jomaOlapschema, this.getSession(), metadataServer));
                    break;
                }
            }
            if (olapSchema == null) {
                MessageFormatter messageFormatter = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.SchemaNotFound.fmt.txt", schemaName, serverName);
                throw new MetadataException(messageFormatter);
            }
            AssociationList associationList = jomaOlapschema.getCubes();
            if (associationList.size() >= 1) {
                for (com.sas.metadata.remote.Cube cube : associationList) {
                    Cube thisCube = (Cube)((Object)OMAResourceFactory.getReposObject((CMetadata)cube, this.getSession(), metadataServer));
                    if (!cubeName.equalsIgnoreCase(thisCube.getCubeName())) continue;
                    myCube = thisCube;
                    break;
                }
            }
            if (myCube == null) {
                MessageFormatter message = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.CubeNotFound.fmt.txt", cubeName, schemaName, serverName);
                throw new MetadataException(message);
            }
            dataSource = this.newDataSourceCube(olapServer, olapSchema, myCube);
            dataSource.setLabel(cubeName);
        }
        catch (RemoteException re) {
            MessageFormatter message = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.ServerNotFound.fmt.txt", serverName);
            throw new MetadataException(message, (Throwable)re);
        }
        catch (ServiceException se) {
            MessageFormatter message = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.ServerNotFound.fmt.txt", serverName);
            throw new MetadataException(message, (Throwable)se);
        }
        catch (MdException me) {
            MessageFormatter message = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.CubeNotFound.fmt.txt", cubeName, schemaName, serverName);
            throw new MetadataException(message, (Throwable)me);
        }
        return dataSource;
    }

    @Override
    public DataSourceTable newDataSourceTable(String reposName, String serverName, String accessingSchemaName, String tableName) throws MetadataException {
        return this.newDataSourceTable(serverName, accessingSchemaName, tableName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataSourceTable newDataSourceTable(@Nonnull String serverName, @Nonnull String accessingSchemaName, @Nonnull String tableName) throws MetadataException {
        this.changeableCheck();
        if (serverName == null || accessingSchemaName == null || tableName == null) {
            MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.AllArgumentsMustBeSpecifiedForServerBasedTableDataSource.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(errorMsg);
        }
        serverName = serverName.trim();
        accessingSchemaName = accessingSchemaName.trim();
        tableName = tableName.trim();
        String template = OMRTemplates.getRelationalResourceResolutionTemplate(serverName, Arrays.asList(accessingSchemaName), Arrays.asList(tableName), new ArrayList());
        OMASoftwareServer server = null;
        com.sas.iquery.metadata.physical.SASLibrary schema = null;
        Table myTable = null;
        DataSourceTable dst = null;
        try {
            void var14_29;
            MetadataServerInterface metadataServer = IQModelImplUtilities.getMetadataServerAuthenticatedWith(this.getSession());
            List serverContextSmartObjects = IQModelImplUtilities.generalSearch((ServerInterface)metadataServer, 0, template, "ServerContext", null);
            ServerContext context = null;
            if (serverContextSmartObjects.size() >= 1) {
                List<Root> serverContexts = IQModelImplUtilities.unwrapOMRSmartObjects(serverContextSmartObjects);
                for (Root root : serverContexts) {
                    OMASoftwareServer serverObject;
                    if (!(root instanceof ServerContext) || !serverName.equalsIgnoreCase((serverObject = OMAResourceFactory.getOMAServerObject(context = (ServerContext)root, this.getSession(), metadataServer, true)).getLabel())) continue;
                    server = serverObject;
                    break;
                }
            }
            if (server == null) {
                MessageFormatter message = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.ServerNotFound.fmt.txt", serverName);
                throw new MetadataException(message);
            }
            AssociationList packages = context.getDataPackages();
            SASLibrary jomaLibrary = null;
            if (packages.size() >= 1) {
                for (DeployedDataPackage ddpackage : packages) {
                    if (!accessingSchemaName.equalsIgnoreCase(ddpackage.getName()) || !(ddpackage instanceof SASLibrary)) continue;
                    jomaLibrary = (SASLibrary)ddpackage;
                    schema = (com.sas.iquery.metadata.physical.SASLibrary)((Object)OMAResourceFactory.getReposObject((CMetadata)jomaLibrary, this.getSession(), metadataServer));
                    break;
                }
            }
            if (schema == null) {
                MessageFormatter messageFormatter = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.SchemaNotFound.fmt.txt", accessingSchemaName, serverName);
                throw new MetadataException(messageFormatter);
            }
            Object var14_25 = null;
            if (jomaLibrary.getIsDBMSLibname() > 0) {
                RelationalSchema relationalSchemaToUse = null;
                List<RelationalSchema> relationalSchemas = AssociationListUtil.filteredSnapshot(jomaLibrary.getUsingPackages(), RelationalSchema.class);
                if (!relationalSchemas.isEmpty()) {
                    relationalSchemaToUse = relationalSchemas.get(0);
                }
                if (relationalSchemaToUse != null) {
                    AssociationList associationList = relationalSchemaToUse.getTables();
                }
            } else {
                AssociationList associationList = jomaLibrary.getTables();
            }
            if (var14_29 != null && var14_29.size() >= 1) {
                List<PhysicalTable> physicalTables = AssociationListUtil.filteredSnapshot((AssociationList)var14_29, PhysicalTable.class);
                for (PhysicalTable table : physicalTables) {
                    if (!tableName.equalsIgnoreCase(table.getName())) continue;
                    myTable = (Table)((Object)OMAResourceFactory.getReposObject((CMetadata)table, this.getSession(), metadataServer));
                    break;
                }
            }
            if (myTable == null) {
                MessageFormatter message = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.TableNotFound.fmt.txt", tableName, accessingSchemaName, serverName);
                throw new MetadataException(message);
            }
            AccessPathToRelationalData accessPath = new AccessPathToRelationalData(server, schema);
            dst = this.newDataSourceTable(accessPath, myTable);
            dst.setLabel(tableName);
        }
        catch (RemoteException e) {
            MessageFormatter message = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.ServerNotFound.fmt.txt", serverName);
            throw new MetadataException(message, (Throwable)e);
        }
        catch (ServiceException se) {
            MessageFormatter message = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.TableNotFound.fmt.txt", tableName, accessingSchemaName, serverName);
            throw new MetadataException(message, (Throwable)se);
        }
        catch (MdException me) {
            MessageFormatter message = IQModelImplUtilities.getMessageFormatter("InformationMapImpl.ServerNotFound.fmt.txt", serverName);
            throw new MetadataException(message, (Throwable)me);
        }
        return dst;
    }

    @Override
    public DataSourceTable newDataSourceTable(RelationalServer accessViaThisRelationalServer, com.sas.iquery.metadata.physical.RelationalSchema accessViaThisRelationalSchema, Table table) throws MetadataException {
        AccessPathToRelationalData accessPath = new AccessPathToRelationalData(accessViaThisRelationalServer, accessViaThisRelationalSchema);
        return this.newDataSourceTable(accessPath, table);
    }

    @Override
    public DataSourceTable newDataSourceTable(AccessPath accessPath, Table table) throws MetadataException {
        this.changeableCheck();
        DataSourceTableImpl2 dst = new DataSourceTableImpl2(this, accessPath, table);
        return dst;
    }

    @Override
    public DataSourceRelationalQuery newDataSourceRelationalQuery(BusinessQuery businessQuery) throws MetadataException {
        this.changeableCheck();
        DataSourceRelationalQueryImpl dsrq = new DataSourceRelationalQueryImpl(this, businessQuery);
        return dsrq;
    }

    @Override
    public DataSourceCube newDataSourceCube(OlapServer server, OlapSchema schema, Cube cube) throws MetadataException {
        return this.newDataSourceCube(new AccessPathToOlapData(server, schema), cube);
    }

    @Override
    public DataSourceCube newDataSourceCube(AccessPathToOlapData accessPath, Cube cube) throws MetadataException {
        this.changeableCheck();
        DataSourceCubeImpl dsc = new DataSourceCubeImpl(this, accessPath, cube);
        return dsc;
    }

    public DataSourceCube newDataSourceCube() {
        DataSourceCubeImpl dsc = new DataSourceCubeImpl(this);
        return dsc;
    }

    @Override
    public void addDataSource(DataSource dataSource) throws MetadataException {
        this.addDataSource(this._dataSources.size(), dataSource);
    }

    @Override
    public void addDataSource(int index, @Nonnull DataSource dataSource) throws MetadataException {
        Preconditions.ensureNonNull(dataSource, "dataSource");
        this.changeableCheck();
        if (!this._dataSources.contains(dataSource)) {
            if (this.isDataSourceCompatible(dataSource)) {
                if (index < 0 || index > this._dataSources.size()) {
                    this._dataSources.add(dataSource);
                } else {
                    this._dataSources.add(index, dataSource);
                }
                this.fireChangeEvent("data sources changed");
            } else {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImplDataSourceNotAdded.txt", new Object[0]));
            }
        }
    }

    @Override
    public boolean isDataSourceCompatible(DataSource dataSource) {
        boolean compatible = true;
        Iterator<DataSource> it = this._dataSources.iterator();
        while (compatible && it.hasNext()) {
            DataSourceImpl ds = (DataSourceImpl)it.next();
            compatible = ds.isCompatibleWith(dataSource);
        }
        return compatible;
    }

    public boolean isBusinessRuleCompatible(BusinessRule rule) throws MetadataException {
        boolean compatible = true;
        if (rule instanceof RunStoredProcess) {
            RunStoredProcess process = (RunStoredProcess)rule;
            StoredProcess physicalStoredProcess = process.getStoredProcess();
            boolean found = false;
            if (physicalStoredProcess != null) {
                StoredProcessInterface omaStoredProcess = process.getStoredProcess().getStoredProcessInterface();
                List<StoredProcessInterface> processes = this.getAvailableStoredProcesses(true);
                for (StoredProcessInterface spi : processes) {
                    try {
                        if (!IQModelImplUtilities.same(spi.getReposId(), omaStoredProcess.getReposId())) continue;
                        found = true;
                        break;
                    }
                    catch (RemoteException e) {
                        _logger.debug("RemoteException while testing for stored process compatibility.", (Throwable)e);
                    }
                }
            }
            if (!found) {
                compatible = false;
            }
        }
        return compatible;
    }

    @Override
    public List<BusinessModelObject> removeDataSource(@Nonnull DataSource dataSource) throws MetadataException {
        this.changeableCheck();
        Preconditions.ensureNonNull(dataSource, _logger);
        ArrayList<BusinessModelObject> dependentObjects = new ArrayList<BusinessModelObject>();
        if (this._dataSources.contains(dataSource)) {
            List<BusinessItem> dependentBusinessItems = this.getObjectsBasedOn(dataSource, BusinessItem.class);
            dependentObjects.addAll(dependentBusinessItems);
            dependentObjects.addAll(this.getObjectsBasedOn(dataSource, BusinessRule.class));
            if (this._dataSources.size() == 1) {
                List<RunStoredProcess> storedProcesses = this.getObjects(false, RunStoredProcess.class);
                dependentObjects.addAll(storedProcesses);
            }
            this._dataSources.remove(dataSource);
            this._businessRules.removeAll(dependentObjects);
            this._businessItems.removeAll(dependentObjects);
            this.removeFromFolders(dependentBusinessItems);
            this.removeFromBusinessGroups(dataSource);
            for (BusinessModelObject busModelObj : dependentObjects) {
                this.removeFromBusinessGroups(busModelObj);
            }
            this.fireChangeEvent("data sources changed");
        }
        if (this._dataSources.isEmpty()) {
            this.serverProperties = null;
        }
        return dependentObjects;
    }

    @Override
    public StructureOfData getStructure() {
        StructureOfData structure = null;
        if (!this._dataSources.isEmpty()) {
            DataSource ds = this._dataSources.get(0);
            structure = ds.getStructure();
        } else {
            AbstractBusinessModel baseModel = this.getParentModel();
            if (baseModel != null) {
                if (baseModel.isUnresolved()) {
                    structure = new StructureOfData();
                    if (this._structureDuringRead != null) {
                        structure.setIsRelational(this._structureDuringRead.isRelational());
                        structure.setIsOLAP(this._structureDuringRead.isOLAP());
                    }
                } else {
                    structure = baseModel.getStructure();
                }
            } else {
                structure = new StructureOfData();
            }
        }
        return structure;
    }

    StructureOfData trustedGetStructureDuringRead() {
        return this._structureDuringRead;
    }

    @Override
    public ServerProperties getServerProperties() throws MetadataException {
        if (this.serverProperties == null) {
            this.serverProperties = this.computeServerProperties();
        }
        return this.serverProperties;
    }

    @Override
    public List<StoredProcessInterface> getAvailableStoredProcesses() throws MetadataException {
        return this.getAvailableStoredProcesses(false);
    }

    @Override
    public List<StoredProcessInterface> getAvailableStoredProcesses(boolean includeHidden) throws MetadataException {
        ArrayList<StoredProcessInterface> returnList = new ArrayList<StoredProcessInterface>();
        ServerContextInterface serverContext = null;
        try {
            DataSource source;
            Server server;
            List<DataSource> sources = this.getObjects(true, DataSource.class);
            if (!sources.isEmpty() && (server = (source = sources.get(0)).getServer()) instanceof OMASoftwareServer) {
                OMASoftwareServer omaSoftwareServer = (OMASoftwareServer)server;
                LogicalServerInterface logicalServer = omaSoftwareServer.getNonPooledLogicalServerInterface();
                if (logicalServer == null) {
                    logicalServer = omaSoftwareServer.getPooledLogicalServerInterface();
                }
                if (logicalServer != null) {
                    List serverContextServers = AssociationListUtil.getCopyIfASL(logicalServer.getServed());
                    if (serverContextServers.size() == 1) {
                        serverContext = (ServerContextInterface)serverContextServers.get(0);
                    }
                    if (serverContext != null) {
                        StructureOfData struct = this.getStructure();
                        if (struct.isOLAP()) {
                            List servers = AssociationListUtil.getCopyIfASL(serverContext.getServers());
                            for (LogicalServerInterface element : servers) {
                                if (!element.getClassIdentifier().equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") && !element.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c") && !element.getClassIdentifier().equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb")) continue;
                                this.retrieveStoredProcesses((com.sas.services.information.metadata.ServerInterface)element, returnList);
                            }
                        } else {
                            this.retrieveStoredProcesses((com.sas.services.information.metadata.ServerInterface)logicalServer, returnList);
                        }
                        this.retrieveStoredProcesses((com.sas.services.information.metadata.ServerInterface)serverContext, returnList);
                    }
                }
            }
        }
        catch (ServiceException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImplUnableToGetStoredProcesses.txt", new Object[0]), (Throwable)e);
        }
        catch (RemoteException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImplUnableToGetStoredProcesses.txt", new Object[0]), (Throwable)e);
        }
        catch (MdException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImplUnableToGetStoredProcesses.txt", new Object[0]), (Throwable)e);
        }
        if (!includeHidden) {
            Iterator it = returnList.iterator();
            while (it.hasNext()) {
                StoredProcessInterface spi = (StoredProcessInterface)it.next();
                try {
                    CMetadata reposEntity = (CMetadata)spi.getRepositoryEntity();
                    if (!(reposEntity instanceof PrimaryType) || ((PrimaryType)reposEntity).getIsHidden() != 1) continue;
                    it.remove();
                }
                catch (RemoteException e) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Removing stored process from available list", (Throwable)e);
                    }
                    it.remove();
                }
            }
        }
        return returnList;
    }

    private void retrieveStoredProcesses(com.sas.services.information.metadata.ServerInterface computeLocation, List<StoredProcessInterface> storedProcesses) throws MdException, RemoteException, ServiceException {
        List<StoredProcessInterface> stps = IQModelImplUtilities.getAvailableStoredProcesses(computeLocation);
        if (stps != null) {
            if (storedProcesses.isEmpty()) {
                storedProcesses.addAll(stps);
            } else {
                for (StoredProcessInterface c : stps) {
                    if (storedProcesses.contains(c)) continue;
                    storedProcesses.add(c);
                }
            }
        }
    }

    private ServerProperties computeServerProperties() throws MetadataException {
        ServerProperties sp = null;
        List<DataSource> dsList = this.getObjects(true, DataSource.class);
        if (!dsList.isEmpty()) {
            for (DataSource ds : dsList) {
                if (ds.getServer() instanceof InMemoryServer) {
                    InMemoryServer imServer = (InMemoryServer)ds.getServer();
                    sp = imServer.getServerPropertes();
                } else {
                    sp = this.metadataService.getPropertiesForServer(this.getSession(), ds.getServer());
                }
                if (sp == null) continue;
                return sp;
            }
        } else if (_logger.isEnabled(Level.WARN)) {
            _logger.warn(IQModelImplUtilities.getMessage("BusinessModelImplNoDataSources.txt", new Object[0]));
        }
        if (sp == null && this.getParentBusinessModel() != null) {
            sp = this.getParentBusinessModel().getServerProperties();
        }
        return sp;
    }

    @Override
    public Join newJoin() throws MetadataException {
        this.changeableCheck();
        JoinImpl join = new JoinImpl(this);
        return join;
    }

    @Override
    public Governing newGoverning() throws MetadataException {
        this.changeableCheck();
        GoverningImpl governing = new GoverningImpl(this);
        return governing;
    }

    @Override
    public RunStoredProcess newRunStoredProcess() throws MetadataException {
        this.changeableCheck();
        RunStoredProcessImpl rStoredProcess = new RunStoredProcessImpl(this);
        return rStoredProcess;
    }

    @Override
    public DrillThroughToDetail newDrillThroughToDetail() throws MetadataException {
        this.changeableCheck();
        DrillThroughToDetailImpl dttd = new DrillThroughToDetailImpl(this);
        return dttd;
    }

    @Override
    public void addBusinessRule(BusinessRule rule) throws MetadataException {
        this.addBusinessRule(this._businessRules.size(), rule);
    }

    @Override
    public void addBusinessRule(int index, @Nonnull BusinessRule rule) throws MetadataException {
        Preconditions.ensureNonNull(rule, "rule");
        this.changeableCheck();
        if (!this._businessRules.contains(rule)) {
            if (this.isBusinessRuleCompatible(rule)) {
                if (index < 0 || index > this._businessRules.size()) {
                    this._businessRules.add(rule);
                } else {
                    this._businessRules.add(index, rule);
                }
                this.fireChangeEvent("business rules changed");
            } else {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImplBusinessRuleNotAdded.txt", new Object[0]));
            }
        }
    }

    @Override
    public List<BusinessRule> removeBusinessRule(@Nonnull BusinessRule rule) throws MetadataException {
        Preconditions.ensureNonNull(rule, "rule");
        this.changeableCheck();
        List<BusinessRule> dependentRules = Collections.emptyList();
        if (this._businessRules.contains(rule)) {
            dependentRules = this.getObjectsBasedOn(rule, BusinessRule.class);
            if (dependentRules.size() > 0) {
                this._businessRules.removeAll(dependentRules);
            }
            this._businessRules.remove(rule);
            this.removeFromBusinessGroups(rule);
            for (BusinessRule dRule : dependentRules) {
                this.removeFromBusinessGroups(dRule);
            }
            this.fireChangeEvent("business rules changed");
        }
        return dependentRules;
    }

    @Override
    public RootDataItem newDataItem() throws MetadataException {
        this.changeableCheck();
        return new DataItemImpl(this);
    }

    @Override
    public RootDataItem newDataItem(PhysicalResource physicalResource, Properties options) throws MetadataException {
        this.changeableCheck();
        DataItemImpl item = new DataItemImpl(this);
        item.baseItemOnResource(physicalResource, options);
        return item;
    }

    @Override
    public DataItemReference newDataItemReference(DataItem baseDataItem) throws MetadataException {
        this.changeableCheck();
        DataItemReferenceImpl diRefImpl = new DataItemReferenceImpl(this, baseDataItem);
        return diRefImpl;
    }

    @Override
    public FilterItem newFilterItem() throws MetadataException {
        this.changeableCheck();
        return new FilterItemImpl(this);
    }

    @Override
    public CompoundFilter newCompoundFilter() throws MetadataException {
        this.changeableCheck();
        return new CompoundFilterImpl(this);
    }

    @Override
    public Prompt newPrompt() throws MetadataException {
        this.changeableCheck();
        return new PromptImpl(this);
    }

    @Override
    public AssociationMatrix newAssociationMatrix() throws MetadataException {
        this.changeableCheck();
        return new AssociationMatrixImpl(this);
    }

    @Override
    public BusinessGroup newBusinessGroup(BusinessGroup.Type type) throws MetadataException {
        this.changeableCheck();
        return new GroupImpl(this, type);
    }

    @Override
    public void addBusinessGroup(@Nonnull BusinessGroup businessGroup) throws MetadataException {
        Preconditions.ensureNonNull(businessGroup, "businessGroup");
        if (businessGroup.getBusinessModel() != this) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImplBusinessGroupNotCreated.txt", new Object[0]));
        }
        this.changeableCheck();
        if (!this._businessGroups.contains(businessGroup)) {
            this._businessGroups.add(businessGroup);
        }
    }

    @Override
    public void removeBusinessGroup(@Nonnull BusinessGroup businessGroup) throws MetadataException {
        Preconditions.ensureNonNull(businessGroup, "businessGroup");
        if (businessGroup.getBusinessModel() != this) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImplBusinessGroupNotCreated.txt", new Object[0]));
        }
        this.changeableCheck();
        this._businessGroups.remove(businessGroup);
    }

    @Override
    public synchronized void addBusinessItem(BusinessItem businessItem) throws MetadataException {
        if (!this._businessItems.contains(businessItem)) {
            this.addBusinessItem(this._businessItems.size(), businessItem);
        }
    }

    @Override
    public synchronized void addBusinessItem(int index, @Nonnull BusinessItem businessItem) throws MetadataException {
        Preconditions.ensureNonNull(businessItem, "businessItem");
        if (businessItem.getBusinessModel() != this) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImplBusinessItemNotCreated.txt", new Object[0]));
        }
        this.changeableCheck();
        int alreadyAtIndex = this._businessItems.indexOf(businessItem);
        if (alreadyAtIndex != index) {
            if (alreadyAtIndex != -1) {
                this._businessItems.remove(alreadyAtIndex);
            }
            try {
                this._businessItems.add(index, businessItem);
            }
            catch (IndexOutOfBoundsException e) {
                if (alreadyAtIndex != -1) {
                    this._businessItems.add(alreadyAtIndex, businessItem);
                }
                throw e;
            }
            this.fireChangeEvent("business items changed");
        }
    }

    @Override
    public synchronized List<BusinessItem> removeBusinessItem(@Nonnull BusinessItem businessItem) throws MetadataException {
        Preconditions.ensureNonNull(businessItem, "businessItem");
        BusinessModel itemsModel = businessItem.getBusinessModel();
        if (itemsModel != this) {
            boolean found = false;
            for (BusinessModel scan = this.getParentModel(); scan != null && !found; scan = scan.getParentBusinessModel()) {
                found = scan == itemsModel;
            }
            if (!found) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImplBusinessItemNotCreated.txt", new Object[0]));
            }
        }
        this.changeableCheck();
        List<BusinessItem> dependentItems = this.getObjectsBasedOn(businessItem, BusinessItem.class);
        this.removeFromContainers(businessItem);
        if (itemsModel == this) {
            for (BusinessItem dItem : dependentItems) {
                this.removeFromBusinessGroups(dItem);
                this.removeFromFolder(dItem);
            }
            if (dependentItems.size() > 0) {
                this._businessItems.removeAll(dependentItems);
            }
            this._businessItems.remove(businessItem);
            this.fireChangeEvent("business items changed");
        }
        return dependentItems;
    }

    private void removeFromContainers(BusinessItem businessItem) throws MetadataException {
        this.removeFromAssociationMatrix(businessItem);
        this.removeFromBusinessGroups(businessItem);
        this.removeFromFolder(businessItem);
    }

    private void removeFromAssociationMatrix(BusinessItem itemRemoved) throws MetadataException {
        if (itemRemoved instanceof AssociationItem) {
            List<BusinessRule> dependentItems = this.getObjects(false, BusinessRule.class);
            Iterator<BusinessRule> it = dependentItems.iterator();
            while (it.hasNext()) {
                BusinessRule item = it.next();
                if (!(item instanceof AssociationMatrix)) continue;
                AssociationMatrix matrix = (AssociationMatrix)item;
                List<Association> associations = matrix.getAssociationsBasedOn((AssociationItem)((Object)itemRemoved));
                for (Association association : associations) {
                    matrix.removeAssociation(association);
                }
                it.remove();
            }
        }
    }

    private void removeFromBusinessGroups(@Nonnull BusinessModelObject itemRemoved) throws MetadataException {
        for (BusinessGroup group : this._businessGroups) {
            if (group instanceof GroupImpl) {
                ((GroupImpl)group).remove(itemRemoved);
                continue;
            }
            List<BusinessModelObject> items = group.getItems();
            items.remove(itemRemoved);
            group.setItems(items);
        }
    }

    @Override
    public boolean contains(@Nonnull BusinessModelObject businessModelObject) {
        Preconditions.ensureNonNull(businessModelObject, "businessModelObject");
        return this._contains(businessModelObject);
    }

    @Override
    protected boolean contains(Object obj) {
        return this._contains(obj);
    }

    private boolean _contains(Object obj) {
        boolean found = false;
        if (IQModelImplUtilities.firstIndexOfUsingEqualsEquals(this._businessItems, obj) >= 0) {
            found = true;
        } else if (IQModelImplUtilities.firstIndexOfUsingEqualsEquals(this._dataSources, obj) >= 0) {
            found = true;
        } else if (IQModelImplUtilities.firstIndexOfUsingEqualsEquals(this._businessRules, obj) >= 0) {
            found = true;
        } else if (IQModelImplUtilities.firstIndexOfUsingEqualsEquals(this._businessGroups, obj) >= 0) {
            found = true;
        }
        return found;
    }

    @Override
    public boolean contains(boolean includeBaseModels, BusinessModelObject businessModelObject) {
        return super.contains(includeBaseModels, businessModelObject);
    }

    @Override
    public synchronized void setBusinessItems(List<BusinessItem> items) throws MetadataException {
        this.changeableCheck();
        for (BusinessItem bi : items) {
            if (bi.getBusinessModel() == this) continue;
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImplGivenBusinessItemNotCreated.txt", new Object[0]));
        }
        this._businessItems.clear();
        this._businessItems.addAll(items);
        this.fireChangeEvent("business items changed");
    }

    @Override
    public <T extends BusinessModelObject> List<T> getObjectsBasedOn(BusinessModelObject baseObject, @Nonnull Class<T> type) throws MetadataException {
        return this.getObjectsBasedOn((ModelItem)baseObject, type);
    }

    @Override
    public <T extends BusinessModelObject> List<T> getObjectsBasedOn(PhysicalResource baseResource, @Nonnull Class<T> type) throws MetadataException {
        return this.getObjectsBasedOn((ModelItem)baseResource, type);
    }

    private <T extends BusinessModelObject> List<T> getObjectsBasedOn(ModelItem modelItem, @Nonnull Class<T> type) throws MetadataException {
        type = type == null ? BusinessModelObject.class : type;
        ArrayList<BusinessModelObject> results = new ArrayList<BusinessModelObject>();
        if (modelItem != null && BusinessModelObject.class.isAssignableFrom(type)) {
            boolean isDataSource = modelItem instanceof DataSource;
            ArrayList<ModelItem> basedOnResources = new ArrayList<ModelItem>();
            basedOnResources.add(modelItem);
            if (isDataSource) {
                if (modelItem instanceof DataSourceTable) {
                    DataSourceTable tableResource = (DataSourceTable)modelItem;
                    basedOnResources.addAll(tableResource.getColumns());
                } else if (modelItem instanceof DataSourceCube) {
                    DataSourceCube cubeResource = (DataSourceCube)modelItem;
                    for (Dimension dim : cubeResource.getDimensions()) {
                        basedOnResources.add(dim);
                        for (Hierarchy hierarchy : dim.getHierarchies()) {
                            basedOnResources.add(hierarchy);
                            basedOnResources.addAll(hierarchy.getLevels());
                        }
                    }
                    basedOnResources.addAll(cubeResource.getMeasures());
                }
            }
            List<BusinessModelObject> bmObjects = this.getAllContainedObjects();
            for (BusinessModelObject bmo : bmObjects) {
                if (!type.isInstance(bmo)) continue;
                List<BusinessModelResource> resources = bmo instanceof AbstractModelItem ? ((AbstractModelItem)((Object)bmo)).getResources(BusinessModelResource.class, 65535, true) : bmo.getResources(BusinessModelResource.class, 65535);
                boolean found = false;
                Iterator iter = basedOnResources.iterator();
                while (!found && iter.hasNext()) {
                    ModelItem basedOnResource = (ModelItem)iter.next();
                    if (!resources.contains(basedOnResource)) continue;
                    BusinessModelObject obj = (BusinessModelObject)type.cast(bmo);
                    results.add(obj);
                    found = true;
                }
            }
        }
        return results;
    }

    @Override
    public String getID() {
        return this.getIdentity();
    }

    @Override
    public void setID(String ID) throws MetadataException {
        if (!this.isLegalID(ID)) {
            Object[] args = new Object[]{new String(INVALID_ID_CHARS)};
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImplBadID.fmt.txt", args));
        }
        super.setIdentity(ID);
        this.fireChangeEvent("ID changed");
    }

    @Override
    public List<String> getBaseModelIDs() {
        ArrayList<String> outList = new ArrayList<String>();
        if (this.getParentModel() != null) {
            String baseModelID = this.getParentModel().getID();
            if (baseModelID != null) {
                outList.add(baseModelID);
            }
            outList.addAll(this.getParentModel().getBaseModelIDs());
        }
        return outList;
    }

    @Override
    public DataSource getDataSourceByID(String id) throws MetadataException {
        DataSource foundObject = this.getBusinessModelObjectByID(id, DataSource.class);
        return foundObject;
    }

    @Override
    public BusinessRule getBusinessRuleByID(String id) throws MetadataException {
        BusinessRule foundObject = this.getBusinessModelObjectByID(id, BusinessRule.class);
        return foundObject;
    }

    @Override
    public BusinessItem getBusinessItemByID(String id) throws MetadataException {
        BusinessItem foundObject = this.getBusinessModelObjectByID(id, BusinessItem.class);
        return foundObject;
    }

    AbstractBusinessModelObject getItemByID(String objectIdentity) {
        AbstractBusinessModelObject abmo;
        int i;
        AbstractBusinessModelObject out = null;
        for (i = 0; i < this._businessItems.size() && out == null; ++i) {
            abmo = (AbstractBusinessModelObject)((Object)this._businessItems.get(i));
            if (!IQModelImplUtilities.same(abmo.getIntraModelID(), objectIdentity)) continue;
            out = abmo;
        }
        for (i = 0; i < this._dataSources.size() && out == null; ++i) {
            abmo = (AbstractBusinessModelObject)((Object)this._dataSources.get(i));
            if (!IQModelImplUtilities.same(abmo.getIntraModelID(), objectIdentity)) continue;
            out = abmo;
        }
        for (i = 0; i < this._businessRules.size() && out == null; ++i) {
            abmo = (AbstractBusinessModelObject)((Object)this._businessRules.get(i));
            if (!IQModelImplUtilities.same(abmo.getIntraModelID(), objectIdentity)) continue;
            out = abmo;
        }
        for (i = 0; i < this._businessGroups.size() && out == null; ++i) {
            abmo = (AbstractBusinessModelObject)((Object)this._businessGroups.get(i));
            if (!IQModelImplUtilities.same(abmo.getIntraModelID(), objectIdentity)) continue;
            out = abmo;
        }
        return out;
    }

    <T extends BusinessModelObject> T getBusinessModelObjectByID(String id, @Nonnull Class<T> type) throws MetadataException {
        BusinessModelObject foundBmo;
        block19: {
            Preconditions.ensureNonNull(id, "id");
            Preconditions.ensureNonNull(type, "type");
            foundBmo = null;
            boolean localGet = !AbstractBusinessModel.isInterModelID(id);
            String intraModelID = id;
            if (!localGet) {
                String givenBmid = AbstractBusinessModel.getBusinessModelID(id);
                intraModelID = AbstractBusinessModel.getIntraModelID(id);
                if (IQModelImplUtilities.same(this.getIdentity(), givenBmid)) {
                    localGet = true;
                } else {
                    AbstractBusinessModel abstractBusinessModel = (AbstractBusinessModel)this.getBusinessModelWithID(givenBmid);
                    if (abstractBusinessModel != null) {
                        foundBmo = (BusinessModelObject)abstractBusinessModel.getBusinessModelObjectByID(intraModelID, type);
                    } else if (_logger.isDebugEnabled()) {
                        _logger.debug("No " + type + " class with the id " + intraModelID);
                    }
                }
            }
            if (!localGet) break block19;
            if (type == BusinessItem.class) {
                for (BusinessItem businessItem : this._businessItems) {
                    String bmoID = businessItem.getIntraModelID();
                    if (bmoID == null || !intraModelID.equals(bmoID)) continue;
                    foundBmo = businessItem;
                    break;
                }
            } else if (type == BusinessRule.class) {
                for (BusinessRule businessRule : this._businessRules) {
                    String bmoID = businessRule.getIntraModelID();
                    if (!intraModelID.equals(bmoID)) continue;
                    foundBmo = businessRule;
                    break;
                }
            } else if (type == BusinessGroup.class) {
                for (BusinessGroup businessGroup : this._businessGroups) {
                    String bmoID = businessGroup.getIntraModelID();
                    if (!intraModelID.equals(bmoID)) continue;
                    foundBmo = businessGroup;
                    break;
                }
            } else if (type == DataSource.class) {
                for (DataSource dataSource : this._dataSources) {
                    String bmoID = dataSource.getIntraModelID();
                    if (!intraModelID.equals(bmoID)) continue;
                    foundBmo = dataSource;
                    break;
                }
            } else {
                for (BusinessModelObject businessModelObject : this.getAllContainedObjects()) {
                    String bmoID;
                    if (!type.isInstance(businessModelObject) || !intraModelID.equals(bmoID = businessModelObject.getIntraModelID())) continue;
                    foundBmo = businessModelObject;
                    break;
                }
            }
        }
        return (T)((BusinessModelObject)type.cast(foundBmo));
    }

    public synchronized void cleanUpBusinessItemsById(HashSet<String> idSet) {
        ListIterator<BusinessItem> iter = this._businessItems.listIterator(this._businessItems.size());
        int cleanedup = 0;
        while (iter.hasPrevious()) {
            try {
                String id = iter.previous().getID();
                if (id == null || !idSet.remove(id)) continue;
                iter.remove();
                ++cleanedup;
            }
            catch (InvalidIDException invalidIDException) {}
        }
        if (cleanedup > 0) {
            this.fireChangeEvent("business items changed");
        }
    }

    private static boolean isInterModelID(String id) {
        int lastIndex;
        int firstIndex;
        boolean isInterModelID = false;
        if (id != null && (firstIndex = id.indexOf(".")) != -1 && firstIndex == (lastIndex = id.lastIndexOf(".")) && firstIndex != 0 && firstIndex != id.length() - 1) {
            isInterModelID = true;
        }
        return isInterModelID;
    }

    public static String getBusinessModelID(@Nonnull String interModelID) throws MetadataException {
        Preconditions.ensureNonNull(interModelID, "interModelID");
        int index = interModelID.indexOf(".");
        if (index == -1 || interModelID.indexOf(".", index + 1) != -1) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImplBadInterID.txt", new Object[0]));
        }
        String bmid = interModelID.substring(0, index);
        return bmid;
    }

    public static String getIntraModelID(@Nonnull String interModelID) throws MetadataException {
        Preconditions.ensureNonNull(interModelID, "interModelID");
        int index = interModelID.indexOf(".");
        if (index == -1 || interModelID.indexOf(".", index + 1) != -1) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImplBadInterID.txt", new Object[0]));
        }
        String intraModelID = interModelID.substring(index + 1);
        return intraModelID;
    }

    public static String getInterModelID(@Nonnull String businessModelID, @Nonnull String intraModelID) {
        Preconditions.ensureNonNull(businessModelID, "businessModelID");
        Preconditions.ensureNonNull(intraModelID, "intraModelID");
        return businessModelID + "." + intraModelID;
    }

    @Override
    public boolean isIntraModelIDInUse(@Nonnull String ID) {
        Preconditions.ensureNonNull(ID, "ID");
        List<String> idsInUse = this.getAllContainedIntraModelIDs();
        return idsInUse.contains(ID);
    }

    List<String> getAllContainedIntraModelIDs() {
        ArrayList<String> outIDs = new ArrayList<String>();
        List<BusinessModelObject> objs = this.getAllContainedObjects();
        for (BusinessModelObject bmo : objs) {
            String thisID = bmo.getIntraModelID();
            if (thisID == null) continue;
            outIDs.add(thisID);
        }
        return outIDs;
    }

    @Override
    public boolean isLegalID(String ID) {
        boolean isLegal = true;
        if (ID == null || ID.trim().length() == 0) {
            isLegal = false;
        } else {
            for (int i = 0; i < INVALID_ID_CHARS.length; ++i) {
                if (ID.indexOf(INVALID_ID_CHARS[i]) == -1) continue;
                isLegal = false;
                break;
            }
        }
        return isLegal;
    }

    private static String makeLegalID(String ID) {
        if (ID.trim().length() == 0) {
            ID = "_";
        } else {
            for (int i = 0; i < INVALID_ID_CHARS.length; ++i) {
                ID = ID.replace(INVALID_ID_CHARS[i], '_');
            }
        }
        return ID;
    }

    @Override
    public String generateIntraModelID(@Nonnull String proposedID) {
        Preconditions.ensureNonNull(proposedID, "proposedID");
        if (!this.isLegalID(proposedID)) {
            proposedID = AbstractBusinessModel.makeLegalID(proposedID);
        }
        List<String> idsInUse = this.getAllContainedIntraModelIDs();
        return this.getUniqueIntraModelID(proposedID, idsInUse, 2);
    }

    protected String getUniqueIntraModelID(String proposedID, List<String> idsInUse, int seed) {
        String result = proposedID;
        char separator = '_';
        StringBuffer newID = null;
        while (this.isIntraModelIDUsed(idsInUse, result)) {
            if (newID == null) {
                newID = new StringBuffer();
            } else {
                newID.setLength(0);
            }
            newID.append(separator);
            newID.append(Integer.toString(seed++));
            int length = newID.length();
            if (proposedID.length() + length <= 32) {
                result = newID.insert(0, proposedID).toString();
                continue;
            }
            newID.insert(0, proposedID.substring(0, 32 - length));
            newID.append(separator);
            newID.append(proposedID.substring(32 - length));
            result = newID.toString();
        }
        return result;
    }

    protected boolean isIntraModelIDUsed(List<String> ids, String newID) {
        String usedID;
        int usedIDLength;
        boolean isUsed = false;
        int newIDLength = Math.min(32, newID.length());
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext() && (newIDLength != (usedIDLength = Math.min(32, (usedID = iterator.next()).length())) || !(isUsed = usedID.regionMatches(true, 0, newID, 0, newIDLength)))) {
        }
        return isUsed;
    }

    @Override
    public List<BusinessModelObject> getAllContainedObjects() {
        ArrayList<BusinessModelObject> outList = new ArrayList<BusinessModelObject>(this._dataSources);
        outList.addAll(this._businessRules);
        outList.addAll(this._businessItems);
        outList.addAll(this._businessGroups);
        return outList;
    }

    @Override
    protected void clearReferencesToModelItems() {
        super.clearReferencesToModelItems();
        this._businessGroups = (List)this.clearItemUsages(this._businessGroups);
        this._businessItems = (List)this.clearItemUsages(this._businessItems);
        this._businessRules = (List)this.clearItemUsages(this._businessRules);
        this._dataSources = (List)this.clearItemUsages(this._dataSources);
        this._structureDuringRead = null;
        this.folders.clear();
        this.items.clear();
        this.rootMapFolder = null;
    }

    @Override
    public synchronized <T> List<T> getObjects(boolean includeBaseModels, @Nonnull Class<T> type) {
        type = type == null ? BusinessModelObject.class : type;
        ArrayList<Object> outList = new ArrayList<Object>();
        if (BusinessModelObject.class == type) {
            outList.addAll(this._dataSources);
            outList.addAll(this._businessRules);
            outList.addAll(this._businessItems);
            outList.addAll(this._businessGroups);
        } else {
            Object obj;
            if (DataSource.class.isAssignableFrom(type)) {
                for (DataSource dataSource : this._dataSources) {
                    if (!type.isInstance(dataSource)) continue;
                    obj = type.cast(dataSource);
                    outList.add(obj);
                }
            }
            if (BusinessRule.class.isAssignableFrom(type)) {
                for (BusinessRule businessRule : this._businessRules) {
                    if (!type.isInstance(businessRule)) continue;
                    obj = type.cast(businessRule);
                    outList.add(obj);
                }
            }
            if (BusinessItem.class.isAssignableFrom(type)) {
                for (BusinessItem businessItem : this._businessItems) {
                    if (!type.isInstance(businessItem)) continue;
                    obj = type.cast(businessItem);
                    outList.add(obj);
                }
            }
            if (BusinessGroup.class.isAssignableFrom(type)) {
                for (BusinessGroup businessGroup : this._businessGroups) {
                    if (!type.isInstance(businessGroup)) continue;
                    obj = type.cast(businessGroup);
                    outList.add(obj);
                }
            }
        }
        if (includeBaseModels && this.getParentModel() != null) {
            outList.addAll(this.getParentModel().getObjects(includeBaseModels, type));
        }
        return outList;
    }

    @Override
    public <T> List<T> getObjects(int flags, @Nonnull Class<T> type) {
        T obj;
        boolean includeHiddenObjects;
        boolean includeBaseModels;
        Preconditions.ensureNonNull(type, _logger);
        ArrayList<T> outList = new ArrayList<T>();
        if (flags == 0) {
            includeBaseModels = false;
            includeHiddenObjects = false;
        } else {
            includeBaseModels = (flags & 1) != 0;
            boolean bl = includeHiddenObjects = (flags & 2) != 0;
        }
        if (DataSource.class.isAssignableFrom(type)) {
            for (DataSource dataSource : this._dataSources) {
                if (!includeHiddenObjects && dataSource.isHidden() || !type.isInstance(dataSource)) continue;
                obj = type.cast(dataSource);
                outList.add(obj);
            }
        }
        if (BusinessRule.class.isAssignableFrom(type)) {
            for (BusinessRule businessRule : this._businessRules) {
                if (!includeHiddenObjects && businessRule.isHidden() || !type.isInstance(businessRule)) continue;
                obj = type.cast(businessRule);
                outList.add(obj);
            }
        }
        if (BusinessItem.class.isAssignableFrom(type)) {
            for (BusinessItem businessItem : this._businessItems) {
                if (!includeHiddenObjects && businessItem.isHidden() || !type.isInstance(businessItem)) continue;
                obj = type.cast(businessItem);
                outList.add(obj);
            }
        }
        if (BusinessGroup.class.isAssignableFrom(type)) {
            for (BusinessGroup businessGroup : this._businessGroups) {
                if (!includeHiddenObjects && businessGroup.isHidden() || !type.isInstance(businessGroup)) continue;
                obj = type.cast(businessGroup);
                outList.add(obj);
            }
        }
        if (includeBaseModels && this.getParentModel() != null) {
            outList.addAll(this.getParentModel().getObjects(flags, type));
        }
        return outList;
    }

    @Override
    public synchronized <T extends BusinessModelObject> List<T> getObjectsWithInvalidIDs(@Nonnull Class<T> type) {
        type = type == null ? BusinessModelObject.class : type;
        ArrayList<BusinessModelObject> outList = new ArrayList<BusinessModelObject>();
        List<String> allIdList = this.getAllContainedIntraModelIDs();
        List<T> objList = this.getObjects(false, type);
        for (BusinessModelObject bmo : objList) {
            String thisID = bmo.getIntraModelID();
            if (thisID == null) {
                BusinessModelObject obj = (BusinessModelObject)type.cast(bmo);
                outList.add(obj);
                continue;
            }
            ArrayList<String> tempList = new ArrayList<String>(allIdList);
            tempList.remove(thisID);
            if (!tempList.contains(thisID)) continue;
            BusinessModelObject obj = (BusinessModelObject)type.cast(bmo);
            outList.add(obj);
        }
        return outList;
    }

    private List<BusinessModelObject> getObjectsWithConflictingIDs() {
        ArrayList<BusinessModelObject> outList = new ArrayList<BusinessModelObject>();
        ArrayList<BusinessModelObject> objectsWithIDs = new ArrayList<BusinessModelObject>();
        if (this._businessItems != null) {
            objectsWithIDs.addAll(this._businessItems);
        }
        if (this._dataSources != null) {
            objectsWithIDs.addAll(this._dataSources);
        }
        if (this._businessRules != null) {
            objectsWithIDs.addAll(this._businessRules);
        }
        if (this._businessGroups != null) {
            objectsWithIDs.addAll(this._businessGroups);
        }
        HashMap<String, String> usedIDs = new HashMap<String, String>();
        for (BusinessModelObject bmo : objectsWithIDs) {
            AbstractModelItemWithIdentity itemWithIdentity = (AbstractModelItemWithIdentity)((Object)bmo);
            String thisID = itemWithIdentity.getIntraModelIdentity();
            if (usedIDs.put(thisID, USED) == null) continue;
            outList.add(bmo);
        }
        return outList;
    }

    @Override
    public boolean isUsableInQuery() {
        return this.getReasonsUnusable().isEmpty();
    }

    @Override
    public List<Reason> getReasonsUnusable() {
        return new ArrayList<Reason>();
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        DataItemActionType missingDIUsage;
        super.writeDefinition(thisElement, writingContext);
        StructureOfData struct = this.getStructure();
        if ((struct.isRelational() || struct.isTabular()) && struct.isOLAP()) {
            String msg = IQModelImplUtilities.getMessage("AbstractBusinessModel.InvalidStructureOnSave.txt", new Object[0]);
            throw new UnsupportedOperationException(msg);
        }
        if (!struct.equals(StructureOfData.NONE)) {
            IQModelImplUtilities.setAttr(thisElement, "inputStructure", struct.toValueString());
        }
        if (this._dataSources.size() != 0) {
            this.getServerProperties();
            if (this.serverProperties != null) {
                this.serverPropertiesID = this.serverProperties.getID();
                IQModelImplUtilities.setAttr(thisElement, "serverPropsID", this.serverPropertiesID);
            }
        }
        if ((missingDIUsage = this.writeMissingDataItemUsageMeaning(thisElement)) != null) {
            writingContext.setMissingDataItemUsage(missingDIUsage);
        }
        ArrayList<BusinessModelObject> orderedListOfContents = new ArrayList<BusinessModelObject>();
        orderedListOfContents.addAll(this._dataSources);
        orderedListOfContents.addAll(this._businessItems);
        orderedListOfContents.addAll(this._businessRules);
        orderedListOfContents.addAll(this._businessGroups);
        AbstractBusinessModel.writeRelatedObjects(orderedListOfContents, thisElement, writingContext, "ContainedItems");
        AbstractBusinessModel.writeRelatedObjects(this._queries, thisElement, writingContext, "Queries");
        this.writeDataLocale(this._computationalLocale, thisElement, writingContext, "DataLocale");
        this.writeFolder(this.rootMapFolder, thisElement, writingContext, "RootFolder");
    }

    void writeFolder(MapFolder folder, Node parentNode, WritingContext writingContext, String newSubelementName) throws MetadataException {
        AbstractBusinessModel.writeRelatedObject(this.rootMapFolder, parentNode, writingContext, "RootFolder");
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this.serverPropertiesID = attrsProvider.consumeAttr("serverPropsID");
        DataItemActionType missingDIUsage = DataItemActionType.consumeValue(attrsProvider, "missingUsageOnDataItems", null);
        if (missingDIUsage != null) {
            attrsProvider.setDataItemUsageWhenMissing(missingDIUsage);
        }
        String struct = attrsProvider.consumeAttr("inputStructure");
        this._structureDuringRead = null;
        if (struct != null) {
            this._structureDuringRead = StructureOfData.valueOf(struct);
        }
        if (this.serverPropertiesID != null) {
            try {
                this.serverProperties = this.metadataService.getPropertiesForServer(this.getSession(), this.serverPropertiesID);
            }
            catch (MetadataException e) {
                SAXException se = new SAXException(e);
                se.initCause(e);
                throw se;
            }
        }
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._computationalLocale = (Locale)riHolder.consumeForeignObject("DataLocale");
        List<AbstractModelItemWithIdentity> contents = riHolder.consumeObjects("ContainedItems", AbstractModelItemWithIdentity.class);
        int size = contents.size();
        for (int i = 0; i < size; ++i) {
            AbstractModelItemWithIdentity obj = contents.get(i);
            if (obj instanceof BusinessItem) {
                BusinessItem businessItem = (BusinessItem)((Object)obj);
                this._businessItems.add(businessItem);
                continue;
            }
            if (obj instanceof DataSource) {
                DataSource dataSource = (DataSource)((Object)obj);
                this._dataSources.add(dataSource);
                continue;
            }
            if (obj instanceof BusinessRule) {
                BusinessRule businessRule = (BusinessRule)((Object)obj);
                this._businessRules.add(businessRule);
                continue;
            }
            if (obj instanceof BusinessGroup) {
                BusinessGroup businessGroup = (BusinessGroup)((Object)obj);
                this._businessGroups.add(businessGroup);
                continue;
            }
            throw new IQueryServicesRuntimeException(IQModelImplUtilities.getMessageFormatter("AbstractBusinessModel.UnknownObjectInXML.fmt.txt", obj.getIdentityString()));
        }
        this._queries = riHolder.consumeObjects("Queries", BusinessQuery.class);
        MapFolderImpl folder = (MapFolderImpl)riHolder.consumeObject("RootFolder");
        if (folder != null) {
            this.removeMapFolder(this.rootMapFolder);
            this.rootMapFolder = folder;
        }
    }

    @Override
    protected void postPopulationProcessing(ReadingContextV2 readingContext) throws MetadataException {
        long startTimePostPopulationProcessing = 0L;
        if (_persistRFSLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogReadFlowSummary("begin post model population processing");
            startTimePostPopulationProcessing = System.currentTimeMillis();
        }
        List remainingUnresolvedObjects = readingContext.replaceExternalResourcesWithinModel();
        this.setUnresolvedResources(remainingUnresolvedObjects);
        ExtraLoggingContexts.debugLogReadFlowSummary("begin data item valid actions & aggregations initialization");
        List<DataItemImpl> dataItems = this.getObjects(false, DataItemImpl.class);
        for (DataItemImpl dii : dataItems) {
            dii.initializeValidActionsAndAggregations();
        }
        ExtraLoggingContexts.debugLogReadFlowSummary("end   data item valid actions & aggregations initialization");
        ExtraLoggingContexts.debugLogReadFlowSummary("begin adding unreferenced columns in data sources");
        ArrayList<DataSourceTableImpl2.ReadModification> dstReadMods = this.fixupDataSourceTables();
        readingContext.setDSTReadMods(dstReadMods);
        ExtraLoggingContexts.debugLogReadFlowSummary("end   adding unreferenced columns in data sources");
        ExtraLoggingContexts.debugLogReadFlowSummary("begin setting up listeners in model");
        this.setUpListenersWithinModel(readingContext.trustedGetObjsCreatedDuringRead());
        if (_persistRFSLogger.isDebugEnabled()) {
            long elapsedTimePostPopulationProcessing = System.currentTimeMillis() - startTimePostPopulationProcessing;
            ExtraLoggingContexts.debugLogReadFlowSummary("end   setting up listeners in model");
            ExtraLoggingContexts.debugLogReadFlowSummary("end   post model population processing (includes any waiting for metadata server): " + elapsedTimePostPopulationProcessing + "ms");
        }
        this.convertOLAPResource(dataItems);
    }

    private void convertOLAPResource(List dataItems) {
        Iterator dimIter = dataItems.iterator();
        AbstractBusinessModel businessModel = this;
        if (!businessModel.getStructure().isOLAP()) {
            return;
        }
        while (dimIter.hasNext()) {
            ExpressionInterface expression;
            DataItemImpl dataItem = (DataItemImpl)dimIter.next();
            boolean isUnresolved = false;
            isUnresolved = !dataItem.isUsableInQuery() ? true : dataItem.isUnresolved();
            if (isUnresolved || !((expression = dataItem.getExpression()) instanceof ResourceAwareStringExpression) || expression instanceof OLAPResourceAwareStringExpression) continue;
            ResourceAwareStringExpression raseOld = (ResourceAwareStringExpression)expression;
            ResourceScope raseScope = raseOld.getResourceScope();
            if (raseScope.equals(ResourceScope.BUSINESS_SCOPE)) {
                List<BusinessModelResource> resources = raseOld.getResources(BusinessModelResource.class, 65535);
                for (BusinessModelResource bmaResource : resources) {
                    if (!(bmaResource instanceof Dimension) && !(bmaResource instanceof Hierarchy) && !(bmaResource instanceof com.sas.iquery.metadata.physical.Level) && !(bmaResource instanceof Measure)) continue;
                    raseScope = ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE;
                }
            }
            try {
                ExpressionInterface raseConverted = StringExpressionUtil.getInstance().newExpression(businessModel, raseOld.getText(), expression.getExpressionType(), raseScope);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Expression converted during read" + raseOld.getText());
                }
                dataItem.replaceDirectReferences(raseOld, raseConverted);
            }
            catch (MetadataException me) {
                if (!_logger.isDebugEnabled()) continue;
                Object[] msgArgs2 = new Object[]{"Expression could not be converted during read. ", me};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                _logger.debug(msF.toString());
            }
        }
    }

    @Override
    public void consumeExternalReferenceRelatedItems(RelatedObjectListsHolder rilsHolder) throws SAXException {
        super.consumeExternalReferenceRelatedItems(rilsHolder);
        this._unresolvedReferencedItemsWhenUnresolved = rilsHolder.consumeObjects("ReferencedItems", BusinessModelObject.class);
        this.setBMOsToModelLink(this._unresolvedReferencedItemsWhenUnresolved);
    }

    private void setBMOsToModelLink(List unresolvedBMOs) {
        for (int i = 0; i < unresolvedBMOs.size(); ++i) {
            AbstractModelItemWithIdentity ami = (AbstractModelItemWithIdentity)unresolvedBMOs.get(i);
            ami.setModel(this);
        }
    }

    protected void addRelationshipsToUnresolvedResources(IdentityHashMap mapping) {
        this.noteRelationshipsWithOtherUnresolvedResources(mapping, "ReferencedItems", this._unresolvedReferencedItemsWhenUnresolved);
    }

    private DataItemActionType writeMissingDataItemUsageMeaning(Element thisElement) {
        int measureCount = 0;
        int categoryCount = 0;
        int detailCount = 0;
        int biSize = this._businessItems.size();
        for (int i = 0; i < biSize; ++i) {
            BusinessItem businessItem = this._businessItems.get(i);
            if (!(businessItem instanceof DataItemImpl)) continue;
            DataItem di = (DataItem)businessItem;
            DataItemActionType u = di.getUsage();
            if (u == DataItemActionType.USAGE_AGGREGATE) {
                ++measureCount;
                continue;
            }
            if (u == DataItemActionType.USAGE_CATEGORY) {
                ++categoryCount;
                continue;
            }
            if (u != DataItemActionType.USAGE_DETAIL) continue;
            ++detailCount;
        }
        int max = categoryCount;
        DataItemActionType missingDIUsage = DataItemActionType.USAGE_CATEGORY;
        if (measureCount > max) {
            max = measureCount;
            missingDIUsage = DataItemActionType.USAGE_AGGREGATE;
        }
        if (detailCount > max) {
            max = detailCount;
            missingDIUsage = DataItemActionType.USAGE_DETAIL;
        }
        if (max > 3) {
            IQModelImplUtilities.setEnumAttr(thisElement, "missingUsageOnDataItems", missingDIUsage);
        } else {
            missingDIUsage = null;
        }
        return missingDIUsage;
    }

    @Override
    public String toXML(int spacesPerIndentation) throws MetadataException {
        Element bogusParent = IQModelImplUtilities.newDocumentWithElementName("BogusElement");
        ExtraLoggingContexts.debugLogWriteFlowDetails("start writing model to a DOM");
        Element element = this.write(bogusParent);
        ExtraLoggingContexts.debugLogWriteFlowDetails("end   writing model to a DOM");
        ExtraLoggingContexts.debugLogWriteFlowDetails("start creating XML String from DOM");
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version='1.0' encoding='UTF-8'?>");
        if (spacesPerIndentation != 0) {
            buf.append('\n');
        }
        buf.append(IQModelImplUtilities.toPrettyString(element, spacesPerIndentation));
        String exportedXml = buf.toString();
        ExtraLoggingContexts.debugLogWriteFlowDetails("end   creating XML String from DOM");
        return exportedXml;
    }

    @Override
    public Element write(@Nonnull Element parentElement) throws MetadataException {
        if (parentElement == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplMapItemNull.txt", new Object[0]));
        }
        return this.writeAsInlineXMLUnder(parentElement, null).getElement();
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this.serverPropertiesID = IQModelImplUtilities.getAttr(thisElement, "serverPropsID");
        this.readExternalReferencesV1(thisElement, readingContext);
        this._dataSources = AbstractBusinessModel.v1_readItemListUnderSubelement(thisElement, readingContext, "DataSourceList", new Class[]{DataSource.class});
        if (this._dataSources.size() > 0 && this.getServerProperties() == null) {
            this.serverProperties = this.metadataService.getPropertiesForServer(this.getSession(), this.serverPropertiesID);
        }
        AbstractBusinessModel.v1_readItemListUnderSubelement(thisElement, readingContext, "QualifiedResourceList", new Class[]{QualifiedColumn.class, QualifiedLevel.class});
        this._businessRules = AbstractBusinessModel.v1_readItemListUnderSubelementIgnoreElementNamed(thisElement, readingContext, "BusinessRuleList", new Class[]{BusinessRule.class}, "ModelIsNewerThanRelease_912");
        this._businessItems = AbstractBusinessModel.v1_readItemListUnderSubelement(thisElement, readingContext, "BusinessItemList", new Class[]{BusinessItem.class});
        MapFolderImpl folder = (MapFolderImpl)AbstractBusinessModel.v1_readItemDirectlyUnderElement(thisElement, readingContext, "MapFolder", new Class[]{MapFolderImpl.class});
        if (folder != null) {
            this.removeMapFolder(this.rootMapFolder);
            this.rootMapFolder = folder;
        }
    }

    protected void readExternalReferencesV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        if (!this.externalReferencesRead) {
            this.externalReferencesRead = true;
            Element externalResourcesElement = IQModelImplUtilities.getSpecificKidElement(thisElement, "ExternalResourceList");
            if (externalResourcesElement != null) {
                List<Element> subelements = IQModelImplUtilities.getSubelements(externalResourcesElement);
                for (Element xrefElement : subelements) {
                    readingContext.readExternalReferenceElement(xrefElement);
                }
            }
        }
    }

    @Override
    protected void postReadV1(ReadingContext readingContext) throws MetadataException {
        super.postReadV1(readingContext);
        this.fixupDataSourceTables();
    }

    private ArrayList<DataSourceTableImpl2.ReadModification> fixupDataSourceTables() throws MetadataException {
        ArrayList<DataSourceTableImpl2.ReadModification> dstMods = new ArrayList<DataSourceTableImpl2.ReadModification>();
        for (DataSource ds : this._dataSources) {
            if (!(ds instanceof DataSourceTableImpl2)) continue;
            DataSourceTableImpl2 dst = (DataSourceTableImpl2)ds;
            dst.resolveColumnManagerOmittedColumns();
            DataSourceTableImpl2.ReadModification dstMod = dst.addUnusedColumns();
            if (!dstMod.hasModsToTellAPIUser()) continue;
            dstMods.add(dstMod);
        }
        return dstMods;
    }

    @Override
    public IntelligentQueryMetadataServiceInterface getMetadataService() {
        return this.metadataService;
    }

    @Override
    IntelligentQueryMetadataServiceInterface getService() {
        return this.metadataService;
    }

    @Override
    void setService(IntelligentQueryMetadataServiceInterface service) {
        this.metadataService = service;
    }

    @Override
    @Nonnull
    public <T> List<T> getResources(Class<T> type) {
        return this.getResources(type, 65535);
    }

    @Override
    public <T> List<T> getResources(Class<T> type, int flags) {
        Preconditions.ensureNonNull(type);
        if (!BusinessModelResource.class.isAssignableFrom(type)) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("Utils.MustSpecifyClassOrInterf.txt", new Object[0]));
        }
        ArrayList outList = new ArrayList();
        List<BusinessModelObject> bmos = this.getObjects(false, BusinessModelObject.class);
        for (BusinessModelObject bmo : bmos) {
            Utils.addResource(outList, bmo, type, flags);
        }
        return outList;
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource) throws MetadataException {
        this.replaceResource(oldResource, newResource, true);
    }

    @Override
    public void replaceResource(@Nonnull BusinessModelResource oldResource, @Nonnull BusinessModelResource newResource, boolean recursive) throws MetadataException {
        this.changeableCheck();
        Preconditions.ensureNonNull(oldResource, _logger);
        Preconditions.ensureNonNull(newResource, _logger);
        List<BusinessModelObject> allObjects = this.getAllContainedObjects();
        for (BusinessModelObject bmo : allObjects) {
            bmo.replaceResource(oldResource, newResource, this, recursive);
        }
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel businessModel) throws MetadataException {
        this.replaceResource(oldResource, newResource, businessModel, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel businessModel, boolean recursive) throws MetadataException {
        if (businessModel != this) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("BusinessModelImplInvalidBusinessModel.txt", new Object[0]));
        }
        this.replaceResource(oldResource, newResource, recursive);
    }

    public void ruleBasedResourceReplacement(NamedObjectInterface oldItem, NamedObjectInterface newItem, Map relinkRules, boolean recursive) throws MetadataException {
        Utils.ruleBasedResourceReplacement(this, oldItem, newItem, relinkRules, recursive);
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInNonDownwardDefinition(List<? super ModelItem> intoList) {
        super.accumulateDirectlyReferencedItemsInNonDownwardDefinition(intoList);
        HashSet<BusinessModelObject> set = new HashSet<BusinessModelObject>();
        if (this._businessItems != null) {
            set.addAll(this._businessItems);
        }
        if (this._businessRules != null) {
            set.addAll(this._businessRules);
        }
        if (this._businessGroups != null) {
            set.addAll(this._businessGroups);
        }
        if (this._dataSources != null) {
            set.addAll(this._dataSources);
        }
        set.addAll(this.items.keySet());
        intoList.addAll(set);
    }

    @Override
    protected void replaceDirectReferences(Object replaceThis, Object withThis) {
        super.replaceDirectReferences(replaceThis, withThis);
        AbstractBusinessModel.replaceInList(this._businessItems, replaceThis, withThis);
        AbstractBusinessModel.replaceInList(this._businessRules, replaceThis, withThis);
        AbstractBusinessModel.replaceInList(this._dataSources, replaceThis, withThis);
        AbstractBusinessModel.replaceInList(this._businessGroups, replaceThis, withThis);
        AbstractBusinessModel.replaceInJavaMap(this.folders, replaceThis, withThis);
        AbstractBusinessModel.replaceInJavaMap(this.items, replaceThis, withThis);
        this.rootMapFolder = (MapFolderImpl)AbstractBusinessModel.replace(this.rootMapFolder, replaceThis, withThis);
    }

    protected AbstractModel readFromLocationV1(AbstractModelReference modelRef, ReadingContext readingContext) throws MetadataException {
        AbstractModel outModel = null;
        if (modelRef instanceof BusinessModelReferenceInfoImpl) {
            String absolutePathToMap = ((BusinessModelReferenceInfoImpl)modelRef).getAbsolutePathPersistentLocation();
            InformationMapFactory factory = InformationMapFactory.getInstance();
            SessionContextInterface session = this.getSession();
            MetadataInterface mi = IQModelImplUtilities.absolutePathToMetadataInterface(session, absolutePathToMap, (ServerInterface)readingContext.getMetadataServer(), true);
            if (mi instanceof BriefInformationMap) {
                outModel = (AbstractModel)((Object)factory.newInformationMap(session, this.metadataService, (BriefInformationMap)mi));
            } else {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("V2ResourceResolver.NonInformationMapFoundAtPath.fmt.txt", absolutePathToMap));
            }
        }
        return outModel;
    }

    @Override
    public RequiredDataSources newRequiredDataSources() throws MetadataException {
        this.changeableCheck();
        RequiredDataSourcesImpl requiredDataSources = new RequiredDataSourcesImpl(this);
        return requiredDataSources;
    }

    @Override
    protected IdentityHashMap getResourceConstraints() throws MetadataException {
        Server server;
        IdentityHashMap out = super.getResourceConstraints();
        List<DataSourceTable> dsts = this.getObjects(false, DataSourceTable.class);
        for (DataSourceTable dataSourceTable : dsts) {
            server = dataSourceTable.getServer();
            Schema lib = dataSourceTable.getAccessPath().getSchema();
            Table table = dataSourceTable.getTable();
            if (table instanceof InMemoryQueryTable) {
                List<com.sas.iquery.metadata.physical.SASLibrary> libraries = ((InMemoryQueryTable)table).getLibraries();
                for (com.sas.iquery.metadata.physical.SASLibrary library : libraries) {
                    this.notePotentialRepositoryResourceConstraint(out, server, "SASLibraries", library);
                }
            }
            this.notePotentialRepositoryResourceConstraint(out, server, "SASLibraries", lib);
            this.notePotentialRepositoryResourceConstraint(out, lib, "Tables", table);
        }
        List<DataSourceCube> dscs = this.getObjects(true, DataSourceCube.class);
        for (DataSourceCube dsc : dscs) {
            AccessPath accessPath = dsc.getAccessPath();
            Server server2 = accessPath.getServer();
            Schema schema = accessPath.getSchema();
            Cube cube = dsc.getCube();
            this.notePotentialRepositoryResourceConstraint(out, server2, "Schemas", schema);
            this.notePotentialRepositoryResourceConstraint(out, schema, "Cubes", cube);
        }
        List<RunStoredProcess> list = this.getObjects(false, RunStoredProcess.class);
        server = null;
        if (list.size() > 0 && (server = this.getServer()) != null) {
            for (RunStoredProcess rsp : list) {
                this.notePotentialRepositoryResourceConstraint(out, server, "StoredProcesses", rsp.getStoredProcess());
            }
        }
        return out;
    }

    private Server getServer() {
        Server out = null;
        List<DataSource> dataSources = this.getObjects(true, DataSource.class);
        if (dataSources.size() > 0) {
            DataSource ds = dataSources.get(0);
            out = ds.getServer();
        }
        return out;
    }

    @Override
    public void setQueries(List<? extends BusinessQuery> queries) throws MetadataException {
        if (queries == null) {
            this._queries = new ArrayList<BusinessQuery>();
        } else {
            this._queries = new ArrayList<BusinessQuery>(queries);
            Preconditions.ensureNonNullTypedElements(this._queries, BusinessQuery.class);
        }
        List<AbstractModel> lineageAndThis = this.getLineage();
        lineageAndThis.add(this);
        for (BusinessQuery query : this._queries) {
            if (!lineageAndThis.contains(query)) continue;
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("AbstractBusinessModel.InvalidToUseQueryAsPrivateQuery.fmt.txt", ((AbstractModel)((Object)query)).getIdentityString()));
        }
    }

    @Override
    public List<BusinessQuery> getQueries() throws MetadataException {
        if (this._queries == null) {
            return new ArrayList<BusinessQuery>();
        }
        return new ArrayList<BusinessQuery>(this._queries);
    }

    @Override
    public <T extends BusinessModelObject> List<T> getObjectsBasedOn(BusinessQuery query, @Nonnull Class<T> type) throws MetadataException {
        type = type == null ? BusinessModelObject.class : type;
        IdentityList out = new IdentityList();
        List<BusinessModelObject> containedObjs = this.getObjects(false, BusinessModelObject.class);
        for (BusinessModelObject abmo : containedObjs) {
            if (!type.isInstance(abmo) || !((AbstractBusinessModelObject)abmo).isBasedOn(query)) continue;
            BusinessModelObject obj = (BusinessModelObject)type.cast(abmo);
            out.add(obj);
        }
        return out.toList();
    }

    @Override
    public List<BusinessGroup> getGroupsContaining(BusinessModelObject bmObject, BusinessGroup.Type type) {
        ArrayList<BusinessGroup> gpContainingBi = new ArrayList<BusinessGroup>();
        for (BusinessGroup bgp : this._businessGroups) {
            if (!bgp.getType().equals((Object)type) || !bgp.contains(bmObject, false)) continue;
            gpContainingBi.add(bgp);
        }
        return gpContainingBi;
    }

    @Override
    public FilterCascadeRule newFilterCascadeRule() throws MetadataException {
        this.changeableCheck();
        FilterCascadeRuleImpl cascade = new FilterCascadeRuleImpl(this);
        return cascade;
    }

    @Override
    public AssociationRule newAssociationRule() throws MetadataException {
        this.changeableCheck();
        AssociationRuleImpl rule = new AssociationRuleImpl(this);
        return rule;
    }

    @Override
    public LasrRule newLasrRule() throws MetadataException {
        this.changeableCheck();
        LasrRuleImpl rule = new LasrRuleImpl(this);
        return rule;
    }

    @Override
    public LasrRule newLasrRule(LasrType usage) throws MetadataException {
        this.changeableCheck();
        LasrRuleImpl rule = new LasrRuleImpl(this, usage);
        return rule;
    }

    @Override
    public ExportRule newExportRule(ExportType usage, ExportProperties ... properties) throws MetadataException {
        this.changeableCheck();
        Export export = ExportUtilities.newExport(this, usage, properties);
        ExportRule rule = ExportUtilities.newExportRuleObject(this);
        rule.setExport(export);
        return rule;
    }

    @Nonnull
    protected List<LocalizableModelObject> getLocalizableModelObjects() throws MetadataException {
        ArrayList<LocalizableModelObject> mapLocObjs = new ArrayList<LocalizableModelObject>();
        mapLocObjs.addAll(this._businessItems);
        mapLocObjs.addAll(this._dataSources);
        mapLocObjs.addAll(this._businessGroups);
        this.getLocalizableMapFolders(mapLocObjs, this.getRootMapFolder());
        return mapLocObjs;
    }

    private void getLocalizableMapFolders(List<LocalizableModelObject> folders, MapFolder mapFolder) {
        if (!folders.contains(mapFolder)) {
            folders.add(mapFolder);
            List<MapFolder> subFolders = mapFolder.getSubfolders();
            int size = subFolders.size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    MapFolder subFolder = subFolders.get(i);
                    this.getLocalizableMapFolders(folders, subFolder);
                }
            }
        }
    }

    @Nonnull
    protected List<String> getLocalizablePropertyNames() {
        return Arrays.asList(LOCALIZATION_KEY_NESTED_DATA_SOURCES, LOCALIZATION_KEY_NESTED_DATA_ITEMS, LOCALIZATION_KEY_NESTED_FILTER_ITEMS, LOCALIZATION_KEY_NESTED_PROMPTS, LOCALIZATION_KEY_NESTED_BUSINESS_GROUP, LOCALIZATION_KEY_NESTED_MAP_FOLDERS);
    }

    @Nonnull
    protected HashMap<String, Class<?>> getLocalizablePropertyNamesAndClasses() {
        LinkedHashMap loc = new LinkedHashMap();
        loc.put(LOCALIZATION_KEY_NESTED_DATA_SOURCES, DataSource.class);
        loc.put(LOCALIZATION_KEY_NESTED_DATA_ITEMS, DataItem.class);
        loc.put(LOCALIZATION_KEY_NESTED_FILTER_ITEMS, FilterItem.class);
        loc.put(LOCALIZATION_KEY_NESTED_PROMPTS, Prompt.class);
        loc.put(LOCALIZATION_KEY_NESTED_BUSINESS_GROUP, BusinessGroup.class);
        loc.put(LOCALIZATION_KEY_NESTED_MAP_FOLDERS, MapFolder.class);
        return loc;
    }

    public PropertyList getLocalizableProperties() {
        return this.getLocalizableProperties(null);
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setLocalizableProperties(null, map);
    }

    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        List<String> nestedPropNames = this.getLocalizablePropertyNames();
        HashMap<String, Class<?>> nestedPropNamesAndClasses = this.getLocalizablePropertyNamesAndClasses();
        try {
            List<LocalizableModelObject> localizableModelObjects = this.getLocalizableModelObjects();
            if (!localizableModelObjects.isEmpty()) {
                for (int i = 0; i < nestedPropNamesAndClasses.size(); ++i) {
                    String nestedPropName = nestedPropNames.get(i);
                    Class<?> nestedPropClass = nestedPropNamesAndClasses.get(nestedPropName);
                    PropertyList props = new PropertyList();
                    boolean first = true;
                    Iterator<LocalizableModelObject> iter = localizableModelObjects.iterator();
                    while (iter.hasNext()) {
                        LocalizableModelObject locObj = iter.next();
                        if (locObj == null || !nestedPropClass.isAssignableFrom(locObj.getClass())) continue;
                        if (first) {
                            list.addBlankLine();
                            list.addComment(nestedPropName);
                            first = false;
                        }
                        String localizationId = locObj.getLocalizationID();
                        PropertyList nestedList = locObj.getLocalizableProperties(locale);
                        if (nestedList != null && !nestedList.isEmpty()) {
                            props.addProperty(localizationId, nestedList);
                            props.addBlankLine();
                        } else if (_logger.isEnabled(Level.WARN)) {
                            _logger.warn(IQModelImplUtilities.getMessage("AbstractBusinessModel.LocalizableObjectNoProperties.txt", locObj));
                        }
                        iter.remove();
                    }
                    if (props.isEmpty()) continue;
                    list.addProperty(nestedPropName, props);
                }
                if (!localizableModelObjects.isEmpty() && _logger.isEnabled(Level.WARN)) {
                    _logger.warn(IQModelImplUtilities.getMessage("AbstractBusinessModel.LocalizableObjectNotAllProps.txt", localizableModelObjects));
                }
            }
        }
        catch (MetadataException e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        return list;
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        List<String> nestedPropNames = this.getLocalizablePropertyNames();
        try {
            List<LocalizableModelObject> localizableModelObjects;
            if (map.containsProperty(LOCALIZATION_KEY_COMPUTATIONAL_LOCALE)) {
                String localeStr = map.getProperty(LOCALIZATION_KEY_COMPUTATIONAL_LOCALE);
                Locale dataLocale = this.getComputationalLocale();
                String[] values = localeStr.split("[_-]");
                int args = values.length;
                if (args > 0) {
                    switch (args) {
                        case 1: {
                            dataLocale = new Locale(values[0]);
                            break;
                        }
                        case 2: {
                            dataLocale = new Locale(values[0], values[1]);
                            break;
                        }
                        case 3: {
                            dataLocale = new Locale(values[0], values[1], values[2]);
                        }
                    }
                }
                this.setComputationalLocale(dataLocale);
            }
            if (!(localizableModelObjects = this.getLocalizableModelObjects()).isEmpty()) {
                for (int i = 0; i < nestedPropNames.size(); ++i) {
                    PropertyMap nestedMap;
                    String nestedPropName = nestedPropNames.get(i);
                    if (!map.containsNestedProperty(nestedPropName) || (nestedMap = map.getNestedProperties(nestedPropName)) == null || nestedMap.isEmpty()) continue;
                    Iterator<LocalizableModelObject> iter = localizableModelObjects.iterator();
                    while (iter.hasNext()) {
                        String locID;
                        LocalizableModelObject locObj = iter.next();
                        if (locObj == null || !nestedMap.containsNestedProperty(locID = locObj.getLocalizationID())) continue;
                        locObj.setLocalizableProperties(locale, nestedMap);
                        iter.remove();
                    }
                }
                if (localizableModelObjects.size() > 0 && _logger.isEnabled(Level.WARN)) {
                    String message = IQModelImplUtilities.getMessage("AbstractBusinessModel.LocalizableObjectNotAllPropsSet.txt", new Object[0]) + localizableModelObjects;
                    _logger.warn(message);
                }
            }
        }
        catch (MetadataException e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
    }

    public Collection<Locale> getLocales() {
        LinkedHashSet<Locale> allLocales;
        block3: {
            allLocales = new LinkedHashSet<Locale>();
            try {
                List<LocalizableModelObject> localizableModelObjects = this.getLocalizableModelObjects();
                if (localizableModelObjects == null || localizableModelObjects.isEmpty()) break block3;
                for (LocalizableModelObject localizableModelObject : localizableModelObjects) {
                    if (!(localizableModelObject instanceof DataSource)) continue;
                    LocalizableString labels = localizableModelObject.getLabels();
                    this.getLocales(allLocales, labels);
                    LocalizableString descs = localizableModelObject.getDescriptions();
                    this.getLocales(allLocales, descs);
                    break;
                }
            }
            catch (MetadataException e) {
                throw new UnexpectedLocalizationException((Throwable)e);
            }
        }
        return allLocales;
    }

    private void getLocales(Collection<Locale> locales, LocalizableString localizableString) {
        if (localizableString != null) {
            List labelLocales;
            Locale defaultLocale = localizableString.getDefaultLocale();
            if (defaultLocale != null) {
                locales.add(defaultLocale);
            }
            if ((labelLocales = localizableString.getLocales()) != null && labelLocales.size() > 0) {
                locales.addAll(labelLocales);
            }
        }
    }

    public void beginLocalization() throws UnexpectedLocalizationException {
    }

    public void endLocalization() throws UnexpectedLocalizationException {
    }

    @Override
    public MapFolder getRootMapFolder() throws MetadataException {
        return this.rootMapFolder;
    }

    void addMapFolder(MapFolder newFolder) {
        this.folders.put(newFolder, new ArrayList());
    }

    List<BusinessItem> getMapFolderItems(MapFolder folder) {
        return this.folders.get(folder);
    }

    void addBusinessItemToMapFolder(BusinessItem item, MapFolder folder) {
        if (this.items.containsKey(item)) {
            MapFolder bif = this.items.get(item);
            List<BusinessItem> fil = this.folders.get(bif);
            fil.remove(item);
        }
        this.items.put(item, folder);
        List<BusinessItem> folderItems = this.folders.get(folder);
        folderItems.add(item);
    }

    void removeMapFolder(MapFolder folder) {
        if (folder != null) {
            this.folders.remove(folder);
        }
    }

    void removeBusinessItem(BusinessItem item, MapFolder folder) {
        if (item != null && folder != null) {
            this.items.remove(item);
            List<BusinessItem> fil = this.folders.get(folder);
            fil.remove(item);
        }
    }

    List<BusinessItem> removeAllBusinessItems(MapFolder folder) {
        List<BusinessItem> removedItems;
        if (folder != null) {
            List<BusinessItem> folderItems = this.getMapFolderItems(folder);
            removedItems = new ArrayList<BusinessItem>(folderItems.size());
            Iterator<BusinessItem> itemsIter = folderItems.iterator();
            while (itemsIter.hasNext()) {
                BusinessItem item = itemsIter.next();
                this.items.remove(item);
                removedItems.add(item);
                itemsIter.remove();
            }
        } else {
            removedItems = Collections.emptyList();
        }
        return removedItems;
    }

    void removeFromFolders(List<BusinessItem> itemsToRemove) {
        if (itemsToRemove != null) {
            for (BusinessItem item : itemsToRemove) {
                this.removeFromFolder(item);
            }
        }
    }

    private void removeFromFolder(BusinessItem item) {
        MapFolder f = this.items.remove(item);
        if (f != null) {
            List<BusinessItem> fil = this.folders.get(f);
            fil.remove(item);
        }
    }

    Set<MapFolder> getAllFolders() {
        return this.folders.keySet();
    }

    @Override
    public MapFolder getMapFolderContaining(BusinessItem item) throws MetadataException {
        return this.items.get(item);
    }

    @Override
    @Nonnull
    public List<BusinessItem> getBusinessItemsNotInMapFolders() throws MetadataException {
        ArrayList<BusinessItem> resultList = new ArrayList<BusinessItem>();
        List<BusinessItem> itemsInTheModel = this.getObjects(false, BusinessItem.class);
        for (BusinessItem item : itemsInTheModel) {
            if (this.items.containsKey(item)) continue;
            resultList.add(item);
        }
        return resultList;
    }
}

