/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.EntityInterface;
import com.sas.entities.persist.EntityPersistenceUtility;
import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataNotChangeableException;
import com.sas.iquery.metadata.MetadataUnresolvedException;
import com.sas.iquery.metadata.PropertyChangeListenee;
import com.sas.iquery.metadata.business.Base;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.Model;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.business.impl.IntegratedObjectWriter;
import com.sas.iquery.metadata.business.impl.LazyWrittenInterface;
import com.sas.iquery.metadata.business.impl.PersistenceProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectList;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.UnsynchronizedStack;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.impl.XMLV2;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.util.LocalizableString;
import com.sas.util.xmlpersist.PersistenceInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class AbstractBase
implements Base {
    private boolean _changeable = true;
    private boolean _setChangeableAllowed = true;
    private static final int INITIAL_SIZE_OF_LISTENER_LIST = 1;
    @Nonnull
    private List<PropertyChangeListener> _listeners = new ArrayList<PropertyChangeListener>(1);
    private boolean _unresolved = false;
    private static final Logger _logger = LogManager.getLogger(AbstractBase.class);
    protected static final Class<?>[] NO_BARRIER_TYPES = new Class[0];
    private static IntegratedObjectWriter _integratedObjectWriter = IntegratedObjectWriter.getInstance();

    public final boolean isUnresolved() {
        return this._unresolved;
    }

    protected void setIsUnresolved(boolean value) {
        this._unresolved = value;
    }

    public void setUnresolved() {
        this._unresolved = true;
    }

    public final boolean isLive() {
        return !this._unresolved;
    }

    protected final void unresolvedCheck() {
        if (this._unresolved) {
            if (this instanceof BusinessModelResource) {
                throw new MetadataUnresolvedException((BusinessModelResource)((Object)this), IQModelImplUtilities.getMessageFormatter("BusinessModelUnresolvedCheck.txt", new Object[0]));
            }
            String msg = IQModelImplUtilities.getMessage("OMAResourceFactoryUnexpectedCodePathError.txt", new Object[0]);
            throw new RuntimeException(msg);
        }
    }

    boolean isChangeable() {
        return this._changeable && !this._unresolved;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setIsChangeable(boolean changeable) throws MetadataException {
        if (this._unresolved) {
            MessageFormatter message = IQModelImplUtilities.getMessageFormatter("AbstractBase.CannotModifyUnresolved.fmt.txt", this);
            throw new MetadataException(message);
        }
        boolean current = this.isChangeable();
        if (current == changeable) return;
        if (this.isSetIsChangeableAllowed()) {
            this.trustedSetIsChangeable(changeable);
            return;
        }
        MessageFormatter message = IQModelImplUtilities.getMessageFormatter("AbstractBase.CannotModifyIsChangable.fmt.txt", this);
        throw new MetadataException(message);
    }

    boolean isSetIsChangeableAllowed() {
        return this._setChangeableAllowed;
    }

    void trustedSetIsChangeable(boolean changeable) {
        this._changeable = changeable;
    }

    void trustedSetChangeableAllowed(boolean setChangeableAllowed) {
        this._setChangeableAllowed = setChangeableAllowed;
    }

    void trustedMarkNeverChangeable() {
        this._changeable = false;
        this._setChangeableAllowed = false;
    }

    protected void changeableCheck() throws MetadataNotChangeableException {
        if (!this._changeable) {
            throw new MetadataNotChangeableException(IQModelImplUtilities.getMessageFormatter("BusinessModelObjectImplModelReadOnly.txt", new Object[0]), 1);
        }
        this.unresolvedCheck();
    }

    void setModel(AbstractModel model) {
    }

    public abstract String getIdentityString();

    @Override
    public List<PropertyChangeListener> getListeners() {
        return new ArrayList<PropertyChangeListener>(this._listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(@Nullable PropertyChangeListener listener) {
        if (listener != null) {
            List<PropertyChangeListener> list = this._listeners;
            synchronized (list) {
                ListIterator<PropertyChangeListener> listIter = this._listeners.listIterator();
                boolean found = false;
                while (listIter.hasNext()) {
                    if (listIter.next() != listener) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this._listeners.add(listener);
                }
            }
        }
    }

    protected void addListenerUnsynchronized(@Nonnull PropertyChangeListener listener) {
        if (this._listeners.size() == 0) {
            this._listeners.add(listener);
        } else {
            ListIterator<PropertyChangeListener> listIter = this._listeners.listIterator();
            boolean found = false;
            while (listIter.hasNext()) {
                if (listIter.next() != listener) continue;
                found = true;
                break;
            }
            if (!found) {
                this._listeners.add(listener);
            }
        }
    }

    protected void addListenersUnsynchronized(@Nonnull IdentityList listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            ListIterator<PropertyChangeListener> listIter = this._listeners.listIterator();
            boolean found = false;
            while (listIter.hasNext()) {
                if (listIter.next() != listeners.get(i)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this._listeners.add((PropertyChangeListener)listeners.get(i));
        }
    }

    protected void listenTo(PropertyChangeListenee listenee) {
        if (listenee != null) {
            listenee.addListener(this);
        }
    }

    protected void listenTo(@Nullable List<? extends PropertyChangeListener> objs) {
        if (objs != null) {
            for (PropertyChangeListener propertyChangeListener : objs) {
                if (!(propertyChangeListener instanceof PropertyChangeListenee)) continue;
                ((PropertyChangeListenee)((Object)propertyChangeListener)).addListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(@Nullable PropertyChangeListener listener) {
        if (listener != null) {
            List<PropertyChangeListener> list = this._listeners;
            synchronized (list) {
                ListIterator<PropertyChangeListener> listIter = this._listeners.listIterator();
                while (listIter.hasNext()) {
                    if (listIter.next() != listener) continue;
                    listIter.remove();
                    break;
                }
            }
        }
    }

    protected void clearListeningToBaseObjects() {
        this.removeListeningTo(this.getDirectlyReferencedBaseObjectsInDownwardDefinition());
    }

    protected void fireChangeEvent(String eventID) {
        this.fireChangeEvent(eventID, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeEvent(String eventID, Object oldObject, Object newObject) {
        int listenerSize = this._listeners.size();
        if (listenerSize > 0) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, eventID, oldObject, newObject);
            List<PropertyChangeListener> list = this._listeners;
            synchronized (list) {
                for (int i = 0; i < listenerSize; ++i) {
                    PropertyChangeListener listener = this._listeners.get(i);
                    try {
                        listener.propertyChange(event);
                        continue;
                    }
                    catch (Exception e) {
                        if (!_logger.isEnabled(Level.ERROR)) continue;
                        _logger.error(IQModelImplUtilities.getMessage("Utils.ExceptionDuringListenerNotif.txt", new Object[0]), (Throwable)e);
                    }
                }
            }
        }
    }

    protected void removeListeningTo(@Nullable ModelItem oldItem) {
        if (oldItem != null) {
            List<ModelItem> downwardItems = this.getDirectlyReferencedItemsInDownwardDefinition();
            int referenceCount = 0;
            for (ModelItem modelItem : downwardItems) {
                if (modelItem != oldItem) continue;
                ++referenceCount;
            }
            if (referenceCount <= 1) {
                oldItem.removeListener(this);
            }
        }
    }

    protected void removeListeningTo(@Nullable List<? extends PropertyChangeListener> oldItems) {
        if (oldItems != null) {
            List<ModelItem> downwardItems = this.getDirectlyReferencedItemsInDownwardDefinition();
            for (PropertyChangeListener propertyChangeListener : oldItems) {
                ModelItem oldItem = (ModelItem)propertyChangeListener;
                int referenceCount = 0;
                for (ModelItem modelItem : downwardItems) {
                    if (modelItem != oldItem) continue;
                    ++referenceCount;
                }
                if (referenceCount > true) continue;
                oldItem.removeListener(this);
            }
        }
    }

    protected void moveListeningTo(ModelItem oldItem, ModelItem newItem) {
        if (oldItem != newItem) {
            this.removeListeningTo(oldItem);
            this.listenTo(newItem);
        }
    }

    protected void moveListeningTo(List<? extends ModelItem> oldItems, List<? extends ModelItem> newItems) {
        if (oldItems != newItems) {
            this.removeListeningTo(oldItems);
            this.listenTo(newItems);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractBase clone = (AbstractBase)super.clone();
        clone._listeners = new ArrayList<PropertyChangeListener>(1);
        clone._changeable = true;
        clone._setChangeableAllowed = true;
        return clone;
    }

    public final List<ModelItem> getDirectlyReferencedItems() {
        List<ModelItem> items = this.getDirectlyReferencedItemsInDownwardDefinition();
        int size = items.size();
        for (int i = size - 1; i >= 0; --i) {
            ModelItem item = items.get(i);
            if (!(item instanceof Column) && !(item instanceof com.sas.iquery.metadata.physical.Level)) continue;
            items.remove(i);
        }
        return items;
    }

    public final List<ModelItem> getDirectlyReferencedItemsInDownwardDefinition() {
        ArrayList<ModelItem> outList = new ArrayList<ModelItem>();
        this.accumulateDirectlyReferencedItemsInDownwardDefinition(outList);
        outList.removeAll(Collections.singleton(null));
        return outList;
    }

    protected abstract void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> var1);

    protected void accumulateDirectlyReferencedItemsInNonDownwardDefinition(List<? super ModelItem> intoList) {
    }

    void accumulateDirectlyReferencedItems(List<? super ModelItem> intoList) {
        this.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        this.accumulateDirectlyReferencedItemsInNonDownwardDefinition(intoList);
    }

    protected final List<ModelItem> getRecursivelyReferencedItemsInDownwardDefinition() {
        return this.getRecursivelyReferencedItemsInDownwardDefinition(NO_BARRIER_TYPES, null, ModelItem.class);
    }

    protected final <T> List<T> getRecursivelyReferencedItemsInDownwardDefinition(@Nonnull Class<?>[] barrierItemTypes, @Nullable AbstractModel onlyWithinThisContainer, @Nonnull Class<T> type) {
        ArrayList items = new ArrayList(100);
        AbstractBase._accumulateRecursivelyReferencedItemsInDownwardDefinition(this, items, barrierItemTypes, onlyWithinThisContainer, type);
        items.trimToSize();
        return items;
    }

    private static <T> void _accumulateRecursivelyReferencedItemsInDownwardDefinition(AbstractBase thisBase, List<? super T> intoList, Class<?>[] barrierItemTypes, AbstractModel onlyWithinThisContainer, Class<T> includeType) {
        List<ModelItem> directlyReferencedItems = thisBase.getDirectlyReferencedItemsInDownwardDefinition();
        int size = directlyReferencedItems.size();
        for (int i = 0; i < size; ++i) {
            AbstractModel itemContainer;
            ModelItem object = directlyReferencedItems.get(i);
            if (!(object instanceof AbstractModelItem)) continue;
            AbstractModelItem item = (AbstractModelItem)object;
            boolean outsideBoundary = false;
            if (onlyWithinThisContainer != null && (itemContainer = item.getModel()) != null && itemContainer != onlyWithinThisContainer) {
                outsideBoundary = true;
            }
            if (outsideBoundary || IQModelImplUtilities.firstIndexOfUsingEqualsEquals(intoList, item) != -1) continue;
            if (includeType.isInstance(item)) {
                intoList.add(includeType.cast(item));
            }
            boolean typeBarrier = false;
            for (int j = 0; j < barrierItemTypes.length && !typeBarrier; ++j) {
                if (!barrierItemTypes[j].isInstance(item)) continue;
                typeBarrier = true;
            }
            if (typeBarrier) continue;
            AbstractBase._accumulateRecursivelyReferencedItemsInDownwardDefinition(item, intoList, barrierItemTypes, onlyWithinThisContainer, includeType);
        }
    }

    protected void accumulateDirectlyReferencedModelsInDownwardDefinition(List<? super Model> intoList) {
    }

    private List<AbstractBase> getDirectlyReferencedBaseObjectsInDownwardDefinition() {
        ArrayList references = new ArrayList();
        this.accumulateDirectlyReferencedBaseObjectsInDownwardDefinition(references);
        ArrayList<AbstractBase> outList = new ArrayList<AbstractBase>(references.size());
        for (Object o : references) {
            if (!(o instanceof AbstractBase)) continue;
            outList.add((AbstractBase)AbstractBase.class.cast(o));
        }
        return outList;
    }

    private void accumulateDirectlyReferencedBaseObjectsInDownwardDefinition(List<? super Base> intoList) {
        this.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        this.accumulateDirectlyReferencedModelsInDownwardDefinition(intoList);
    }

    protected final void accumulateDirectlyReferencedBaseObjects(List<? super Base> intoList) {
        this.accumulateDirectlyReferencedItems(intoList);
        this.accumulateDirectlyReferencedModelsInDownwardDefinition(intoList);
    }

    protected abstract void replaceDirectReferences(Object var1, Object var2);

    protected void replaceDirectReferencesDuringResourceReplacement(Object oldObject, Object newObject) {
        this.replaceDirectReferences(oldObject, newObject);
    }

    protected static <T> T replace(T referencedObject, T oldObject, T newObject) {
        T out = referencedObject;
        if (referencedObject == oldObject) {
            out = newObject;
        }
        return out;
    }

    protected static void replaceInList(List referencedItems, Object oldItem, Object newItem) {
        if (referencedItems != null) {
            int size = referencedItems.size();
            for (int i = 0; i < size; ++i) {
                Object obj = referencedItems.get(i);
                if (obj == oldItem) {
                    referencedItems.set(i, newItem);
                    continue;
                }
                if (!(obj instanceof List)) continue;
                AbstractBase.replaceInList((List)obj, oldItem, newItem);
            }
        }
    }

    protected static void replaceInJavaMap(Map map, Object oldItem, Object newItem) {
        if (map != null) {
            HashMap additionalChangesToMake = null;
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value == oldItem) {
                    if (additionalChangesToMake == null) {
                        additionalChangesToMake = new HashMap();
                    }
                    Object key = entry.getKey();
                    additionalChangesToMake.put(key, newItem);
                    continue;
                }
                if (!(value instanceof List)) continue;
                List list = (List)value;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    if (list.get(i) != oldItem) continue;
                    list.set(i, newItem);
                }
            }
            if (additionalChangesToMake != null) {
                for (Map.Entry entry : additionalChangesToMake.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    map.put(key, value);
                }
            }
        }
    }

    protected final boolean hasCycleInDownwardDefinition() {
        UnsynchronizedStack<AbstractBase> stack = new UnsynchronizedStack<AbstractBase>();
        stack.push(this);
        return this.hasCycleInDownwardDefinition(stack);
    }

    private boolean hasCycleInDownwardDefinition(UnsynchronizedStack stack) {
        boolean hasCycle = false;
        List<AbstractBase> baseObjs = this.getDirectlyReferencedBaseObjectsInDownwardDefinition();
        AbstractBase.removeDuplicatesUsingEqualsEquals(baseObjs);
        int size = baseObjs.size();
        for (int i = 0; i < size && !hasCycle; ++i) {
            AbstractBase baseObj = baseObjs.get(i);
            if (IQModelImplUtilities.firstIndexOfUsingEqualsEquals(stack, baseObj) >= 0) {
                hasCycle = true;
                continue;
            }
            stack.push(baseObj);
            hasCycle = baseObj.hasCycleInDownwardDefinition(stack);
            stack.pop();
        }
        return hasCycle;
    }

    private static <T> void removeDuplicatesUsingEqualsEquals(List<T> list) {
        int size = list.size();
        for (int i = size - 1; i >= 0; --i) {
            T obj = list.get(i);
            if (IQModelImplUtilities.firstIndexOfUsingEqualsEquals(list, obj) == i) continue;
            list.remove(i);
        }
    }

    protected final void write(Node parentNode, WritingContext writingContext) throws MetadataException {
        if (writingContext.hasBeenWritten(this)) {
            this.writeReferenceUnder(parentNode, writingContext);
        } else if (writingContext.testForAndAccumulateExternalObject(this)) {
            this.writeReferenceToExternalReferenceUnder(parentNode, writingContext);
            this.registerExternalResources(writingContext);
        } else if (this instanceof LazyWrittenInterface) {
            this.writeReferenceUnder(parentNode, writingContext);
        } else {
            this.writeDefinitionUnder(parentNode, writingContext);
        }
    }

    protected void registerExternalResources(WritingContext writingContext) throws MetadataException {
    }

    private void writeReferenceUnder(Node parentNode, WritingContext writingContext) throws MetadataException {
        Element refElement = IQModelImplUtilities.newSubelement(parentNode, this.getWriteUseElementName());
        String idValue = writingContext.getInternalPersistenceIDForWritingReferenceTo(this);
        writingContext.markInternalPersistenceIDReferenced(idValue);
        IQModelImplUtilities.setAttr(refElement, "ref", idValue);
    }

    final Element writeDefinitionUnder(Node parentNode, WritingContext writingContext) throws MetadataException {
        String persistenceID = writingContext.getInternalPersistenceIDFor(this);
        return this.writeDefinitionUnder(parentNode, writingContext, persistenceID);
    }

    final Element writeDefinitionUnder(Node parentNode, WritingContext writingContext, String persistenceID) throws MetadataException {
        Element thisElement;
        writingContext.markObjAsWritten(this);
        if (this instanceof AbstractModel && this != writingContext.getModel()) {
            AbstractModel modelToWrite = (AbstractModel)this;
            thisElement = modelToWrite.writeElementWithModelDefinition(parentNode, writingContext, persistenceID, false);
        } else {
            thisElement = this.writeElementWithDefinition(parentNode, writingContext, persistenceID);
        }
        return thisElement;
    }

    protected final Element writeElementWithDefinition(Node parentNode, WritingContext writingContext, String persistenceID) throws MetadataException {
        Element thisElement = this.createDefinitionElement(parentNode, writingContext);
        IQModelImplUtilities.setAttr(thisElement, "obj", persistenceID);
        this.writeDefinition(thisElement, writingContext);
        return thisElement;
    }

    protected Element createDefinitionElement(Node parentNode, WritingContext writingContext) {
        return IQModelImplUtilities.newSubelement(parentNode, this.getDefinitionElementName());
    }

    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
    }

    protected abstract String getDefinitionElementName();

    protected String getReferredToElementName() {
        return this.getDefinitionElementName();
    }

    private String getWriteUseElementName() {
        String objElementName = this.getReferredToElementName();
        return XMLV2.getObjectUseElementName(objElementName);
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder rilsHolder) throws SAXException {
    }

    protected boolean mustCallConsumeRelatedObjects() {
        return false;
    }

    public void consumeAttributes(AttributesProvider attrsHolder) throws SAXException {
    }

    private void writeReferenceToExternalReferenceUnder(Node parentNode, WritingContext writingContext) {
        Element refElement = IQModelImplUtilities.newSubelement(parentNode, this.getWriteUseElementName());
        String idValue = writingContext.getExternalPersistenceIDFor(this);
        IQModelImplUtilities.setAttr(refElement, "ref", idValue);
    }

    final Element writeExternalReferenceUnder(Node parentNode, WritingContext writingContext) throws MetadataException {
        Element xrefElement = IQModelImplUtilities.newSubelement(parentNode, this.getDefinitionElementName());
        writingContext.markObjAsWritten(this);
        String persistenceID = writingContext.getExternalPersistenceIDFor(this);
        IQModelImplUtilities.setAttr(xrefElement, "obj", persistenceID);
        this.writeExternalReference(xrefElement, writingContext);
        return xrefElement;
    }

    protected void writeExternalReference(Element thisElement, WritingContext writingContext) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    public void consumeExternalReferenceAttributes(AttributesProvider attrsProvider) throws SAXException {
        this._unresolved = true;
    }

    public void consumeExternalReferenceRelatedItems(RelatedObjectListsHolder rilsHolder) throws SAXException {
    }

    abstract boolean isReachableViaPersistenceFromGivenModel(AbstractModel var1);

    abstract boolean isLocatedExternalToGivenModel(AbstractModel var1);

    protected final void recursivelyNoteRelationshipsWithOtherUnresolvedResources(IdentityHashMap<AbstractBase, List<RelatedObjectList>> mapping) {
        List<RelatedObjectList> listOfRelationships = mapping.get(this);
        if (listOfRelationships == null) {
            this.addRelationshipsToUnresolvedResources(mapping);
            listOfRelationships = mapping.get(this);
            if (listOfRelationships == null) {
                mapping.put(this, Collections.emptyList());
            } else {
                int nRelations = listOfRelationships.size();
                for (int i = 0; i < nRelations; ++i) {
                    RelatedObjectList relatedItems = listOfRelationships.get(i);
                    List<Object> items = relatedItems.getObjects();
                    for (int j = 0; j < items.size(); ++j) {
                        AbstractBase relatedItem = (AbstractBase)items.get(j);
                        relatedItem.recursivelyNoteRelationshipsWithOtherUnresolvedResources(mapping);
                    }
                }
            }
        }
    }

    protected void addRelationshipsToUnresolvedResources(IdentityHashMap<AbstractBase, List<RelatedObjectList>> mapping) {
    }

    protected void noteRelationshipsWithOtherUnresolvedResources(IdentityHashMap<AbstractBase, List<RelatedObjectList>> mapping, String relationshipName, List<? extends Object> otherUnresolvedObjects) {
        if (otherUnresolvedObjects != null && otherUnresolvedObjects.size() > 0) {
            List<RelatedObjectList> listOfRelationships = mapping.get(this);
            if (listOfRelationships == null) {
                listOfRelationships = new ArrayList<RelatedObjectList>();
                mapping.put(this, listOfRelationships);
            }
            RelatedObjectList relatedItems = new RelatedObjectList(relationshipName, otherUnresolvedObjects);
            listOfRelationships.add(relatedItems);
        }
    }

    protected static void writeRelatedObject(Base object, Node parentNode, WritingContext writingContext, String relationshipName) throws MetadataException {
        AbstractBase.writeRelatedObject(object, parentNode, writingContext, relationshipName, null);
    }

    protected static final void writeRelatedObject(Base object, Node parentNode, WritingContext writingContext, String relationshipName, ModelVersion adjustedModelVersion) throws MetadataException {
        if (object != null) {
            Element newSubelement = IQModelImplUtilities.newSubelement(parentNode, relationshipName);
            AbstractBase obj = (AbstractBase)object;
            obj.write(newSubelement, writingContext);
            if (adjustedModelVersion != null) {
                writingContext.adjustModelVersion(adjustedModelVersion);
            }
        }
    }

    protected static final void writeRelatedObjects(List<? extends Object> objsToWrite, Node parentNode, WritingContext writingContext, String relationshipName) throws MetadataException {
        AbstractBase.writeRelatedObjects(objsToWrite, parentNode, writingContext, relationshipName, null);
    }

    protected static final void writeRelatedObjects(List<? extends Object> objsToWrite, Node parentNode, WritingContext writingContext, String relationshipName, ModelVersion adjustedModelVersion) throws MetadataException {
        int size;
        if (objsToWrite != null && (size = objsToWrite.size()) > 0) {
            Element newSubelement = IQModelImplUtilities.newSubelement(parentNode, relationshipName);
            for (int i = 0; i < size; ++i) {
                Object objToWrite = objsToWrite.get(i);
                if (!(objToWrite instanceof AbstractBase)) continue;
                AbstractBase obj = (AbstractBase)objToWrite;
                obj.write(newSubelement, writingContext);
                if (adjustedModelVersion == null) continue;
                writingContext.adjustModelVersion(adjustedModelVersion);
            }
        }
    }

    protected void writeDataLocale(Locale locale, Node parentNode, WritingContext writingContext, String newSubelementName) throws MetadataException {
        AbstractBase.writeForeignObjectUnderNewSubelement(locale, parentNode, writingContext, newSubelementName);
    }

    protected static void writeForeignObjectUnderNewSubelement(Object object, Node parentNode, WritingContext writingContext, String newSubelementName) throws MetadataException {
        if (object != null) {
            if (object instanceof Locale) {
                AbstractBase.writeRelatedObject(PersistenceProvider.newProviderForWritingLocale((Locale)object), parentNode, writingContext, newSubelementName);
            } else if (object instanceof LinkedHashMap) {
                AbstractBase.writeRelatedObject(PersistenceProvider.newProviderForWritingLinkedHashMap((LinkedHashMap)object), parentNode, writingContext, newSubelementName);
            } else if (object instanceof EntityInterface) {
                _integratedObjectWriter.writeUnderNewSubelement((EntityInterface)object, parentNode, writingContext, newSubelementName);
            } else if (object instanceof LocalizableString) {
                _integratedObjectWriter.writeUnderNewSubelement((LocalizableString)object, parentNode, writingContext, newSubelementName);
            } else if (object instanceof PersistenceInterface) {
                _integratedObjectWriter.writeUnderNewSubelement((PersistenceInterface)object, parentNode, writingContext, newSubelementName);
            } else {
                MessageFormatter message = IQModelImplUtilities.getMessageFormatter("AbstractBase.CannotPersistNoSupportForObject.fmt.txt", object.getClass().getName());
                throw new MetadataException(message);
            }
        }
    }

    protected abstract void readDefinitionV1(Element var1, ReadingContext var2) throws MetadataException;

    protected static AbstractModelItem v1_readItemDirectlyUnderElement(Element parentElement, ReadingContext readingContext, String subelementName, Class<?>[] allowedTypes) throws MetadataException {
        AbstractModelItem out = null;
        Element subelement = IQModelImplUtilities.getFirstSubelementNamed(parentElement, subelementName);
        if (subelement != null && (out = readingContext.readModelElement(subelement)) != null) {
            AbstractBase.v1_validateItemTypeDuringReading(out, allowedTypes);
        }
        return out;
    }

    protected static List v1_readItemListDirectlyUnderElement(Element parentElement, ReadingContext readingContext, String subelementName, Class[] allowedTypes) throws MetadataException {
        List<Element> subelements = null;
        subelements = subelementName == null ? IQModelImplUtilities.getSubelements(parentElement) : IQModelImplUtilities.getSubelementsNamed(parentElement, subelementName);
        int size = subelements.size();
        List outList = ListUtils.newList(size);
        for (int i = 0; i < size; ++i) {
            Element subelement = subelements.get(i);
            AbstractModelItem item = readingContext.readModelElement(subelement);
            outList.add(item);
        }
        return outList;
    }

    protected static AbstractModelItem v1_readItemUseFromAttribute(Element thisElement, String attributeName, ReadingContext readingContext) throws MetadataException {
        AbstractModelItem out = null;
        String persistenceID = IQModelImplUtilities.getAttr(thisElement, attributeName);
        if (persistenceID == null) {
            MessageFormatter message = IQModelImplUtilities.getMessageFormatter("AbstractBase.InvalidNullID.txt", new Object[0]);
            throw new MetadataException(message);
        }
        out = readingContext.getDefinition(persistenceID);
        return out;
    }

    protected static AbstractModelItem v1_readItemUnderSubelement(Node parentNode, ReadingContext readingContext, String subelementName, Class<?>[] allowedTypes) throws MetadataException {
        Element objElement;
        AbstractModelItem out = null;
        Element subelement = IQModelImplUtilities.getFirstSubelementNamed(parentNode, subelementName);
        if (subelement != null && (objElement = IQModelImplUtilities.getOnlySubelement(subelement)) != null && (out = readingContext.readModelElement(objElement)) != null) {
            AbstractBase.v1_validateItemTypeDuringReading(out, allowedTypes);
        }
        return out;
    }

    protected static List v1_readItemListUnderSubelement(Node parentNode, ReadingContext readingContext, String subelementName, Class<?>[] allowedTypes) throws MetadataException {
        List outList = null;
        Element subelement = IQModelImplUtilities.getFirstSubelementNamed(parentNode, subelementName);
        if (subelement != null) {
            List<Element> itemElements = IQModelImplUtilities.getSubelements(subelement);
            int size = itemElements.size();
            outList = ListUtils.newList(size);
            for (int i = 0; i < size; ++i) {
                Element itemElement = itemElements.get(i);
                AbstractModelItem item = readingContext.readModelElement(itemElement);
                if (item != null) {
                    AbstractBase.v1_validateItemTypeDuringReading(item, allowedTypes);
                }
                outList.add(item);
            }
        } else {
            outList = ListUtils.newList(0);
        }
        return outList;
    }

    protected static final List v1_readItemListUnderSubelementIgnoreElementNamed(Node parentNode, ReadingContext readingContext, String subelementName, Class[] allowedTypes, String ignoreElementNamed) throws MetadataException {
        List outList = null;
        Element subelement = IQModelImplUtilities.getFirstSubelementNamed(parentNode, subelementName);
        if (subelement != null) {
            List<Element> itemElements = IQModelImplUtilities.getSubelements(subelement);
            int size = itemElements.size();
            outList = ListUtils.newList(size);
            for (int i = 0; i < size; ++i) {
                Element itemElement = itemElements.get(i);
                if (ignoreElementNamed.equals(itemElement.getTagName())) continue;
                AbstractModelItem item = readingContext.readModelElement(itemElement);
                if (item != null) {
                    AbstractBase.v1_validateItemTypeDuringReading(item, allowedTypes);
                }
                outList.add(item);
            }
        } else {
            outList = ListUtils.newList(0);
        }
        return outList;
    }

    protected static void v1_validateItemTypeDuringReading(AbstractModelItem item, Class<?>[] allowedTypes) throws MetadataException {
        boolean isOfType = false;
        for (Class<?> c : allowedTypes) {
            if (!c.isInstance(item)) continue;
            isOfType = true;
            break;
        }
        if (!isOfType) {
            ArrayMessageFormatter messageFormatter = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_LONG, (Object[])allowedTypes);
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("AbstractBase.WrongObjectType.fmt.txt", item.getClass().getName(), messageFormatter));
        }
    }

    protected EntityInterface v1_readExtendedAttributes(Element parentElement) throws MetadataException {
        EntityInterface out = null;
        Element xasElement = IQModelImplUtilities.getFirstSubelementNamed(parentElement, "ExtendedAttribute");
        if (xasElement != null) {
            out = IQModelImplUtilities.getEntityAttr(xasElement, "entity");
        } else {
            Element entityElement;
            xasElement = IQModelImplUtilities.getFirstSubelementNamed(parentElement, "ExtendedAttributes");
            if (xasElement != null && (entityElement = IQModelImplUtilities.getFirstSubelementNamed(xasElement, "Entity")) != null) {
                out = EntityPersistenceUtility.read((Element)entityElement);
            }
        }
        return out;
    }

    private static void checkForDeploymentError(String classname) {
        try {
            Class.forName(classname);
            AbstractBase.invalidIqueryDeployment();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception e) {
            AbstractBase.invalidIqueryDeployment();
        }
    }

    private static void invalidIqueryDeployment() {
        MessageFormatter message = IQModelImplUtilities.getMessageFormatter("AbstractBase.ErrorVersion92DeploymentRequiresJarRemoval.txt", new Object[0]);
        throw new IQueryServicesRuntimeException(message);
    }

    protected boolean isReferrableToWithinModel() {
        return true;
    }

    static {
        AbstractBase.checkForDeploymentError("com.sas.iquery.metadata.business.impl.InMemoryInformationMapImpl");
        AbstractBase.checkForDeploymentError("com.sas.iquery.dataservices.FileBasedInformationMapFactory");
    }
}

