/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.IQueryServicesIllegalStateException;
import com.sas.iquery.execution2.DrillPath;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.IQResultSetMetaData;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.PropertyChangeListenee;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Drill;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.QueryWriteOption;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.MonotonicIntegerToStringMapping;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.Preconditions;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public class SelectedItem
extends AbstractModelItem
implements PropertyChangeListenee,
Cloneable {
    @SASScope
    public static final String EVENT_SELECTED_ITEM_FORMAT_TYPE_CHANGED = "The format type of a selected item has changed";
    @SASScope
    public static final String EVENT_SELECTED_ITEM_JOIN_BEHAVIOR_CHANGED = "The join behavior of a selected item has changed";
    public static final int RETURN_AS_SPECIFIED_IN_BUSINESS_QUERY = 0;
    public static final int RETURN_FORMATTED_AND_UNFORMATTED_DATA = 1;
    @SASScope
    public static final int RETURN_AS_SPECIFIED_IN_JOIN = 3;
    @SASScope
    public static final int RETURN_ALL_ROWS = 4;
    private static final int NOXML_FORMAT_TYPE = 0;
    private static final int NOXML_JOIN_BEHAVIOUR = 3;
    private List<Drill> _drillOrder = new LinkedList<Drill>();
    private DataItem _item;
    private Role _role;
    private int _formatType = 0;
    private int _joinBehavior = 3;
    private static final MonotonicIntegerToStringMapping formatValueMapper = new MonotonicIntegerToStringMapping(new String[]{"RETURN_AS_SPECIFIED_IN_BUSINESS_QUERY", "RETURN_FORMATTED_AND_UNFORMATTED_DATA"}, new int[]{0, 1});
    private static final MonotonicIntegerToStringMapping joinBehaviourMapper = new MonotonicIntegerToStringMapping(new String[]{"0", "1", "2", "RETURN_AS_SPECIFIED_IN_JOIN", "RETURN_ALL_ROWS"}, new int[]{0, 1, 2, 3, 4});

    @SASScope
    public SelectedItem() {
    }

    @SASScope
    public SelectedItem(DataItem item) {
        this(item, null, 0);
    }

    public SelectedItem(DataItem item, Role role) {
        this(item, role, 0);
    }

    @SASScope
    public SelectedItem(@Nonnull DataItem item, Role role, int formatType) {
        Preconditions.ensureNonNull(item);
        this._item = item;
        this.setRole(role);
        this.setFormatType(formatType);
    }

    public int getFormatType() {
        return this._formatType;
    }

    public void setFormatType(int formatType) {
        if (this._formatType != formatType) {
            int oldFormatType = this._formatType;
            if (formatType != 0 && formatType != 1) {
                throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("SelectedItem.InvalidFormatType.txt", new Object[0]));
            }
            this._formatType = formatType;
            this.fireChangeEvent(EVENT_SELECTED_ITEM_FORMAT_TYPE_CHANGED, oldFormatType, formatType);
        }
    }

    @SASScope
    public int getJoinBehavior() {
        return this._joinBehavior;
    }

    @SASScope
    public void setJoinBehavior(int joinBehavior) {
        int oldJoinBehavior = this._joinBehavior;
        if (joinBehavior != 3 && joinBehavior != 4) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("SelectedItem.InvalidBehaviorType.txt", joinBehavior));
        }
        this._joinBehavior = joinBehavior;
        this.fireChangeEvent(EVENT_SELECTED_ITEM_JOIN_BEHAVIOR_CHANGED, oldJoinBehavior, joinBehavior);
    }

    public Role getRole() {
        return this._role;
    }

    public void setRole(Role role) {
        if (role != this._role) {
            Role oldObj = this._role;
            this._role = role;
            this.fireChangeEvent("The role of a result item has changed", oldObj, role);
        }
    }

    @Nonnull
    public DataItem getItem() throws IllegalStateException {
        if (this._item == null) {
            throw new IQueryServicesIllegalStateException(IQMetadataResourceBundle.getMessageFormatter("SelectedItem.MissingDataItem.txt", new Object[0]));
        }
        return this._item;
    }

    public List<Drill> getDrillOrder() {
        return Collections.unmodifiableList(this._drillOrder);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @SASScope
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj != null) {
            if (this == obj) {
                equal = true;
            } else if (obj instanceof SelectedItem) {
                SelectedItem rhs = (SelectedItem)obj;
                if (this._item.equals(rhs._item) && this._role == rhs._role && this._formatType == rhs._formatType) {
                    equal = true;
                }
            }
        }
        return equal;
    }

    @SASScope
    public int hashCode() {
        int result = 17;
        result = 37 * result + this._item.hashCode();
        result = 37 * result + (this._role == null ? 0 : this._role.hashCode());
        result = 37 * result + this._formatType;
        return result;
    }

    @SASScope
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("item ");
        if (this._item == null) {
            buffer.append("null");
        } else {
            buffer.append("'").append(this._item).append("' (as '").append(this._item.getResultSetID()).append("')");
        }
        buffer.append(" on role=");
        buffer.append(this._role);
        switch (this._formatType) {
            case 1: {
                buffer.append(", returning both formatted and unformatted values");
                break;
            }
        }
        switch (this._joinBehavior) {
            case 4: {
                buffer.append(", return all rows for this item");
                break;
            }
        }
        if (!this._drillOrder.isEmpty()) {
            for (Drill drill : this._drillOrder) {
                buffer.append("\n" + drill.toString());
            }
        }
        return buffer.toString();
    }

    @Override
    @SASScope
    public void addListener(PropertyChangeListener listener) {
        super.addListener(listener);
        this._item.addListener(listener);
    }

    @Override
    @SASScope
    public void removeListener(PropertyChangeListener listener) {
        super.removeListener(listener);
        this._item.removeListener(listener);
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        SelectedItem.writeRelatedObject(this._item, thisElement, writingContext, "Item");
        Map<QueryWriteOption, Object> options = writingContext.getWritingOptions();
        if (options != null && options.containsKey((Object)QueryWriteOption.SAVE_DRILLORDER)) {
            List<Drill> drillOrder = this.getDrillOrder((IQResultSetMetaData)options.get((Object)QueryWriteOption.SAVE_DRILLORDER));
            if (!drillOrder.isEmpty()) {
                SelectedItem.writeRelatedObjects(drillOrder, thisElement, writingContext, "DrillState", ModelVersion.VERSION_93);
            }
            this._drillOrder.clear();
            this._drillOrder.addAll(drillOrder);
        }
        IQModelImplUtilities.setEnumAttr(thisElement, "role", this._role);
        if (this._formatType != 0) {
            IQModelImplUtilities.setAttr(thisElement, "fmtType", formatValueMapper.stringValue(this._formatType));
        }
        if (this._joinBehavior != 3) {
            IQModelImplUtilities.setAttr(thisElement, "joinBehavior", joinBehaviourMapper.stringValue(this._joinBehavior));
        }
    }

    private List<Drill> getDrillOrder(IQResultSetMetaData rsMetaData) {
        LinkedList<Drill> drillOrder;
        block3: {
            drillOrder = new LinkedList<Drill>();
            try {
                List<DrillPath> drillPathList = rsMetaData.getDrillPaths(this._item);
                for (DrillPath dp : drillPathList) {
                    drillOrder.add(new Drill(this, dp.getLevelName(), dp.getMemberName(), dp.getMemberUniqueName()));
                }
            }
            catch (ExecutionException e) {
                Logger logger = LogManager.getLogger(SelectedItem.class);
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Unable to get drill order history from result set for selected item");
            }
        }
        return drillOrder;
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "SelectedItem";
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._role = Role.fromPersistentForm(attrsProvider.consumeAttr("role"), null);
        String formatTypeAttr = attrsProvider.consumeAttr("fmtType");
        this._formatType = formatValueMapper.intValueNoCheckedException(formatTypeAttr, 0);
        String joinBehaviourAttr = attrsProvider.consumeAttr("joinBehavior");
        this._joinBehavior = joinBehaviourMapper.intValueNoCheckedException(joinBehaviourAttr, 3);
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._item = (DataItem)((Object)riHolder.consumeObject("Item"));
        this._drillOrder.addAll(riHolder.consumeObjects("DrillState", Drill.class));
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._item);
        intoList.addAll(this._drillOrder);
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._item = (DataItem)SelectedItem.replace(this._item, oldObject, newObject);
        SelectedItem.replaceInList(this._drillOrder, oldObject, newObject);
    }
}

