/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.business.impl.IQUsageVersions;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.util.UsageVersion;

@SASScope(value="ALL")
@SubjectToChange
public class ModelVersion
implements Comparable<ModelVersion> {
    public static final ModelVersion VERSION_912 = new ModelVersion("9.1.2");
    public static final ModelVersion VERSION_913 = new ModelVersion("9.1.3");
    public static final ModelVersion VERSION_913_2 = new ModelVersion("9.1.3.2");
    public static final ModelVersion VERSION_913_3 = new ModelVersion("9.1.3.3");
    public static final ModelVersion VERSION_913_4 = new ModelVersion("9.1.3.4");
    @SASScope
    public static final ModelVersion VERSION_pre92a = new ModelVersion("9.1.3.4a");
    @SASScope
    public static final ModelVersion VERSION_pre92b = new ModelVersion("9.1.3.4b");
    public static final ModelVersion VERSION_92 = new ModelVersion("9.2.0.2", IQUsageVersions.VERSION_92);
    public static final ModelVersion VERSION_92M3 = new ModelVersion("9.2.0.3", IQUsageVersions.VERSION_92M3);
    public static final ModelVersion VERSION_93a = new ModelVersion("9.3.0.0", IQUsageVersions.VERSION_93);
    public static final ModelVersion VERSION_93 = new ModelVersion("9.3.0.1", IQUsageVersions.VERSION_93);
    public static final ModelVersion VERSION_94;
    public static final ModelVersion THIS_SOFTWARE_VERSION;
    private int _version;
    private int _release;
    private int _modification;
    private String _stringValue;
    private UsageVersion _equivalentUsageVersion;
    private static final char DOT = '.';

    public ModelVersion(String versionString) {
        if (versionString == null) {
            MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("ModelVersion.NullArgVersionString.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(errorMsg);
        }
        String sub1 = null;
        String sub2 = null;
        String sub3 = null;
        int dot1 = versionString.indexOf(46);
        if (dot1 != -1) {
            sub1 = versionString.substring(0, dot1);
            int dot2 = versionString.indexOf(46, dot1 + 1);
            if (dot2 != -1) {
                sub2 = versionString.substring(dot1 + 1, dot2);
                int dot3 = versionString.indexOf(46, dot2 + 1);
                sub3 = dot3 != -1 ? versionString.substring(dot2 + 1, dot3) : versionString.substring(dot2 + 1);
            } else {
                sub2 = versionString.substring(dot1 + 1);
            }
        } else {
            sub1 = versionString;
        }
        this._stringValue = versionString;
        this._version = sub1 != null ? Integer.parseInt(sub1) : 0;
        this._release = sub2 != null ? Integer.parseInt(sub2) : 0;
        this._modification = sub3 != null ? Integer.parseInt(sub3) : 0;
    }

    private ModelVersion(String versionString, UsageVersion equivalentUsageVersion) {
        this(versionString);
        this._equivalentUsageVersion = equivalentUsageVersion;
    }

    @SASScope
    public UsageVersion getEquivalentUsageVersion() {
        return this._equivalentUsageVersion;
    }

    @SASScope
    public String toString() {
        return this._stringValue;
    }

    @Override
    @SASScope
    public int compareTo(ModelVersion thatVer) {
        if (thatVer == null) {
            throw new NullPointerException();
        }
        int rc = this._version < thatVer._version ? -1 : (this._version > thatVer._version ? 1 : (this._release < thatVer._release ? -1 : (this._release > thatVer._release ? 1 : (this._modification < thatVer._modification ? -1 : (this._modification > thatVer._modification ? 1 : this._stringValue.compareTo(thatVer._stringValue))))));
        return rc;
    }

    public boolean laterThan(ModelVersion version) {
        return this.compareTo(version) > 0;
    }

    public boolean earlierThan(ModelVersion version) {
        return this.compareTo(version) < 0;
    }

    public boolean laterThanOrSame(ModelVersion version) {
        return !this.earlierThan(version);
    }

    public boolean earlierThanOrSame(ModelVersion version) {
        return !this.laterThan(version);
    }

    @SASScope
    public boolean equals(Object obj) {
        boolean rc = false;
        if (obj instanceof ModelVersion) {
            ModelVersion that = (ModelVersion)obj;
            rc = this.compareTo(that) == 0;
        }
        return rc;
    }

    @SASScope
    public int hashCode() {
        return this._stringValue.hashCode();
    }

    static {
        THIS_SOFTWARE_VERSION = VERSION_94 = new ModelVersion("9.4.0.0", IQUsageVersions.VERSION_94);
    }
}

