/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.Lookup;
import com.sas.iquery.metadata.business.LookupValue;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.util.BaseStringComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class LookupList
extends Lookup {
    private List<LookupValue> lookupValues = new ArrayList<LookupValue>();
    private static final Logger _logger = LogManager.getLogger(LookupList.class);

    @SASScope(value="ALL")
    @SubjectToChange
    public LookupList() {
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public LookupList(List<LookupValue> values) throws MetadataException {
        this();
        this.setValuesList(values, true);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public LookupList(List<LookupValue> values, boolean allowDuplicates) throws MetadataException {
        this();
        this.setValuesList(values, allowDuplicates);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setValuesList(List<LookupValue> values) throws MetadataException {
        this.setValuesList(values, true);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setValuesList(List<LookupValue> values, boolean allowDuplicates) throws MetadataException {
        Preconditions.ensureNonNull(values);
        this.lookupValues.clear();
        if (!values.isEmpty()) {
            boolean valid = true;
            ArrayList<LookupValue> duplicates = new ArrayList<LookupValue>();
            if (allowDuplicates) {
                Iterator<LookupValue> it = values.iterator();
                while (it.hasNext() && valid) {
                    LookupValue obj = it.next();
                    if (obj instanceof LookupValue) continue;
                    valid = false;
                }
            } else {
                BaseStringComparator comparator = new BaseStringComparator(true, true);
                Collections.sort(values, comparator);
                for (int i = 0; i < values.size() - 1 && valid; ++i) {
                    LookupValue lkv1 = values.get(i);
                    LookupValue lkv2 = values.get(i + 1);
                    if (!(lkv1 instanceof LookupValue) || !(lkv2 instanceof LookupValue)) {
                        valid = false;
                        continue;
                    }
                    if (comparator.compare((Object)lkv1, (Object)lkv2) != 0) continue;
                    duplicates.add(lkv1);
                    values.remove(i);
                    --i;
                }
            }
            if (valid) {
                this.lookupValues.addAll(values);
                if (_logger.isEnabled(Level.WARN)) {
                    MessageFormatter messageFormatter = IQModelImplUtilities.getMessageFormatter("LookupListHasDuplicates.txt", new Object[0]);
                    ArrayMessageFormatter amf = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_LONG, messageFormatter, duplicates);
                    _logger.warn((Object)amf);
                }
            } else {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("LookupListNoLookupValue.txt", new Object[0]));
            }
        }
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public List<LookupValue> getValuesList() {
        return ListUtils.newList(this.lookupValues);
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "LookupList";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        LookupList.writeRelatedObjects(this.lookupValues, thisElement, writingContext, "LookupValues");
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this.lookupValues = riHolder.consumeObjects("LookupValues", LookupValue.class);
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this.lookupValues = LookupList.v1_readItemListUnderSubelement(thisElement, readingContext, "LookupValueList", new Class[]{LookupValue.class});
    }

    @SASScope
    public String toString() {
        return IQModelImplUtilities.toString(this.getValuesList());
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        if (this.lookupValues != null) {
            intoList.addAll(this.lookupValues);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        LookupList.replaceInList(this.lookupValues, oldObject, newObject);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        LookupList clone = (LookupList)super.clone();
        clone.lookupValues = new ArrayList<LookupValue>();
        for (int i = 0; i < this.lookupValues.size(); ++i) {
            LookupValue value = this.lookupValues.get(i);
            LookupValue valueClone = (LookupValue)value.clone();
            clone.lookupValues.add(valueClone);
        }
        return clone;
    }
}

