/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.impl.InformationMapImpl2;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

@SASScope(value="ALL")
@SubjectToChange
public class InformationMapFactory {
    private static final Logger _logger = LogManager.getLogger(InformationMapFactory.class);
    private static final Logger _mdLogger = LogManager.getLogger((String)"com.sas.iquery.metadata.business");
    private static InformationMapFactory instance = new InformationMapFactory();

    private InformationMapFactory() {
    }

    public static InformationMapFactory getInstance() {
        return instance;
    }

    @SASScope
    public InformationMap newInformationMap(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, Element xmlElement, String repositoryName) throws MetadataException {
        InformationMapImpl2 outMap = InformationMapImpl2.readInNewMap(xmlElement, new HashMap(), service, session);
        return outMap;
    }

    @SASScope
    public InformationMap newInformationMap(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service) throws MetadataException {
        Locale locale = LocaleUtilities.getDefaultComputationalLocale(session);
        return this.newInformationMap(session, service, locale);
    }

    @SASScope
    public InformationMap newInformationMap(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, Locale locale) throws MetadataException {
        Preconditions.ensureNonNull(session, "session");
        Preconditions.ensureNonNull(service, "service");
        Preconditions.ensureNonNull(locale, "locale");
        if (_logger.isDebugEnabled()) {
            _logger.debug(">> newInformationMap(session): " + IQModelImplUtilities.toString(session));
        }
        _logger.info("API: newInformationMap(session)");
        InformationMap outMap = InformationMapImpl2.newInformationMap(service, session, locale);
        if (_logger.isDebugEnabled()) {
            _logger.debug("<< newInformationMap: " + IQModelImplUtilities.toString(outMap));
        }
        return outMap;
    }

    public InformationMap newInformationMap(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, PathUrl pathToMap) throws MetadataException {
        if (_mdLogger.isInfoEnabled()) {
            _logger.info("API: newInformationMap(session, pathToMap)");
        }
        InformationMap outMap = null;
        MetadataInterface metadataObject = service.getMetadataInterface(session, pathToMap);
        if (metadataObject != null) {
            if (!(metadataObject instanceof BriefInformationMap)) {
                MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter("IntelligentQueryMetadataService.InvalidPathUrl.fmt.txt", pathToMap.getAbsolutePath());
                throw new MetadataException(errorMsg);
            }
            BriefInformationMap briefMap = (BriefInformationMap)metadataObject;
            outMap = this.newInformationMap(session, service, briefMap);
        }
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug("<< newInformationMap: " + IQModelImplUtilities.toString(outMap));
        }
        return outMap;
    }

    public InformationMap newInformationMap(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, BriefInformationMap briefMap) throws MetadataException {
        return this.newInformationMap(session, service, briefMap, null).getMap();
    }

    @SASScope
    public Results newInformationMap(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, BriefInformationMap briefMap, FactorySettings settings) throws MetadataException {
        Preconditions.ensureNonNull(session, "session");
        Preconditions.ensureNonNull(service, "service");
        Preconditions.ensureNonNull(briefMap, "briefMap");
        return InformationMapImpl2.readInNewMap(briefMap, service, session);
    }

    @SASScope
    public FactorySettings newFactorySettings() {
        return new Settings();
    }

    @SASScope
    public static interface FactorySettings {

        public static enum TYPE {
            ResolveExternalResources,
            LoadAllResourceAttributes,
            LoadExternalResourcesOnly;

        }
    }

    @SASScope
    public static interface Results {
        public InformationMap getMap();

        public Collection<DataSourceTable.ReadModification> getDataSourceTableMods();
    }

    private class Settings
    implements FactorySettings {
        private HashMap<FactorySettings.TYPE, Boolean> settings = new HashMap(3);

        Settings() {
            this.settings.put(FactorySettings.TYPE.ResolveExternalResources, Boolean.TRUE);
            this.settings.put(FactorySettings.TYPE.LoadExternalResourcesOnly, Boolean.FALSE);
            this.settings.put(FactorySettings.TYPE.LoadAllResourceAttributes, Boolean.FALSE);
        }

        public void setValue(FactorySettings.TYPE setting, boolean value) {
            this.settings.put(setting, value);
        }

        public boolean getValue(FactorySettings.TYPE setting) {
            return this.settings.get((Object)setting);
        }
    }
}

