/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.NamedObjectInterface;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.ExportColumn;
import com.sas.iquery.metadata.business.ExportObject;
import com.sas.iquery.metadata.business.Model;
import com.sas.iquery.metadata.business.ModelItemWithIdentity;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.OlapItem;
import java.util.List;

public interface ExportColumnGroup
extends ExportObject<Object, ExportColumnGroup> {
    public ExportGroupType getGroupType() throws MetadataException;

    public List<ExportColumn> getColumns() throws MetadataException;

    public static enum ExportGroupType {
        ROLE{

            @Override
            public String getID(Object obj) throws MetadataException {
                Role role = (Role)obj;
                String id = role.getV2PersistentForm();
                return id;
            }

            @Override
            public String getDescription(Object obj) throws MetadataException {
                String desc = obj == null ? "" : "Role=" + obj;
                return desc;
            }
        }
        ,
        USAGE{

            @Override
            public String getID(Object obj) throws MetadataException {
                DataItemActionType usage = (DataItemActionType)obj;
                String id = usage.getV2PersistentForm();
                return id;
            }

            @Override
            public String getDescription(Object obj) throws MetadataException {
                String desc = obj == null ? "" : "Usage=" + obj;
                return desc;
            }
        }
        ,
        HIERARCHY{

            @Override
            public String getID(Object obj) throws MetadataException {
                String id;
                if (obj instanceof Hierarchy) {
                    Hierarchy hier = (Hierarchy)obj;
                    id = hier.getHierarchyUniqueName();
                } else if (obj instanceof OlapItem) {
                    OlapItem olapItem = (OlapItem)obj;
                    id = olapItem.getUniqueName();
                } else if (obj instanceof ModelItemWithIdentity) {
                    ModelItemWithIdentity miwi = (ModelItemWithIdentity)obj;
                    id = miwi.getID();
                } else if (obj instanceof Model) {
                    Model bm = (Model)obj;
                    id = bm.getID();
                } else {
                    id = String.valueOf(obj);
                }
                return id;
            }

            @Override
            public String getLabel(Object obj) throws MetadataException {
                String label;
                if (obj instanceof Hierarchy) {
                    Hierarchy hier = (Hierarchy)obj;
                    label = hier.getLabel();
                } else if (obj instanceof NamedObjectInterface) {
                    NamedObjectInterface noi = (NamedObjectInterface)obj;
                    label = noi.getLabel();
                } else {
                    label = String.valueOf(obj);
                }
                return label;
            }

            @Override
            public String getDescription(Object obj) throws MetadataException {
                String label;
                if (obj instanceof Hierarchy) {
                    Hierarchy hier = (Hierarchy)obj;
                    label = hier.getDescription();
                } else if (obj instanceof NamedObjectInterface) {
                    NamedObjectInterface noi = (NamedObjectInterface)obj;
                    label = noi.getDescription();
                } else {
                    label = String.valueOf(obj);
                }
                return label;
            }
        }
        ,
        OTHER{};


        public String getID(Object obj) throws MetadataException {
            String id = obj == null ? "" : obj.getClass().getName() + "_" + Integer.toHexString(obj.hashCode());
            return id;
        }

        public String getLabel(Object obj) throws MetadataException {
            String label = obj == null ? "" : obj.toString();
            return label;
        }

        public String getDescription(Object obj) throws MetadataException {
            String desc = obj == null ? "" : obj.getClass().getSimpleName() + "=" + obj;
            return desc;
        }
    }
}

