/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import java.util.List;
import javax.annotation.Nonnull;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Drill
extends AbstractModelItem
implements Cloneable {
    private SelectedItem _item;
    private String _levelName;
    private String _memberName;
    private String _uniqueName;

    @SASScope
    public Drill() {
    }

    public Drill(@Nonnull SelectedItem item, @Nonnull String levelName, @Nonnull String memberName, @Nonnull String uniqueName) {
        this._item = item;
        this._levelName = levelName;
        this._memberName = memberName;
        this._uniqueName = uniqueName;
    }

    @Nonnull
    public String getLevelName() {
        return this._levelName;
    }

    @Nonnull
    public String getMemberName() {
        return this._memberName;
    }

    @Nonnull
    public String getUniqueName() {
        return this._uniqueName;
    }

    @Override
    protected String getDefinitionElementName() {
        return "DrillStateInfo";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        Drill.writeRelatedObject(this._item, thisElement, writingContext, "Item");
        IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "levelName", this._levelName);
        IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "memberName", this._memberName);
        IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "uniqueName", this._uniqueName);
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._levelName = attrsProvider.consumeAttrEmptyDefault("levelName");
        this._memberName = attrsProvider.consumeAttrEmptyDefault("memberName");
        this._uniqueName = attrsProvider.consumeAttrEmptyDefault("uniqueName");
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._item = (SelectedItem)riHolder.consumeObject("Item");
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._item);
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._item = (SelectedItem)Drill.replace(this._item, oldObject, newObject);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @SASScope
    public boolean equals(Object obj) {
        boolean equal = super.equals(obj);
        if (!equal && obj instanceof Drill) {
            Drill lhs = (Drill)obj;
            if (lhs._levelName.equals(this._levelName) && lhs._memberName.equals(this._memberName) && lhs._uniqueName.equals(this._uniqueName)) {
                equal = true;
            }
        }
        return equal;
    }

    @SASScope
    public int hashCode() {
        int result = 37;
        result += this._levelName.hashCode();
        result += this._memberName.hashCode();
        return result += this._uniqueName.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DrillStateInfo: Level Name - [");
        buffer.append(this._levelName);
        buffer.append("] Member Name - [");
        buffer.append(this._memberName);
        buffer.append("] Unique Name - [");
        buffer.append(this._uniqueName);
        buffer.append("]");
        return buffer.toString();
    }
}

