/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.execution.UserSessionConnectionDecorator;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.session.SessionContextInterface;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class CancelQuerySupport {
    private static final Logger _logger = LogManager.getLogger(CancelQuerySupport.class);
    private static CancelQuerySupport _instance = new CancelQuerySupport();
    public static int RC_CANCELLEDQUERY = -86;
    private static Map registeredListeners = Collections.synchronizedMap(new WeakHashMap(1000));
    private static boolean _cancelQueryEnabledByDefault = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Map map = registeredListeners;
        synchronized (map) {
            if (!registeredListeners.isEmpty()) {
                System.err.println("Finalizing CancelQuerySupport, and it still has registered queries!");
                ArrayList keyList = new ArrayList(registeredListeners.keySet());
                for (DataSelection cancelQuery : keyList) {
                    List pairs;
                    System.err.println("  query=" + cancelQuery + " [" + cancelQuery.getID() + "] " + cancelQuery.getClass().getName() + "@" + Integer.toHexString(cancelQuery.hashCode()));
                    if (cancelQuery instanceof CancellableQuery) {
                        System.err.println("  isCancelEnabled at finalization=" + ((CancellableQuery)((Object)cancelQuery)).isCancelEnabled());
                    }
                    if ((pairs = (List)registeredListeners.get(cancelQuery)) == null) continue;
                    System.err.println("    number of pairs = " + pairs.size());
                    if (pairs.size() <= 0) continue;
                    ArrayList targets = new ArrayList(pairs);
                    for (ListenerConnectionPair pair : targets) {
                        System.err.println("    pair=" + pair);
                        if (pair == null) continue;
                        CancelQueryListener listener = pair.getListener();
                        ConnectionInterface connection = pair.getConnection();
                        System.err.println("      listener=" + listener.getClass().getName() + "@" + Integer.toHexString(listener.hashCode()) + "\n      connection=" + connection);
                        pair.printStackTrace(System.err);
                    }
                }
            }
        }
        super.finalize();
    }

    public static boolean isCancelQueryEnabledByDefault() {
        return _cancelQueryEnabledByDefault;
    }

    public static void setCancelQueryEnabledByDefault(boolean cancelQueryEnabledByDefault) {
        _cancelQueryEnabledByDefault = cancelQueryEnabledByDefault;
    }

    public static void cancelRegisteredQuery(DataSelection cancelQuery) {
        CancelQuerySupport.cancelRegisteredQuery(cancelQuery, null);
    }

    static void cancelRegisteredQuery(DataSelection cancelQuery, CancelQueryEvent event) {
        if (cancelQuery instanceof CancellableQuery && ((CancellableQuery)((Object)cancelQuery)).isCancelEnabled()) {
            CancelQueryEvent evt;
            CancelQueryEvent cancelQueryEvent;
            if (event == null) {
                CancelQuerySupport cancelQuerySupport = _instance;
                Objects.requireNonNull(cancelQuerySupport);
                cancelQueryEvent = cancelQuerySupport.new CancelQueryEvent(cancelQuery);
            } else {
                cancelQueryEvent = evt = event;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("cancelling query: " + cancelQuery + " [" + cancelQuery.getID() + "] " + cancelQuery.getClass().getName() + "@" + Integer.toHexString(cancelQuery.hashCode()));
            }
            List listeners = CancelQuerySupport.getRegisteredQueryListeners(cancelQuery);
            HashSet processedListeners = new HashSet();
            while (listeners != null && !listeners.isEmpty()) {
                CancelQuerySupport.cancel(listeners, evt);
                processedListeners.addAll(listeners);
                listeners = CancelQuerySupport.getRegisteredQueryListeners(cancelQuery);
                listeners.removeAll(processedListeners);
            }
        }
    }

    private static void cancel(Collection<CancelQueryListener> listeners, CancelQueryEvent evt) {
        for (CancelQueryListener listener : listeners) {
            listener.cancelQueryPerformed(evt);
        }
    }

    public static List getRegisteredQueryListeners(DataSelection cancelQuery) {
        ArrayList<CancelQueryListener> listeners = new ArrayList<CancelQueryListener>();
        List pairs = CancelQuerySupport.getRegisteredPairs(cancelQuery);
        HashSet processedPairs = new HashSet();
        while (pairs != null && !pairs.isEmpty()) {
            for (ListenerConnectionPair pair : pairs) {
                CancelQueryListener listener = pair.getListener();
                if (listener == null || listeners.contains(listener)) continue;
                listeners.add(listener);
            }
            processedPairs.addAll(pairs);
            pairs = CancelQuerySupport.getRegisteredPairs(cancelQuery);
            pairs.removeAll(processedPairs);
        }
        return listeners;
    }

    public static void registerQueryListener(DataSelection cancelQuery, CancelQueryListener registerListener) {
        CancelQuerySupport.registerQueryListener(cancelQuery, registerListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerQueryListener(DataSelection cancelQuery, CancelQueryListener registerListener, ConnectionInterface registerConnection) {
        if (cancelQuery instanceof CancellableQuery && ((CancellableQuery)((Object)cancelQuery)).isCancelEnabled()) {
            Map map = registeredListeners;
            synchronized (map) {
                ArrayList<ListenerConnectionPair> pairs = (ArrayList<ListenerConnectionPair>)registeredListeners.get(cancelQuery);
                if (pairs == null) {
                    pairs = new ArrayList<ListenerConnectionPair>();
                    registeredListeners.put(cancelQuery, pairs);
                }
                CancelQuerySupport cancelQuerySupport = _instance;
                Objects.requireNonNull(cancelQuerySupport);
                ListenerConnectionPair newPair = cancelQuerySupport.new ListenerConnectionPair(registerListener, registerConnection);
                if (!pairs.contains(newPair)) {
                    Iterator pairsIter = pairs.iterator();
                    boolean match = false;
                    while (pairsIter.hasNext() && !match) {
                        ListenerConnectionPair pair = (ListenerConnectionPair)pairsIter.next();
                        if (pair == null) continue;
                        if (pair.equals(newPair)) {
                            match = true;
                            continue;
                        }
                        if (pair.getListener() != registerListener || pair.getConnection() != null || registerConnection == null) continue;
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Update Registration:\n  query=" + cancelQuery + " [" + cancelQuery.getID() + "] " + cancelQuery.getClass().getName() + "@" + Integer.toHexString(cancelQuery.hashCode()) + "\n   listener=" + registerListener.getClass().getName() + "@" + Integer.toHexString(registerListener.hashCode()) + "\n   connection=" + registerConnection);
                        }
                        pair.setConnection(registerConnection);
                        pair.setStackTrace(new Exception());
                        match = true;
                    }
                    if (!match) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Register:\n  query=" + cancelQuery + " [" + cancelQuery.getID() + "] " + cancelQuery.getClass().getName() + "@" + Integer.toHexString(cancelQuery.hashCode()) + "\n   listener=" + registerListener.getClass().getName() + "@" + Integer.toHexString(registerListener.hashCode()) + "\n   connection=" + registerConnection);
                        }
                        pairs.add(newPair);
                        newPair.setStackTrace(new Exception());
                    }
                }
            }
        }
    }

    public static void unRegisterQueryListener(DataSelection cancelQuery, CancelQueryListener unRegisterListener) {
        CancelQuerySupport.unRegisterQuery(cancelQuery, false, unRegisterListener);
    }

    public static void unRegisterQuery(DataSelection unRegisterQuery) {
        CancelQuerySupport.unRegisterQuery(unRegisterQuery, true, null);
    }

    public static void cancelRegisteredQueries(SessionContextInterface session) {
        CancelQuerySupport.cancelRegisteredQueries(session, null);
    }

    static void cancelRegisteredQueries(SessionContextInterface session, CancelQueryEvent event) {
        if (!registeredListeners.isEmpty()) {
            List queries = CancelQuerySupport.getRegisteredQueries(session);
            HashSet processedQueries = new HashSet();
            while (queries.size() > 0) {
                for (DataSelection cancelQuery : queries) {
                    CancelQuerySupport.cancelRegisteredQuery(cancelQuery, event);
                }
                processedQueries.addAll(queries);
                queries = CancelQuerySupport.getRegisteredQueries(session);
                queries.removeAll(processedQueries);
            }
        }
    }

    public static void unRegisterSession(SessionContextInterface unRegisterSessionContext) {
        if (!registeredListeners.isEmpty()) {
            List queries = CancelQuerySupport.getRegisteredQueries(unRegisterSessionContext);
            HashSet processedQueries = new HashSet();
            while (queries.size() > 0) {
                for (DataSelection cancelQuery : queries) {
                    CancelQuerySupport.unRegisterQuery(cancelQuery);
                }
                processedQueries.addAll(queries);
                queries = CancelQuerySupport.getRegisteredQueries(unRegisterSessionContext);
                queries.removeAll(processedQueries);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRegisteredQueries(SessionContextInterface session) {
        ArrayList<DataSelection> queries = new ArrayList<DataSelection>();
        Map map = registeredListeners;
        synchronized (map) {
            if (!registeredListeners.isEmpty()) {
                for (DataSelection cancelQuery : registeredListeners.keySet()) {
                    if (cancelQuery == null || cancelQuery.getSession() != session || queries.contains(cancelQuery)) continue;
                    queries.add(cancelQuery);
                }
            }
        }
        return queries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unRegisterConnection(ConnectionInterface unRegisterConnection) {
        Map map = registeredListeners;
        synchronized (map) {
            if (!registeredListeners.isEmpty()) {
                ArrayList keyList = new ArrayList(registeredListeners.keySet());
                for (DataSelection cancelQuery : keyList) {
                    List pairs = (List)registeredListeners.get(cancelQuery);
                    if (pairs == null) continue;
                    if (pairs.size() > 0) {
                        ArrayList targets = new ArrayList(pairs);
                        for (ListenerConnectionPair pair : targets) {
                            ConnectionInterface connection = pair.getConnection();
                            if (connection != unRegisterConnection) continue;
                            CancelQuerySupport.unRegisterPair(cancelQuery, pair, "for connection");
                        }
                    }
                    if (pairs.size() != 0) continue;
                    CancelQuerySupport.unRegisterKey(cancelQuery, "Query (empty listener list)");
                }
            }
        }
    }

    public static void cancelRegisteredQueries(ConnectionInterface connection) {
        CancelQuerySupport cancelQuerySupport = _instance;
        Objects.requireNonNull(cancelQuerySupport);
        CancelQueryEvent event = cancelQuerySupport.new CancelQueryEvent(connection);
        if (!registeredListeners.isEmpty()) {
            Set<CancelQueryListener> listeners = CancelQuerySupport.getRegisteredListeners(connection);
            HashSet<CancelQueryListener> processedListeners = new HashSet<CancelQueryListener>();
            while (listeners.size() > 0) {
                CancelQuerySupport.cancel(listeners, event);
                processedListeners.addAll(listeners);
                listeners = CancelQuerySupport.getRegisteredListeners(connection);
                listeners.removeAll(processedListeners);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<CancelQueryListener> getRegisteredListeners(ConnectionInterface cancelConnection) {
        HashSet<CancelQueryListener> listeners = new HashSet<CancelQueryListener>();
        Map map = registeredListeners;
        synchronized (map) {
            if (!registeredListeners.isEmpty()) {
                for (ListenerConnectionPair pair : registeredListeners.values()) {
                    ConnectionInterface connection = pair.getConnection();
                    CancelQueryListener listener = pair.getListener();
                    if (connection == cancelConnection) {
                        listeners.add(listener);
                    }
                    if (connection instanceof UserSessionConnectionDecorator && ((UserSessionConnectionDecorator)connection).getComponent() == cancelConnection) {
                        listeners.add(listener);
                    }
                    if (cancelConnection instanceof UserSessionConnectionDecorator && ((UserSessionConnectionDecorator)cancelConnection).getComponent() == connection) {
                        listeners.add(listener);
                    }
                    if (!(connection instanceof UserSessionConnectionDecorator) || !(cancelConnection instanceof UserSessionConnectionDecorator) || ((UserSessionConnectionDecorator)cancelConnection).getComponent() != ((UserSessionConnectionDecorator)connection).getComponent()) continue;
                    listeners.add(listener);
                }
            }
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unRegisterQuery(DataSelection cancelQuery, boolean allListeners, CancelQueryListener unRegisterListener) {
        if (cancelQuery instanceof CancellableQuery) {
            Map map = registeredListeners;
            synchronized (map) {
                List pairs;
                if (!registeredListeners.isEmpty() && (pairs = (List)registeredListeners.get(cancelQuery)) != null) {
                    if (!pairs.isEmpty()) {
                        ArrayList targets = new ArrayList(pairs);
                        for (ListenerConnectionPair pair : targets) {
                            CancelQueryListener listener = pair.getListener();
                            if (allListeners) {
                                CancelQuerySupport.unRegisterPair(cancelQuery, pair, "for query");
                                continue;
                            }
                            if (listener != unRegisterListener) continue;
                            CancelQuerySupport.unRegisterPair(cancelQuery, pair, "for listener");
                        }
                    }
                    if (allListeners) {
                        CancelQuerySupport.unRegisterKey(cancelQuery, "Query (all listeners)");
                    } else if (pairs.isEmpty()) {
                        CancelQuerySupport.unRegisterKey(cancelQuery, "Query (empty listener list)");
                    }
                }
            }
        }
    }

    private static void unRegisterPair(DataSelection cancelQuery, ListenerConnectionPair unRegisterPair, String tag) {
        List pairs;
        CancelQueryListener listener = unRegisterPair.getListener();
        ConnectionInterface connection = unRegisterPair.getConnection();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Unregister " + tag + ":\n  query=" + cancelQuery + " [" + cancelQuery.getID() + "] " + cancelQuery.getClass().getName() + "@" + Integer.toHexString(cancelQuery.hashCode()) + "\n   listener=" + listener.getClass().getName() + "@" + Integer.toHexString(listener.hashCode()) + "\n   connection=" + connection);
        }
        if ((pairs = (List)registeredListeners.get(cancelQuery)) != null) {
            if (pairs.size() > 0) {
                pairs.remove(unRegisterPair);
            }
            if (pairs.size() == 0) {
                CancelQuerySupport.unRegisterKey(cancelQuery, "Query (last listener removed)");
            }
        }
    }

    private static void unRegisterKey(DataSelection unRegisterQuery, String tag) {
        if (registeredListeners.containsKey(unRegisterQuery)) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Unregister " + tag + ":\n  query=" + unRegisterQuery + " [" + unRegisterQuery.getID() + "] " + unRegisterQuery.getClass().getName() + "@" + Integer.toHexString(unRegisterQuery.hashCode()));
            }
            registeredListeners.remove(unRegisterQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getRegisteredPairs(DataSelection cancelQuery) {
        ArrayList pairs = new ArrayList();
        Map map = registeredListeners;
        synchronized (map) {
            List cancelListeners;
            if (!registeredListeners.isEmpty() && registeredListeners.containsKey(cancelQuery) && (cancelListeners = (List)registeredListeners.get(cancelQuery)) != null) {
                pairs.addAll(cancelListeners);
            }
        }
        return pairs;
    }

    @SASScope
    public static interface CancellableQuery {
        public boolean isCancelEnabled();

        public void setCancelEnabled(boolean var1);
    }

    @SASScope
    class ListenerConnectionPair {
        CancelQueryListener _listener = null;
        ConnectionInterface _connection = null;
        private Exception _stackTraceException = null;

        ListenerConnectionPair(CancelQueryListener listener, ConnectionInterface connection) {
            this._connection = connection;
            this._listener = listener;
        }

        ConnectionInterface getConnection() {
            return this._connection;
        }

        void setConnection(ConnectionInterface connection) {
            this._connection = connection;
        }

        CancelQueryListener getListener() {
            return this._listener;
        }

        void setListener(CancelQueryListener listener) {
            this._listener = listener;
        }

        public boolean equals(Object obj) {
            ListenerConnectionPair obj2;
            boolean result = false;
            if (obj != null && obj instanceof ListenerConnectionPair && (obj2 = (ListenerConnectionPair)obj).getConnection() == this.getConnection() && obj2.getListener() == this.getListener()) {
                result = true;
            }
            return result;
        }

        void setStackTrace(Exception e) {
            this._stackTraceException = e;
        }

        StackTraceElement[] getStackTrace() {
            if (this._stackTraceException != null) {
                return this._stackTraceException.getStackTrace();
            }
            return null;
        }

        void printStackTrace() {
            this.printStackTrace(System.err);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void printStackTrace(PrintStream s) {
            PrintStream printStream = s;
            synchronized (printStream) {
                s.println("Registered: " + this);
                StackTraceElement[] trace = this.getStackTrace();
                for (int i = 0; i < trace.length; ++i) {
                    s.println("\tat " + trace[i]);
                }
            }
        }
    }

    @SASScope
    public static interface CancelQueryListener
    extends EventListener {
        public void cancelQueryPerformed(CancelQueryEvent var1);

        public SessionContextInterface getSession();
    }

    @SASScope
    public class CancelQueryEvent
    extends EventObject {
        private static final long serialVersionUID = 4584351796617986335L;

        public CancelQueryEvent(Object source) {
            super(source);
        }
    }
}

