/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.impl.cache.TextStoreMgr;

@SASScope
public final class OMRInformationMapCacheControl {
    private static final OMRInformationMapCacheControl instance = new OMRInformationMapCacheControl();
    private TextStoreMgr _cacheMgr = TextStoreMgr.instance();

    public static OMRInformationMapCacheControl getInstance() {
        return instance;
    }

    private OMRInformationMapCacheControl() {
    }

    public void setMaxAgeSec(int ageInSeconds) {
        this._cacheMgr.getTuning().setMaxAgeSec(ageInSeconds);
    }

    public int getMaxAgeSec() {
        return this._cacheMgr.getTuning().getMaxAgeSec();
    }

    public void setMaxEntries(int maxEntries) {
        this._cacheMgr.getTuning().setMaxSize(maxEntries);
    }

    public int getMaxEntries() {
        return this._cacheMgr.getTuning().getMaxSize();
    }

    public void setMaxSize(int maxSize) {
        this._cacheMgr.getTuning().setMaxWeightedSize(maxSize);
    }

    public int getMaxSize() {
        return this._cacheMgr.getTuning().getMaxSize();
    }

    public void activate() {
        this._cacheMgr.setCacheAllowed(true);
    }

    public void deactivate() {
        this._cacheMgr.setCacheAllowed(false);
    }

    public boolean isActivated() {
        return this._cacheMgr.isCachingAllowed();
    }

    public void clear() {
        this._cacheMgr.getTuning().clear();
    }
}

