/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.InformationMapFactory;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.InformationMapImpl2;
import com.sas.iquery.metadata.business.impl.OMRTemplates;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.DatabaseSchema;
import com.sas.iquery.metadata.physical.OMAResourceFactory;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.metadata.physical.OlapServer;
import com.sas.iquery.metadata.physical.RelationalSchema;
import com.sas.iquery.metadata.physical.RelationalServer;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.SASOlapSchema;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.Server;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.oma.OMASoftwareServer;
import com.sas.iquery.metadata.serverprop.ServerIdentification;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.session.SessionContextInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class IntelligentQueryMetadataService
implements IntelligentQueryMetadataServiceInterface {
    private final List<ServerProperties> _serverProperties;
    private Map<Server, ServerProperties> _cachedServersWithProperties = Collections.synchronizedMap(new WeakHashMap());
    private static final Logger _logger = LogManager.getLogger(IntelligentQueryMetadataService.class);
    private static final Logger _mdLogger = LogManager.getLogger((String)"com.sas.iquery.metadata");

    IntelligentQueryMetadataService() throws MetadataException {
        this.initService();
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug("Reading the default server properties file");
        }
        this._serverProperties = ServerProperties.readServerProperties();
    }

    IntelligentQueryMetadataService(File serverPropertiesFile) throws MetadataException {
        if (serverPropertiesFile == null) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("IntelligentQueryMetadataService.NullServerPropFile.txt", new Object[0]));
        }
        try {
            this.initService();
            if (_mdLogger.isDebugEnabled()) {
                _logger.debug("Reading user specified server properties file");
            }
            this._serverProperties = ServerProperties.readServerProperties(new FileInputStream(serverPropertiesFile));
        }
        catch (FileNotFoundException e) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("IntelligentQueryMetadataService.ServerPropFileNotFound.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error((Object)msg, (Throwable)e);
            }
            throw new MetadataException(msg, (Throwable)e);
        }
    }

    private void initService() throws MetadataException {
        try {
            if (_mdLogger.isDebugEnabled()) {
                _logger.debug("Getting the information service");
            }
            this.findService(InformationServiceInterface.class);
        }
        catch (ServiceNotAvailableException e) {
            if (_mdLogger.isDebugEnabled()) {
                _logger.debug("Information Service unavailable ... and is required");
            }
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("IntelligentQueryMetadataService.FailedToLoadInfoService.txt", new Object[0]), (Throwable)e);
        }
        catch (InitializationException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public FolderInterface getBIPTreeRootFolder(SessionContextInterface session, String reposName) throws MetadataException {
        if (session == null || reposName == null) {
            String errorMsg = IQMetadataResourceBundle.getStringResource("IntelligentQueryMetadataService.NullArgSessionOrReposName.txt");
            throw new IQueryServicesIllegalArgumentException(errorMsg);
        }
        try {
            if (_mdLogger.isDebugEnabled()) {
                _logger.debug(">> getBIPTreeRootFolder(session, reposName): " + Utils.toString(session) + "," + reposName);
            }
            _logger.info("API: getBIPTreeRootFolder");
            RepositoryInterface repository = IQModelImplUtilities.connectToRepos(session, reposName);
            FolderInterface outFolder = repository.getRootFolder("BIP Tree");
            if (_mdLogger.isDebugEnabled()) {
                _logger.debug("<< getBIPTreeRootFolder: " + Utils.toString(outFolder));
            }
            return outFolder;
        }
        catch (ServiceException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                String errorMsg = IQMetadataResourceBundle.getStringResource("IntelligentQueryMetadataService.FailedToGetBIPTree.txt");
                _logger.error(errorMsg, (Throwable)e);
            }
            return null;
        }
        catch (RemoteException e) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("IntelligentQueryMetadataService.FailedToGetBIPTree.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error((Object)msg, (Throwable)e);
            }
            throw new MetadataException(msg, (Throwable)e);
        }
    }

    @Override
    public InformationMap newInformationMap(SessionContextInterface session) throws MetadataException {
        Locale dataLocale = LocaleUtilities.getDefaultComputationalLocale(session);
        return this.newInformationMap(session, dataLocale);
    }

    @Override
    public InformationMap newInformationMap(SessionContextInterface session, Locale locale) throws MetadataException {
        if (session == null) {
            String errorMsg = IQMetadataResourceBundle.getStringResource("IntelligentQueryMetadataService.NullArgSession.txt");
            throw new IQueryServicesIllegalArgumentException(errorMsg);
        }
        if (locale == null) {
            String errorMsg = IQMetadataResourceBundle.getStringResource("InformationMap.NullLocale.txt");
            throw new IQueryServicesIllegalArgumentException(errorMsg);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug(">> newInformationMap(session): " + IQModelImplUtilities.toString(session));
        }
        _logger.info("API: newInformationMap(session)");
        InformationMap outMap = InformationMapImpl2.newInformationMap(this, session, locale);
        if (_logger.isDebugEnabled()) {
            _logger.debug("<< newInformationMap: " + IQModelImplUtilities.toString(outMap));
        }
        return outMap;
    }

    @Override
    public InformationMap getInformationMap(SessionContextInterface session, BriefInformationMap briefMap) throws MetadataException {
        return InformationMapFactory.getInstance().newInformationMap(session, (IntelligentQueryMetadataServiceInterface)this, briefMap);
    }

    @Override
    public MetadataInterface getMetadataInterface(SessionContextInterface session, PathUrl pathToMap) throws MetadataException {
        return IQModelImplUtilities.pathUrlToMetadataInterface(session, pathToMap);
    }

    @Override
    public InformationMap getInformationMap(SessionContextInterface session, PathUrl pathToMap) throws MetadataException {
        return InformationMapFactory.getInstance().newInformationMap(session, (IntelligentQueryMetadataServiceInterface)this, pathToMap);
    }

    @Override
    @Deprecated
    public List getSoftwareServers(SessionContextInterface session, String reposName, List serverTypes) throws MetadataException {
        return this.getSoftwareServers(session, serverTypes);
    }

    private List getIQSoftwareServers(List serverContextInterfaces, List serverTypes, SessionContextInterface session) throws MetadataException, ServiceException, MdException, RemoteException {
        ArrayList<SoftwareServer> outServers = new ArrayList<SoftwareServer>();
        WhichServer<Boolean> ws = this.determineServerTypesToReturn(serverTypes);
        for (ServerContextInterface sci : serverContextInterfaces) {
            SoftwareServer server;
            if (((Boolean)ws.workspaceServer).booleanValue() && (server = this.getIQServerObject(sci, true, session)) != null) {
                outServers.add(server);
            }
            if (!((Boolean)ws.olapServer).booleanValue() || (server = this.getIQServerObject(sci, false, session)) == null) continue;
            outServers.add(server);
        }
        return outServers;
    }

    private WhichServer<Boolean> determineServerTypesToReturn(List serverTypes) {
        Boolean returnWorkspaceServers = Boolean.FALSE;
        Boolean returnOLAPServers = Boolean.FALSE;
        for (Object object : serverTypes) {
            Class c = (Class)object;
            if (RelationalServer.class.isAssignableFrom(c)) {
                returnWorkspaceServers = Boolean.TRUE;
                continue;
            }
            if (OlapServer.class.isAssignableFrom(c)) {
                returnOLAPServers = Boolean.TRUE;
                continue;
            }
            if (!SoftwareServer.class.isAssignableFrom(c)) continue;
            returnWorkspaceServers = Boolean.TRUE;
            returnOLAPServers = Boolean.TRUE;
            break;
        }
        return new WhichServer<Boolean>(returnWorkspaceServers, returnOLAPServers);
    }

    private SoftwareServer getIQServerObject(ServerContextInterface sci, boolean relationalType, SessionContextInterface session) throws MetadataException, ServiceException, MdException, RemoteException {
        OMASoftwareServer out = null;
        Object obj = sci.getRepositoryEntity();
        if (obj instanceof ServerContext) {
            ServerContext serverContext = (ServerContext)obj;
            MetadataServerInterface msi = (MetadataServerInterface)sci.getRepository().getServer();
            out = OMAResourceFactory.getOMAServerObject(serverContext, session, msi, relationalType);
        }
        return out;
    }

    public <T extends SoftwareServer> List<T> getSoftwareServers(SessionContextInterface session, Class<T> type) throws MetadataException {
        Preconditions.ensureNonNull(session, "session");
        Preconditions.ensureNonNull(type, "type");
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug(">> getSoftwareServers(SessionContextInterface, List of serverTypes): " + session.toString() + "," + type.toString());
        }
        List<T> outServers = this._getSoftwareServers(session, null, Collections.singletonList(type));
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug("<< getSoftwareServers: " + outServers.toString());
        }
        return outServers;
    }

    public <T extends SoftwareServer> List<T> getSoftwareServers(SessionContextInterface session, Class<T> type, MetadataServerInterface metadataServer) throws MetadataException {
        Preconditions.ensureNonNull(session, "session");
        Preconditions.ensureNonNull(type, "serverTypes");
        Preconditions.ensureNonNull(metadataServer, "metadataServer");
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug(">> getSoftwareServers(SessionContextInterface, List of serverTypes): " + session.toString() + "," + type.toString());
        }
        List<T> outServers = this._getSoftwareServers(session, metadataServer, Collections.singletonList(type));
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug("<< getSoftwareServers: " + outServers.toString());
        }
        return outServers;
    }

    @Override
    public List getSoftwareServers(SessionContextInterface session, List serverTypes) throws MetadataException {
        Preconditions.ensureNonNull(session, "session");
        Preconditions.ensureNonNull(serverTypes, "serverTypes");
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug(">> getSoftwareServers(SessionContextInterface, List of serverTypes): " + session.toString() + "," + serverTypes.toString());
        }
        List outServers = this._getSoftwareServers(session, null, serverTypes);
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug("<< getSoftwareServers: " + outServers.toString());
        }
        return outServers;
    }

    public List getSoftwareServers(SessionContextInterface session, List serverTypes, MetadataServerInterface metadataServer) throws MetadataException {
        Preconditions.ensureNonNull(session, "session");
        Preconditions.ensureNonNull(serverTypes, "serverTypes");
        Preconditions.ensureNonNull(metadataServer, "metadataServer");
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug(">> getSoftwareServers(SessionContextInterface, MetadataServerInterface, List of serverTypes): " + session.toString() + "," + metadataServer.toString() + "," + serverTypes.toString());
        }
        List outServers = this._getSoftwareServers(session, metadataServer, serverTypes);
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug("<< getSoftwareServers: " + outServers.toString());
        }
        return outServers;
    }

    @Nonnull
    private <T extends SoftwareServer> List<T> _getSoftwareServers(SessionContextInterface session, MetadataServerInterface metadataServer, List<Class<T>> serverTypes) throws MetadataException {
        List outServers = null;
        try {
            if (metadataServer == null) {
                metadataServer = IQModelImplUtilities.getMetadataServerAuthenticatedWith(session);
            }
            if (serverTypes.size() > 0) {
                String getServersTemplate = OMRTemplates.getGetServersTemplate();
                List serverContextSmartObjects = IQModelImplUtilities.generalSearch((ServerInterface)metadataServer, 0, getServersTemplate, "ServerContext", null);
                outServers = this.getIQSoftwareServers(serverContextSmartObjects, serverTypes, session);
            } else {
                outServers = new ArrayList();
            }
        }
        catch (ServiceException e) {
            MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("IntelligentQueryMetadataService.FailedQueryingForObjectsOfType.fmt.txt", "ServerContext");
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(formatter.toString(), (Throwable)e);
            }
            throw new MetadataException(formatter, (Throwable)e);
        }
        catch (MdException e) {
            MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("IntelligentQueryMetadataService.FailedQueryingForObjectsOfType.fmt.txt", "ServerContext");
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(formatter.toString(), (Throwable)e);
            }
            throw new MetadataException(formatter, (Throwable)e);
        }
        catch (RemoteException e) {
            MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("IntelligentQueryMetadataService.FailedQueryingForObjectsOfType.fmt.txt", "ServerContext");
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(formatter.toString(), (Throwable)e);
            }
            throw new MetadataException(formatter, (Throwable)e);
        }
        return outServers;
    }

    @Override
    @Nonnull
    public List<Schema> getSchemas(SessionContextInterface session, String reposName, Class<?> schemaType) throws MetadataException {
        Preconditions.ensureNonNull(session, "session");
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug(">> getSchemas(session, reposName, type): " + Utils.toString(session) + "," + Utils.toString(reposName) + "," + Utils.toString(schemaType));
        }
        if (_mdLogger.isInfoEnabled()) {
            _logger.info("API: getSchemas(session, reposName, type)");
        }
        List<Schema> outSchemas = this._getSchemas(session, schemaType, null);
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug("<< getSchemas: " + outSchemas.toString());
        }
        return outSchemas;
    }

    @Nonnull
    private List<Schema> _getSchemas(SessionContextInterface session, Class<?> schemaType, MetadataServerInterface metadataServer) throws MetadataException {
        String omrTypeToQueryFor;
        if (schemaType == null) {
            omrTypeToQueryFor = "DeployedDataPackage";
            schemaType = Schema.class;
        } else if (schemaType == Schema.class) {
            omrTypeToQueryFor = "DeployedDataPackage";
        } else if (schemaType == RelationalSchema.class) {
            omrTypeToQueryFor = "RelationalSchema";
        } else if (schemaType == DatabaseSchema.class) {
            omrTypeToQueryFor = "DatabaseSchema";
        } else if (schemaType == SASLibrary.class) {
            omrTypeToQueryFor = "SASLibrary";
        } else if (schemaType == SASOlapSchema.class || schemaType == OlapSchema.class) {
            omrTypeToQueryFor = "OLAPSchema";
        } else {
            omrTypeToQueryFor = "DeployedDataPackage";
            schemaType = Schema.class;
        }
        try {
            if (metadataServer == null) {
                metadataServer = IQModelImplUtilities.getMetadataServerAuthenticatedWith(session);
            }
            List packages = IQModelImplUtilities.generalSearch((ServerInterface)metadataServer, 0, null, omrTypeToQueryFor, null);
            List<Root> omrSchemas = IQModelImplUtilities.unwrapOMRSmartObjects(packages);
            List<Schema> outSchemas = OMAResourceFactory.getReposObjects(omrSchemas, schemaType, session, metadataServer);
            return outSchemas;
        }
        catch (ServiceException e) {
            MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("IntelligentQueryMetadataService.FailedQueryingForObjectsOfType.fmt.txt", omrTypeToQueryFor);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error((Object)errorMsg, (Throwable)e);
            }
            throw new MetadataException(errorMsg, (Throwable)e);
        }
        catch (RemoteException e) {
            MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("IntelligentQueryMetadataService.FailedQueryingForObjectsOfType.fmt.txt", omrTypeToQueryFor);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error((Object)errorMsg, (Throwable)e);
            }
            throw new MetadataException(errorMsg, (Throwable)e);
        }
    }

    @Nonnull
    public List<Schema> getSchemas(SessionContextInterface session, Class<?> schemaType, MetadataServerInterface metadataServer) throws MetadataException {
        Preconditions.ensureNonNull(session, "session");
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug(">> getSchemas(session, type, metadataServer): " + session.toString() + "," + String.valueOf(schemaType) + "," + String.valueOf(metadataServer));
        }
        if (_mdLogger.isInfoEnabled()) {
            _logger.info("API: getSchemas(session, type, metadataServer)");
        }
        List<Schema> outSchemas = this._getSchemas(session, schemaType, metadataServer);
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug("<< getSchemas: " + outSchemas.toString());
        }
        return outSchemas;
    }

    @Override
    @CheckForNull
    public Schema getSchemaWithLabel(SessionContextInterface session, String reposName, Class<?> schemaType, String schemaLabel) throws MetadataException {
        Schema outSchema = null;
        List<Schema> schemas = this.getSchemas(session, reposName, schemaType);
        for (Schema schema : schemas) {
            if (!IQModelImplUtilities.sameIgnoreCase(schema.getLabel(), schemaLabel)) continue;
            if (outSchema != null) {
                MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("IntelligentQueryMetadataService.DuplicateSchemaFound.fmt.txt", schemaLabel, reposName);
                Reason reason = new Reason((Object)this, 6, 80, errorMsg);
                throw new MetadataException(errorMsg, Collections.singletonList(reason));
            }
            outSchema = schema;
        }
        return outSchema;
    }

    @Override
    public ServerProperties getPropertiesForServer(SessionContextInterface session, Server server) throws MetadataException {
        if (session == null || server == null) {
            String errorMsg = IQMetadataResourceBundle.getStringResource("IntelligentQueryMetadataService.NullArgSessionOrServer.txt");
            throw new IQueryServicesIllegalArgumentException(errorMsg);
        }
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug(">> getPropertiesForServer(session, server): " + Utils.toString(session) + "," + Utils.toString(server));
        }
        if (_mdLogger.isInfoEnabled()) {
            _logger.info("API: getPropertiesForServer");
        }
        ServerProperties outProperties = this.getPropertiesForServer(server);
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug("<< getPropertiesForServer: " + Utils.toString(outProperties));
        }
        return outProperties;
    }

    @Override
    public ServerProperties getPropertiesForServer(SessionContextInterface session, String id) throws MetadataException {
        if (session == null || id == null) {
            String errorMsg = IQMetadataResourceBundle.getStringResource("IntelligentQueryMetadataService.NullArgSessionOrID.txt");
            throw new IQueryServicesIllegalArgumentException(errorMsg);
        }
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug(">> getPropertiesForServer(session, id): " + Utils.toString(session) + "," + id);
        }
        if (_mdLogger.isInfoEnabled()) {
            _logger.info("API: getPropertiesForServer");
        }
        ServerProperties outProperties = null;
        Iterator<ServerProperties> itKeys = this._serverProperties.iterator();
        while (itKeys.hasNext() && outProperties == null) {
            ServerProperties sp = itKeys.next();
            if (!sp.getID().equals(id)) continue;
            outProperties = sp;
        }
        if (outProperties == null && _mdLogger.isDebugEnabled()) {
            _logger.debug(" ServerProperties for id " + id + "does not exist");
        }
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug("<< getPropertiesForServer: " + Utils.toString(outProperties));
        }
        return outProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerProperties getPropertiesForServer(Server server) throws MetadataException {
        Map<Server, ServerProperties> map = this._cachedServersWithProperties;
        synchronized (map) {
            ServerProperties outProperties = this._cachedServersWithProperties.get(server);
            if (outProperties == null) {
                Iterator<ServerProperties> itKeys = this._serverProperties.iterator();
                while (itKeys.hasNext() && outProperties == null) {
                    ServerProperties sp = itKeys.next();
                    ServerIdentification serverIdent = sp.getServerIdentification();
                    if (!serverIdent.isPropertiesFor(server)) continue;
                    outProperties = sp;
                    this._cachedServersWithProperties.put(server, outProperties);
                }
            }
            return outProperties;
        }
    }

    private Object findService(Class theClass) throws ServiceNotAvailableException, InitializationException, RemoteException, ServiceException {
        return DiscoveryService.defaultInstance().findService(new ServiceTemplate(new Class[]{theClass}));
    }

    @Override
    public boolean isRepositoryWritable(SessionContextInterface session, String reposName) throws MetadataException {
        boolean isWritable = false;
        MetadataInterface smartObject = null;
        RepositoryInterface repository = null;
        if (session == null || reposName == null) {
            String errorMsg = IQMetadataResourceBundle.getStringResource("IntelligentQueryMetadataService.NullArgSessionOrReposName.txt");
            throw new IQueryServicesIllegalArgumentException(errorMsg);
        }
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug(">> isRepositoryWritable(session, reposName): " + Utils.toString(session) + "," + reposName);
        }
        if (_mdLogger.isInfoEnabled()) {
            _logger.info("API: isRepositoryWritable");
        }
        try {
            String baseReposID;
            repository = IQModelImplUtilities.connectToRepos(session, reposName);
            String reposID = baseReposID = repository.getBase();
            int idot = baseReposID.indexOf(46);
            if (idot != -1) {
                reposID = baseReposID.substring(idot + 1);
            }
            String name = this.getClass().getName() + " isRW";
            String objectType = "TextStore";
            smartObject = repository.newMetadata(reposID, name, objectType);
        }
        catch (ServiceException e) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("IntelligentQueryMetadataService.ErrorTestingIsRepositoryWritable.fmt.txt", reposName);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error((Object)msg, (Throwable)e);
            }
            throw new MetadataException(msg, (Throwable)e);
        }
        catch (RemoteException e) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("IntelligentQueryMetadataService.ErrorTestingIsRepositoryWritable.fmt.txt", reposName);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error((Object)msg, (Throwable)e);
            }
            throw new MetadataException(msg, (Throwable)e);
        }
        if (smartObject == null) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("IntelligentQueryMetadataService.ErrorTestingIsRepositoryWritable.fmt.txt", reposName);
            throw new MetadataException(msg);
        }
        try {
            smartObject.update();
            isWritable = true;
        }
        catch (ServiceException msg) {
        }
        catch (RemoteException e) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("IntelligentQueryMetadataService.ErrorTestingIsRepositoryWritable.fmt.txt", reposName);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error((Object)msg, (Throwable)e);
            }
            throw new MetadataException(msg, (Throwable)e);
        }
        try {
            repository.deleteEntity(smartObject);
        }
        catch (ServiceException serviceException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        smartObject = null;
        if (_mdLogger.isDebugEnabled()) {
            _logger.debug("<< isRepositoryWritable: " + isWritable);
        }
        return isWritable;
    }

    private static final class WhichServer<T> {
        public final T workspaceServer;
        public final T olapServer;

        public WhichServer(T w, T o) {
            this.workspaceServer = w;
            this.olapServer = o;
        }

        public T returnWorkspaceServer() {
            return this.workspaceServer;
        }

        public T returnOlapServer() {
            return this.olapServer;
        }
    }
}

