/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.RBMessageFormatter;
import com.sas.util.RBBase;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class IQMetadataResourceBundle
extends RBBase {
    public static final IQMetadataResourceBundle defaultBundle = new IQMetadataResourceBundle();
    private final ResourceBundle localeBundle;
    private static final String EMPTY_STR = "";
    private static final Logger _logger = LogManager.getLogger(IQMetadataResourceBundle.class);

    private IQMetadataResourceBundle() {
        Locale locale = LocaleUtilities.getDefaultViewerLocale();
        this.localeBundle = this._getResources(locale);
    }

    public IQMetadataResourceBundle(String source) {
        super(source);
        Locale locale = LocaleUtilities.getDefaultViewerLocale();
        this.localeBundle = this._getResources(locale);
    }

    public IQMetadataResourceBundle(String source, Locale locale) {
        super(source);
        this.localeBundle = this._getResources(locale);
    }

    public static MessageFormatter getMessageFormatter(String resourceName, Object ... args) {
        return new RBMessageFormatter(defaultBundle, resourceName, args);
    }

    public static MessageFormatter getMessageFormatter(ExpressionInterface expr) {
        return IQMetadataResourceBundle.getMessageFormatter("{0}", expr);
    }

    public String messageString(String key, Object ... args) {
        String pattern = this.getString(key);
        return MessageFormat.format(pattern, args);
    }

    public static String getMessageString(String key, Object ... args) {
        String pattern = IQMetadataResourceBundle.getStringResource(key);
        return MessageFormat.format(pattern, args);
    }

    public static String getMessageString(String key, Locale locale, Object ... args) {
        String pattern = IQMetadataResourceBundle.getStringResource(key, locale);
        return MessageFormat.format(pattern, args);
    }

    public static String getStringResource(String classKey, String subKey) {
        String result = defaultBundle._getStringResource(classKey + subKey);
        if (result == null) {
            result = EMPTY_STR;
        }
        return result;
    }

    public static String getStringResource(String key) {
        String result = defaultBundle._getStringResource(key);
        if (result == null) {
            result = EMPTY_STR;
        }
        return result;
    }

    public static int getIntResource(String key) {
        return IQMetadataResourceBundle.getIntResource(key, 0);
    }

    public static int getIntResource(String key, int notFoundReturnValue) {
        int result;
        block4: {
            result = Integer.MIN_VALUE;
            try {
                String strValue = IQMetadataResourceBundle.getStringResource(key);
                result = Integer.parseInt(strValue);
            }
            catch (MissingResourceException mre) {
                result = notFoundReturnValue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Missing Resource (" + key + ")");
                }
            }
            catch (NumberFormatException nfe) {
                result = notFoundReturnValue;
                if (!_logger.isDebugEnabled()) break block4;
                _logger.debug("Numeric format exception " + nfe.getMessage());
            }
        }
        return result;
    }

    public static ResourceBundle getResources() {
        return defaultBundle._getResources();
    }

    public static String getStringResource(String key, Locale locale) {
        String result = defaultBundle._getStringResource(key, locale);
        if (result == null) {
            result = EMPTY_STR;
        }
        return result;
    }

    public String getString(String classKey, String subKey) {
        String key = classKey + subKey;
        String result = this.localeBundle.getString(key);
        if (result == null) {
            result = IQMetadataResourceBundle.getStringResource(key);
        }
        return result;
    }

    public String getString(String key) {
        String result = this.localeBundle.getString(key);
        if (result == null) {
            result = IQMetadataResourceBundle.getStringResource(key);
        }
        return result;
    }

    public String getString(String key, Locale locale) {
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        String result = null;
        if (!this.localeBundle.getLocale().toString().equals(locale.toString())) {
            ResourceBundle bundle = this._getResources(locale);
            result = bundle.getString(key);
        }
        if (result == null && (result = this.localeBundle.getString(key)) == null) {
            result = defaultBundle._getStringResource(key, locale);
        }
        return result;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int notFoundReturnValue) {
        int result;
        block4: {
            result = Integer.MIN_VALUE;
            try {
                String strValue = this.getString(key);
                result = strValue.length() > 0 ? Integer.parseInt(strValue) : notFoundReturnValue;
            }
            catch (MissingResourceException mre) {
                result = notFoundReturnValue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Missing Resource (" + key + ")");
                }
            }
            catch (NumberFormatException nfe) {
                result = notFoundReturnValue;
                if (!_logger.isDebugEnabled()) break block4;
                _logger.debug("Numeric format exception " + nfe.getMessage());
            }
        }
        return result;
    }

    public ResourceBundle getResourceBundle() {
        return this.localeBundle;
    }
}

