/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.generation2;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceRelationalQuery;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.ExplicitJoinPathSupport;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.impl.EffectiveObjectsCache;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.Server;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.inmemory.InMemoryQueryTable;
import com.sas.iquery.strategies.sas.oma.relational.join.JoinGeneration;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.FilterSetQueryGeneration;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.information.metadata.LogicalServerInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@SASScope
public class MetadataDataSource {
    private Server _serverToUse;
    private final LinkedHashSet<DataSourceTable> _uniqueDataSources = new LinkedHashSet();
    private final LinkedHashSet<DataSourceTable> _uniqueDataSourceWithNested = new LinkedHashSet();
    private final LinkedHashSet<SASLibrary> _uniqueLibs = new LinkedHashSet();
    private boolean _libraryAccessReadyOnly = false;

    public void initializeData() throws MetadataException, GenerationException {
    }

    public final void initializeDataForModel(DataSelection model) throws MetadataException, GenerationException {
        this.initializeDataForOneModel(model);
    }

    public final void initializeDataForOneModel(DataSelection model) throws MetadataException, GenerationException {
        EffectiveObjectsCache effectiveObjectsCache = new EffectiveObjectsCache();
        try {
            this.initializeDataForOneModel(model, effectiveObjectsCache);
        }
        finally {
            effectiveObjectsCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initializeDataForOneModel(DataSelection model, EffectiveObjectsCache effectiveObjectsCache) throws MetadataException, GenerationException {
        List<DataItem> dataItems = effectiveObjectsCache.getEffectiveResultItems(model);
        for (DataItem dataItem : dataItems) {
            List<QualifiedColumn> cols = dataItem.getResources(QualifiedColumn.class, 65535);
            for (QualifiedColumn qc : cols) {
                DataSourceTable dst = qc.getDataSource();
                this._uniqueDataSources.add(dst);
            }
        }
        List<DataSource> realDataSources = effectiveObjectsCache.getEffectiveDataSources(model);
        for (DataSource dataSource : realDataSources) {
            if (dataSource instanceof DataSourceTable) {
                DataSourceTable dst = (DataSourceTable)dataSource;
                this._uniqueDataSources.add(dst);
                continue;
            }
            String className = dataSource.getClass().toString();
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("MetadataDataSource.extractServer.fmt.txt", className);
            throw new MetadataException(msg);
        }
        if (this._uniqueDataSources.isEmpty()) {
            MessageFormatter messageFormatter = IQDataServicesResourceBundle.getMessageFormatter("MetadataDataSource.initializeDataForModel.NoData.txt", new Object[0]);
            throw new GenerationException(messageFormatter);
        }
        LinkedHashSet<DataSourceTable> linkedHashSet = new LinkedHashSet<DataSourceTable>(this._uniqueDataSources);
        if (model instanceof ExplicitJoinPathSupport) {
            List<Join> explicitJoinPath = ((ExplicitJoinPathSupport)((Object)model)).getExplicitJoinPath();
            Set<DataSourceTable> explicitJoinDataSources = MetadataDataSource.extractDataSourcesFromJoins(explicitJoinPath);
            linkedHashSet.addAll(explicitJoinDataSources);
        }
        JoinGeneration joinGenerator = new JoinGeneration();
        joinGenerator.setDataSelection(model);
        joinGenerator.getDataSelectionProcessor().setEffectiveObjectsCache(effectiveObjectsCache);
        List<BusinessModelObject> joinPath = joinGenerator.generateJoinPath();
        Set<DataSourceTable> joinDataSources = MetadataDataSource.extractDataSourcesFromJoins(joinPath);
        linkedHashSet.addAll(joinDataSources);
        if (FilterSetQueryGeneration.canHandle(model, realDataSources)) {
            FilterSetQueryGeneration filteredGen = new FilterSetQueryGeneration();
            filteredGen.setDataSelection(model);
            filteredGen.setEffectiveDataSources(realDataSources);
            DataSelection temporaryDataSelection = null;
            try {
                temporaryDataSelection = filteredGen.getGeneratedDataSelection();
                List<DataSource> prefilteredDataSources = temporaryDataSelection.getEffectiveDataSources();
                for (DataSource dataSource : prefilteredDataSources) {
                    if (!(dataSource instanceof DataSourceTable)) continue;
                    DataSourceTable dst = (DataSourceTable)dataSource;
                    linkedHashSet.add(dst);
                }
            }
            finally {
                if (temporaryDataSelection != null && temporaryDataSelection != model) {
                    temporaryDataSelection.dispose();
                }
            }
        }
        this._libraryAccessReadyOnly = model.getQueryProperty(BusinessQueryProperty.LIBRARY_ACCESS_READONLY);
        this._uniqueDataSourceWithNested.addAll(linkedHashSet);
        this._uniqueLibs.addAll(this.extractLibrariesAndServer(this._uniqueDataSourceWithNested));
    }

    private static Set<DataSourceTable> extractDataSourcesFromJoins(List<? extends BusinessModelObject> joinPath) {
        LinkedHashSet<DataSourceTable> joinDataSources = new LinkedHashSet<DataSourceTable>();
        for (BusinessModelObject businessModelObject : joinPath) {
            if (businessModelObject instanceof DataSourceTable) {
                joinDataSources.add((DataSourceTable)businessModelObject);
                continue;
            }
            Join join = (Join)businessModelObject;
            joinDataSources.add(join.getLeftDataSource());
            joinDataSources.add(join.getRightDataSource());
        }
        return joinDataSources;
    }

    @Nonnull
    private Set<SASLibrary> extractLibrariesAndServer(Collection<? extends DataSourceTable> dataSourceTables) throws GenerationException {
        Set<SASLibrary> libraries;
        if (dataSourceTables.isEmpty()) {
            libraries = Collections.emptySet();
        } else {
            libraries = new LinkedHashSet();
            this.extractServer(dataSourceTables);
            for (DataSourceTable dataSourceTable : dataSourceTables) {
                SASLibrary requiredLibrary = MetadataDataSource.getRequiredLibraryForAllocation(dataSourceTable);
                if (requiredLibrary == null) continue;
                libraries.add(requiredLibrary);
            }
        }
        return libraries;
    }

    @CheckForNull
    private static SASLibrary getRequiredLibraryForAllocation(DataSourceTable dst) throws GenerationException {
        boolean isDSRQ = dst instanceof DataSourceRelationalQuery;
        boolean isInMemoryQueryTable = dst.getTable() instanceof InMemoryQueryTable;
        SASLibrary required = null;
        try {
            Schema schema;
            if (!isDSRQ && (schema = dst.getAccessPath().getSchema()) instanceof SASLibrary) {
                boolean suppressLibrary;
                SASLibrary sasLibrary = (SASLibrary)schema;
                String engine = sasLibrary.getEngine();
                boolean bl = suppressLibrary = "SASIOLA".equalsIgnoreCase(engine) && sasLibrary.getLibnameStatement().toLowerCase().contains("startserver") && isInMemoryQueryTable;
                if (!suppressLibrary) {
                    required = sasLibrary;
                }
            }
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
        return required;
    }

    private void extractServer(Collection<? extends DataSourceTable> dataSources) throws GenerationException {
        for (DataSourceTable dataSourceTable : dataSources) {
            Server server = dataSourceTable.getServer();
            if (this._serverToUse != null && server != null && !this._serverToUse.equals(server)) {
                MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("MetadataDataSource.extractServer.MultipleServersFound.fmt.txt", Arrays.asList(server, this._serverToUse).toString());
                throw new GenerationException(msg);
            }
            this._serverToUse = server;
        }
    }

    public LogicalServerInterface getLogicalServerInterface() throws MetadataException {
        LogicalServerInterface lsi = null;
        if (this._serverToUse instanceof SoftwareServer) {
            lsi = ((SoftwareServer)this._serverToUse).getLogicalServerInterface();
        }
        return lsi;
    }

    public void setServer(Server server) {
        this._serverToUse = server;
    }

    public List<SASLibrary> getLibraryList() {
        return new ArrayList<SASLibrary>(this._uniqueLibs);
    }

    public List<String> getLibraryAllocationStatements() throws GenerationException {
        ArrayList<String> allocList = new ArrayList<String>();
        for (SASLibrary lib : this._uniqueLibs) {
            try {
                if (lib.isPreassigned()) continue;
                String statement = lib.getLibnameStatement(false, this._libraryAccessReadyOnly);
                allocList.add(statement);
            }
            catch (MetadataException e) {
                MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("MetadataDataSource.library.MetadataException.txt", new Object[0]);
                throw new GenerationException(msg, (Throwable)e);
            }
        }
        return allocList;
    }

    public List<DataSource> getUniqueDataSources() {
        return this.getUniqueDataSources(false);
    }

    public List<DataSource> getUniqueDataSources(boolean includeNested) {
        if (includeNested) {
            return new ArrayList<DataSource>(this._uniqueDataSourceWithNested);
        }
        return new ArrayList<DataSource>(this._uniqueDataSources);
    }

    public List<String> getQueryTablesTexts() throws GenerationException {
        return new ArrayList<String>();
    }

    public List<String> getQueryTablesPrepareLogs() throws GenerationException {
        return new ArrayList<String>();
    }
}

