/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution2;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution2.AbstractResultSet;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.IQRelationalResultSetMetaData;
import com.sas.iquery.execution2.IQResultSetMetaData;
import com.sas.iquery.execution2.SQLRowSet;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.CancelQuerySupport;
import com.sas.iquery.strategies.sas.report.xml.EmbeddedData;
import com.sas.services.connection.ConnectionInterface;
import com.sas.storage.jdbc.JDBCDataTypeInfo;
import com.sas.util.ChainedException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import javax.sql.RowSet;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

@SASScope
public class TabularResultSet
extends AbstractResultSet {
    private ConnectionInterface _pfsConnection;
    protected ResultSet _resultSet = null;
    private IQRelationalResultSetMetaData _iqRsmd;
    private RowSet _rowSet = null;
    private static final Logger _logger = LogManager.getLogger(TabularResultSet.class);

    public TabularResultSet() throws ExecutionException {
    }

    public TabularResultSet(ResultSet sqlResultSet) throws ExecutionException {
        this._resultSet = sqlResultSet;
        this._rowSet = new SQLRowSet(this._resultSet);
        this.setResultSetDate(new Date());
    }

    @Override
    public void close() throws ExecutionException {
        super.close();
        this.releaseResources();
    }

    public void releaseResources() throws ExecutionException {
        if (this._resultSet != null) {
            try {
                this._resultSet.close();
                this._resultSet = null;
            }
            catch (SQLException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    Throwable t = ChainedException.getRootException((Throwable)e);
                    if (t == null) {
                        t = e;
                    }
                    _logger.error(e.getMessage(), t);
                }
                throw new ExecutionException(e);
            }
        }
        if (this._pfsConnection != null) {
            CancelQuerySupport.unRegisterConnection(this._pfsConnection);
            ConnectionResources.close(this._pfsConnection);
            this._pfsConnection = null;
        }
        _logger.debug("IQ ResultSetInterface: close() is done.");
    }

    @Override
    public Object getResultSet() throws ExecutionException {
        return this._rowSet;
    }

    public void displayResultSet() throws ExecutionException {
        try {
            ResultSet rs = (ResultSet)this.getResultSet();
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            StringBuffer buffer = new StringBuffer();
            for (int i = 1; i <= columnCount; ++i) {
                buffer.append(rsMetaData.getColumnName(i) + "  ");
            }
            _logger.info(buffer.toString());
            StringBuffer buffer2 = new StringBuffer();
            for (int i = 1; i <= columnCount; ++i) {
                buffer2.append(JDBCDataTypeInfo.getJDBCTypeString((int)rsMetaData.getColumnType(i)) + "-" + rsMetaData.getColumnTypeName(i) + "-  ");
            }
            _logger.info(buffer2.toString());
            StringBuffer buffer3 = new StringBuffer();
            while (rs.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    System.out.print(rs.getString(i) + " ");
                }
                _logger.info(buffer3.toString());
            }
        }
        catch (Exception ex) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(ex.getMessage(), (Throwable)ex);
            }
            throw new ExecutionException(ex);
        }
    }

    @Override
    public void write(Element parentElement) throws ExecutionException {
        try {
            EmbeddedData data = new EmbeddedData(this._resultSet);
            data.write(parentElement);
        }
        catch (SQLException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                Throwable t = ChainedException.getRootException((Throwable)e);
                if (t == null) {
                    t = e;
                }
                _logger.error(e.getMessage(), t);
            }
            throw new ExecutionException(e);
        }
        catch (OutOfMemoryError e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("TabularResultSet.write.outofmemory.txt", new Object[0]));
        }
        catch (Exception e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            throw new ExecutionException(e);
        }
        super.write(parentElement);
    }

    public void setConnection(ConnectionInterface pfsConnection) {
        this._pfsConnection = pfsConnection;
    }

    protected void setRowSet(RowSet set) throws ExecutionException {
        this._rowSet = set;
    }

    @Override
    public int getType() throws ExecutionException {
        return 1;
    }

    @Override
    public IQResultSetMetaData getIQMetaData() throws ExecutionException {
        if (this._iqRsmd == null) {
            this._iqRsmd = new IQRelationalResultSetMetaData(this._resultSet);
        }
        return this._iqRsmd;
    }

    @Override
    public IQResultSetMetaData getIQMetaData(BusinessQuery businessQuery) throws ExecutionException {
        if (this._iqRsmd == null) {
            this._iqRsmd = new IQRelationalResultSetMetaData(this._resultSet, businessQuery);
        }
        return this._iqRsmd;
    }
}

