/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution2;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.AbstractResultSet;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.IQOlapResultSetMetaData;
import com.sas.iquery.execution2.IQResultSetMetaData;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.strategies.sas.oma.olap.util.IQOLAPDataSetInterface;
import com.sas.iquery.strategies.sas.report.xml.EmbeddedOLAPDataWriteROM;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

@SASScope
public class MultiDimResultSet
extends AbstractResultSet {
    private OLAPDataSetInterface _mdDataSet = null;
    private IQOlapResultSetMetaData _iqRsmd;
    private static final Logger _logger = LogManager.getLogger(MultiDimResultSet.class);

    public MultiDimResultSet() {
    }

    public MultiDimResultSet(OLAPDataSetInterface olapDataSet) {
        this._mdDataSet = olapDataSet;
    }

    @Override
    public void close() throws ExecutionException {
        super.close();
        try {
            this._mdDataSet.close();
            if (this._mdDataSet instanceof IQOLAPDataSetInterface) {
                IQOLAPDataSetInterface iqOLAPDataSet = (IQOLAPDataSetInterface)this._mdDataSet;
                BusinessQueryOLAPUtil.releaseOLAPDataSet(iqOLAPDataSet);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug(IQDataServicesResourceBundle.getStringResource("MultiDimResultSetClose.txt"));
            }
        }
        catch (OLAPException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("MultiDimResultSetMetaEClose.txt"));
            }
            throw new ExecutionException(e);
        }
    }

    public void displayResultSet() throws ExecutionException {
        if (_logger.isInfoEnabled()) {
            try {
                OLAPDataSetInterface mdDataSet = (OLAPDataSetInterface)this.getResultSet();
                Object[] cells = mdDataSet.getCells(0L, -1L);
                _logger.info(IQDataServicesResourceBundle.getStringResource("MultiDimResultSet.displayResultSet.unformattedcell.txt"));
                for (int i = 0; i < cells.length; ++i) {
                    _logger.info(i + ": " + cells[i].toString());
                }
                String[] formattedCells = mdDataSet.getFormattedCells(0L, -1L);
                _logger.info(IQDataServicesResourceBundle.getStringResource("MultiDimResultSet.displayResultSet.formattedcell.txt"));
                for (int i = 0; i < formattedCells.length; ++i) {
                    _logger.info(i + ": " + formattedCells[i]);
                }
                ResultSetMetadataInterface rsm = mdDataSet.getResultSetMetadata();
                AxisInterface[] axes = rsm.getAxes(0, -1);
                _logger.info(IQDataServicesResourceBundle.getMessageString("MultiDimResultSet.displayResultSet.axiscount.fmt.txt", axes.length));
                for (int i = 0; i < axes.length; ++i) {
                    _logger.info(IQDataServicesResourceBundle.getMessageString("MultiDimResultSet.displayResultSet.axisnumber.fmt.txt", axes[i].getAxisNumber()));
                    _logger.info(IQDataServicesResourceBundle.getMessageString("MultiDimResultSet.displayResultSet.tuplecount.fmt.txt", axes[i].getTupleCount()));
                    _logger.info(IQDataServicesResourceBundle.getMessageString("MultiDimResultSet.displayResultSet.tupledepth.fmt.txt", axes[i].getMaximumTupleDepth()));
                    String[] axisHeaders = axes[i].getAxisHeaders();
                    _logger.info(IQDataServicesResourceBundle.getStringResource("MultiDimResultSet.displayResultSet.axisheader.txt"));
                    for (int j = 0; j < axisHeaders.length; ++j) {
                        _logger.info(axisHeaders[j]);
                    }
                    _logger.info("");
                    TupleInterface[] tuples = axes[i].getTuples(0, -1);
                    _logger.info(IQDataServicesResourceBundle.getMessageString("MultiDimResultSet.displayResultSet.tuple1.fmt.txt", tuples.length));
                    for (int j = 0; j < tuples.length; ++j) {
                        _logger.info(IQDataServicesResourceBundle.getMessageString("MultiDimResultSet.displayResultSet.tuple2.fmt.txt", tuples[j].getTupleIndex()));
                        TupleElementInterface[] tupleElements = tuples[j].getElements(0, -1);
                        for (int k = 0; k < tupleElements.length; ++k) {
                            _logger.info(IQDataServicesResourceBundle.getMessageString("MultiDimResultSet.displayResultSet.tuple3.fmt.txt", Integer.valueOf(tupleElements[k].getLabel())));
                            _logger.info(IQDataServicesResourceBundle.getMessageString("MultiDimResultSet.displayResultSet.tuple4.fmt.txt", tupleElements[k].getMinimumCoordinate()));
                            _logger.info(IQDataServicesResourceBundle.getMessageString("MultiDimResultSet.displayResultSet.tuple5.fmt.txt", tupleElements[k].getMaximumCoordinate()));
                            _logger.info(IQDataServicesResourceBundle.getMessageString("MultiDimResultSet.displayResultSet.tuple6.fmt.txt", tupleElements[k].getLevelDepth()));
                            TupleElementInterface tupleElement = tupleElements[k];
                            _logger.info(IQDataServicesResourceBundle.getMessageString("MultiDimResultSet.displayResultSet.tuple7.fmt.txt", Integer.valueOf(tupleElement.getName())));
                            TupleInterface tuple = tupleElements[k].getTuple();
                            if (tuple == null) {
                                _logger.info(IQDataServicesResourceBundle.getStringResource("MultiDimResultSet.displayResultSet.tuplenull.txt"));
                                continue;
                            }
                            AxisInterface axis = tuple.getAxis();
                            _logger.info(IQDataServicesResourceBundle.getMessageString("MultiDimResultSet.displayResultSet.tuple8.fmt.txt", tupleElements[k].getLabel(), axis.getAxisNumber()));
                            _logger.info(IQDataServicesResourceBundle.getStringResource("MultiDimResultSet.displayResultSet.dimensions.txt"));
                            String[] dims = axis.getDimensionNames();
                            for (int jj = 0; jj < dims.length; ++jj) {
                                _logger.info(" " + dims[jj]);
                            }
                        }
                    }
                }
            }
            catch (OLAPException e) {
                throw new ExecutionException(e);
            }
        }
    }

    @Override
    public Object getResultSet() throws ExecutionException {
        return this._mdDataSet;
    }

    @Override
    public int getType() throws ExecutionException {
        return 0;
    }

    public void setResultSet(OLAPDataSetInterface resultSet) {
        this._mdDataSet = resultSet;
    }

    @Override
    public void write(Element parentElement) throws ExecutionException {
        try {
            EmbeddedOLAPDataWriteROM data = new EmbeddedOLAPDataWriteROM(this._mdDataSet);
            data.setResultSetDate(this.getResultSetDate());
            data.write(parentElement);
        }
        catch (OutOfMemoryError e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getLocalizedMessage());
            }
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("MultiDimResultSet.write.outofmemory.txt", new Object[0]));
        }
        super.write(parentElement);
    }

    @Override
    public IQResultSetMetaData getIQMetaData(BusinessQuery businessQuery) throws ExecutionException {
        if (this._iqRsmd == null) {
            Object underlyingObject = this.getResultSet();
            if (underlyingObject instanceof BusinessQueryProviderInterface && businessQuery == null) {
                businessQuery = ((BusinessQueryProviderInterface)underlyingObject).getBusinessQuery();
            }
            this._iqRsmd = new IQOlapResultSetMetaData(this._mdDataSet, businessQuery);
        }
        return this._iqRsmd;
    }

    @Override
    public IQResultSetMetaData getIQMetaData() throws ExecutionException {
        if (this._iqRsmd == null) {
            Object underlyingObject = this.getResultSet();
            if (underlyingObject instanceof BusinessQueryProviderInterface) {
                BusinessQuery businessQuery = ((BusinessQueryProviderInterface)underlyingObject).getBusinessQuery();
                this._iqRsmd = new IQOlapResultSetMetaData(this._mdDataSet, businessQuery);
            } else {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("IQOlapResultSetMetadataNoBusinessQuery.txt", new Object[0]));
            }
        }
        return this._iqRsmd;
    }
}

