/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution2;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.AbstractIQResultSetMetaData;
import com.sas.iquery.execution2.DrillPath;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.IQOlapDrillPath;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MeasureInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MemberLevelComparator;
import com.sas.storage.olap.MetadataEntityInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.SchemaInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IQOlapResultSetMetaData
extends AbstractIQResultSetMetaData {
    @NonNull
    private String _cubeName;
    @NonNull
    private final Map<DataItem, List<DrillPath>> _drilledElementsMap = new LinkedHashMap<DataItem, List<DrillPath>>();
    @NonNull
    private final Map<MetadataEntityInterface, DataItem> _metadataEntityToDataItemCache = new LinkedHashMap<MetadataEntityInterface, DataItem>();
    @NonNull
    private MetadataInterface _metadataInterface;
    @NonNull
    private OLAPDataSetInterface _olapDataset;
    @NonNull
    private final ResultSetMetadataInterface _resultMetadataInterface;
    @NonNull
    private final List<DataItem> _rowList;
    @NonNull
    private final List<DataItem> _colList;
    @NonNull
    private final List<DataItem> _slicerList;
    private static final Logger _logger = LogManager.getLogger(IQOlapResultSetMetaData.class);

    public IQOlapResultSetMetaData(@NonNull OLAPDataSetInterface olapDataSet, @NonNull BusinessQuery businessQuery) throws ExecutionException {
        if (businessQuery == null) {
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("IQOlapResultSetMetadataNoBusinessQuery.txt", new Object[0]));
        }
        this._olapDataset = olapDataSet;
        try {
            this._metadataInterface = this._olapDataset.getDatabaseMetadata();
            this._resultMetadataInterface = this._olapDataset.getResultSetMetadata();
            this._cubeName = this._olapDataset.getCubeName();
            this._rowList = this.buildListOfDataItemByAxis(1, businessQuery);
            this._colList = this.buildListOfDataItemByAxis(0, businessQuery);
            this._slicerList = this.buildListOfDataItemByAxis(-1, businessQuery);
            AxisInterface[] rowArray = this._resultMetadataInterface.getAxes(1, -1);
            AxisInterface[] colArray = this._resultMetadataInterface.getAxes(0, -1);
            AxisInterface[] slicerArray = this._resultMetadataInterface.getAxes(-1, -1);
            this.buildDataItemPath(1, rowArray, businessQuery);
            this.buildDataItemPath(0, colArray, businessQuery);
            this.buildDataItemPath(-1, slicerArray, businessQuery);
        }
        catch (OLAPException e) {
            throw new ExecutionException(e);
        }
    }

    private void buildDataItemPath(int axisType, AxisInterface[] axesArray, BusinessQuery businessQuery) throws OLAPException, ExecutionException {
        if (axesArray == null || axesArray.length == 0 || axesArray[0] == null) {
            this.print("No axes present");
            return;
        }
        AxisInterface axis = axesArray[0];
        TupleInterface[] tuples = axis.getTuples(0, -1);
        int maxTupleDepth = axis.getMaximumTupleDepth();
        String[] dimensionNames = axis.getDimensionNames();
        if (dimensionNames == null) {
            this.print("Dimension names array is null for  " + axisType);
            return;
        }
        if (dimensionNames.length == 0) {
            this.print("No dimension present for " + axisType);
            return;
        }
        this.print("\n\n  Dimension names on axis " + axisType + " are: ");
        for (int u = 0; u < dimensionNames.length; ++u) {
            this.print("    " + (u + 1) + ". " + dimensionNames[u]);
        }
        block1: for (int i = 0; i < maxTupleDepth; ++i) {
            if (i > dimensionNames.length) continue;
            Object[] tupleElements = OLAPUtil.getTupleElementsForLevel((int)i, (TupleInterface[])tuples);
            for (int j = 0; j < tupleElements.length; ++j) {
                TupleInterface parentTuple;
                int elementIndex;
                int span;
                DataItem dataItem;
                TupleElementInterface element = (TupleElementInterface)tupleElements[j];
                if (element.getType() != TupleElementType.TOTAL && element.getType() != TupleElementType.SUBTOTAL && (dataItem = this.findDataItemFromUniqueName(element, axisType, businessQuery)) != null) {
                    int elementLevelDepth = element.getLevelDepth();
                    boolean isDrilled = false;
                    if (elementLevelDepth > 1) {
                        isDrilled = true;
                    } else if (axisType == -1 && elementLevelDepth > 0) {
                        isDrilled = true;
                    }
                    if (isDrilled) {
                        this.buildDrilledLevels(axisType, element, dataItem);
                    }
                }
                if ((span = element.getSpan()) <= 1) continue;
                if ((element.getType() == TupleElementType.TOTAL || element.getType() == TupleElementType.SUBTOTAL) && (elementIndex = element.getTupleElementIndex()) + 1 < (parentTuple = element.getTuple()).getTupleDepth() && parentTuple.getElement(elementIndex + 1).getSpan() == 0) continue block1;
                i += span - 1;
                continue block1;
            }
        }
    }

    private void buildDrilledLevels(int axis, TupleElementInterface tupleElement, DataItem dataItem) throws ExecutionException {
        try {
            String tupleName = tupleElement.getName();
            this.print("Drilled tuple element=" + tupleName);
            if (this._cubeName != null && this._metadataInterface != null && dataItem != null && !this._drilledElementsMap.containsKey(dataItem)) {
                Filter filter = new Filter();
                filter.setTreeOperator(Filter.ANCESTORS_TREE_OPERATOR | Filter.SELF_TREE_OPERATOR);
                filter.setUniqueMemberName(tupleName);
                filter.setCubeName(this._cubeName);
                MemberInterface[] members = this._metadataInterface.getMembers(filter, 0, -1);
                filter.reset();
                this.sort(members);
                ArrayList<IQOlapDrillPath> drillPathsForDataItem = new ArrayList<IQOlapDrillPath>();
                for (MemberInterface member : members) {
                    LevelInterface level = member.getLevel();
                    boolean isAllLevel = OLAPUtil.isAllLevel((LevelInterface)level);
                    if (isAllLevel && members.length > 2) {
                        this.print("All member for " + level.getHierarchy().getName());
                        continue;
                    }
                    HierarchyInterface hierarchy = level.getHierarchy();
                    DimensionInterface dimension = hierarchy.getDimension();
                    LevelInterface[] levels = hierarchy.getLevels();
                    if (levels.length <= 1) continue;
                    IQOlapDrillPath drillPath = new IQOlapDrillPath(level, hierarchy, dimension, tupleElement, member);
                    drillPathsForDataItem.add(drillPath);
                }
                this._drilledElementsMap.put(dataItem, drillPathsForDataItem);
            }
        }
        catch (OLAPException e) {
            e.printStackTrace();
            throw new ExecutionException(e);
        }
    }

    private void sort(MemberInterface[] members) {
        Arrays.sort(members, MemberLevelComparator.defaultInstance);
    }

    private List<DrillPath> buildDrillForAxis(List<DataItem> axisList) {
        ArrayList<DrillPath> returnList = new ArrayList<DrillPath>();
        for (DataItem dataItem : axisList) {
            List<DrillPath> drillForDataItem = this.getDrillPaths(dataItem);
            returnList.addAll(drillForDataItem);
        }
        return returnList;
    }

    @NonNull
    private List<DataItem> buildListOfDataItemByAxis(int axisNumber, BusinessQuery businessQuery) throws ExecutionException {
        try {
            List<DataItem> dataItems;
            switch (axisNumber) {
                case 1: {
                    dataItems = businessQuery.getResultItems(Role.ROW);
                    this.print("Data items in rows: " + dataItems.size());
                    break;
                }
                case 0: {
                    dataItems = businessQuery.getResultItems(Role.COLUMN);
                    this.print("Data items in columns: " + dataItems.size());
                    break;
                }
                case -1: {
                    List<DataItem> slicerList = businessQuery.getResultItems(Role.BACKGROUND);
                    List<DataItem> hiddenList = businessQuery.getResultItems(Role.HIDDEN);
                    dataItems = new ArrayList<DataItem>(slicerList.size() + hiddenList.size());
                    dataItems.addAll(slicerList);
                    dataItems.addAll(hiddenList);
                    this.print("Data items on slicer: " + dataItems.size());
                    break;
                }
                default: {
                    throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("IQOlapResultSetMetadataBadAxis.txt", new Object[0]));
                }
            }
            return dataItems;
        }
        catch (MetadataException e) {
            throw new ExecutionException(e);
        }
    }

    private DataItem findDataItemFromUniqueName(TupleElementInterface tupleElement, int axisType, BusinessQuery businessQuery) throws ExecutionException {
        List<DataItem> axisList;
        DataItem foundDataItem = null;
        switch (axisType) {
            case 1: {
                axisList = this._rowList;
                break;
            }
            case 0: {
                axisList = this._colList;
                break;
            }
            case -1: {
                axisList = this._slicerList;
                break;
            }
            default: {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("IQOlapResultSetMetadataBadAxis.txt", new Object[0]));
            }
        }
        try {
            TupleElementType tupleType = tupleElement.getType();
            TupleInterface parentTuple = tupleElement.getTuple();
            AxisInterface tupleAxis = parentTuple.getAxis();
            int tupleElementIndex = tupleElement.getTupleElementIndex();
            String tupleElementName = tupleElement.getName();
            String[] dimensionNames = tupleAxis.getDimensionNames();
            TupleElementInterface[] tupleElements = parentTuple.getElements(0, -1);
            int relativeIndex = 0;
            for (int i = 0; i < tupleElementIndex; ++i) {
                relativeIndex += tupleElements[i].getSpan();
            }
            String dimensionName = dimensionNames[relativeIndex];
            this.print(tupleAxis.getAxisNumber() + ". tupleElement: '" + tupleElement.getLabel() + "', axisType=" + axisType + ", index=" + tupleElementIndex + ", name= " + tupleElementName + ", uniqueLevelName=" + tupleElement.getUniqueLevelName() + ", isMeasure=" + (tupleType == TupleElementType.MEASURE));
            this.print("    dimension name='" + dimensionName + "'");
            foundDataItem = this.findInternalDataItem(axisList, tupleElement, dimensionName, businessQuery, axisType);
            if (foundDataItem == null) {
                this.print("    *** no data item found ***");
            } else {
                this.addTupleNameDataItem(tupleElement, foundDataItem);
                if (tupleType == TupleElementType.MEASURE) {
                    this.addMeasureDataItem(dimensionName, tupleElementName, foundDataItem);
                } else {
                    this.addTupleUniqueLevelNameDataItem(tupleElement, foundDataItem);
                    this.addHierarchyDataItem(dimensionName, foundDataItem);
                }
            }
        }
        catch (OLAPException ex) {
            throw new ExecutionException(ex);
        }
        catch (MetadataException e) {
            throw new ExecutionException(e);
        }
        return foundDataItem;
    }

    private void addHierarchyDataItem(String dimensionName, DataItem foundDataItem) throws OLAPException {
        Filter filterByDimensionName = new Filter();
        filterByDimensionName.setCubeName(this._cubeName);
        filterByDimensionName.setDimensionName(dimensionName);
        this.print("    find Dimension by dimensionName='" + dimensionName + "'");
        DimensionInterface dimension = this._metadataInterface.getDimension(filterByDimensionName);
        filterByDimensionName.reset();
        this.print("    ==> Dimension found: " + dimension);
        if (dimension != null) {
            int dimType = dimension.getType();
            this.print("    Dimension " + dimension.getLabel() + ", name='" + dimension.getName() + "', unique name='" + dimension.getUniqueName() + "', dimType=" + dimType + ", dim=" + dimension.getName());
            this.print("    find Hierarchies by dimensionName='" + dimensionName + "'");
            filterByDimensionName.setCubeName(this._cubeName);
            filterByDimensionName.setDimensionName(dimensionName);
            HierarchyInterface[] hierarchies = this._metadataInterface.getHierarchies(filterByDimensionName);
            filterByDimensionName.reset();
            if (hierarchies != null && hierarchies.length > 0) {
                this.print("    ==> hierarchies = [" + hierarchies.length + "]");
                for (HierarchyInterface hierarchy : hierarchies) {
                    this.print("    Hierarchy " + hierarchy.getLabel() + ", name='" + hierarchy.getName() + "', unique name='" + hierarchy.getUniqueName() + "'");
                    DataItem hierarchyDataItem = this.metadataEntityToDataItem((MetadataEntityInterface)hierarchy);
                    this.print("    ==> found hierarchy DataItem: " + hierarchyDataItem);
                    if (hierarchyDataItem != null) continue;
                    this.addMetadataEntityToDataItem((MetadataEntityInterface)hierarchy, foundDataItem);
                    this.print("    Cached hierarchy '" + hierarchy.getName() + "' data item: " + foundDataItem);
                }
            }
        } else {
            this.print("    ==> * hierarchies not found *");
        }
    }

    private void addMeasureDataItem(String dimensionName, String tupleElementName, DataItem foundDataItem) throws MetadataException, OLAPException {
        StructureOfDataItem structure = foundDataItem.getStructure();
        if (structure == StructureOfDataItem.STRUCTURE_MEASURE) {
            List<Measure> bmoMeasures = foundDataItem.getResources(Measure.class, 65535);
            for (Measure measure : bmoMeasures) {
                this.print("    ==> found BMO Measure=" + measure);
                String measureUniqueName = measure.getMeasureUniqueName();
                this._addMeasureDataItem(measureUniqueName, foundDataItem);
            }
        } else {
            this._addMeasureDataItem(tupleElementName, foundDataItem);
        }
    }

    private void _addMeasureDataItem(String measureUniqueName, DataItem foundDataItem) throws OLAPException {
        this.print("    find Measure by unique measure name='" + measureUniqueName + "'");
        Filter filter = new Filter();
        filter.setCubeName(this._cubeName);
        filter.setUniqueMeasureName(measureUniqueName);
        MeasureInterface measureI = this._metadataInterface.getMeasure(filter);
        filter.reset();
        this.print("    ==> Measure found=" + measureI);
        if (measureI != null) {
            this.print("    Measure " + measureI.getLabel() + ", name='" + measureI.getName() + "', unique name='" + measureI.getUniqueName() + "'");
            DataItem measureDataItem = this.metadataEntityToDataItem((MetadataEntityInterface)measureI);
            this.print("    ==> found measure DataItem: " + measureDataItem);
            if (measureDataItem == null) {
                this.print("    Cached measure '" + measureI.getUniqueName() + "' data item : " + foundDataItem);
                this.addMetadataEntityToDataItem((MetadataEntityInterface)measureI, foundDataItem);
            }
        }
    }

    private void addTupleUniqueLevelNameDataItem(TupleElementInterface tupleElement, DataItem foundDataItem) throws OLAPException {
        String tupleElementUniqueLevelName = tupleElement.getUniqueLevelName();
        this.print("    Check unique level name='" + tupleElementUniqueLevelName + "'");
        DataItem uniqueLevelNameDataItem = this.stringToDataItem(tupleElementUniqueLevelName);
        this.print("    ==> found DataItem: " + uniqueLevelNameDataItem);
        if (uniqueLevelNameDataItem == null) {
            this.print("    Caching unique level name='" + tupleElementUniqueLevelName + "' data item: " + foundDataItem);
            this.addStringToDataItem(tupleElementUniqueLevelName, foundDataItem);
        }
    }

    private void addTupleNameDataItem(TupleElementInterface tupleElement, DataItem foundDataItem) throws OLAPException {
        String tupleElementName = tupleElement.getName();
        this.print("    Check tuple element name='" + tupleElementName + "'");
        DataItem tupleElementNameToDataItem = this.stringToDataItem(tupleElementName);
        this.print("    ==> found DataItem: " + tupleElementNameToDataItem);
        if (tupleElementNameToDataItem == null) {
            this.print("    Caching tuple element name='" + tupleElementName + "' data item: " + foundDataItem);
            this.addStringToDataItem(tupleElementName, foundDataItem);
        }
    }

    private DataItem findInternalDataItem(List<DataItem> dataItems, TupleElementInterface tupleElement, String dimensionName, BusinessQuery businessQuery, int axisType) throws MetadataException, ExecutionException, OLAPException {
        DataItem foundDataItem = null;
        boolean isMeasure = tupleElement.getType() == TupleElementType.MEASURE;
        String tupleElementLabel = tupleElement.getLabel();
        String tupleElementName = tupleElement.getName();
        BusinessModel businessModel = businessQuery.getBusinessModel();
        for (DataItem tdi : dataItems) {
            boolean found = false;
            StructureOfDataItem structure = tdi.getStructure();
            if (isMeasure) {
                String measureName;
                if (structure == StructureOfDataItem.STRUCTURE_MEASURE) {
                    measureName = tdi.getLabel();
                    this.print("    - using data item label based measure name '" + measureName + "': " + tdi.getIdentityString());
                } else {
                    measureName = tdi.getResultSetID();
                    this.print("    - using data item rsid based measure name '" + measureName + "': " + tdi.getIdentityString());
                }
                String tdiMeasureName = "[" + dimensionName + "].[" + measureName + ']';
                this.print("    Check tuple element name '" + tupleElementName + "' against '" + tdiMeasureName + "'");
                found = tdiMeasureName.equals(tupleElementName);
            } else {
                String tdiDimensionName = BusinessQueryOLAPUtil.getDimensionName(businessModel, tdi);
                this.print("    Check tuple dimension name '" + dimensionName + "' against data item dimension name '" + tdiDimensionName + "': " + tdi.getIdentityString());
                boolean bl = found = tdiDimensionName != null && tdiDimensionName.endsWith(dimensionName);
            }
            if (!found) continue;
            foundDataItem = tdi;
            break;
        }
        this.print("    ==> axisDataItem: " + foundDataItem);
        if (foundDataItem == null) {
            this.print("    * error condition *");
            this.print("Data item was not found for " + tupleElementLabel);
            if (axisType != -1) {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("IQOlapResultSetMetadataNoDataItem.txt", new Object[0]) + tupleElementLabel);
            }
        }
        return foundDataItem;
    }

    @Override
    public Map<Integer, List<DrillPath>> getAllDrillPaths() throws ExecutionException {
        LinkedHashMap<Integer, List<DrillPath>> drilledAll = new LinkedHashMap<Integer, List<DrillPath>>();
        List<DrillPath> rowDrill = this.buildDrillForAxis(this._rowList);
        drilledAll.put(1, rowDrill);
        List<DrillPath> colDrill = this.buildDrillForAxis(this._colList);
        drilledAll.put(0, colDrill);
        List<DrillPath> slicerDrill = this.buildDrillForAxis(this._slicerList);
        drilledAll.put(-1, slicerDrill);
        return drilledAll;
    }

    @Override
    public DataItem getDataItem(Object uniquePhysicalObject) {
        String dataItemLookupKey;
        DataItem dataItem = null;
        if (uniquePhysicalObject instanceof MetadataEntityInterface) {
            MetadataEntityInterface metadataEntity = (MetadataEntityInterface)uniquePhysicalObject;
            dataItem = this.metadataEntityToDataItem(metadataEntity);
        } else if (uniquePhysicalObject instanceof TupleElementInterface) {
            String tupleName;
            TupleElementInterface tuple = (TupleElementInterface)uniquePhysicalObject;
            String uniqueLevelName = this.getUniqueLevelName(tuple);
            if (uniqueLevelName != null) {
                dataItem = this.stringToDataItem(uniqueLevelName);
            }
            if (dataItem == null && (tupleName = this.getName(tuple)) != null) {
                dataItem = this.stringToDataItem(tupleName);
            }
        }
        if (dataItem == null && (dataItemLookupKey = this.getDataItemLookupKey(uniquePhysicalObject)) != null) {
            dataItem = this.stringToDataItem(dataItemLookupKey);
        }
        if (dataItem == null) {
            dataItem = super.getDataItem(uniquePhysicalObject);
        }
        return dataItem;
    }

    private String getDataItemLookupKey(Object uniquePhysicalObject) {
        String key = null;
        if (uniquePhysicalObject == null || uniquePhysicalObject instanceof SchemaInterface || uniquePhysicalObject instanceof CubeInterface) {
            key = null;
        } else {
            String toString;
            if (uniquePhysicalObject instanceof DimensionInterface) {
                DimensionInterface dim = (DimensionInterface)uniquePhysicalObject;
                try {
                    HierarchyInterface defaultHierarchy = dim.getDefaultHierarchy();
                    if (defaultHierarchy != null) {
                        key = defaultHierarchy.getUniqueName();
                    }
                }
                catch (OLAPException e) {
                    _logger.warn("Could not get measure unique name for '" + uniquePhysicalObject + "':" + e.getLocalizedMessage());
                }
            } else if (uniquePhysicalObject instanceof HierarchyInterface) {
                HierarchyInterface hier = (HierarchyInterface)uniquePhysicalObject;
                try {
                    key = hier.getUniqueName();
                }
                catch (OLAPException e) {
                    _logger.warn("Could not get measure unique name for '" + uniquePhysicalObject + "':" + e.getLocalizedMessage());
                }
            } else if (uniquePhysicalObject instanceof LevelInterface) {
                LevelInterface lev = (LevelInterface)uniquePhysicalObject;
                try {
                    key = lev.getUniqueName();
                }
                catch (OLAPException e) {
                    _logger.warn("Could not get measure unique name for '" + uniquePhysicalObject + "':" + e.getLocalizedMessage());
                }
            } else if (uniquePhysicalObject instanceof MemberInterface) {
                MemberInterface mem = (MemberInterface)uniquePhysicalObject;
                try {
                    LevelInterface level = mem.getLevel();
                    if (level != null) {
                        key = level.getUniqueName();
                    }
                }
                catch (OLAPException e) {
                    _logger.warn("Could not get measure unique name for '" + uniquePhysicalObject + "':" + e.getLocalizedMessage());
                }
            } else if (uniquePhysicalObject instanceof MeasureInterface) {
                MeasureInterface mea = (MeasureInterface)uniquePhysicalObject;
                try {
                    key = mea.getUniqueName();
                }
                catch (OLAPException e) {
                    _logger.warn("Could not get measure unique name for '" + uniquePhysicalObject + "':" + e.getLocalizedMessage());
                }
            }
            if (key == null && (key = this.lookupAsUniqueMemberName(toString = String.valueOf(uniquePhysicalObject))) == null && (key = this.lookupAsUniqueLevelName(toString)) == null && (key = this.lookupAsUniqueHierarchyName(toString)) == null) {
                key = this.lookupAsUniqueDimensionName(toString);
            }
        }
        return key;
    }

    private String lookupAsUniqueMemberName(String uniqueMemberName) {
        String uniqueLevelName = null;
        Filter filter = new Filter();
        filter.setCubeName(this._cubeName);
        filter.setUniqueMemberName(uniqueMemberName);
        try {
            MemberInterface[] members = this._metadataInterface.getMembers(filter, 0, -1);
            if (members != null && members.length > 0) {
                LevelInterface level = members[0].getLevel();
                uniqueLevelName = level.getUniqueName();
            }
        }
        catch (OLAPException e) {
            _logger.warn("Could not get member with unique member name '" + uniqueMemberName + "': " + e.getLocalizedMessage());
        }
        filter.reset();
        return uniqueLevelName;
    }

    private String lookupAsUniqueLevelName(String uniqueLevelName) {
        String uniqueLevelNameOut = null;
        Filter filter = new Filter();
        filter.setCubeName(this._cubeName);
        filter.setUniqueLevelName(uniqueLevelName);
        try {
            LevelInterface[] levels = this._metadataInterface.getLevels(filter);
            if (levels != null && levels.length > 0) {
                LevelInterface level = levels[0];
                uniqueLevelNameOut = level.getUniqueName();
            }
        }
        catch (OLAPException e) {
            _logger.warn("Could not get level with unique level name '" + uniqueLevelName + "':" + e.getLocalizedMessage());
        }
        filter.reset();
        return uniqueLevelNameOut;
    }

    private String lookupAsUniqueHierarchyName(String uniqueHierarchyName) {
        String uniqueHierarchyNameOut = null;
        Filter filter = new Filter();
        filter.setCubeName(this._cubeName);
        filter.setUniqueHierarchyName(uniqueHierarchyName);
        try {
            HierarchyInterface[] hiers = this._metadataInterface.getHierarchies(filter);
            if (hiers != null && hiers.length > 0) {
                HierarchyInterface hier = hiers[0];
                uniqueHierarchyNameOut = hier.getUniqueName();
            }
        }
        catch (OLAPException e) {
            _logger.warn("Could not get hierarchy with unique hierarchy name '" + uniqueHierarchyName + "':" + e.getLocalizedMessage());
        }
        filter.reset();
        return uniqueHierarchyNameOut;
    }

    private String lookupAsUniqueDimensionName(String uniqueDimensionName) {
        Filter filter;
        String uniqueHierarchyNameOut;
        block3: {
            uniqueHierarchyNameOut = null;
            filter = new Filter();
            filter.setCubeName(this._cubeName);
            filter.setUniqueDimensionName(uniqueDimensionName);
            try {
                DimensionInterface[] dims = this._metadataInterface.getDimensions(filter);
                if (dims == null || dims.length <= 0) break block3;
                for (DimensionInterface dim : dims) {
                    HierarchyInterface defaultHierarchy = dim.getDefaultHierarchy();
                    if (defaultHierarchy == null) continue;
                    uniqueHierarchyNameOut = defaultHierarchy.getUniqueName();
                    break;
                }
            }
            catch (OLAPException e) {
                _logger.warn("Could not get default hierarchy for dimension with unique dimension name '" + uniqueDimensionName + "':" + e.getLocalizedMessage());
            }
        }
        filter.reset();
        return uniqueHierarchyNameOut;
    }

    private String getName(TupleElementInterface tuple) {
        String uniqueLevelName = null;
        try {
            uniqueLevelName = tuple.getName();
        }
        catch (OLAPException e) {
            _logger.warn("Could not get tuple element name: " + e.getLocalizedMessage());
        }
        return uniqueLevelName;
    }

    private String getUniqueLevelName(TupleElementInterface tuple) {
        String uniqueLevelName = null;
        try {
            uniqueLevelName = tuple.getUniqueLevelName();
        }
        catch (OLAPException e) {
            _logger.warn("Could not get tuple element unique level name: " + e.getLocalizedMessage());
        }
        return uniqueLevelName;
    }

    @Override
    @NonNull
    public List<DrillPath> getDrillPaths(DataItem dataItem) {
        List<DrillPath> returnList = this._drilledElementsMap.containsKey(dataItem) ? this._drilledElementsMap.get(dataItem) : Collections.emptyList();
        return returnList;
    }

    @Override
    @NonNull
    public List<DrillPath> getDrillPaths(int axis) throws ExecutionException {
        List<DrillPath> returnList;
        switch (axis) {
            case 1: {
                returnList = this.buildDrillForAxis(this._rowList);
                this.print("Drilled Level for Data item in rows: " + returnList.size());
                break;
            }
            case 0: {
                returnList = this.buildDrillForAxis(this._colList);
                this.print("Drilled Level for Data item in rows: " + returnList.size());
                break;
            }
            case -1: {
                returnList = this.buildDrillForAxis(this._slicerList);
                this.print("Drilled Level for Data item in rows: " + returnList.size());
                break;
            }
            default: {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("IQOlapResultSetMetadataBadAxis.txt", new Object[0]));
            }
        }
        return returnList;
    }

    @NonNull
    public List<HierarchyInterface> getPhysicalHierarchies() {
        ArrayList<HierarchyInterface> list = new ArrayList<HierarchyInterface>();
        for (MetadataEntityInterface metadataEntity : this._metadataEntityToDataItemCache.keySet()) {
            if (!(metadataEntity instanceof HierarchyInterface)) continue;
            list.add((HierarchyInterface)metadataEntity);
        }
        return list;
    }

    @NonNull
    public List<MeasureInterface> getPhysicalMeasures() {
        ArrayList<MeasureInterface> list = new ArrayList<MeasureInterface>();
        for (MetadataEntityInterface metadataEntity : this._metadataEntityToDataItemCache.keySet()) {
            if (!(metadataEntity instanceof MeasureInterface)) continue;
            list.add((MeasureInterface)metadataEntity);
        }
        return list;
    }

    private void addMetadataEntityToDataItem(MetadataEntityInterface metadataEntity, DataItem dataItem) {
        this._metadataEntityToDataItemCache.put(metadataEntity, dataItem);
    }

    private DataItem metadataEntityToDataItem(MetadataEntityInterface metadataEntity) {
        DataItem dataItem = this._metadataEntityToDataItemCache.get(metadataEntity);
        return dataItem;
    }

    OLAPDataSetInterface getOlapDataSetInterface() {
        return this._olapDataset;
    }

    @Override
    public boolean isDrillable() {
        return true;
    }

    private void print(String text) {
        MDXGenerationUtil.applyDebugStatement(text, this.getClass());
    }
}

