/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution2;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.dataretrieval.ResultSetEvent;
import com.sas.iquery.dataretrieval.ResultSetEventBroadcaster;
import com.sas.iquery.dataretrieval.ResultSetListener;
import com.sas.iquery.execution.instructions.StpNames;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.execution2.ResultSetUpdateInterface;
import com.sas.util.LocalizableString;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

@SASScope
public abstract class AbstractResultSet
implements ResultSetInterface,
ResultSetUpdateInterface,
ResultSetEventBroadcaster {
    private Date _resultSetDate = null;
    protected String _query = null;
    private String _storedProcessLog = null;
    private String _sasLog = null;
    private Map<String, LocalizableString> _resultItemDescs = new HashMap<String, LocalizableString>();
    private Map<String, LocalizableString> _resultItemLabels = new HashMap<String, LocalizableString>();
    private Locale _computationalLocale;
    private StpNames _stpNames = null;
    private List<ResultSetListener> _listeners = new ArrayList<ResultSetListener>();
    private static final Logger _logger = LogManager.getLogger(AbstractResultSet.class);

    @Override
    public void close() throws ExecutionException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("[AbstractResultSet] closing result set = (" + this.getClass().getName() + ") " + this);
        }
        ResultSetEvent evt = new ResultSetEvent(this, ResultSetEvent.EventType.CLOSE, this);
        ArrayList<ResultSetListener> listeners = new ArrayList<ResultSetListener>(this._listeners);
        for (ResultSetListener resultSetListener : listeners) {
            resultSetListener.notify(evt);
        }
    }

    @Override
    public String getQuery() throws ExecutionException {
        return this._query;
    }

    @Override
    public Date getResultSetDate() throws ExecutionException {
        return this._resultSetDate;
    }

    @Override
    public String getStoredProcessLog() throws ExecutionException {
        return this._storedProcessLog;
    }

    @Override
    public String getSASLog() throws ExecutionException {
        return this._sasLog;
    }

    @Override
    public LocalizableString getLabels(String rsid) throws ExecutionException {
        return this._resultItemLabels.get(rsid);
    }

    @Override
    public LocalizableString getDescriptions(String rsid) throws ExecutionException {
        return this._resultItemDescs.get(rsid);
    }

    @Override
    public void setResultSetDate(Date date) {
        this._resultSetDate = date;
    }

    @Override
    public void setQuery(String query) throws ExecutionException {
        this._query = query;
    }

    @Override
    public void setStoredProcessLog(String storedProcessLog) {
        this._storedProcessLog = storedProcessLog;
    }

    @Override
    public void setSASLog(String log) {
        this._sasLog = log;
    }

    @Override
    public void setLabels(String rsid, LocalizableString labels) throws ExecutionException {
        this._resultItemLabels.put(rsid, labels);
    }

    @Override
    public void setDescriptions(String rsid, LocalizableString descriptions) throws ExecutionException {
        this._resultItemDescs.put(rsid, descriptions);
    }

    @Override
    public Locale getComputationalLocale() {
        return this._computationalLocale;
    }

    @Override
    public void setComputationalLocale(Locale computationalLocale) {
        this._computationalLocale = computationalLocale;
    }

    @Override
    public void write(Element parentElement) throws ExecutionException {
    }

    @Override
    public StpNames getStpNames() {
        return this._stpNames;
    }

    @Override
    public void setStpNames(StpNames stpNames) {
        this._stpNames = stpNames != null ? new StpNames(stpNames) : null;
    }

    @Override
    public void addResultSetListener(ResultSetListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeResultSetListener(ResultSetListener listener) {
        this._listeners.remove(listener);
    }
}

