/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.util;

import com.sas.iquery.IQueryServicesIllegalStateException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.util.ChunkFile;
import com.sas.iquery.execution.util.FileBackedListInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmartFileBackedList<E>
implements FileBackedListInterface<E> {
    private static final int DEFAULT_PAGE_OUT_THRESHOLD = 500;
    private List<E> _component = new ArrayList();
    private FileBackedListInterface<E> _fileBackedList;
    private boolean _isPagedOut = false;
    private int _pageOutThreshold = 500;
    private static final Logger _logger = LogManager.getLogger(SmartFileBackedList.class);

    public SmartFileBackedList(FileBackedListInterface<E> fileBackedList, int pageOutThreshold) throws IOException {
        this._pageOutThreshold = pageOutThreshold;
        this._fileBackedList = fileBackedList;
    }

    public boolean isPagedOut() {
        return this._isPagedOut;
    }

    @Override
    public boolean add(E o) {
        if (!this._isPagedOut && this.size() >= this._pageOutThreshold) {
            this.pageOut();
        }
        return this._component.add(o);
    }

    private void pageOut() {
        if (_logger.isInfoEnabled()) {
            _logger.info("Paging out smart file backed list containing " + this.size() + " elements");
        }
        this._fileBackedList.addAll(this._component);
        this._component = this._fileBackedList;
        this._fileBackedList = null;
        this._isPagedOut = true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (!this._isPagedOut && this.size() + c.size() >= this._pageOutThreshold) {
            this.pageOut();
        }
        return this._component.addAll(c);
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("SmartFileBackedList.nonSequentialAddition.txt"));
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("SmartFileBackedList.nonSequentialAddition.txt"));
    }

    @Override
    public void flush() throws IOException {
        if (this._isPagedOut) {
            ((FileBackedListInterface)this._component).flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this._isPagedOut) {
            ((FileBackedListInterface)this._component).close();
        }
    }

    @Override
    public ChunkFile<E> getChunkFile() throws IllegalStateException {
        if (this._isPagedOut) {
            return ((FileBackedListInterface)this._component).getChunkFile();
        }
        throw new IQueryServicesIllegalStateException(IQDataServicesResourceBundle.getMessageFormatter("SmartFileBackedList.notYetFileBacked.fmt.txt", this.size(), this._pageOutThreshold));
    }

    public String toString() {
        return "(SmartFileBackedList size=" + this.size() + ", isPagedOut=" + this._isPagedOut + ", pageOutThreshold=" + this._pageOutThreshold + ")";
    }

    @Override
    public int size() {
        return this._component.size();
    }

    @Override
    public boolean isEmpty() {
        return this._component.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this._component.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this._component.iterator();
    }

    @Override
    public Object[] toArray() {
        return this._component.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._component.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this._component.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._component.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this._component.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this._component.retainAll(c);
    }

    @Override
    public void clear() {
        this._component.clear();
    }

    @Override
    public E get(int index) {
        return this._component.get(index);
    }

    @Override
    public E set(int index, E element) {
        return this._component.set(index, element);
    }

    @Override
    public E remove(int index) {
        return this._component.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this._component.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this._component.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this._component.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this._component.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this._component.subList(fromIndex, toIndex);
    }
}

