/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.util;

import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.CreateTableDataSelection;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceRelationalQuery;
import com.sas.iquery.metadata.business.SetOperationDataSelection;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LogUtils {
    public static final Logger _logger = LogManager.getLogger(LogUtils.class);

    public static long logStartTime() {
        long startTime = System.currentTimeMillis();
        if (LogUtils.isLogPropterySet()) {
            Calendar cal = Calendar.getInstance();
            Date date = cal.getTime();
            DateFormat dateFormatter = DateFormat.getDateTimeInstance();
            String time = dateFormatter.format(date);
            _logger.info("Start logIQDataSelection.  Time: " + time + ".  Current system time in milliseconds: <" + startTime + ">");
        }
        return startTime;
    }

    public static void logEndTime(long startTime, boolean success) {
        if (LogUtils.isLogPropterySet()) {
            long endTime = System.currentTimeMillis();
            Calendar cal = Calendar.getInstance();
            Date date = cal.getTime();
            DateFormat dateFormatter = DateFormat.getDateTimeInstance();
            String time = dateFormatter.format(date);
            long totalTime = endTime - startTime;
            if (success) {
                _logger.info("End logIQDataSelection.  Time: " + time + " total elapsed in milliseconds: <" + totalTime + ">");
            } else {
                _logger.info("Error:  Unable to compute the elapsed time because the operation was unsuccessful.  Time: " + time + ".");
            }
        }
    }

    public static void dumpXML(BusinessQuery businessQuery, QueryConnector qc) {
        if (LogUtils.isLogPropterySet()) {
            try {
                long beginGenerateTime = System.currentTimeMillis();
                if (qc != null) {
                    _logger.info("The generated query is:  " + qc.getPhysicalQuery(businessQuery));
                }
                long endGenerateTime = System.currentTimeMillis();
                _logger.info("It took <" + (endGenerateTime - beginGenerateTime) + "> milliseconds to generate the query.");
            }
            catch (IntelligentQueryException e) {
                _logger.info("Error:  Unable to log the generated query because " + e.getMessage());
            }
            try {
                if (LogUtils.isPersistable(businessQuery)) {
                    LogUtils.dumpXMLRecursive(businessQuery, 0);
                } else {
                    _logger.info("Unable to log DataSelection " + businessQuery.getID() + " because it is not persistable.");
                }
            }
            catch (Exception e) {
                _logger.info("Error:  Unable to generate XML representing the DataSelection because: " + e.getMessage());
            }
        }
    }

    private static void dumpXMLRecursive(BusinessQuery businessQuery, int level) throws MetadataException, ParserConfigurationException, TransformerException {
        ++level;
        BusinessQuery parent = businessQuery.getParentQuery();
        if (parent != null) {
            LogUtils.dumpXMLRecursive(parent, level);
        }
        _logger.info("IQ query type is: " + businessQuery.getClass().getName() + ".");
        String dsXML = LogUtils.getDataSelectionXML(businessQuery);
        if (level == 1) {
            _logger.info("The XML representing your DataSelection is:  ");
        }
        _logger.info("DataSelection: " + dsXML);
    }

    private static boolean isLogPropterySet() {
        boolean returnValue = false;
        String logDataSelection = System.getProperty("SASQueryServices.logIQDataSelection", null);
        if (logDataSelection == null) {
            logDataSelection = System.getProperty("logIQDataSelection");
        }
        if (logDataSelection != null && logDataSelection.equalsIgnoreCase("true") && _logger.isInfoEnabled()) {
            returnValue = true;
        }
        return returnValue;
    }

    private static String getDataSelectionXML(BusinessQuery businessQuery) throws ParserConfigurationException, MetadataException, TransformerException {
        String returnString = "";
        Element dsElement = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element topLevelElement = doc.createElement("Temp_Top_Level_Element");
        dsElement = businessQuery.write(topLevelElement);
        if (dsElement != null) {
            returnString = IQModelImplUtilities.toPrettyString(dsElement, 0);
        }
        return returnString;
    }

    private static boolean isPersistable(BusinessQuery businessQuery) throws MetadataException {
        boolean returnValue = true;
        if (businessQuery instanceof SetOperationDataSelection || businessQuery instanceof CreateTableDataSelection) {
            if (businessQuery instanceof SetOperationDataSelection) {
                _logger.info("DataSelection " + businessQuery.getID() + " is an instance of a SetOperationDataSelection.");
            } else {
                _logger.info("DataSelection " + businessQuery.getID() + " is an instance of a CreateTableDataSelection.");
            }
            returnValue = false;
        } else if (LogUtils.queryContainsDSRQ(businessQuery)) {
            _logger.info("DataSelection " + businessQuery.getID() + " contains a DataSourceRelationalQuery.");
            returnValue = false;
        } else if (businessQuery.getParentQuery() != null) {
            returnValue = LogUtils.isPersistable(businessQuery.getParentQuery());
        }
        return returnValue;
    }

    private static boolean queryContainsDSRQ(BusinessQuery businessQuery) throws MetadataException {
        boolean returnValue = false;
        List<DataSource> dataSources = businessQuery.getEffectiveDataSources();
        for (DataSource dataSource : dataSources) {
            if (!(dataSource instanceof DataSourceRelationalQuery)) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }
}

