/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.util;

import java.util.ArrayList;

class ChunkPositions {
    private ArrayList<Entry> _entries = new ArrayList();

    ChunkPositions() {
    }

    private long getEndPosition(int chunkNumber) {
        return this._entries.get((int)chunkNumber)._endPosition;
    }

    public long getChunkLength(int chunkNumber) {
        return this.getEndPosition(chunkNumber) - this.getStartPosition(chunkNumber);
    }

    public long getStartPosition(int chunkNumber) {
        return this._entries.get((int)chunkNumber)._startPosition;
    }

    public int getChunkCount() {
        return this._entries.size();
    }

    public void setChunkPositions(int chunkNumber, long startPosition, long endPosition) {
        Entry entry = new Entry();
        entry._startPosition = startPosition;
        entry._endPosition = endPosition;
        if (chunkNumber >= this._entries.size()) {
            this._entries.add(chunkNumber, entry);
        } else {
            this._entries.set(chunkNumber, entry);
        }
    }

    public void clear() {
        this._entries.clear();
    }

    public double getUsageRatio() {
        int chunkCount = this.getChunkCount();
        long usedSpace = 0L;
        long maxPos = 0L;
        for (int i = 0; i < chunkCount; ++i) {
            usedSpace += this.getChunkLength(i);
            long lastEndPos = this.getEndPosition(i);
            if (lastEndPos <= maxPos) continue;
            maxPos = lastEndPos;
        }
        if (maxPos == 0L) {
            return 0.0;
        }
        return (double)usedSpace / (double)maxPos;
    }

    public static class Entry {
        long _startPosition;
        long _endPosition;
    }
}

