/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.util;

import com.sas.io.util.FileCleanup;
import com.sas.iquery.execution.util.Chunk;
import com.sas.iquery.execution.util.ChunkPositions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkFile<E> {
    private File _chunkFile;
    private RandomAccessFile _randomAccessFile;
    private FileChannel _fileChannel;
    protected ChunkPositions _chunkFilePositions = new ChunkPositions();
    private static final Logger _logger = LogManager.getLogger(ChunkFile.class);

    private FileChannel getFileChannel() throws FileNotFoundException {
        if (this._fileChannel == null) {
            this._chunkFile = this.getFile();
            this._randomAccessFile = new RandomAccessFile(this._chunkFile, "rw");
            this._fileChannel = this._randomAccessFile.getChannel();
            if (_logger.isInfoEnabled()) {
                _logger.info(Integer.toHexString(this.hashCode()) + ": Lazy initialization of chunk file completed: " + this._chunkFile.getAbsolutePath());
            }
        }
        return this._fileChannel;
    }

    public void store(Chunk<E> chunk) throws IOException {
        if (_logger.isInfoEnabled()) {
            _logger.info(Integer.toHexString(this.hashCode()) + ": Storing chunk #" + chunk.getChunkNumber());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.useProtocolVersion(2);
        chunk.setIsModified(false);
        objectOutputStream.writeObject(chunk);
        byte[] byteData = byteArrayOutputStream.toByteArray();
        long startPosition = this.getFileChannel().position();
        this.getFileChannel().write(ByteBuffer.wrap(byteData));
        long endPosition = this.getFileChannel().position();
        this._chunkFilePositions.setChunkPositions(chunk.getChunkNumber(), startPosition, endPosition);
        if (_logger.isDebugEnabled()) {
            _logger.debug(Integer.toHexString(this.hashCode()) + ": Stored chunk #" + chunk.getChunkNumber() + " at positions " + startPosition + " to " + endPosition);
        }
    }

    public Chunk<E> load(int newChunkNumber) throws IOException, ClassNotFoundException {
        if (_logger.isInfoEnabled()) {
            _logger.info(Integer.toHexString(this.hashCode()) + ": Loading chunk #" + newChunkNumber);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)this._chunkFilePositions.getChunkLength(newChunkNumber));
        this.getFileChannel().read(byteBuffer, this._chunkFilePositions.getStartPosition(newChunkNumber));
        ByteArrayInputStream bais = new ByteArrayInputStream(byteBuffer.array());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Chunk chunk = (Chunk)ois.readObject();
        if (_logger.isDebugEnabled()) {
            _logger.debug(Integer.toHexString(this.hashCode()) + ": Loaded chunk #" + chunk.getChunkNumber() + " from position " + this._chunkFilePositions.getStartPosition(newChunkNumber));
        }
        return chunk;
    }

    public boolean containsChunk(int newChunkNumber) {
        return newChunkNumber < this._chunkFilePositions.getChunkCount();
    }

    public File getFile() {
        if (this._chunkFile == null) {
            this._chunkFile = FileCleanup.getInstance().newTemporaryFile(1);
        }
        return this._chunkFile;
    }

    public double getUsageRatio() {
        return this._chunkFilePositions.getUsageRatio();
    }

    public void close() throws IOException {
        if (_logger.isInfoEnabled()) {
            _logger.info(Integer.toHexString(this.hashCode()) + ": Closing file resources");
        }
        this._randomAccessFile.close();
    }

    public void flush() throws IOException {
        this._fileChannel.force(true);
    }
}

