/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.relational.offline;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.relational.offline.PageFile;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class ResultSetCache
implements ResultSet {
    private String[] _columnNames = null;
    private PageFile _pageFile = null;
    private int _cursor = 0;

    public ResultSetCache() {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.constructor.NotSupported.txt"));
    }

    public ResultSetCache(PageFile pageFile) throws ExecutionException {
        this._pageFile = pageFile;
    }

    private boolean position(int rowIndex) throws SQLException {
        boolean returnValue = false;
        try {
            returnValue = this._pageFile.position(rowIndex);
        }
        catch (IOException e) {
            SQLException exception = new SQLException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.position.IOException.txt"));
            exception.initCause(e);
            throw exception;
        }
        catch (ClassNotFoundException e) {
            SQLException exception = new SQLException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.position.ClassNotFoundException.txt"));
            exception.initCause(e);
            throw exception;
        }
        catch (IntelligentQueryException e) {
            SQLException exception = new SQLException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.position.IntelligentQueryException.txt"));
            exception.initCause(e);
            throw exception;
        }
        catch (ExecutionException e) {
            SQLException exception = new SQLException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.position.ExecutionException.txt"));
            exception.initCause(e);
            throw exception;
        }
        return returnValue;
    }

    @Override
    public boolean next() throws SQLException {
        boolean returnValue = true;
        int newCursor = this._cursor + 1;
        returnValue = this.position(newCursor);
        this._cursor = this._pageFile.getPosition();
        return returnValue;
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._pageFile.wasNull(this._cursor);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object obj = this._pageFile.getValue(this._cursor, columnIndex);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        String valueOf = String.valueOf(obj).trim();
        return Boolean.valueOf(valueOf);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Byte) {
            return (Byte)obj;
        }
        String valueOf = String.valueOf(obj).trim();
        return Byte.valueOf(valueOf);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        String valueOf = String.valueOf(obj).trim();
        return Short.valueOf(valueOf);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        String valueOf = String.valueOf(obj).trim();
        return Integer.valueOf(valueOf);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        String valueOf = String.valueOf(obj).trim();
        return Long.valueOf(valueOf);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        String valueOf = String.valueOf(obj).trim();
        return Float.valueOf(valueOf).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        String valueOf = String.valueOf(obj).trim();
        return Double.valueOf(valueOf);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.getBigDecimalIntInt.UnsupportedOperationException.txt"));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])this.getObject(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj instanceof Date) {
            return (Date)obj;
        }
        String valueOf = String.valueOf(obj);
        return Date.valueOf(valueOf);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj instanceof Time) {
            return (Time)obj;
        }
        String valueOf = String.valueOf(obj);
        return Time.valueOf(valueOf);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        String valueOf = String.valueOf(obj);
        return Timestamp.valueOf(valueOf);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return (InputStream)this.getObject(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return (InputStream)this.getObject(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return (InputStream)this.getObject(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.getBigDecimalStringInt.UnsupportedOperationException.txt"));
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return (InputStream)this.getObject(columnName);
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return (InputStream)this.getObject(columnName);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return (InputStream)this.getObject(columnName);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.getWarnings.UnsupportedOperationException.txt"));
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.clearWarnings.UnsupportedOperationException.txt"));
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.getCursorName.UnsupportedOperationException.txt"));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this._pageFile.getMetaData();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Object obj = this._pageFile.getObject(this._cursor, columnIndex);
        if (this.wasNull() || obj == null) {
            return null;
        }
        return obj;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        if (this._columnNames == null) {
            ResultSetMetaData metadata = this.getMetaData();
            int columnCount = metadata.getColumnCount();
            this._columnNames = new String[columnCount];
            for (int i = 1; i <= this._columnNames.length; ++i) {
                this._columnNames[i - 1] = metadata.getColumnName(i);
            }
        }
        for (int col = 1; col <= this._columnNames.length; ++col) {
            if (!this._columnNames[col - 1].equals(columnName)) continue;
            return col;
        }
        throw new SQLException(IQDataServicesResourceBundle.getMessageString("OffLineResultSetCache.findColumn.SQLException.fmt.txt", columnName));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return (Reader)this.getObject(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return (Reader)this.getObject(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)this.getObject(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return (BigDecimal)this.getObject(columnName);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        boolean returnValue = false;
        if (this._cursor == 0) {
            if (this.next()) {
                returnValue = true;
                this.previous();
            } else {
                returnValue = false;
            }
        }
        return returnValue;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        boolean returnValue = false;
        if (this._cursor == 0) {
            return returnValue;
        }
        int oldCursor = this._cursor;
        this.afterLast();
        if (oldCursor == this._cursor) {
            returnValue = true;
        } else {
            this._cursor = oldCursor;
            this.position(this._cursor);
        }
        return returnValue;
    }

    @Override
    public boolean isFirst() throws SQLException {
        boolean returnValue = false;
        if (this._cursor == 1 && this.position(1)) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public boolean isLast() throws SQLException {
        boolean returnValue = false;
        if (this.isBeforeFirst() || this.isAfterLast()) {
            return returnValue;
        }
        boolean hasNext = this.next();
        if (!hasNext && this.isAfterLast()) {
            returnValue = true;
        }
        this.previous();
        return returnValue;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this._cursor = 0;
        this.position(this._cursor);
    }

    @Override
    public void afterLast() throws SQLException {
        this.last();
        int newCursor = this._cursor + 1;
        this.position(newCursor);
        this._cursor = this._pageFile.getPosition();
    }

    @Override
    public boolean first() throws SQLException {
        boolean returnValue = true;
        int newCursor = 1;
        returnValue = this.position(newCursor);
        this._cursor = this._pageFile.getPosition();
        return returnValue;
    }

    @Override
    public boolean last() throws SQLException {
        boolean returnValue = true;
        int newCursor = -1;
        returnValue = this.position(newCursor);
        this._cursor = this._pageFile.getPosition();
        return returnValue;
    }

    @Override
    public int getRow() throws SQLException {
        return this._cursor;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        boolean returnValue = true;
        returnValue = this.position(row);
        this._cursor = this._pageFile.getPosition();
        return returnValue;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        boolean returnValue = true;
        int newCursor = this._cursor;
        if ((newCursor += rows) > 0) {
            returnValue = this.position(newCursor);
        } else {
            returnValue = false;
            this.position(0);
        }
        this._cursor = this._pageFile.getPosition();
        return returnValue;
    }

    @Override
    public boolean previous() throws SQLException {
        boolean returnValue = true;
        int newCursor = this._cursor - 1;
        returnValue = this.position(newCursor);
        this._cursor = this._pageFile.getPosition();
        return returnValue;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.setFetchDirection.UnsupportedOperationException.txt"));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.getFetchDirection.UnsupportedOperationException.txt"));
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.setFetchSize.UnsupportedOperationException.txt"));
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.getFetchSize.UnsupportedOperationException.txt"));
    }

    @Override
    public int getType() throws SQLException {
        return this._pageFile.getResultSetType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.rowUpdated.UnsupportedOperationException.txt"));
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.rowInserted.UnsupportedOperationException.txt"));
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.rowDeleted.UnsupportedOperationException.txt"));
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.updateNull.UnsupportedOperationException.txt"));
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.insertRow.UnsupportedOperationException.txt"));
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.updateRow.UnsupportedOperationException.txt"));
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.deleteRow.UnsupportedOperationException.txt"));
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.refreshRow.UnsupportedOperationException.txt"));
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.cancelRowUpdates.UnsupportedOperationException.txt"));
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.moveToInsertRow.UnsupportedOperationException.txt"));
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.moveToCurrentRow.UnsupportedOperationException.txt"));
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.getStatement.UnsupportedOperationException.txt"));
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        return (Ref)this.getObject(i);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        return (Blob)this.getObject(i);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        return (Clob)this.getObject(i);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        return (Array)this.getObject(i);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return (Ref)this.getObject(colName);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return (Blob)this.getObject(colName);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return (Clob)this.getObject(colName);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return (Array)this.getObject(colName);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.getDateInt.UnsupportedOperationException.txt"));
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.getDateString.UnsupportedOperationException.txt"));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.getTimeInt.UnsupportedOperationException.txt"));
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.getTimeString.UnsupportedOperationException.txt"));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.getTimestampInt.UnsupportedOperationException.txt"));
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.getTimestampString.UnsupportedOperationException.txt"));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return (URL)this.getObject(columnIndex);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return (URL)this.getObject(columnName);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException(this + " is not a wrapper for " + iface.getClass().getName());
        }
        return iface.cast(this);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.getObjectInt.UnsupportedOperationException.txt"));
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("ResultSetCache.getObjectString.UnsupportedOperationException.txt"));
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._pageFile.isClosed();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

