/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.relational.offline;

import com.sas.iquery.execution.relational.offline.MemoryBuffer;
import com.sas.iquery.execution.relational.offline.PhysicalFileIndex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhysicalFileSupport {
    private File _file = null;
    private RandomAccessFile _randomAccessFile = null;
    private FileChannel _fileChannel = null;
    private PhysicalFileIndex _index = new PhysicalFileIndex();
    private static final Logger _logger = LogManager.getLogger(PhysicalFileSupport.class);

    public PhysicalFileSupport(File file) throws FileNotFoundException {
        this.setFile(file);
        this.createFile();
    }

    private void createFile() throws FileNotFoundException {
        this._randomAccessFile = new RandomAccessFile(this.getFile(), "rw");
        this._fileChannel = this._randomAccessFile.getChannel();
        if (_logger.isInfoEnabled()) {
            _logger.info(Integer.toHexString(this.hashCode()) + ": Created new physical file support for " + this.getFile().getAbsolutePath());
        }
    }

    public File getFile() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public void writeMemoryBuffer(MemoryBuffer memoryBuffer) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.useProtocolVersion(2);
        long startPosition = this._fileChannel.position();
        objectOutputStream.writeObject(memoryBuffer);
        this._fileChannel.write(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
        long endPosition = this._fileChannel.position();
        this._index.addChunk(startPosition, endPosition);
        if (_logger.isInfoEnabled()) {
            _logger.info(Integer.toHexString(this.hashCode()) + ": Wrote buffer to file at positions " + startPosition + " to " + endPosition);
        }
    }

    public MemoryBuffer readMemoryBuffer(int blockIndex) throws IOException, ClassNotFoundException {
        if (_logger.isInfoEnabled()) {
            _logger.info(Integer.toHexString(this.hashCode()) + ": Reading block #" + blockIndex + " to memory");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(this._index.getChunkSize(blockIndex));
        this._fileChannel.read(byteBuffer, this._index.getPosition(blockIndex));
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer.array());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return (MemoryBuffer)objectInputStream.readObject();
    }

    public void close() throws IOException {
        this._randomAccessFile.close();
        if (_logger.isDebugEnabled()) {
            _logger.debug(Integer.toHexString(this.hashCode()) + ": Closed temp file");
        }
    }

    public int getMemoryBufferCount() {
        return this._index.getChunkCount();
    }

    public void clear() throws IOException {
        this._index.clear();
        this._fileChannel.truncate(0L);
    }
}

