/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.relational.offline;

import java.io.Serializable;

public class MemoryBuffer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object[][] _data = null;
    private boolean[][] _nulls = null;

    public MemoryBuffer(int rowCount, int columnCount) {
        this._data = new Object[rowCount][columnCount];
        this._nulls = new boolean[rowCount][columnCount];
    }

    public void setValue(int rowIndex, int columnIndex, Object value, boolean wasNull) {
        this._data[rowIndex - 1][columnIndex - 1] = value;
        this._nulls[rowIndex - 1][columnIndex - 1] = wasNull;
    }

    public String toString() {
        StringBuffer outBuffer = new StringBuffer();
        for (int row = 0; row < this._data.length; ++row) {
            for (int column = 0; column < this._data[row].length; ++column) {
                Object value = this._data[row][column];
                outBuffer.append(":");
                outBuffer.append(value);
                if (column + 1 >= this._data[row].length) continue;
                outBuffer.append("; ");
            }
            if (row + 1 >= this._data.length) continue;
            outBuffer.append("\n");
        }
        return outBuffer.toString();
    }

    public Object[][] getData() {
        return this._data;
    }

    public boolean[][] getNulls() {
        return this._nulls;
    }

    public void clear() {
        for (int row = 0; row < this._data.length; ++row) {
            for (int column = 0; column < this._data[row].length; ++column) {
                this._data[row][column] = null;
                this._nulls[row][column] = false;
            }
        }
    }
}

