/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.relational.offline;

import com.sas.io.util.FileCleanup;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.relational.offline.PageFile;
import com.sas.iquery.execution.relational.offline.ResultSetCache;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.SQLRowSet;
import com.sas.iquery.execution2.TabularResultSet;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.util.ChainedException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

public class CachedTabularResultSet
extends TabularResultSet {
    private PageFile _pageFile = null;
    private static final Logger _logger = LogManager.getLogger(CachedTabularResultSet.class);

    public CachedTabularResultSet(ResultSet sqlResultSet, RetrievalPolicy retrievalPolicy) throws ExecutionException, GenerationException {
        super(sqlResultSet);
        this._pageFile = new PageFile(FileCleanup.getInstance().newTemporaryFile(), retrievalPolicy);
    }

    public void initialise(ResultSet sqlResultSet, boolean isDual) throws ExecutionException {
        try {
            this._pageFile.initialize(sqlResultSet, isDual);
            this._pageFile.getFirstDataBlock(sqlResultSet);
        }
        catch (FileNotFoundException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("CachedTabularResultSet.CachedTabularResultSet.NoFile.txt", new Object[0]);
            throw new ExecutionException(formatter, (Throwable)e);
        }
        catch (IOException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("CachedTabularResultSet.CachedTabularResultSet.IO.txt", new Object[0]);
            throw new ExecutionException(formatter, (Throwable)e);
        }
        catch (SQLException e) {
            Throwable t = ChainedException.getRootException((Throwable)e);
            if (t == null) {
                t = e;
            }
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getMessage(), t);
            }
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("CachedTabularResultSet.CachedTabularResultSet.SQL.txt", new Object[0]);
            throw new ExecutionException(formatter, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("CachedTabularResultSet.CachedTabularResultSet.NoClass.txt", new Object[0]);
            throw new ExecutionException(formatter, (Throwable)e);
        }
        this.setRowSet(new SQLRowSet(new ResultSetCache(this._pageFile)));
    }

    @Override
    public void write(Element parentElement) throws ExecutionException {
        ResultSet oldRS = this._resultSet;
        this._resultSet = this.createNonCachingResultSet();
        try {
            super.write(parentElement);
            this._resultSet.close();
        }
        catch (SQLException e) {
            Throwable t = ChainedException.getRootException((Throwable)e);
            if (t == null) {
                t = e;
            }
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getMessage(), t);
            }
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("CachedTabularResultSet.write.SQL.txt", new Object[0]);
            throw new ExecutionException(formatter, (Throwable)e);
        }
        finally {
            this._resultSet = oldRS;
        }
    }

    private ResultSet createNonCachingResultSet() throws ExecutionException {
        ResultSet nonCachingResultSet;
        try {
            nonCachingResultSet = (ResultSet)this._pageFile.executeQuery().getResultSet();
        }
        catch (DataRetrievalException e) {
            throw new ExecutionException(e);
        }
        return nonCachingResultSet;
    }

    @Override
    public void close() throws ExecutionException {
        super.close();
        try {
            this._pageFile.close();
        }
        catch (IOException e) {
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("CachedTabularResultSet.CouldNotClosePageFile.txt", new Object[0]), (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this._pageFile.close();
    }

    public void setInstructions(List instructions) {
        this._pageFile.setInstructions(instructions);
    }
}

