/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iquery.execution.instructions.AbstractExecutionInstruction;
import com.sas.iquery.execution.instructions.CodeStringSASSubmitInstruction;
import com.sas.iquery.execution.instructions.DualSubmitInstruction;
import com.sas.iquery.execution.instructions.ExecutionOptions;
import com.sas.iquery.execution.instructions.SASSubmitInstruction;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.business.ExportType;
import com.sas.iquery.metadata.business.SelectedItem;
import java.util.List;

public abstract class SubmitInstructionFactory {
    public static AbstractExecutionInstruction getSubmitInstruction(String sasStatement, String outputTableName, String replacementPattern, ExecutionOptions executionOptions, DataSelection selection) {
        AbstractExecutionInstruction instruction = SubmitInstructionFactory.getSubmitInstruction(sasStatement, outputTableName, replacementPattern, executionOptions, SubmitInstructionFactory.isDualResultSetEnabled(selection), selection);
        return instruction;
    }

    public static AbstractExecutionInstruction getSubmitInstruction(String sasStatement, String outputTableName, String replacementPattern, ExecutionOptions executionOptions, boolean isDual, DataSelection dataSelection) {
        SASSubmitInstruction instruction = null;
        if (dataSelection != null && SubmitInstructionFactory.isLasrEnabledStandAlone(dataSelection)) {
            CodeStringSASSubmitInstruction codeStringInstruction = null;
            codeStringInstruction = new CodeStringSASSubmitInstruction(sasStatement, executionOptions, dataSelection);
            return codeStringInstruction;
        }
        instruction = isDual ? new DualSubmitInstruction(sasStatement, replacementPattern, executionOptions, dataSelection) : new SASSubmitInstruction(sasStatement, replacementPattern, executionOptions, dataSelection);
        instruction.setOutputTableName(outputTableName);
        return instruction;
    }

    public static boolean isDualResultSetEnabled(DataSelection dataSelection) {
        List<SelectedItem> selectedItems = dataSelection.getSelectedItems();
        boolean isDual = false;
        for (SelectedItem si : selectedItems) {
            if (si.getFormatType() != 1) continue;
            isDual = true;
        }
        return isDual && !dataSelection.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
    }

    private static boolean isLasrEnabledStandAlone(DataSelection dataSelection) {
        boolean lasrInEffect = false;
        Export export = null;
        List<ExportRule> returnList = dataSelection.getEffectiveRules(ExportRule.class);
        if (!returnList.isEmpty() && (export = returnList.get(0).getExport()).getUsage() == ExportType.LASR_OMA_TABLE) {
            lasrInEffect = true;
        }
        return lasrInEffect;
    }
}

