/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.instructions.AbstractSASSubmitInstruction;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.strategies.sas.oma.relational.ExpressionMacroMapping;
import com.sas.iquery.strategies.sas.oma.relational.IndependentExpressionGeneration;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.Iterator;
import java.util.List;

public class MacroExecutionInstruction
extends AbstractSASSubmitInstruction {
    private IndependentExpressionGeneration _ieg;

    public MacroExecutionInstruction(IndependentExpressionGeneration ieg) {
        this._ieg = ieg;
    }

    @Override
    public String getLanguageInstruction() {
        List<ExpressionMacroMapping> mappings;
        String returnValue = "";
        if (this._ieg != null && (mappings = this._ieg.getMappings()).size() != 0) {
            StringBuffer sasNullMacro = new StringBuffer("/* \n");
            sasNullMacro.append(" * IQV: ");
            sasNullMacro.append(IQDataServicesResourceBundle.getMessageFormatter("MacroExecutionInstruction.datastep.commentLine1.txt", new Object[0]));
            sasNullMacro.append("\n * ");
            sasNullMacro.append(IQDataServicesResourceBundle.getMessageFormatter("MacroExecutionInstruction.datastep.commentLine2.txt", new Object[0]));
            sasNullMacro.append("\n */\n");
            sasNullMacro.append("data _null_;\n");
            int curIndx = 0;
            Iterator<ExpressionMacroMapping> iterator = mappings.iterator();
            while (iterator.hasNext()) {
                ExpressionMacroMapping expressionMacroMapping;
                ExpressionMacroMapping mapping = expressionMacroMapping = iterator.next();
                ++curIndx;
                boolean charExp = this._ieg.isCharacterExpression((ExpressionInterface)mapping.getExpressions().get(0));
                String varName = mapping.getVariable();
                if (charExp) {
                    sasNullMacro.append("\tcall symput(\"");
                } else {
                    sasNullMacro.append("\tcall symputx(\"");
                }
                sasNullMacro.append(varName);
                sasNullMacro.append("\", ");
                sasNullMacro.append(mapping.getExpressionValue());
                sasNullMacro.append(");\n");
                boolean referencedByOthers = this.curReferencedByOtherMappings(curIndx, mapping, mappings);
                if (!referencedByOthers) continue;
                sasNullMacro.append("run;\n");
                sasNullMacro.append("data _null_;\n");
            }
            sasNullMacro.append("run;\n");
            returnValue = sasNullMacro.toString();
        }
        return returnValue;
    }

    private boolean curReferencedByOtherMappings(int curIndx, ExpressionMacroMapping currentMapping, List<ExpressionMacroMapping> mappings) {
        boolean returnReferenced = false;
        String curVarName = currentMapping.getVariable();
        for (int indx = curIndx; indx < mappings.size(); ++indx) {
            ExpressionMacroMapping nextMacroMapping = mappings.get(indx);
            String exprValue = nextMacroMapping.getExpressionValue();
            if (!exprValue.contains(curVarName)) continue;
            returnReferenced = true;
            break;
        }
        return returnReferenced;
    }

    @Override
    protected MessageFormatter getGeneralFailureMsg() {
        return IQDataServicesResourceBundle.getMessageFormatter("MacroExecutionInstruction.execute.Exception.txt", new Object[0]);
    }
}

