/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.instructions.AbstractSASSubmitInstruction;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.Locale;

public class LocaleInstruction
extends AbstractSASSubmitInstruction {
    private Locale _originalComputationLocale = null;
    private Locale _effectiveComputationLocale = null;

    public LocaleInstruction(Locale effectiveComputationLocale, Locale originalComputationLocale) {
        this._originalComputationLocale = originalComputationLocale;
        this._effectiveComputationLocale = effectiveComputationLocale;
    }

    @Override
    protected MessageFormatter getGeneralFailureMsg() {
        return IQDataServicesResourceBundle.getMessageFormatter("LocaleInstruction.execute.Exception.txt", new Object[0]);
    }

    @Override
    public String getLanguageInstruction() {
        StringBuffer sasLocaleStatement = new StringBuffer();
        if (this._effectiveComputationLocale == null) {
            sasLocaleStatement.append("/* The locale's language is not set (null), skipping the OPTIONS LOCALE statement. */\n");
            if (this._originalComputationLocale != null) {
                sasLocaleStatement.append("/* The original computation locale of '" + this._originalComputationLocale + "' has been overridden at execution time. */\n");
            }
        } else {
            String lang = this._effectiveComputationLocale.getLanguage();
            String country = this._effectiveComputationLocale.getCountry();
            if ("".equals(lang)) {
                sasLocaleStatement.append("/* The locale's language is empty, using en_US as the locale */\n");
                lang = Locale.ENGLISH.getLanguage();
                country = Locale.US.getCountry();
            }
            if ("iw".equals(lang)) {
                sasLocaleStatement.append("/* The locale's language code 'iw' (Hebrew) is obsolete, converting to ISO 639-2 code 'he' */\n");
                lang = "he";
            } else if ("ji".equals(lang)) {
                sasLocaleStatement.append("/* The locale's language code 'ji' (Yiddish) is obsolete, converting to ISO 639-2 code 'yi' */\n");
                lang = "yi";
            } else if ("in".equals(lang)) {
                sasLocaleStatement.append("/* The locale's language code 'in' (Indonesian) is obsolete, converting to ISO 639-2 code 'id' */\n");
                lang = "id";
            }
            if (country != null && country.trim().length() != 0) {
                sasLocaleStatement.append("options Locale=").append(lang).append('_').append(country).append(";");
            } else {
                String sasLanguageName = "gv".equals(lang) ? "ManxGaelic" : ("nb".equals(lang) ? "NorwegianBokmal" : ("nn".equals(lang) ? "NorwegianNynorsk" : ("sh".equals(lang) ? "SerbianLatin" : this._effectiveComputationLocale.getDisplayLanguage(Locale.ENGLISH))));
                sasLocaleStatement.append("/* ").append(this._effectiveComputationLocale).append(", lang=[").append(lang).append("], country=[").append(country).append("], Language Name in Java=[").append(this._effectiveComputationLocale.getDisplayName(Locale.ENGLISH)).append("], in SAS=[").append(sasLanguageName).append("] */\n");
                if (this._originalComputationLocale == null || this._effectiveComputationLocale.toString().compareToIgnoreCase(this._originalComputationLocale.toString()) != 0) {
                    sasLocaleStatement.append("/* The query's original computation locale of " + (this._originalComputationLocale == null ? "null" : "'" + this._originalComputationLocale + "'") + " has been overridden by '" + this._effectiveComputationLocale + "' at execution time. */\n");
                }
                sasLocaleStatement.append("options Locale=").append(sasLanguageName).append(";");
            }
        }
        return sasLocaleStatement.toString();
    }
}

