/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.instructions.AbstractSASSubmitInstruction;
import com.sas.iquery.execution.instructions.ExecutionOptions;
import com.sas.iquery.execution.instructions.SASSubmitInstruction;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.util.impl.MessageFormatter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CodeStringSASSubmitInstruction
extends AbstractSASSubmitInstruction {
    static final Logger _logger = LogManager.getLogger(SASSubmitInstruction.class);
    protected String _sasStatement;
    protected String _resolvedSasStatement;
    private final DataSelection _dataSelection;
    private ExecutionOptions _executionOptions;

    public CodeStringSASSubmitInstruction(String sasStatement, ExecutionOptions executionOptions, DataSelection dataSelection) {
        this._sasStatement = sasStatement;
        this._executionOptions = executionOptions;
        this._dataSelection = dataSelection;
    }

    @Override
    protected String getLanguageInstruction() {
        String sasStatementString = this.getSasStatement();
        this.setResolvedSasStatement(sasStatementString);
        _logger.debug(sasStatementString);
        return sasStatementString;
    }

    @Override
    protected void delay() {
        int clientRequestedQueryDelayInSeconds = this.getClientRequestedQueryDelayInSeconds();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Start of client requested query delay of " + Integer.toString(clientRequestedQueryDelayInSeconds) + " seconds.");
        }
        try {
            Thread.sleep((long)clientRequestedQueryDelayInSeconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        _logger.debug("End of client requested query delay.");
    }

    @Override
    protected boolean readSASOutput() {
        return true;
    }

    public String getSasStatement() {
        return this._sasStatement;
    }

    public void setSasStatement(String sasStatement) {
        this._sasStatement = sasStatement;
    }

    public ExecutionOptions getExecutionOptions() {
        return this._executionOptions;
    }

    public void setExecutionOptions(ExecutionOptions executionOptions) {
        this._executionOptions = executionOptions;
    }

    public String getResolvedSasStatement() {
        return this._resolvedSasStatement;
    }

    public void setResolvedSasStatement(String sasStatement) {
        this._resolvedSasStatement = sasStatement;
    }

    @Override
    protected void writeOutStatment(String sasStatementString) {
        block8: {
            String writeSasStatements = System.getProperty("SASQueryServices.writeSasStatements");
            if (writeSasStatements == null) {
                writeSasStatements = System.getProperty("IQ.writeSasStatements");
            }
            if (writeSasStatements != null) {
                if (writeSasStatements.equalsIgnoreCase("System.err")) {
                    System.err.println(sasStatementString);
                } else if (writeSasStatements.equalsIgnoreCase("System.out")) {
                    System.out.println(sasStatementString);
                } else {
                    try {
                        FileOutputStream out = new FileOutputStream(writeSasStatements, true);
                        PrintStream ps = new PrintStream(out);
                        ps.println(sasStatementString);
                        ps.close();
                        ((OutputStream)out).close();
                    }
                    catch (IOException io) {
                        MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.writeStatementFailed.fmt.txt", writeSasStatements, io, "SASQueryServices.writeSasStatements");
                        if (!_logger.isEnabled(Level.ERROR)) break block8;
                        _logger.error(msg.toString(), (Throwable)io);
                    }
                }
            }
        }
    }

    private synchronized int getClientRequestedQueryDelayInSeconds() {
        int ret = IQSystemProperties.getIntProperty("SASQueryServices.QueryDelaySeconds", -1);
        if (ret == -1) {
            ret = IQSystemProperties.getIntProperty("SAS.IQ.QueryDelaySeconds", 0);
        }
        return ret;
    }

    @Override
    protected MessageFormatter getGeneralFailureMsg() {
        return IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.submitLanguageInstructions.GenericError.txt", new Object[0]);
    }
}

