/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.UserSessionConnectionDecorator;
import com.sas.iquery.execution.instructions.AbstractSASSubmitInstruction;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.connection.ConnectionInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AllocationInstruction
extends AbstractSASSubmitInstruction {
    String _libname = null;
    String _engine = null;
    String _path = null;
    String _options = null;
    String _statement = null;
    private static final Logger _logger = LogManager.getLogger(AllocationInstruction.class);

    public AllocationInstruction(String statement) {
        this._statement = statement;
    }

    @Override
    public void execute() throws ExecutionException {
        boolean hasBeenSubmitted = false;
        UserSessionConnectionDecorator connDecorator = null;
        ConnectionInterface connection = this.getExecutionContext().getConnection();
        if (connection instanceof UserSessionConnectionDecorator && (connDecorator = (UserSessionConnectionDecorator)connection).hasAllocationInstructionBeenSubmitted(this)) {
            hasBeenSubmitted = true;
        }
        if (!hasBeenSubmitted) {
            super.execute();
            if (connDecorator != null) {
                connDecorator.addSubmittedAllocationInstruction(this);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("=====> " + this.getLanguageInstruction() + " <===== is assigned.");
            }
        }
    }

    @Override
    protected String getLanguageInstruction() {
        StringBuffer buf = new StringBuffer();
        if (this.getStatement() != null) {
            buf.append(this.getStatement());
        } else {
            buf.append(this.getLibname());
            buf.append(" ");
            if (this.getEngine() != null && this.getEngine().length() > 0) {
                buf.append(this.getEngine());
                buf.append(" ");
            }
            if (this.getPath() != null && this.getPath().length() > 0) {
                buf.append(" '");
                buf.append(this.getPath());
                buf.append("' ");
            }
            if (this.getOptions() != null && this.getOptions().length() > 0) {
                buf.append(this.getOptions());
            }
        }
        return buf.toString();
    }

    @Override
    protected MessageFormatter getGeneralFailureMsg() {
        return IQDataServicesResourceBundle.getMessageFormatter("AllocationInstruction.execute.Exception.txt", new Object[0]);
    }

    public String getEngine() {
        return this._engine;
    }

    public String getLibname() {
        return this._libname;
    }

    public String getOptions() {
        return this._options;
    }

    public String getPath() {
        return this._path;
    }

    public String getStatement() {
        return this._statement;
    }

    public void setEngine(String engine) {
        this._engine = engine;
    }

    public void setLibname(String libname) {
        this._libname = libname;
    }

    public void setOptions(String options) {
        this._options = options;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public void setStatement(String statement) {
        this._statement = statement;
    }
}

