/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution;

import com.sas.iom.SASMDX.ISession;
import com.sas.iquery.execution.OLAPConnectionResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionCloseThread
implements Runnable {
    private static final Logger _logger = LogManager.getLogger(OLAPConnectionResource.class);
    private ISession _session;

    public SessionCloseThread(ISession session) {
        this._session = session;
    }

    @Override
    public void run() {
        _logger.debug("SessionCloseThread started.");
        if (this._session != null) {
            String name = "";
            try {
                name = " " + String.valueOf(this._session);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            _logger.debug("Closing ISession" + name + " is a seperate thread.");
            try {
                this._session.Close();
            }
            catch (Throwable e) {
                _logger.warn("Could not close ISession" + name + ". " + e, e);
            }
            _logger.debug("Releasing ISession" + name + " is a seperate thread.");
            try {
                this._session._release();
            }
            catch (Throwable e) {
                _logger.warn("Could not release ISession" + name + ". " + e, e);
            }
        }
        _logger.debug("SessionCloseThread completed.");
    }
}

