/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution;

import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.ISession;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionRecycler;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.execution.UserSessionConnectionDecorator;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ModelItemWithIdentity;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.IQOLAPDataSet;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.util.anno.NotNull;
import java.rmi.RemoteException;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConnectionUtil {
    public static final Logger _logger = LogManager.getLogger(ConnectionUtil.class);
    public static final Logger _perfDSLogger = LogManager.getLogger((String)"com.sas.iquery.perf.DataServer");
    public static final Logger _perfCLogger = LogManager.getLogger((String)"com.sas.iquery.perf.Connections");

    public static ConnectionRecycler getConnectionRecycler(SessionContextInterface sessionContext) throws ExecutionException {
        ConnectionRecycler recycler = null;
        if (sessionContext == null) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("ConnectionUtil.getConnectionRecycler.NoSession.Error.txt", new Object[0]);
            _logger.error((Object)message);
            throw new ExecutionException(message);
        }
        try {
            recycler = ConnectionRecycler.getInstance(sessionContext);
        }
        catch (RemoteException e) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("ConnectionUtil.getConnectionRecycler.RemoteException.Error.txt", new Object[0]);
            _logger.error((Object)message, (Throwable)e);
            _logger.error((Object)sessionContext);
            throw new ExecutionException(message, (Throwable)e);
        }
        if (recycler == null) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("ConnectionUtil.getConnectionRecycler.NoRecycler.Error.txt", new Object[0]);
            _logger.error((Object)message);
            _logger.error((Object)sessionContext);
            throw new ExecutionException(message);
        }
        return recycler;
    }

    public static UserContextInterface getUserContext(SessionContextInterface sessionContext) throws ExecutionException {
        UserContextInterface userContext = null;
        if (sessionContext == null) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("ConnectionUtil.getConnectionRecycler.NoSession.Error.txt", new Object[0]);
            _logger.error((Object)message);
            throw new ExecutionException(message);
        }
        try {
            userContext = sessionContext.getUserContext();
        }
        catch (RemoteException e) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("ConnectionUtil.getConnectionRecycler.RemoteException.Error.txt", new Object[0]);
            _logger.error((Object)message, (Throwable)e);
            _logger.error((Object)sessionContext);
            throw new ExecutionException(message, (Throwable)e);
        }
        if (userContext == null) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("ConnectionUtil.getConnectionRecycler.NoRecycler.Error.txt", new Object[0]);
            _logger.error((Object)message);
            _logger.error((Object)sessionContext);
            throw new ExecutionException(message);
        }
        return userContext;
    }

    public static Object findMetadataInterfaceConnection(MetadataInterface metaI) throws ExecutionException {
        Object connection = null;
        try {
            connection = metaI.getConnection();
        }
        catch (OLAPException oe) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.OLAPExceptionm.Message.txt", new Object[0]);
            throw new ExecutionException(message, (Throwable)oe);
        }
        if (connection == null) {
            MessageFormatter messageFormatter = IQDataServicesResourceBundle.getMessageFormatter("ConnectionUtil.getOlapConnectionObject.Null.txt", new Object[0]);
            throw new ExecutionException(messageFormatter);
        }
        return connection;
    }

    public static void LoggerErrorWithObjects(Logger logger, Object message, Object ... stuff) {
        for (int i = 0; i < stuff.length; ++i) {
            Object object = stuff[i];
            if (i == 0) {
                if (object instanceof Throwable) {
                    logger.error(message, (Throwable)object);
                    continue;
                }
                logger.error(message);
            }
            if (object instanceof BusinessModelResource) {
                logger.error(((BusinessModelResource)object).getIdentityString());
                continue;
            }
            if (object instanceof ModelItemWithIdentity) {
                logger.error(((ModelItemWithIdentity)object).getIdentityString());
                continue;
            }
            if (object instanceof Throwable) {
                logger.error((Object)((Throwable)object));
                continue;
            }
            if (object instanceof ExpressionInterface) {
                String readableText = null;
                try {
                    readableText = StringExpressionUtil.getInstance().getReadableText((ExpressionInterface)object);
                }
                catch (Throwable t) {
                    logger.error((Object)t);
                    readableText = String.valueOf(object);
                }
                logger.error(readableText);
                continue;
            }
            logger.error(object);
        }
    }

    public static ResultSetMetadataInterface findResultSetMetadata(IQOLAPDataSet olapDataSet) throws OLAPException, ExecutionException {
        ResultSetMetadataInterface resultSetMeta = olapDataSet.getResultSetMetadata();
        if (resultSetMeta == null) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationUtilNoOLAPDataSet.txt", new Object[0]);
            throw new ExecutionException(message);
        }
        return resultSetMeta;
    }

    public static Locale getConnectionLocale(MetadataInterface metaI) throws ExecutionException {
        Locale connectionLocale;
        try {
            connectionLocale = metaI.getLocale();
        }
        catch (OLAPException oe) {
            throw new ExecutionException(oe);
        }
        if (connectionLocale == null) {
            throw new ExecutionException("The server returned a null connection Locale.");
        }
        return connectionLocale;
    }

    @NotNull
    public static ConnectionInterface findConnection(ConnectionRecycler recycler, DataSelection dataSelection, LogicalServerInterface logicalServer, UserContextInterface userContext, RetrievalPolicy policy, Locale connectionLocale) throws ExecutionException {
        ConnectionInterface connection = null;
        try {
            connection = recycler.getConnection(dataSelection, logicalServer, userContext, policy, connectionLocale);
        }
        catch (RemoteException e) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("ConnectionUtil.createConnection.Remote.txt", logicalServer.toString(), userContext.toString());
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, e, dataSelection, logicalServer, policy, connectionLocale);
            throw new ExecutionException(message, (Throwable)e);
        }
        catch (ConnectionFactoryException e) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("ConnectionUtil.createConnection.ConnectionFactory.txt", logicalServer.toString(), userContext.toString());
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, new Object[]{e, dataSelection, logicalServer, policy, connectionLocale});
            throw new ExecutionException(message, (Throwable)e);
        }
        catch (ServiceException e) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("ConnectionUtil.createConnection.Service.txt", logicalServer.toString(), userContext.toString());
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, new Object[]{e, dataSelection, logicalServer, policy, connectionLocale});
            throw new ExecutionException(message, (Throwable)e);
        }
        if (connection == null) {
            MessageFormatter msF = IQDataServicesResourceBundle.getMessageFormatter("ConnectionUtil.createConnection.Connection.txt", logicalServer, userContext);
            ConnectionUtil.LoggerErrorWithObjects(_logger, msF, dataSelection, logicalServer, policy, connectionLocale);
            throw new ExecutionException(msF);
        }
        return connection;
    }

    public static ConnectionInterface findPfsConnection(ConnectionInterface connection) {
        ConnectionInterface pfsConnection = connection;
        if (connection instanceof UserSessionConnectionDecorator) {
            pfsConnection = ((UserSessionConnectionDecorator)connection).getComponent();
        }
        return pfsConnection;
    }

    public static void LoggerDebugConnectionObtained(Logger logger, Object contextHint, ConnectionInterface connection) {
        if (logger.isDebugEnabled()) {
            String hint = "";
            if (contextHint != null) {
                hint = " by '" + contextHint + "': " + (contextHint instanceof Class ? ((Class)contextHint).getName() : contextHint.getClass().getName() + "@" + Integer.toHexString(contextHint.hashCode()));
            }
            logger.debug("Connection obtained" + hint + "\n    connection = " + connection.toString());
            if (connection instanceof UserSessionConnectionDecorator) {
                ConnectionInterface decoratedConn = ((UserSessionConnectionDecorator)connection).getComponent();
                logger.debug("   Wrapping connection = " + decoratedConn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IQOLAPDataSet newOLAPDataSet(BusinessModel businessModel, String query, int contextType, MetadataInterface metaI, OLAPConnectionResource olapConnection) throws OLAPException, ExecutionException {
        Object connectionObject = ConnectionUtil.findMetadataInterfaceConnection(metaI);
        Locale connectionLocale = ConnectionUtil.getConnectionLocale(metaI);
        boolean isOk = false;
        IQOLAPDataSet olapDataSet = null;
        try {
            if (connectionObject instanceof IMDXServer) {
                IMDXServer mdxServer = (IMDXServer)connectionObject;
                olapDataSet = ConnectionResources.newOLAPDataSet(mdxServer, contextType);
            } else if (connectionObject instanceof ISession) {
                ISession isession = (ISession)connectionObject;
                olapDataSet = ConnectionResources.newOLAPDataSet(isession, contextType, null);
                if (olapConnection != null) {
                    olapDataSet.setRelatedConnection(olapConnection);
                    olapConnection.addOlapDataSet(isession, olapDataSet, connectionLocale);
                }
            } else {
                if (connectionObject == null) {
                    MessageFormatter messageFormatter = IQDataServicesResourceBundle.getMessageFormatter("ConnectionUtil.getOlapConnectionObject.Null.txt", new Object[0]);
                    MDXGenerationUtil.applyDebugStatement(query, OLAPConnectionInfoUtil.class);
                    throw new ExecutionException(messageFormatter);
                }
                MessageFormatter messageFormatter = IQDataServicesResourceBundle.getMessageFormatter("ConnectionUtil.unknownConnectionObject.fmt.txt", connectionObject, connectionObject.getClass().getName());
                MDXGenerationUtil.applyDebugStatement(query, OLAPConnectionInfoUtil.class);
                throw new ExecutionException(messageFormatter);
            }
            olapDataSet.setQueryStatement(query, null);
            olapDataSet.setLocale(connectionLocale);
            olapDataSet.setBusinesModel(businessModel);
            return olapDataSet;
        }
        catch (Throwable throwable) {
            if (isOk) throw throwable;
            ConnectionResources.close(olapDataSet);
            throw throwable;
        }
    }
}

