/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution;

import com.sas.iom.SASIOMCommon.ISessionControl;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.QueryConnectorReturnCodeType;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.execution.UserSessionConnectionDecorator;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.metadata.business.CancelQuerySupport;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.impl.SessionContextDependentCache;
import com.sas.iquery.metadata.impl.SessionContextDependentCacheException;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.LogicalServer;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class ConnectionRecycler
implements Serializable,
SessionContextDependentCache.SessionContextEndListener {
    private int _killTimer = 1;
    private static final String SESSION_CACHE_KEY = "com.sas.iquery.execution.ConnectionRecycler";
    private static final long serialVersionUID = 1L;
    private static final SessionContextDependentCache _sessionCache = SessionContextDependentCache.getNewInstance();
    protected ServerToUserMapping _connectionMap = new ServerToUserMapping();
    protected String _temporaryTableName = "A";
    protected int _counter = 0;
    private static final Logger _logger = LogManager.getLogger(ConnectionRecycler.class);

    private ConnectionRecycler() {
    }

    public ConnectionInterface getConnection(DataSelection dataSelection, LogicalServer logicalServer, RetrievalPolicy retrievalPolicy) throws RemoteException, ConnectionFactoryException, ServiceException {
        if (dataSelection == null) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ConnectionRecycler.getConnection.NoDataSelection.txt", new java.lang.Object[0]);
            IllegalArgumentException e = new IllegalArgumentException(msg.toString());
            e.initCause(new ExecutionException(msg));
            throw e;
        }
        Locale connectionLocale = LocaleUtilities.getDefaultComputationalLocale(dataSelection);
        UserContextInterface userContext = dataSelection.getSession().getUserContext();
        ServerInterface server = userContext.getAuthServer();
        LogicalServerInterface lsi = (LogicalServerInterface)server.factoryProcess((java.lang.Object)logicalServer);
        return this.getConnection(dataSelection, lsi, userContext, retrievalPolicy, connectionLocale);
    }

    public ConnectionInterface getConnection(DataSelection dataSelection, LogicalServerInterface logicalServer, RetrievalPolicy retrievalPolicy) throws RemoteException, ConnectionFactoryException, ServiceException {
        if (dataSelection == null) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ConnectionRecycler.getConnection.NoDataSelection.txt", new java.lang.Object[0]);
            IllegalArgumentException e = new IllegalArgumentException(msg.toString());
            e.initCause(new ExecutionException(msg));
            throw e;
        }
        Locale connectionLocale = LocaleUtilities.getDefaultComputationalLocale(dataSelection);
        SessionContextInterface sessionContext = dataSelection.getSession();
        UserContextInterface userContext = sessionContext.getUserContext();
        return this.getConnection(dataSelection, logicalServer, userContext, retrievalPolicy, connectionLocale);
    }

    public ConnectionInterface getConnection(DataSelection dataSelection, LogicalServerInterface logicalServer, RetrievalPolicy retrievalPolicy, Locale connectionLocale) throws RemoteException, ServiceException, ConnectionFactoryException {
        SessionContextInterface sessionContext = dataSelection.getSession();
        UserContextInterface userContext = sessionContext.getUserContext();
        return this.getConnection(dataSelection, logicalServer, userContext, retrievalPolicy, connectionLocale);
    }

    public synchronized ConnectionInterface getConnection(DataSelection dataSelection, LogicalServerInterface logicalServer, UserContextInterface userContext, RetrievalPolicy retrievalPolicy, Locale connectionLocale) throws ServiceException, RemoteException, ConnectionFactoryException {
        final boolean[] _killedWhileConnecting = new boolean[]{false};
        final DataSelection listenerDs = dataSelection;
        CancelQuerySupport.CancelQueryListener preConnectListener = new CancelQuerySupport.CancelQueryListener(){

            @Override
            public void cancelQueryPerformed(CancelQuerySupport.CancelQueryEvent event) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("cancelQueryPerformed on " + listenerDs + " " + listenerDs.getClass().getName() + "@" + Integer.toHexString(listenerDs.hashCode()) + " before connection complete  by event=" + event);
                }
                _killedWhileConnecting[0] = true;
            }

            @Override
            public SessionContextInterface getSession() {
                return listenerDs.getSession();
            }
        };
        CancelQuerySupport.registerQueryListener(dataSelection, preConnectListener);
        _logger.debug("Getting connection");
        ConnectionInterface connection = this.getWorkspaceConnection(logicalServer, userContext, retrievalPolicy, connectionLocale);
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Killed while connecting = " + _killedWhileConnecting[0]);
            }
            CancelQuerySupport.unRegisterQueryListener(dataSelection, preConnectListener);
            if (_killedWhileConnecting[0]) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Cancel before getConnection() completed, detected by " + this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()));
                }
                String msg = IQDataServicesResourceBundle.getStringResource("ConnectionRecycler.getConnection.QueryCancelledWhileConnectingToServer.txt");
                ExecutionException e = new ExecutionException(msg, CancelQuerySupport.RC_CANCELLEDQUERY);
                ConnectionFactoryException cfe = new ConnectionFactoryException(msg);
                cfe.initCause((Throwable)e);
                throw cfe;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("Got connection = " + connection);
                String type = "Relational";
                if (connection instanceof UserSessionConnectionDecorator) {
                    ConnectionInterface decoratedConn = ((UserSessionConnectionDecorator)connection).getComponent();
                    _logger.debug("   wrapping connection = " + decoratedConn);
                    if (decoratedConn instanceof OLAPConnectionResource) {
                        type = "OLAP (decorated)";
                    }
                } else if (connection instanceof OLAPConnectionResource) {
                    type = "OLAP";
                }
                _logger.debug("Connection is of type: " + type);
            }
        }
        catch (ConnectionFactoryException e) {
            _logger.error((java.lang.Object)e);
            if (connection != null) {
                ConnectionResources.close(connection);
            }
            throw e;
        }
        return connection;
    }

    private boolean isOLAPServer(LogicalServerInterface logicalServer) throws ServiceException, RemoteException {
        String olapServerId = "f3f46472-1e31-11d5-87c2-00c04f38f9f6".toLowerCase();
        boolean isOLAPServer = logicalServer.getClassIdentifier().equals(olapServerId);
        return isOLAPServer;
    }

    public synchronized void closeConnections(SessionContextInterface sessionContext) throws IllegalStateException, RemoteException {
        Collection<UserToDomainMapping> serverToUserCol = this._connectionMap.values();
        CancelQuerySupport.unRegisterSession(sessionContext);
        for (UserToDomainMapping userMapping : serverToUserCol) {
            UserSessionConnectionDecorator connection;
            UserContextInterface userContext;
            if (!userMapping.containsKey(userContext = sessionContext.getUserContext())) continue;
            ConnectionInterface connectionObject = userMapping.getConnection(userContext);
            if (connectionObject instanceof UserSessionConnectionDecorator) {
                connection = (UserSessionConnectionDecorator)connectionObject;
                ConnectionInterface pfsConnection = connection.getComponent();
                CancelQuerySupport.unRegisterConnection(pfsConnection);
                CancelQuerySupport.unRegisterConnection(connection);
                this.close(pfsConnection);
            } else {
                connection = connectionObject;
                CancelQuerySupport.unRegisterConnection(connection);
                this.close(connection);
            }
            userMapping.remove(userContext);
        }
    }

    public synchronized void closeResources(SessionContextInterface sessionContext, int options) throws IllegalStateException, RemoteException {
        int bitMask = 61440;
        if ((options & ~bitMask) != 0) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ConnectionRecycler.closeResources.InvalidOptions.fmt.txt", Integer.toBinaryString(options));
            IllegalArgumentException e = new IllegalArgumentException(msg.toString());
            e.initCause(new ExecutionException(msg));
            throw e;
        }
        Set<Map.Entry<String, UserToDomainMapping>> serverToUserCol = this._connectionMap.entrySet();
        for (Map.Entry entry : serverToUserCol) {
            UserSessionConnectionDecorator connection;
            UserContextInterface userContext;
            UserToDomainMapping userMapping = (UserToDomainMapping)entry.getValue();
            if (!userMapping.containsKey(userContext = sessionContext.getUserContext())) continue;
            ConnectionInterface connectionObject = userMapping.getConnection(userContext);
            boolean closedConnection = false;
            if (connectionObject instanceof UserSessionConnectionDecorator) {
                connection = (UserSessionConnectionDecorator)connectionObject;
                ConnectionInterface pfsConnection = connection.getComponent();
                closedConnection = this.closeIfMatchesOptions(pfsConnection, options);
                if (closedConnection) {
                    CancelQuerySupport.unRegisterConnection(connection);
                }
            } else {
                connection = connectionObject;
                closedConnection = this.closeIfMatchesOptions(connection, options);
            }
            if (!closedConnection) continue;
            userMapping.remove(userContext);
        }
    }

    private boolean closeIfMatchesOptions(ConnectionInterface connection, int options) throws IllegalStateException {
        boolean closed = false;
        boolean isOLAP = OLAPConnectionInfoUtil.isOLAP(connection);
        try {
            if (!isOLAP && (options & 0x1000) != 0 || isOLAP && (options & 0x2000) != 0) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Closing " + (isOLAP ? "OLAP" : "relational") + " connection " + connection);
                }
                this.cancelConnection(connection, options);
                CancelQuerySupport.unRegisterConnection(connection);
                this.close(connection);
                closed = true;
            }
        }
        catch (SystemException e) {
            if (_logger.isEnabled(Level.WARN)) {
                _logger.warn("Problem closing connection " + connection + ", removing and continuing ", (Throwable)e);
            }
            closed = true;
        }
        return closed;
    }

    private QueryConnectorReturnCodeType closeThread(ConnectionInterface connection) {
        QueryConnectorReturnCodeType returnType = QueryConnectorReturnCodeType.CANCEL_SUCCESS;
        if (connection instanceof OLAPConnectionResource) {
            OLAPConnectionResource olapConn = (OLAPConnectionResource)connection;
            try {
                olapConn.cancelQueryThreads();
                this.close(connection);
            }
            catch (Throwable e) {
                returnType = QueryConnectorReturnCodeType.CANCEL_FAILURE;
            }
            returnType = QueryConnectorReturnCodeType.CANCEL_SUCCESS;
        } else {
            returnType = QueryConnectorReturnCodeType.CANCEL_NO_OP;
        }
        return returnType;
    }

    public QueryConnectorReturnCodeType closeThread(SessionContextInterface sessionContext) throws IllegalStateException, RemoteException {
        LinkedHashSet<UserToDomainMapping> serverToUserCol = new LinkedHashSet<UserToDomainMapping>(this._connectionMap.values());
        LinkedHashSet<ConnectionInterface> connections = new LinkedHashSet<ConnectionInterface>();
        for (UserToDomainMapping userMapping : serverToUserCol) {
            UserContextInterface userContext;
            if (!userMapping.containsKey(userContext = sessionContext.getUserContext())) continue;
            ConnectionInterface connection = userMapping.getConnection(userContext);
            if (connection instanceof UserSessionConnectionDecorator) {
                ConnectionInterface pfsConnection = ((UserSessionConnectionDecorator)connection).getComponent();
                connections.add(pfsConnection);
                continue;
            }
            connections.add(connection);
        }
        for (ConnectionInterface connection : connections) {
            if (connection instanceof OLAPConnectionResource) continue;
            return QueryConnectorReturnCodeType.CANCEL_NO_OP;
        }
        CancelQuerySupport.unRegisterSession(sessionContext);
        QueryConnectorReturnCodeType returnType = QueryConnectorReturnCodeType.CANCEL_SUCCESS;
        for (ConnectionInterface connection : connections) {
            QueryConnectorReturnCodeType returnType1 = this.closeThread(connection);
            if (returnType != QueryConnectorReturnCodeType.CANCEL_SUCCESS || returnType1 == QueryConnectorReturnCodeType.CANCEL_SUCCESS) continue;
            returnType = returnType1;
        }
        return returnType;
    }

    public synchronized void closeConnection(ConnectionInterface connection) throws IllegalStateException, RemoteException, ServiceException {
        block6: {
            ConnectionInterface realConnection = connection;
            if (connection instanceof UserSessionConnectionDecorator) {
                UserSessionConnectionDecorator connectionDecorator = (UserSessionConnectionDecorator)connection;
                realConnection = connectionDecorator.getComponent();
            }
            CancelQuerySupport.unRegisterConnection(realConnection);
            if (realConnection != connection) {
                CancelQuerySupport.unRegisterConnection(connection);
            }
            try {
                ConnectionResources.close(realConnection);
            }
            catch (SystemException e) {
                if (!_logger.isEnabled(Level.WARN)) break block6;
                _logger.warn("Problem closing connection " + realConnection + ", removing and continuing ", (Throwable)e);
            }
        }
        for (Map.Entry<String, UserToDomainMapping> serverToUserMapping : this._connectionMap.entrySet()) {
            UserToDomainMapping userMapping = serverToUserMapping.getValue();
            if (userMapping == null) continue;
            Iterator iterUserToConnectionMappings = userMapping.map.entrySet().iterator();
            while (iterUserToConnectionMappings.hasNext()) {
                Map.Entry userToConnectionMapping = iterUserToConnectionMappings.next();
                ConnectionInterface value = (ConnectionInterface)userToConnectionMapping.getValue();
                if (value == null || value != connection) continue;
                iterUserToConnectionMappings.remove();
            }
        }
    }

    synchronized void cancelConnection(ConnectionInterface connection, int options) throws IllegalStateException {
        ConnectionInterface realConnection;
        block15: {
            boolean isOLAP;
            realConnection = connection;
            CancelQuerySupport.unRegisterConnection(connection);
            if (connection instanceof UserSessionConnectionDecorator) {
                realConnection = ((UserSessionConnectionDecorator)realConnection).getComponent();
                CancelQuerySupport.unRegisterConnection(realConnection);
            }
            if (isOLAP = realConnection instanceof OLAPConnectionResource) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Canceling OLAP query(s) on connection " + realConnection);
                }
                OLAPConnectionResource olapConnection = (OLAPConnectionResource)realConnection;
                try {
                    olapConnection.cancelAllRunningQueries();
                }
                catch (IQueryServicesException e) {
                    _logger.error("Cancel failed.", (Throwable)e);
                    throw new IllegalStateException(e);
                }
                try {
                    _logger.debug("Closing unused isessions.");
                    olapConnection.closeAllReleasedUnusedISessions();
                }
                catch (IQueryServicesException e) {
                    if (_logger.isEnabled(Level.WARN)) {
                        _logger.warn("Problem closing unused connection objects " + this + ", continuing: " + e.getLocalizedMessage(), (Throwable)e);
                    }
                    break block15;
                }
            }
            if ((options & 0x10) != 0) {
                Object obj;
                ISessionControl iSessionControl;
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Canceling relational query(s) on connection " + realConnection);
                }
                if ((iSessionControl = IOMServerUtils.GetISessionControl(obj = realConnection.getObject())) != null) {
                    try {
                        iSessionControl.Kill(this._killTimer);
                    }
                    catch (GenericError e) {
                        _logger.warn("ISessionControl Kill() failed; continuing to close physical connection", (Throwable)e);
                    }
                }
            }
        }
        this.close(realConnection);
        HashSet<UserToDomainMapping> userToDomainMappings = new HashSet<UserToDomainMapping>(this._connectionMap.values());
        for (UserToDomainMapping userMapping : userToDomainMappings) {
            Set<Map.Entry<String, ConnectionInterface>> entrySet = userMapping.entrySet();
            Iterator<Map.Entry<String, ConnectionInterface>> iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ConnectionInterface> entry = iterator.next();
                ConnectionInterface cacheValueConnection = entry.getValue();
                if (cacheValueConnection != connection) continue;
                iterator.remove();
            }
        }
    }

    private ConnectionInterface fetchNonCloseablePFSConnection(LogicalServerInterface logicalServer, UserContextInterface userContextInterface, Locale locale, long maxConnectionWaitTime) throws IllegalStateException, ServiceException, RemoteException, ConnectionFactoryException {
        ConnectionInterface connection = this._connectionMap.getConnection(logicalServer, userContextInterface);
        if (connection == null) {
            connection = this.fetchPFSConnection(logicalServer, userContextInterface, locale, maxConnectionWaitTime);
            connection = new UserSessionConnectionDecorator(connection);
            this._connectionMap.addConnection(connection, logicalServer, userContextInterface);
        }
        return connection;
    }

    private ConnectionInterface fetchPFSConnection(LogicalServerInterface omrLogicalServer, UserContextInterface userContextInterface, Locale connectionLocale, long maxConnectionWaitTime) throws ServiceException, RemoteException, ConnectionFactoryException {
        ConnectionInterface connection = null;
        try {
            connection = this.open(omrLogicalServer, userContextInterface, connectionLocale, maxConnectionWaitTime);
            Locale supportedLocale = null;
            try {
                supportedLocale = IOMServerUtils.negotiateValidServerLocale(connection, connectionLocale);
                if (supportedLocale == null) {
                    supportedLocale = connectionLocale;
                }
            }
            catch (Throwable e) {
                _logger.warn((java.lang.Object)e);
                supportedLocale = connectionLocale;
            }
            if (this.isOLAPServer(omrLogicalServer)) {
                connection = new OLAPConnectionResource(connection, supportedLocale);
            }
        }
        catch (ConnectionFactoryException e) {
            ConnectionResources.close(connection);
            throw e;
        }
        catch (Throwable e) {
            ConnectionResources.close(connection);
            throw new ConnectionFactoryException(e);
        }
        return connection;
    }

    public static synchronized ConnectionRecycler getInstance(SessionContextInterface sessionContext) throws RemoteException {
        ConnectionRecycler recycler = (ConnectionRecycler)_sessionCache.get(sessionContext, SESSION_CACHE_KEY);
        if (recycler == null) {
            recycler = new ConnectionRecycler();
            try {
                _sessionCache.put(sessionContext, SESSION_CACHE_KEY, recycler, recycler);
            }
            catch (SessionContextDependentCacheException e) {
                MessageFormatter msF = IQDataServicesResourceBundle.getMessageFormatter("ConnectionRecycler.getInstance.UnableToCacheRecycler.fmt.txt", SESSION_CACHE_KEY);
                throw new RemoteException(msF.toString(), e);
            }
        }
        return recycler;
    }

    public synchronized String getNewTemporaryTableName() {
        ++this._counter;
        return this._temporaryTableName + this._counter;
    }

    public synchronized ConnectionInterface getWorkspaceConnection(LogicalServer logicalServer, UserContextInterface userContext, RetrievalPolicy retrievalPolicy) throws ServiceException, RemoteException, GenericError, ConnectionFactoryException {
        Locale connectionLocale = LocaleUtilities.getDefaultComputationalLocale(userContext);
        ServerInterface authServer = userContext.getAuthServer();
        LogicalServerInterface lsi = (LogicalServerInterface)authServer.factoryProcess((java.lang.Object)logicalServer);
        return this.getWorkspaceConnection(lsi, userContext, retrievalPolicy, connectionLocale);
    }

    public synchronized ConnectionInterface getWorkspaceConnection(LogicalServer logicalServer, UserContextInterface userContext, RetrievalPolicy retrievalPolicy, Locale connectionLocale) throws ServiceException, RemoteException, GenericError, ConnectionFactoryException {
        ServerInterface server = userContext.getAuthServer();
        LogicalServerInterface lsi = (LogicalServerInterface)server.factoryProcess((java.lang.Object)logicalServer);
        ConnectionInterface connection = this.getWorkspaceConnection(lsi, userContext, retrievalPolicy, connectionLocale);
        return connection;
    }

    public synchronized ConnectionInterface getWorkspaceConnection(LogicalServerInterface logicalServer, UserContextInterface userContext, RetrievalPolicy retrievalPolicy, Locale connectionLocale) throws ServiceException, RemoteException, ConnectionFactoryException {
        ConnectionInterface connection = this.getCommonConnection(logicalServer, userContext, retrievalPolicy, connectionLocale);
        return connection;
    }

    private ConnectionInterface getCommonConnection(LogicalServerInterface server, UserContextInterface userContext, RetrievalPolicy retrievalPolicy, Locale connectionLocale) throws ServiceException, RemoteException, ConnectionFactoryException {
        ConnectionInterface connection;
        if (retrievalPolicy == null) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ConnectionRecycler.getConnection.NoRetrievalPolicy.txt", new java.lang.Object[0]);
            IllegalArgumentException e = new IllegalArgumentException(msg.toString());
            e.initCause(new ExecutionException(msg));
            throw e;
        }
        int connectionLifetime = retrievalPolicy.getConnectionConfiguration().getConnectionLifetime();
        long maxConnectionWaitTime = retrievalPolicy.getConnectionConfiguration().getMaxConnectionWaitTime();
        if (connectionLifetime == 0) {
            connection = this.fetchPFSConnection(server, userContext, connectionLocale, maxConnectionWaitTime);
        } else if (connectionLifetime == 1) {
            connection = this.fetchNonCloseablePFSConnection(server, userContext, connectionLocale, maxConnectionWaitTime);
        } else {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ConnectionRecycler.getConnection.IllegalArgument.txt", new java.lang.Object[0]);
            IllegalArgumentException e = new IllegalArgumentException(msg.toString());
            e.initCause(new ExecutionException(msg));
            throw e;
        }
        return connection;
    }

    @Override
    public void sessionEnd(SessionContextInterface session) {
        block2: {
            _logger.debug("In SessionContextEndListener sessionEnd");
            try {
                int bitMask = 61440;
                this.closeResources(session, bitMask);
            }
            catch (RemoteException e) {
                _logger.error("Unable to close connectoin on session end event", (Throwable)e);
                if (!_logger.isDebugEnabled()) break block2;
                _logger.debug(">> " + this._connectionMap.toString());
            }
        }
        _sessionCache.removeSessionContextEndListener(session, this, true);
    }

    private void close(ConnectionInterface realConnection) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Close connection = " + realConnection, (Throwable)new Exception("not an error, stack location for ConnectionRecycler based closing of connection = " + realConnection));
        }
        ConnectionResources.close(realConnection);
    }

    private ConnectionInterface open(LogicalServerInterface omrLogicalServer, UserContextInterface userContextInterface, Locale connectionLocale, long maxConnectionWaitTime) throws ServiceException, RemoteException, ConnectionFactoryException {
        ConnectionInterface realConnection = ConnectionResources.getConnection(omrLogicalServer, userContextInterface, connectionLocale, maxConnectionWaitTime);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Open connection = " + realConnection, (Throwable)new Exception("not an error, stack location for ConnectionRecycler based opening of connection = " + realConnection));
        }
        return realConnection;
    }

    private class ServerToUserMapping
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, UserToDomainMapping> map = new HashMap<String, UserToDomainMapping>();

        private ServerToUserMapping() {
        }

        public ConnectionInterface getConnection(LogicalServerInterface logicalServer, UserContextInterface userContext) throws ServiceException, RemoteException {
            ConnectionInterface connection = null;
            String key = logicalServer.getEntityKey();
            if (this.map.containsKey(key)) {
                UserToDomainMapping userMapping = this.map.get(key);
                connection = userMapping.getConnection(userContext);
            }
            return connection;
        }

        public void addConnection(ConnectionInterface connection, LogicalServerInterface logicalServer, UserContextInterface userContext) throws ServiceException, RemoteException {
            String entityKey = logicalServer.getEntityKey();
            UserToDomainMapping userMapping = this.map.get(entityKey);
            if (userMapping == null) {
                userMapping = new UserToDomainMapping();
                this.map.put(entityKey, userMapping);
            }
            userMapping.addConnection(connection, userContext);
        }

        public Set<Map.Entry<String, UserToDomainMapping>> entrySet() {
            return this.map.entrySet();
        }

        public Collection<UserToDomainMapping> values() {
            return this.map.values();
        }
    }

    private class UserToDomainMapping
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, ConnectionInterface> map = new HashMap<String, ConnectionInterface>();

        private UserToDomainMapping() {
        }

        public ConnectionInterface getConnection(UserContextInterface userContext) throws RemoteException {
            ConnectionInterface connection = null;
            String key = userContext.getUniqueId();
            if (this.map.containsKey(key)) {
                connection = this.map.get(key);
            }
            return connection;
        }

        public void addConnection(ConnectionInterface connection, UserContextInterface userContext) throws RemoteException {
            this.map.put(userContext.getUniqueId(), connection);
        }

        public boolean containsKey(UserContextInterface userContext) throws RemoteException {
            return this.map.containsKey(userContext.getUniqueId());
        }

        public ConnectionInterface remove(UserContextInterface userContext) throws RemoteException {
            return this.map.remove(userContext.getUniqueId());
        }

        public void removeConnection(ConnectionInterface connection, UserContextInterface userContext) throws RemoteException {
            this.map.remove(userContext.getUniqueId());
        }

        public Set<Map.Entry<String, ConnectionInterface>> entrySet() {
            return this.map.entrySet();
        }
    }
}

