/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionRecycler;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.metadata.business.CancelQuerySupport;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.session.SessionContextInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectionCancelQueryListener
implements CancelQuerySupport.CancelQueryListener {
    private DataSelection _dataSelection = null;
    private ConnectionInterface _connection = null;
    private boolean _isOLAP = false;
    private static final Logger _logger = LogManager.getLogger(ConnectionCancelQueryListener.class);

    public ConnectionCancelQueryListener(DataSelection dataSelection, boolean isOLAP, ConnectionInterface connection) {
        this._isOLAP = isOLAP;
        this._connection = connection;
        this._dataSelection = dataSelection;
    }

    @Override
    public SessionContextInterface getSession() {
        if (this._dataSelection == null) {
            return null;
        }
        return this._dataSelection.getSession();
    }

    @Override
    public void cancelQueryPerformed(CancelQuerySupport.CancelQueryEvent event) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("cancelQueryPerformed on " + this._dataSelection + " [" + this._dataSelection.getID() + "] " + this._dataSelection.getClass().getName() + "@" + Integer.toHexString(this._dataSelection.hashCode()) + "\n   for " + (this._isOLAP ? "OLAP" : "Relational") + " connection=" + this._connection + "\n    by event=" + event);
        }
        if (this._connection != null) {
            try {
                SessionContextInterface session = this.getSession();
                ConnectionRecycler connectionRecycler = ConnectionUtil.getConnectionRecycler(session);
                connectionRecycler.cancelConnection(this._connection, 16);
            }
            catch (Throwable e) {
                String msg = null;
                Object source = event.getSource();
                msg = source == null ? IQDataServicesResourceBundle.getStringResource("ConnectionCancelQueryListener.ErrorTryingToCancelQuery.txt") : IQDataServicesResourceBundle.getMessageString("ConnectionCancelQueryListener.ErrorTryingToCancelQuery.fmt.txt", source, source.getClass().getName());
                _logger.error(msg, e);
            }
        }
    }
}

