/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataservices;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.execution2.MLSValueInterface;
import java.text.DateFormat;
import java.text.ParseException;

@SASScope(value="ALL")
@SubjectToChange
public class PossibleFilterValue {
    @SASScope
    protected int _JDBCType;
    @SASScope
    protected Object _unformattedData;
    @SASScope
    protected String _formattedData;
    @SASScope
    protected MLSValueInterface _mlsValue;

    @SASScope
    public PossibleFilterValue(int columnType, Object unformattedData, String formattedData, MLSValueInterface mlsValue) {
        this._JDBCType = columnType;
        this._unformattedData = unformattedData;
        this._formattedData = formattedData;
        this._mlsValue = mlsValue;
    }

    @SASScope
    public String toString() {
        return this._formattedData;
    }

    public String getFormatted() throws DataServicesException {
        return this._formattedData;
    }

    @SASScope
    public void setFormatted(String formattedData) {
        this._formattedData = formattedData;
    }

    public Object getUnformatted() throws DataServicesException {
        return this._unformattedData;
    }

    @SASScope
    public void setUnformatted(String unformattedData) {
        switch (this._JDBCType) {
            case 12: {
                this._unformattedData = unformattedData;
                break;
            }
            case 8: {
                this._unformattedData = Double.valueOf(unformattedData);
                break;
            }
            case 91: {
                try {
                    this._unformattedData = DateFormat.getDateInstance().parse(unformattedData);
                    break;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    public int getJDBCType() {
        return this._JDBCType;
    }

    public MLSValueInterface getMlsValue() {
        return this._mlsValue;
    }

    public void setMlsValue(MLSValueInterface mlsValue) {
        this._mlsValue = mlsValue;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PossibleFilterValue)) {
            return false;
        }
        PossibleFilterValue otherPFV = (PossibleFilterValue)other;
        return this._JDBCType == otherPFV._JDBCType && (this._unformattedData == null ? otherPFV._unformattedData == null : this._unformattedData.equals(otherPFV._unformattedData)) && (this._formattedData == null ? otherPFV._formattedData == null : this._formattedData.equals(otherPFV._formattedData)) && (this._mlsValue == null ? otherPFV._mlsValue == null : this._mlsValue.equals(otherPFV._mlsValue));
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this._JDBCType;
        hash = hash * 31 + (this._unformattedData == null ? 0 : this._unformattedData.hashCode());
        hash = hash * 31 + (this._formattedData == null ? 0 : this._formattedData.hashCode());
        hash = hash * 31 + (this._mlsValue == null ? 0 : this._mlsValue.hashCode());
        return hash;
    }
}

