/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataservices;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.RBMessageFormatter;
import com.sas.util.RBBase;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class IQDataServicesResourceBundle
extends RBBase {
    private static final Logger _logger = LogManager.getLogger((String)"IQDataServicesResourceBundle.class");
    private static IQDataServicesResourceBundle defaultBundle = new IQDataServicesResourceBundle();
    private static final String EMPTY_STR = "";

    public static MessageFormatter getMessageFormatter(String resourceName, Object ... args) {
        return new RBMessageFormatter(defaultBundle, resourceName, args);
    }

    public static MessageFormatter getMessageFormatter(ExpressionInterface expr) {
        return IQDataServicesResourceBundle.getMessageFormatter("{0}", expr);
    }

    protected IQDataServicesResourceBundle() {
    }

    public IQDataServicesResourceBundle(String source) {
        super(source);
    }

    public IQDataServicesResourceBundle(String source, Locale locale) {
        super(source);
        this._getResources(locale);
    }

    public static String getStringResource(String classKey, String subKey) {
        String result = defaultBundle._getStringResource(classKey + subKey);
        if (result == null) {
            result = EMPTY_STR;
        }
        return result;
    }

    public static String getStringResource(String key) {
        String result = defaultBundle._getStringResource(key);
        if (result == null) {
            result = EMPTY_STR;
        }
        return result;
    }

    public static int getIntResource(String key) {
        return IQDataServicesResourceBundle.getIntResource(key, 0);
    }

    public static int getIntResource(String key, int notFoundReturnValue) {
        int result = Integer.MIN_VALUE;
        try {
            String strValue = IQDataServicesResourceBundle.getStringResource(key);
            result = Integer.parseInt(strValue);
        }
        catch (MissingResourceException mre) {
            result = notFoundReturnValue;
            _logger.debug("Missing Resource (" + key + ")");
        }
        catch (NumberFormatException nfe) {
            result = notFoundReturnValue;
            _logger.debug("Numeric format exception " + nfe.getMessage());
        }
        return result;
    }

    public static ResourceBundle getResources() {
        return defaultBundle._getResources();
    }

    public static String getMessageString(String key, Object ... args) {
        String pattern = IQDataServicesResourceBundle.getStringResource(key);
        return MessageFormat.format(pattern, args);
    }

    public String getString(String classKey, String subKey) {
        String key = classKey + subKey;
        String result = this._getStringResource(key);
        if (result == null) {
            result = IQDataServicesResourceBundle.getStringResource(key);
        }
        return result;
    }

    public String getString(String key) {
        String result = this._getStringResource(key);
        if (result == null) {
            result = IQDataServicesResourceBundle.getStringResource(key);
        }
        return result;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int notFoundReturnValue) {
        int result = Integer.MIN_VALUE;
        try {
            String strValue = this.getString(key);
            result = strValue.length() > 0 ? Integer.parseInt(strValue) : notFoundReturnValue;
        }
        catch (MissingResourceException mre) {
            result = notFoundReturnValue;
            _logger.debug("Missing Resource (" + key + ")");
        }
        catch (NumberFormatException nfe) {
            result = notFoundReturnValue;
            _logger.debug("Numeric format exception " + nfe.getMessage());
        }
        return result;
    }

    public ResourceBundle getResourceBundle() {
        return this._getResources();
    }

    public String messageString(String key, Object ... args) {
        String pattern = this._getStringResource(key);
        if (pattern == null) {
            pattern = IQDataServicesResourceBundle.getStringResource(key);
        }
        return MessageFormat.format(pattern, args);
    }
}

