/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataservices;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iom.SASMDX.ISession;
import com.sas.iquery.dataretrieval.ConnectionConfiguration;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.dataretrieval.QueryConnectorInterface;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataretrieval.SessionQueryConnectorsManager;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.dataservices.PossibleFilterValue;
import com.sas.iquery.execution.ConnectionCancelQueryListener;
import com.sas.iquery.execution.ConnectionRecycler;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.MDXInstruction;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.MLSResultSetInterface;
import com.sas.iquery.execution2.MLSValueInterface;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.intelligentquery.QueryConnectionInterface;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.NamedObjectInterface;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.CancelQuerySupport;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Governing;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.Lookup;
import com.sas.iquery.metadata.business.LookupByDataItem;
import com.sas.iquery.metadata.business.LookupByQuery;
import com.sas.iquery.metadata.business.LookupList;
import com.sas.iquery.metadata.business.LookupNotAllowed;
import com.sas.iquery.metadata.business.LookupValue;
import com.sas.iquery.metadata.business.Model;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.RequiredDataSources;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.impl.DataItemImpl;
import com.sas.iquery.metadata.business.impl.GoverningImpl;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.DateValueExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.TimeValueExpression;
import com.sas.iquery.metadata.expr.TimestampValueExpression;
import com.sas.iquery.metadata.expr.olap.BusinessGroupMemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.SlicerFilterExpression;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.impl.AbstractExpression;
import com.sas.iquery.metadata.physical.CalculatedMember;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.NamedSet;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadataInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.IQOLAPDataSet;
import com.sas.iquery.strategies.sas.oma.olap.util.ISessionCacheContainer;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXVariable;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPItemType;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import com.sas.iquery.strategies.sas.oma.olapv2.PreFilterDLLGeneration;
import com.sas.iquery.strategies.sas.oma.olapv2.step.MemberFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.StepManager;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.RelationalDataSelectionProcessor;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.OLAPUtilities;
import com.sas.metadata.MdException;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.embedded.TupleElement;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import com.sas.util.ChainedException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

@SASScope(value="ALL")
@SubjectToChange
public class IQDataServices {
    private static final Logger _logger = LogManager.getLogger((String)"IQDataServices.class");
    public static final int FORMATTED = 1;
    public static final int FORMATTED_UNFORMATTED = 3;
    public static final int REASONCODE_IDPROP_MUST_SAVE = -3;
    public static final int REASONCODE_VALIDATION_WARNING_NO_RESOURCES = -1;
    public static final int REASONCODE_VALIDATION_WARNING_TYPE_CAST = -2;
    public static final int UNFORMATTED = 2;
    @SASScope
    protected IntelligentQueryMetadataServiceInterface _iqService;
    private final int _maxRows = 1000;
    @SASScope
    protected QueryConnectionInterface _queryConnector = null;

    private static Map<String, List<String>> getElementMap(TupleElementInterface[] tupleElements, String cubeName, MetadataInterface olapMeta) throws OLAPException {
        LinkedHashMap<String, List<String>> dimList = new LinkedHashMap<String, List<String>>(5);
        AxisInterface axis = tupleElements[0].getTuple().getAxis();
        ResultSetMetadataInterface rsMI = axis.getResultSetMetadata();
        ResultSetInterface rsm = null;
        rsm = rsMI.getResultSet();
        if (rsm != null) {
            ResultSetMetadataInterface resultSetMetadata = rsm.getResultSetMetadata();
            AxisInterface[] axes = resultSetMetadata.getAxes(0, -1);
            Filter filter = new Filter();
            filter.setCubeName(cubeName);
            ArrayList<TupleElementInterface> elemList = new ArrayList<TupleElementInterface>();
            for (AxisInterface axe : axes) {
                TupleInterface[] tuplesA;
                int axisNum = axe.getAxisNumber();
                if (axisNum == -1) continue;
                int counter = 0;
                for (int i = 0; i < tupleElements.length; ++i) {
                    if (tupleElements[i].getTuple().getAxis().getAxisNumber() != axisNum) continue;
                    if (!tupleElements[i].isContextual() && tupleElements[i].getType() != TupleElementType.MEASURE) {
                        elemList.add(tupleElements[i]);
                    }
                    ++counter;
                }
                if (counter == 0) {
                    String[] uniqueLevelNames = axe.getUniqueLevelNames();
                    for (int i = 0; i < uniqueLevelNames.length; ++i) {
                        TupleInterface[] tuples = axe.getTuples(-12, -18);
                        TupleElementInterface[] elements = OLAPUtil.getTupleElementsForLevel((int)i, (TupleInterface[])tuples, (boolean)false, (int)-1);
                        for (int j = 0; j < elements.length; ++j) {
                            if (elements[j].isContextual() || elements[j].getType() == TupleElementType.MEASURE) continue;
                            elemList.add(elements[j]);
                        }
                    }
                    continue;
                }
                int lastElementIndex = tupleElements.length - 1;
                _logger.debug("Last element " + tupleElements[lastElementIndex]);
                if (tupleElements[lastElementIndex].getTuple().getAxis().getAxisNumber() != axisNum) continue;
                int minCoord = tupleElements[lastElementIndex].getMinimumCoordinate();
                int maxCoord = tupleElements[lastElementIndex].getMaximumCoordinate();
                for (TupleInterface element : tuplesA = axe.getTuples(minCoord, maxCoord - minCoord + 1)) {
                    TupleElementInterface[] elements;
                    for (TupleElementInterface element2 : elements = element.getElements(tupleElements[lastElementIndex].getTupleElementIndex() + 1, -1)) {
                        if (element2.isContextual() || element2.getType() == TupleElementType.MEASURE) continue;
                        elemList.add(element2);
                        _logger.debug("Adding " + element2);
                    }
                }
            }
            TupleElementInterface[] tupleElems = elemList.toArray(new TupleElementInterface[elemList.size()]);
            for (int index = 0; index < tupleElems.length; ++index) {
                Filter filter1 = new Filter();
                filter1.setCubeName(cubeName);
                filter1.setUniqueLevelName(tupleElems[index].getUniqueLevelName());
                if (tupleElems[index].getType() == TupleElementType.MEASURE) continue;
                LevelInterface level = olapMeta.getLevel(filter1);
                DimensionInterface dimension = level.getHierarchy().getDimension();
                String dimName = dimension.getName();
                List tupleL = dimList.containsKey(dimName) ? (List)dimList.get(dimName) : new ArrayList();
                if (!tupleL.contains(tupleElems[index].getName())) {
                    tupleL.add(tupleElems[index].getName());
                }
                dimList.put(dimName, tupleL);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("  DimList: " + dimList);
            }
        }
        return dimList;
    }

    private static String getExpressionText(ExpressionInterface expr) throws MetadataException {
        StringExpressionUtil stringExprUtil = StringExpressionUtil.getInstance();
        String expressionText = stringExprUtil.getText(expr);
        return expressionText;
    }

    private void extractTupleElements(List<TupleElementInterface> returnList, TupleInterface[] element) throws OLAPException {
        if (element.length > 0) {
            for (TupleInterface element2 : element) {
                TupleElementInterface[] tupleElements = element2.getElements(0, 1);
                TupleElementInterface firstTupleElement = tupleElements[0];
                TupleElement emTupleElement = OLAPConnectionInfoUtil.newEmbeddedTupleElement(firstTupleElement);
                emTupleElement.setContinued(true);
                returnList.add((TupleElementInterface)emTupleElement);
            }
        }
    }

    private static String buildWhereClauseForGetMembers(TupleElementInterface[] tupleElements, String cubeName, List<String> slicersTextList, MetadataInterface metaI) throws OLAPException {
        boolean hasSlicerFilter;
        String where = " ";
        boolean hasTupleElements = tupleElements != null && tupleElements.length > 0;
        boolean bl = hasSlicerFilter = slicersTextList.size() > 0;
        if (hasTupleElements || hasSlicerFilter) {
            Map<String, List<String>> elementMap = hasTupleElements ? IQDataServices.getElementMap(tupleElements, cubeName, metaI) : Collections.emptyMap();
            if (elementMap.size() == 0) {
                MDXGenerationUtil.applyDebugStatement("No Where needed to be constructed for this getMembers", IQDataServices.class);
            }
            StringBuilder whereClause = new StringBuilder();
            whereClause.append(" WHERE ");
            boolean isUseNonNestedCJ = Boolean.valueOf(System.getProperty("SASQueryServices.useNonNestedCrossJoin", "true"));
            String crossJoinString = "";
            crossJoinString = isUseNonNestedCJ ? IQDataServices.buildNonNestedCrossJoin(slicersTextList, elementMap) : IQDataServices.buildNestedCrossJoin(hasTupleElements, slicersTextList, elementMap);
            whereClause.append(crossJoinString);
            where = whereClause.toString();
        }
        return where;
    }

    private static String buildNestedCrossJoin(boolean hasTupleElements, List<String> slicersTextList, Map<String, List<String>> elementMap) {
        int i;
        boolean hasSlicerFilter = slicersTextList.size() > 0;
        int numDims = elementMap.size();
        int cj = 0;
        int cjSlicer = 0;
        int cjSlicerMore = 0;
        int ctSlicer = 0;
        Set<String> dimkeys = elementMap.keySet();
        Iterator<String> iter = dimkeys.iterator();
        Iterator<String> iterSlicer = slicersTextList.iterator();
        int slicerValues = slicersTextList.size();
        StringBuilder querySlicer = new StringBuilder();
        if (hasSlicerFilter && numDims > 0) {
            querySlicer.append("CROSSJOIN(");
            ++cjSlicerMore;
        }
        while (iterSlicer.hasNext()) {
            if (slicersTextList.size() >= 2) {
                querySlicer.append("CROSSJOIN(");
                ++cjSlicer;
            }
            querySlicer.append(iterSlicer.next());
            ++ctSlicer;
            if (--slicerValues <= 0) continue;
            querySlicer.append(",");
        }
        if (ctSlicer > 0) {
            for (int i2 = 0; i2 < cjSlicer; ++i2) {
                querySlicer.append(")");
            }
        }
        cjSlicer = 0;
        if (hasSlicerFilter && numDims > 0) {
            querySlicer.append(", ");
        }
        StringBuilder queryA = new StringBuilder();
        while (iter.hasNext()) {
            if (numDims >= 2) {
                queryA.append("CROSSJOIN(");
                ++cj;
            }
            List<String> elementList = elementMap.get(iter.next());
            queryA.append("{");
            int ct = 0;
            for (int i3 = 0; i3 < elementList.size(); ++i3) {
                String element = elementList.get(i3);
                if (element == null || element.length() <= 0) continue;
                queryA.append(element).append(", ");
                ++ct;
            }
            if (queryA.length() == 1) {
                queryA.delete(0, 1);
            }
            if (ct > 0) {
                queryA.setLength(queryA.length() - 2);
                queryA.append("}");
                querySlicer.append(queryA.toString());
                queryA.setLength(0);
            } else {
                --cj;
            }
            if (--numDims <= 0) continue;
            querySlicer.append(",");
        }
        for (i = 0; i < cj; ++i) {
            querySlicer.append(")");
        }
        for (i = 0; i < cjSlicerMore; ++i) {
            querySlicer.append(")");
        }
        return querySlicer.toString();
    }

    private static String buildNonNestedCrossJoin(List<String> slicersTextList, Map<String, List<String>> elementMap) {
        int numDims = elementMap.size();
        int numSlicers = slicersTextList.size();
        StringBuilder query = new StringBuilder();
        if (numSlicers + numDims >= 2) {
            query.append("CROSSJOIN(");
        }
        for (String string : slicersTextList) {
            query.append(string);
            query.append(",");
        }
        Set<String> dimkeys = elementMap.keySet();
        for (String dim : dimkeys) {
            query.append("{");
            List<String> elementList = elementMap.get(dim);
            for (String element : elementList) {
                if (element.length() <= 0) continue;
                query.append(element).append(", ");
            }
            int lastCommaPosition = query.lastIndexOf(",");
            if (lastCommaPosition >= query.length() - 2) {
                query.setLength(lastCommaPosition);
            }
            query.append("}, ");
        }
        int n = query.lastIndexOf(",");
        if (n >= query.length() - 2) {
            query.setLength(n);
        }
        if (numSlicers + numDims >= 2) {
            if (numSlicers + numDims > 2) {
                query.append(",").append(numSlicers + numDims);
            }
            query.append(")");
        }
        return query.toString();
    }

    private MessageFormatter _formatMismatchedTypeMsg(String msgKey, Object obj, int dataItemType, int resultExpressionType, boolean hasPDJulFormat) {
        String objString = null;
        objString = obj instanceof BusinessModelResource ? ((BusinessModelResource)obj).getIdentityString() : (obj instanceof NamedObjectInterface ? ((NamedObjectInterface)obj).getLabel() : "" + obj);
        int typeToConvert = dataItemType;
        if (typeToConvert == 2 && hasPDJulFormat) {
            typeToConvert = 4;
        }
        String dataItemTypeString = IQDataServices.convertExpressionTypeToString(typeToConvert);
        typeToConvert = resultExpressionType;
        if (typeToConvert == 2 && hasPDJulFormat) {
            typeToConvert = 4;
        }
        String resultExpressionTypeString = IQDataServices.convertExpressionTypeToString(typeToConvert);
        return IQDataServicesResourceBundle.getMessageFormatter(msgKey, objString, dataItemTypeString, resultExpressionTypeString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _verifyOLAPItem(BusinessModel businessModel, BusinessItem item) throws DataServicesException {
        DataSelection selection = DataSelectionFactory.newDataSelection(businessModel);
        SessionContextInterface session = businessModel.getSession();
        Map<String, com.sas.iquery.execution2.ResultSetInterface> resultMap = null;
        QueryConnectionInterface myQueryConnection = null;
        try {
            block28: {
                try {
                    RequiredDataSources rds = selection.newRequiredDataSources();
                    rds.setDataSources(Collections.emptyList());
                    selection.addBusinessRule(rds);
                    if (item instanceof DataItem) {
                        DataItem di = (DataItem)item;
                        DataItemReference dataItemReference = selection.newDataItemReference(di);
                        selection.addBusinessItem(dataItemReference);
                        selection.addResultItem(dataItemReference, Role.COLUMN);
                        break block28;
                    }
                    if (item instanceof FilterItem) {
                        FilterItem f = (FilterItem)item;
                        this.addItemForVerifyingOLAPFilter(businessModel, f, selection);
                        FilterItem filter = selection.newFilterItem();
                        filter.setExpression(f.getExpression());
                        filter.setLabel(f.getLabel());
                        selection.addBusinessItem(filter);
                        selection.setFilters(Collections.singletonList(filter));
                        List<Reason> reasons = selection.getReasonsNotValid();
                        if (!reasons.isEmpty()) {
                            String queryID = selection.getID();
                            MessageFormatter message = this.formatReasonsBasedMessage("DataServices.InvalidDataSelection.Message.fmt.txt", queryID, reasons);
                            DataServicesException e = new DataServicesException(message, reasons);
                            throw e;
                        }
                        break block28;
                    }
                    throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.InvalidItem.Message.txt", new Object[0]));
                }
                catch (MetadataException me) {
                    throw new DataServicesException(me);
                }
            }
            myQueryConnection = this.getQueryConnector(session, 1);
            try {
                List<DataSelection> selections = Collections.singletonList(selection);
                resultMap = myQueryConnection.retrieveQueryResultMap(selections);
            }
            catch (IntelligentQueryException ie) {
                MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.UnableToVerify.Message.fmt.txt", this.getExpressionText(item));
                _logger.info((Object)message, (Throwable)ie);
                throw new DataServicesException(message, (Throwable)ie);
            }
            String modelID = selection.getID();
            com.sas.iquery.execution2.ResultSetInterface iqResultSet = resultMap.get(modelID);
            if (item instanceof DataItem) {
                OLAPDataSet olapDS = (OLAPDataSet)iqResultSet.getResultSet();
                try {
                    olapDS.getCells(0L, 0L);
                }
                catch (OLAPException oe) {
                    MessageFormatter errorMsg = IQDataServicesResourceBundle.getMessageFormatter("DataServices.UnableToVerify.Message.fmt.txt", this.getExpressionText(item));
                    _logger.error((Object)errorMsg, (Throwable)oe);
                    throw new DataServicesException(errorMsg, (Throwable)oe);
                }
                try {
                    AxisInterface columnAxis = OLAPConnectionInfoUtil.getAxisInQuery(olapDS);
                    String[] dimNames = columnAxis.getDimensionNames();
                    if (dimNames.length == 0) {
                        MessageFormatter errorMsg = IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExpressionGeneratesNoResult.Message.txt", new Object[0]);
                        throw new DataServicesException(errorMsg);
                    }
                    String dimName = dimNames[0];
                    MetadataInterface olapMeta = olapDS.getDatabaseMetadata();
                    String cubeName = olapDS.getCubeName();
                    Filter filter = new Filter();
                    filter.setCubeName(cubeName);
                    filter.setDimensionName(dimName);
                    DimensionInterface[] dimensions = olapMeta.getDimensions(filter);
                    if (dimensions.length == 0) {
                        MessageFormatter errorMsg = IQDataServicesResourceBundle.getMessageFormatter("DataServices.ExpressionGeneratesNoResult.Message.txt", new Object[0]);
                        throw new DataServicesException(errorMsg);
                    }
                    DimensionInterface dimension = dimensions[0];
                    if (dimNames.length > 1) {
                        for (int i = 0; i < dimNames.length; ++i) {
                            dimName = dimNames[i];
                            int dimCount = 0;
                            for (int j = 0; j < dimNames.length; ++j) {
                                if (dimName.equals(dimNames[j])) continue;
                                ++dimCount;
                            }
                            if (dimCount <= 0) continue;
                            MessageFormatter errorMsg = IQDataServicesResourceBundle.getMessageFormatter("DataServices.OLAPMoreThanOneDim.txt", new Object[0]);
                            throw new DataServicesException(errorMsg);
                        }
                    }
                    int dimensionType = dimension.getType();
                    DataItem di = (DataItem)item;
                    int diType = di.getExpressionType();
                    if (dimensionType == 2) {
                        ExpressionInterface expr = di.getExpression();
                        String eString = null;
                        try {
                            eString = IQDataServices.getExpressionText(expr);
                            if (eString.trim().length() > 10 && eString.trim().substring(0, 10).equalsIgnoreCase("Dimensions")) {
                                diType = 2;
                            }
                        }
                        catch (MetadataException e) {
                            _logger.debug("Metadata exception encountered getting expression text" + di.toString() + " " + e.getLocalizedMessage());
                        }
                    }
                    if (diType != 0) {
                        MessageFormatter errorMsg;
                        String iqTypeString;
                        if (dimensionType == 2) {
                            if (diType != 2) {
                                iqTypeString = IQDataServicesResourceBundle.getStringResource("DataServices.ExpressionType.OLAPMeasure.txt");
                                errorMsg = IQDataServicesResourceBundle.getMessageFormatter("DataServices.IncorrectType.fmt.txt", iqTypeString);
                                throw new DataServicesException(errorMsg);
                            }
                        } else if (diType != 3) {
                            iqTypeString = IQDataServicesResourceBundle.getStringResource("DataServices.ExpressionType.OLAPCategory.txt");
                            errorMsg = IQDataServicesResourceBundle.getMessageFormatter("DataServices.IncorrectType.fmt.txt", iqTypeString);
                            throw new DataServicesException(errorMsg);
                        }
                    }
                }
                catch (OLAPException oe) {
                    String message = IQDataServicesResourceBundle.getStringResource("DataServices.OLAPDimNotDetermined.txt");
                    _logger.error(message, (Throwable)oe);
                }
            }
            this.closeMyQueryConnection(session, resultMap, myQueryConnection);
        }
        catch (Throwable throwable) {
            this.closeMyQueryConnection(session, resultMap, myQueryConnection);
            selection.dispose();
            throw throwable;
        }
        selection.dispose();
    }

    private void closeMyQueryConnection(SessionContextInterface session, Map<String, com.sas.iquery.execution2.ResultSetInterface> resultMap, QueryConnectionInterface myQueryConnection) {
        if (this._queryConnector == null && myQueryConnection instanceof QueryConnector) {
            try {
                IQDataServices.closeQueryConnector((QueryConnector)myQueryConnection, session, resultMap);
            }
            catch (Exception e) {
                _logger.warn((Object)e);
            }
        } else if (resultMap != null) {
            for (com.sas.iquery.execution2.ResultSetInterface iqResultSet : resultMap.values()) {
                if (iqResultSet == null) continue;
                try {
                    IQDataServices.closeResultSet(myQueryConnection, iqResultSet);
                }
                catch (ExecutionException e) {
                    _logger.warn((Object)e);
                }
            }
        }
    }

    private void _verifyRelationalItem(BusinessModel businessModel, BusinessItem item) throws DataServicesException {
        boolean hasDataSource = true;
        this._verifyValidProcSqlStatement(businessModel, item);
        DataSelection selection = DataSelectionFactory.newDataSelection(businessModel);
        SessionContextInterface session = businessModel.getSession();
        Map<String, com.sas.iquery.execution2.ResultSetInterface> resultMap = null;
        QueryConnectionInterface myQueryConnection = null;
        try {
            DataItem di;
            int diType;
            try {
                SimpleConditionalExpression_Comparison expression;
                RequiredDataSources rds = selection.newRequiredDataSources();
                rds.setDataSources(Collections.emptyList());
                selection.addBusinessRule(rds);
                selection.setLabel("1");
                selection.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, true);
                selection.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
                if (item instanceof DataItem) {
                    DataItemReference dataItemReference = selection.newDataItemReference((DataItem)item);
                    selection.addBusinessItem(dataItemReference);
                    selection.addResultItem(dataItemReference, Role.COLUMN);
                } else if (item instanceof FilterItem) {
                    FilterItem f = (FilterItem)item;
                    List<DataItem> dataitems = f.getDataItems(65535);
                    int id = 0;
                    List<QualifiedColumn> physicalColumns = f.getResources(QualifiedColumn.class, 0);
                    for (QualifiedColumn qc : physicalColumns) {
                        boolean used = false;
                        Iterator<DataItem> iter2 = dataitems.iterator();
                        while (iter2.hasNext() && !used) {
                            DataItem dataitem = iter2.next();
                            List<QualifiedColumn> diUsedQcs = dataitem.getResources(QualifiedColumn.class, 65535);
                            if (!diUsedQcs.contains(qc)) continue;
                            used = true;
                        }
                        if (used) continue;
                        RootDataItem dummy = selection.newDataItem();
                        dummy.setExpression(qc);
                        dummy.setLabel(qc.getDbmsName());
                        dummy.setResultSetID("RSID_VERIFY_PHY_" + ++id);
                        dataitems.add(dummy);
                        selection.addBusinessItem(dummy);
                    }
                    if (dataitems.size() > 0) {
                        for (DataItem dataItem : dataitems) {
                            selection.addResultItem(dataItem, Role.COLUMN);
                        }
                    } else {
                        DataItem dataItem;
                        StringExpression expression2 = new StringExpression();
                        expression2.setText("COUNT(*)");
                        expression2.setExpressionType(2);
                        dataItem = selection.newDataItem();
                        dataItem.setLabel("Count");
                        dataItem.setExpression(expression2);
                        selection.addBusinessItem(dataItem);
                        selection.addResultItem(dataItem, Role.COLUMN);
                    }
                    FilterItem filter = selection.newFilterItem();
                    filter.setExpression(f.getExpression());
                    filter.setLabel(f.getLabel());
                    selection.addBusinessItem(filter);
                    selection.setFilters(Collections.singletonList(filter));
                } else {
                    MessageFormatter errorMsg = IQDataServicesResourceBundle.getMessageFormatter("DataServices.InvalidItem.Message.txt", new Object[0]);
                    throw new DataServicesException(errorMsg);
                }
                hasDataSource = this.addHiddenItemIfNecessary(businessModel, item, selection);
                ConstantExpression right = new ConstantExpression();
                right.setValue("1");
                right.setExpressionType(2);
                ConstantExpression left = new ConstantExpression();
                left.setValue("0");
                left.setExpressionType(2);
                FilterItem myFilter = selection.newFilterItem();
                SimpleConditionalExpression_Comparison condExpr = expression = new SimpleConditionalExpression_Comparison();
                condExpr.setLeftExpression(left);
                condExpr.setComparisonOperator(ComparisonOperator.COMPARE_EQ);
                condExpr.setRightExpression(right);
                myFilter.setExpression(condExpr);
                myFilter.setLabel("BIQZeroEqOne");
                List<FilterItem> filters = selection.getFilters();
                filters.add(myFilter);
                selection.addBusinessItem(myFilter);
                selection.setFilters(filters);
                Governing governing = selection.newGoverning();
                governing.setOutputObservations(1);
                if (governing instanceof GoverningImpl) {
                    ((GoverningImpl)governing).setInputObservations(0);
                }
                selection.addBusinessRule(governing);
            }
            catch (MetadataException me) {
                throw new DataServicesException(me);
            }
            List<Reason> reasons = selection.getReasonsNotValid();
            if (!reasons.isEmpty()) {
                String queryID = selection.getID();
                MessageFormatter message = this.formatReasonsBasedMessage("DataServices.InvalidDataSelection.Message.fmt.txt", queryID, reasons);
                DataServicesException e = new DataServicesException(message, reasons);
                throw e;
            }
            myQueryConnection = this.getQueryConnector(session, 0);
            if (_logger.isDebugEnabled() && myQueryConnection instanceof QueryConnector) {
                try {
                    String queryString = ((QueryConnector)myQueryConnection).getPhysicalQuery(selection);
                    _logger.debug("SQL: " + queryString);
                }
                catch (IntelligentQueryException e) {
                    _logger.debug("IntelligentQueryException: " + e.getDetailMessage());
                }
            }
            com.sas.iquery.execution2.ResultSetInterface iqResultSet = null;
            try {
                List<DataSelection> selections = Collections.singletonList(selection);
                resultMap = myQueryConnection.retrieveQueryResultMap(selections);
                iqResultSet = resultMap.get(selection.getID());
            }
            catch (IntelligentQueryException ie) {
                MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.UnableToVerify.Message.fmt.txt", this.getExpressionText(item));
                _logger.error((Object)message, (Throwable)ie);
                throw new DataServicesException(message, (Throwable)ie);
            }
            if (item instanceof DataItem && (diType = (di = (DataItem)item).getExpressionType()) != 0) {
                if (iqResultSet == null) {
                    MessageFormatter errorMsg = IQDataServicesResourceBundle.getMessageFormatter("DataServices.NoResultSet.txt", new Object[0]);
                    throw new DataServicesException(errorMsg);
                }
                ResultSet sqlRS = (ResultSet)iqResultSet.getResultSet();
                ResultSetMetaData rsMeta = sqlRS.getMetaData();
                int nCols = rsMeta.getColumnCount();
                if (nCols >= 1) {
                    int jdbcType = rsMeta.getColumnType(1);
                    int iqTypeFromResult = ExpressionUtil.getExprType(jdbcType);
                    int pdjulPos = -1;
                    String sasFormatRaw = rsMeta.getColumnTypeName(1);
                    if (sasFormatRaw != null) {
                        String sasFormat = sasFormatRaw.toUpperCase();
                        String pdjulFormat = "PDJUL";
                        pdjulPos = sasFormat.indexOf(pdjulFormat);
                    }
                    boolean hasPDJulFormat = false;
                    if (pdjulPos > -1) {
                        hasPDJulFormat = true;
                    }
                    if (!(iqTypeFromResult == diType && !hasPDJulFormat || iqTypeFromResult == 2 && diType == 9 || iqTypeFromResult == 2 && diType == 4 && hasPDJulFormat || iqTypeFromResult == 2 && (diType == 8 || diType == 7))) {
                        if (!(iqTypeFromResult != 2 || diType != 4 && diType != 5 && diType != 6 || hasPDJulFormat)) {
                            throw new DataServicesException(this._formatMismatchedTypeMsg("DataServices.WarnAboutPossibleTypeMismatch.Message.fmt.txt", di, diType, iqTypeFromResult, hasPDJulFormat), -2);
                        }
                        if (!(iqTypeFromResult != 4 && iqTypeFromResult != 5 && iqTypeFromResult != 6 || diType != 2 || hasPDJulFormat)) {
                            throw new DataServicesException(this._formatMismatchedTypeMsg("DataServices.WarnAboutPossibleTypeMismatch.Message.fmt.txt", di, diType, iqTypeFromResult, hasPDJulFormat), -2);
                        }
                        if (!(iqTypeFromResult != 4 && iqTypeFromResult != 5 && iqTypeFromResult != 6 || diType != 4 && diType != 5 && diType != 6 || hasPDJulFormat)) {
                            throw new DataServicesException(this._formatMismatchedTypeMsg("DataServices.WarnAboutPossibleTypeMismatch.Message.fmt.txt", di, diType, iqTypeFromResult, hasPDJulFormat), -2);
                        }
                        int typeToConvert = iqTypeFromResult;
                        if (typeToConvert == 2 && hasPDJulFormat) {
                            typeToConvert = 4;
                        }
                        throw new DataServicesException(this._formatMismatchedTypeMsg("DataServices.ErrorAboutTypeMismatch.Message.fmt.txt", di, diType, iqTypeFromResult, hasPDJulFormat));
                    }
                } else {
                    throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.UnableToVerify.txt", new Object[0]));
                }
            }
            this.closeMyQueryConnection(session, resultMap, myQueryConnection);
        }
        catch (SQLException se) {
            try {
                Throwable t = ChainedException.getRootException((Throwable)se);
                if (t == null) {
                    t = se;
                }
                _logger.error(se.getMessage(), t);
                throw new DataServicesException(se);
            }
            catch (Throwable throwable) {
                this.closeMyQueryConnection(session, resultMap, myQueryConnection);
                selection.dispose();
                throw throwable;
            }
        }
        selection.dispose();
        if (!hasDataSource) {
            throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.WarnAboutNoDataSource.Message.txt", new Object[0]), -1);
        }
    }

    private void _verifyValidProcSqlStatement(BusinessModel businessModel, BusinessItem item) throws DataServicesException {
        ExpressionInterface expr = null;
        if (item instanceof DataItem) {
            DataItem di = (DataItem)item;
            expr = di.getExpression();
        } else if (item instanceof FilterItem) {
            FilterItem fi = (FilterItem)item;
            expr = fi.getExpression();
        }
        String exprText = null;
        try {
            if (expr instanceof ResourceAwareStringExpression) {
                ResourceAwareStringExpression rase = (ResourceAwareStringExpression)expr;
                HashMap<BusinessModelResource, String> resourceMap = new HashMap<BusinessModelResource, String>();
                List<BusinessModelResource> businessModelResources = expr.getResources(BusinessModelResource.class, 65535);
                int i = 0;
                for (BusinessModelResource bmr : businessModelResources) {
                    resourceMap.put(bmr, "X" + i);
                    ++i;
                }
                exprText = StringExpressionUtil.getInstance().getText(rase, resourceMap);
            } else {
                exprText = StringExpressionUtil.getInstance().getText(expr, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, businessModel);
            }
        }
        catch (MetadataException e) {
            throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.NoExpression.Message.txt", new Object[0]), (Throwable)e);
        }
        if (exprText == null) {
            throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.NoExpression.Message.txt", new Object[0]));
        }
        int last = 0;
        boolean inQuote = false;
        boolean inComment = false;
        char quoteChar = '\u0000';
        boolean inStartOfStatement = true;
        int len = exprText.length();
        for (int i = 0; i < len; ++i) {
            char ch = exprText.charAt(i);
            if (ch == ';' && !inQuote && !inComment) {
                throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.InvalidSemicolonFound.fmt.txt", i + 1));
            }
            if (inStartOfStatement && (ch == '*' || exprText.regionMatches(true, i, "COMMENT", 0, 7))) {
                throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.InvalidSASCommentFound.fmt.txt", i + 1));
            }
            if (inStartOfStatement && ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n' && ch != '\f') {
                inStartOfStatement = false;
            }
            if (inQuote) {
                if (ch != quoteChar) continue;
                inQuote = false;
                quoteChar = '\u0000';
                continue;
            }
            if (inComment) {
                if (ch != '*' || len <= i + 1 || exprText.charAt(i + 1) != '/') continue;
                inComment = false;
                continue;
            }
            if (ch == '-' && len > i + 1 && exprText.charAt(i + 1) == '-') {
                throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.InvalidEolnCommentFound.fmt.txt", i + 1));
            }
            if (ch == '/' && len > i + 1 && exprText.charAt(i + 1) == '*') {
                inComment = true;
                last = i;
                continue;
            }
            if (ch != '\'' && ch != '\"') continue;
            inQuote = true;
            quoteChar = ch;
            last = i;
        }
        if (inComment) {
            throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.InvalidUnclosedComment.fmt.txt", last + 1));
        }
        if (inQuote) {
            throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.InvalidUnclosedQuote.fmt.txt", last + 1));
        }
    }

    private boolean addHiddenItemIfNecessary(BusinessModel businessModel, BusinessItem item, BusinessQuery query) throws MetadataException {
        List<DataSourceTable> tableObjects;
        List<QualifiedColumn> resources;
        boolean hasDataSource = true;
        if (item instanceof DataItemReference) {
            while (item instanceof DataItemReference) {
                item = ((DataItemReference)item).getBaseDataItem();
            }
        }
        if ((resources = item.getResources(QualifiedColumn.class, 65535)).isEmpty() && !(tableObjects = businessModel.getObjects(true, DataSourceTable.class)).isEmpty()) {
            DataSourceTable dsTable = tableObjects.get(0);
            List<Column> columns = dsTable.getColumns();
            Column column = columns.get(0);
            RootDataItem hiddenItem = query.getBusinessModel().newDataItem();
            hiddenItem.setExpression(column);
            hiddenItem.setIsHidden(true);
            String name = column.getLabel() + "_hidden";
            hiddenItem.setLabel(name);
            query.getBusinessModel().addBusinessItem(hiddenItem);
            query.addResultItem(hiddenItem, Role.HIDDEN);
            hasDataSource = false;
        }
        return hasDataSource;
    }

    private void addItemForVerifyingOLAPFilter(BusinessModel businessModel, FilterItem item, DataSelection selection) throws MetadataException, DataServicesException {
        List<DataItem> resources = item.getDataItems(0);
        DataItem baseItem = resources.get(0);
        if (baseItem != null) {
            DataItemReference dataItemReference = selection.newDataItemReference(baseItem);
            selection.addBusinessItem(dataItemReference);
            selection.addResultItem(dataItemReference, Role.COLUMN);
        } else {
            DataSourceCube dsCube = OLAPConnectionInfoUtil.getCube(selection);
            List<Measure> measureItems = dsCube.getMeasures();
            Measure measureItem = measureItems.get(0);
            if (measureItem == null) {
                throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ErrorNoMeasure.txt", new Object[0]));
            }
            RootDataItem filterDataItem = selection.getBusinessModel().newDataItem();
            filterDataItem.setExpression(measureItem);
            filterDataItem.setIsHidden(false);
            String name = measureItem.getLabel();
            filterDataItem.setLabel(name);
            selection.addBusinessItem(filterDataItem);
            selection.addResultItem(filterDataItem, Role.COLUMN);
        }
    }

    private String buildMDX(MDXVariable mdxVariable, DataItem dataItem, MetadataInterface metaI, DataSelection dataSelection, String cubeName) throws DataServicesException {
        String mdx = null;
        if (dataItem.getExpression() instanceof ResourceAwareStringExpression) {
            mdx = MDXGenerationUtil.buildMemberQuery(mdxVariable.getMDXPhrase(), cubeName, mdxVariable.getLabel(), true);
            if (dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
                mdx = MDXGenerationUtil.buildMeasureQuery(mdxVariable.getMDXPhrase(), cubeName, mdxVariable.getLabel(), true);
            }
        } else {
            mdxVariable.setAggregateOn(false);
            mdxVariable.getMDXForFilter();
            mdx = dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_MEASURE) ? MDXGenerationUtil.buildMeasureQuery(mdxVariable.getMDXExpression(), cubeName, mdxVariable.getLabel(), false) : MDXGenerationUtil.buildMemberQuery(mdxVariable.getMDXExpression(), cubeName, mdxVariable.getLabel(), false);
        }
        if (mdx == null) {
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, dataItem, cubeName, IQDataServicesResourceBundle.getStringResource("OLAPConnectionInfoUtilBadDataSource.txt"));
            DataServicesException e = new DataServicesException(msF);
            throw e;
        }
        return mdx;
    }

    private MDXVariable buildMDXVariable(DataItem dataItem, MetadataInterface metaI, DataSelection dataSelection, OLAPValues olapValues, int stepNumber, boolean buildMDXOnFly) throws GenerationException {
        MDXVariable mdxVariable = new MDXVariable(metaI, dataItem, true, dataSelection);
        if (dataItem.hasSteps()) {
            StepManager stepManager = new StepManager(dataItem, stepNumber);
            mdxVariable.setSteps(stepManager, dataSelection);
        }
        String hierarchyName = (String)olapValues.getOLAPValue(dataItem, OLAPItemType.HIERNAME);
        mdxVariable.setLabel(hierarchyName, dataItem.getLabel());
        if (buildMDXOnFly) {
            mdxVariable.getMDXPhrase();
        }
        return mdxVariable;
    }

    private OLAPValues buildOLAPValues(MetadataInterface metaI, DataSelection dataSelection, DataItem dataItem) throws GenerationException {
        ArrayList<DataItem> onFlyResultItems = new ArrayList<DataItem>();
        onFlyResultItems.add(dataItem);
        OLAPValues olapValues = new OLAPValues(metaI, onFlyResultItems, dataSelection);
        return olapValues;
    }

    @SASScope
    public static String convertExpressionTypeToString(int expressionType) {
        String expString = null;
        switch (expressionType) {
            case 0: {
                expString = IQDataServicesResourceBundle.getStringResource("DataServices.ExpressionType.NotSet.txt");
                break;
            }
            case 3: {
                expString = IQDataServicesResourceBundle.getStringResource("DataServices.ExpressionType.Character.txt");
                break;
            }
            case 2: {
                expString = IQDataServicesResourceBundle.getStringResource("DataServices.ExpressionType.Numeric.txt");
                break;
            }
            case 5: {
                expString = IQDataServicesResourceBundle.getStringResource("DataServices.ExpressionType.Time.txt");
                break;
            }
            case 4: {
                expString = IQDataServicesResourceBundle.getStringResource("DataServices.ExpressionType.Date.txt");
                break;
            }
            case 6: {
                expString = IQDataServicesResourceBundle.getStringResource("DataServices.ExpressionType.TimeStamp.txt");
                break;
            }
            case 9: {
                expString = IQDataServicesResourceBundle.getStringResource("DataServices.ExpressionType.Boolean.txt");
                break;
            }
            case 1: {
                expString = IQDataServicesResourceBundle.getStringResource("DataServices.ExpressionType.BitString.txt");
                break;
            }
            case 7: {
                expString = IQDataServicesResourceBundle.getStringResource("DataServices.ExpressionType.IntervalYearMonth.txt");
                break;
            }
            case 8: {
                expString = IQDataServicesResourceBundle.getStringResource("DataServices.ExpressionType.IntervalDateTime.txt");
                break;
            }
            case 10: {
                expString = IQDataServicesResourceBundle.getStringResource("DataServices.ExpressionType.Enumeration.txt");
                break;
            }
            case 11: {
                expString = IQDataServicesResourceBundle.getStringResource("DataServices.ExpressionType.UnquotedCharacter.txt");
                break;
            }
            default: {
                expString = IQDataServicesResourceBundle.getStringResource("DataServices.ExpressionType.NotSet.txt");
            }
        }
        return expString;
    }

    private PossibleFilterValue copyRequestedData(PossibleFilterValue distinctVal, int dataToReturn) throws DataServicesException {
        PossibleFilterValue returnValue = distinctVal;
        if (!this.isReturnFormattedData(dataToReturn)) {
            distinctVal.setFormatted(distinctVal.getUnformatted().toString());
        }
        if (!this.isReturnUnformattedData(dataToReturn)) {
            ConstantExpression constantData = new ConstantExpression();
            constantData.setValue(distinctVal.getFormatted());
            constantData.setExpressionType(3);
            returnValue = new PossibleFilterValue(1, constantData, distinctVal.getFormatted(), distinctVal.getMlsValue());
        }
        return returnValue;
    }

    MessageFormatter formatReasonsBasedMessage(String msgKey, String objectId, List<Reason> reasons) {
        MessageFormatter reasonListFormatter = Reason.getMessageFormatter(null, reasons, true);
        return IQDataServicesResourceBundle.getMessageFormatter(msgKey, objectId, reasonListFormatter);
    }

    private static String buildSlicerExpressionForGetMembers(DataSelection model, FilterItem filter, String hierName, String level) throws GenerationException {
        StepInterface step;
        String returnValue = hierName + ".[" + level + "].MEMBERS";
        String filterId = null;
        ExpressionInterface filterExpression = filter.getExpression();
        try {
            filterId = filter.getID();
        }
        catch (InvalidIDException e) {
            throw new GenerationException(e);
        }
        if (filterId == null) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationNullFilterId.txt", new Object[0]);
            throw new GenerationException(message);
        }
        boolean isOldByGroup = MDXGenerationUtil.isOldByGroupExpression(filterExpression, model, filterId, filter);
        if ((filterExpression instanceof SlicerFilterExpression || isOldByGroup) && (step = MDXGenerationUtil.generateStepsForFilterExpression(filterExpression)) != null) {
            returnValue = MemberFilter.getMDXExpression(model, returnValue, (DataItemMemberFilter)step);
        }
        return returnValue;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getAvailableLevels(DataItem dataItem, BusinessQuery businessQuery) throws DataServicesException {
        IQMetadataInterface metaI;
        ArrayList<String> returnList;
        block36: {
            Preconditions.ensureNonNull(dataItem, "dataItem");
            returnList = new ArrayList<String>();
            RetrievalPolicy policy = this.getQueryPolicy();
            String constructor = "DEFAULT_CONSTRUCTOR_BEHAVIOR";
            BusinessModel businessModel = null;
            boolean disposeDataSelection = false;
            metaI = null;
            OLAPConnectionResource olapConnection = null;
            Model dataSelection = null;
            try {
                Locale connectionLocale;
                String cacheKey;
                businessModel = OLAPUtilities.findBusinessModel(null, businessQuery, dataItem);
                dataSelection = OLAPUtilities.findDataSelection(businessQuery, businessModel);
                if (dataSelection == null) {
                    disposeDataSelection = true;
                    dataSelection = OLAPUtilities.createDataSelection(businessModel, dataItem);
                }
                if (!dataSelection.getStructure().isOLAP()) {
                    MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoValidModel.txt", new Object[0]);
                    ConnectionUtil.LoggerErrorWithObjects(_logger, message, dataSelection);
                    throw new DataServicesException(message);
                }
                DataSourceCube dataCube = OLAPUtilities.findDataSourceCube((BusinessModel)dataSelection);
                String cubeName = OLAPUtilities.findCubeName(dataCube);
                SoftwareServer softwareServer = OLAPUtilities.findSoftwareServer(dataCube);
                LogicalServerInterface logicalServer = OLAPUtilities.findLogicalServerInterface(softwareServer);
                SessionContextInterface sessionContext = businessModel.getSession();
                ConnectionRecycler recycler = ConnectionUtil.getConnectionRecycler(sessionContext);
                Locale viewerLocale = LocaleUtilities.getDefaultViewerLocale(sessionContext);
                viewerLocale = IOMServerUtils.negotiateStoredCubeLocale(dataCube, viewerLocale, dataSelection.getComputationalLocale());
                UserContextInterface userContext = ConnectionUtil.getUserContext(sessionContext);
                ConnectionInterface connection = ConnectionUtil.findConnection(recycler, (DataSelection)dataSelection, logicalServer, userContext, policy, viewerLocale);
                ConnectionInterface pfsConnection = ConnectionUtil.findPfsConnection(connection);
                olapConnection = OLAPUtilities.findOlapConnectionResource(pfsConnection);
                ISessionCacheContainer container = olapConnection.getISessionContainerFromCache(cacheKey = MDXGenerationUtil.buildCacheKey((BusinessModel)dataSelection, connectionLocale = olapConnection.getConnectionLocale((BusinessModel)dataSelection), constructor));
                if (container != null) {
                    ISession iSession = container.getISession();
                    try {
                        metaI = ConnectionResources.newIQMetadata(iSession, connectionLocale);
                    }
                    catch (OLAPException e1) {
                        MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("DataServices.ErrorGettingMembers.Message.txt", new Object[0]);
                        ConnectionUtil.LoggerErrorWithObjects(_logger, mft, new Object[]{dataSelection, connection, iSession, e1});
                        throw new ExecutionException(mft, (Throwable)e1);
                    }
                } else {
                    ConnectionCancelQueryListener postConnectionListener = new ConnectionCancelQueryListener((DataSelection)dataSelection, true, connection);
                    CancelQuerySupport.registerQueryListener((DataSelection)dataSelection, postConnectionListener, connection);
                    ConnectionUtil.LoggerDebugConnectionObtained(_logger, OLAPUtilities.class, connection);
                    metaI = olapConnection.createMetadataInterface((BusinessModel)dataSelection, constructor, dataCube, true, true, null);
                }
                if (!(metaI instanceof IQMetadataInterface)) {
                    MessageFormatter message1 = IQDataServicesResourceBundle.getMessageFormatter("OLAPStrategyNoMetadataI.txt", new Object[0]);
                    ConnectionUtil.LoggerErrorWithObjects(_logger, message1, dataSelection, metaI);
                    throw new ExecutionException(message1);
                }
                ExpressionInterface exp = dataItem.getExpression();
                OLAPValues olapValues = null;
                try {
                    LevelInterface[] levels;
                    olapValues = this.buildOLAPValues(metaI, (DataSelection)dataSelection, dataItem);
                    this.validateDDLFilter(cacheKey, olapValues, cubeName, olapConnection, (DataSelection)dataSelection);
                    Filter filter = new Filter();
                    filter.setCubeName(cubeName);
                    if (exp instanceof Dimension) {
                        String uniqueDimensionName = ((Dimension)exp).getUniqueName();
                        filter.setUniqueHierarchyName(uniqueDimensionName);
                    } else if (exp instanceof Hierarchy) {
                        String uniqueHierarchyName = ((Hierarchy)exp).getUniqueName();
                        filter.setUniqueHierarchyName(uniqueHierarchyName);
                    } else if (exp instanceof com.sas.metadata.Level) {
                        String uniqueOwningDimensionName = ((com.sas.metadata.Level)exp).getOwningDimension().getUniqueName();
                        filter.setUniqueLevelName(uniqueOwningDimensionName);
                    } else if (exp instanceof NamedSet) {
                        NamedSet namedSet = (NamedSet)exp;
                        Hierarchy hierarchy = namedSet.getOwningHierarchy();
                        String uniqueOwningHierarchyName = hierarchy.getUniqueName();
                        filter.setUniqueLevelName(uniqueOwningHierarchyName);
                    } else if (exp instanceof CalculatedMember) {
                        CalculatedMember calcMem = (CalculatedMember)exp;
                        String uniqueOwningHierarchyName = calcMem.getOwningHierarchy().getUniqueName();
                        filter.setUniqueLevelName(uniqueOwningHierarchyName);
                    }
                    try {
                        levels = metaI.getLevels(filter);
                    }
                    catch (OLAPException e) {
                        MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.ErrorGettingMembers.Message.txt", new Object[0]);
                        ConnectionUtil.LoggerErrorWithObjects(_logger, message, new Object[]{dataSelection, dataCube, dataItem, metaI, filter, e});
                        throw new DataServicesException(message, (Throwable)e);
                    }
                    for (int ct = 1; ct < levels.length; ++ct) {
                        String levelName;
                        LevelInterface level = levels[ct];
                        if (level == null) {
                            String message = IQDataServicesResourceBundle.getStringResource("OLAPValuesNullLevel.txt");
                            ConnectionUtil.LoggerErrorWithObjects(_logger, message, dataSelection, dataCube, dataItem);
                            continue;
                        }
                        try {
                            levelName = level.getName();
                        }
                        catch (OLAPException e) {
                            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationLevelNameException.txt", new Object[0]);
                            ConnectionUtil.LoggerErrorWithObjects(_logger, message, new Object[]{dataSelection, dataCube, dataItem, level, e});
                            throw new DataServicesException(message, (Throwable)e);
                        }
                        returnList.add(levelName);
                    }
                }
                catch (MetadataException e) {
                    MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.MetadataException.Message.txt", new Object[0]);
                    ConnectionUtil.LoggerErrorWithObjects(_logger, message, dataSelection, dataCube, dataItem, exp, e);
                    throw new DataServicesException(message, (Throwable)e);
                }
                catch (MdException e) {
                    MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.MetadataException.Message.txt", new Object[0]);
                    ConnectionUtil.LoggerErrorWithObjects(_logger, message, new Object[]{dataSelection, dataCube, dataItem, exp, e});
                    throw new DataServicesException(message, (Throwable)e);
                }
                finally {
                    if (olapValues != null) {
                        olapValues.release();
                    }
                }
                if (!disposeDataSelection) break block36;
            }
            catch (MetadataException e) {
                try {
                    MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.MetadataException.Message.txt", new Object[0]);
                    ConnectionUtil.LoggerErrorWithObjects(_logger, message, e, businessModel, dataSelection, dataItem);
                    throw new ExecutionException(message, (Throwable)e);
                    catch (DataServicesException e2) {
                        message = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoMetadata.txt", new Object[0]);
                        ConnectionUtil.LoggerErrorWithObjects(_logger, e2, message, dataSelection, olapConnection);
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    if (disposeDataSelection) {
                        dataSelection.dispose();
                    }
                    if (metaI == null) throw throwable;
                    BusinessQueryOLAPUtil.releaseMetadataInterface(metaI);
                    throw throwable;
                }
            }
            dataSelection.dispose();
        }
        if (metaI == null) return returnList;
        BusinessQueryOLAPUtil.releaseMetadataInterface(metaI);
        return returnList;
    }

    public QueryConnectionInterface getConnection() {
        return this._queryConnector;
    }

    private String getExpressionText(BusinessItem item) {
        String exprText = null;
        ExpressionInterface expr = null;
        if (item instanceof DataItem) {
            DataItem di = (DataItem)item;
            expr = di.getExpression();
        } else if (item instanceof FilterItem) {
            FilterItem fi = (FilterItem)item;
            expr = fi.getExpression();
        }
        if (expr != null) {
            StringExpressionUtil stringUtil = StringExpressionUtil.getInstance();
            try {
                exprText = stringUtil.getReadableText(expr);
            }
            catch (MetadataException e) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("DataServices.ErrorRetrievingValues.Message.txt"), (Throwable)e);
            }
        }
        if (exprText == null) {
            exprText = IQDataServicesResourceBundle.getStringResource("DataServices.NoExpression.Message.txt");
        }
        return exprText;
    }

    @SASScope
    public List<TupleElementInterface> getMembers(DataItem dataItem) throws DataServicesException {
        return this.getMembers(dataItem, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TupleElementInterface> getMembers(DataItem dataItem, int stepNumber) throws DataServicesException {
        OLAPConnectionResource olapConnection;
        IQMetadataInterface metaI;
        Model dataSelection;
        boolean disposeDataSelection;
        boolean acquireRelease;
        ArrayList<TupleElementInterface> returnList;
        block28: {
            Preconditions.ensureNonNull(dataItem, "dataItem");
            returnList = new ArrayList<TupleElementInterface>();
            RetrievalPolicy policy = this.getQueryPolicy();
            ConnectionConfiguration connectionConfiguration = policy.getConnectionConfiguration();
            acquireRelease = connectionConfiguration.getConnectionLifetime() == 0;
            BusinessModel businessModel = null;
            disposeDataSelection = false;
            dataSelection = null;
            Model temporaryDataSelection = null;
            metaI = null;
            olapConnection = null;
            try {
                businessModel = OLAPUtilities.findBusinessModel(null, null, dataItem);
                dataSelection = OLAPUtilities.findDataSelection(null, businessModel);
                if (dataSelection == null) {
                    disposeDataSelection = true;
                    dataSelection = OLAPUtilities.createDataSelection(businessModel, dataItem);
                }
                if (!(temporaryDataSelection = DataSelectionFactory.newLookThroughDataSelection((DataSelection)dataSelection)).getStructure().isOLAP()) {
                    MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoValidModel.txt", new Object[0]);
                    _logger.error(temporaryDataSelection.getIdentityString());
                    _logger.error((Object)message);
                    throw new DataServicesException(message);
                }
                DataSourceCube dataCube = OLAPUtilities.findDataSourceCube((BusinessModel)temporaryDataSelection);
                String cubeName = OLAPUtilities.findCubeName(dataCube);
                SoftwareServer softwareServer = OLAPUtilities.findSoftwareServer(dataCube);
                LogicalServerInterface logicalServer = OLAPUtilities.findLogicalServerInterface(softwareServer);
                SessionContextInterface sessionContext = businessModel.getSession();
                ConnectionRecycler recycler = ConnectionUtil.getConnectionRecycler(sessionContext);
                Locale viewerLocale = LocaleUtilities.getDefaultViewerLocale(sessionContext);
                viewerLocale = IOMServerUtils.negotiateStoredCubeLocale(dataCube, viewerLocale, dataSelection.getComputationalLocale());
                UserContextInterface userContext = ConnectionUtil.getUserContext(sessionContext);
                ConnectionInterface connection = ConnectionUtil.findConnection(recycler, (DataSelection)temporaryDataSelection, logicalServer, userContext, policy, viewerLocale);
                ConnectionInterface pfsConnection = ConnectionUtil.findPfsConnection(connection);
                olapConnection = OLAPUtilities.findOlapConnectionResource(pfsConnection);
                String constructor = "DEFAULT_CONSTRUCTOR_BEHAVIOR";
                Locale connectionLocale = olapConnection.getConnectionLocale((BusinessModel)temporaryDataSelection);
                String cacheKey = MDXGenerationUtil.buildCacheKey((BusinessModel)temporaryDataSelection, connectionLocale, constructor);
                ISessionCacheContainer container = olapConnection.getISessionContainerFromCache(cacheKey);
                if (container != null) {
                    ISession iSession = container.getISession();
                    try {
                        metaI = ConnectionResources.newIQMetadata(iSession, connectionLocale);
                    }
                    catch (OLAPException e) {
                        MessageFormatter message2 = IQDataServicesResourceBundle.getMessageFormatter("DataServices.ErrorGettingMembers.Message.txt", new Object[0]);
                        ConnectionUtil.LoggerErrorWithObjects(_logger, message2, new Object[]{temporaryDataSelection, connection, iSession, e});
                        throw new ExecutionException(message2, (Throwable)e);
                    }
                } else {
                    ConnectionCancelQueryListener postConnectionListener = new ConnectionCancelQueryListener((DataSelection)temporaryDataSelection, true, connection);
                    CancelQuerySupport.registerQueryListener((DataSelection)temporaryDataSelection, postConnectionListener, connection);
                    ConnectionUtil.LoggerDebugConnectionObtained(_logger, OLAPUtilities.class, connection);
                    metaI = olapConnection.createMetadataInterface((BusinessModel)temporaryDataSelection, constructor, dataCube, true, true, null);
                }
                if (!(metaI instanceof IQMetadataInterface)) {
                    MessageFormatter message1 = IQDataServicesResourceBundle.getMessageFormatter("OLAPStrategyNoMetadataI.txt", new Object[0]);
                    ConnectionUtil.LoggerErrorWithObjects(_logger, message1, temporaryDataSelection, metaI);
                    throw new ExecutionException(message1);
                }
                MDXVariable mdxVariable = null;
                OLAPValues olapValues = null;
                try {
                    olapValues = this.buildOLAPValues(metaI, (DataSelection)temporaryDataSelection, dataItem);
                    this.validateDDLFilter(cacheKey, olapValues, cubeName, olapConnection, (DataSelection)temporaryDataSelection);
                    int stepNumberOfDI = this.getStepNumberOfDataItem(stepNumber, dataItem);
                    mdxVariable = this.buildMDXVariable(dataItem, metaI, (DataSelection)temporaryDataSelection, olapValues, stepNumberOfDI, false);
                }
                finally {
                    if (olapValues != null) {
                        olapValues.release();
                    }
                }
                String mdx = this.buildMDX(mdxVariable, dataItem, metaI, (DataSelection)temporaryDataSelection, cubeName);
                MDXGenerationUtil.applyDebugStatement("MDX generated for get members: " + mdx, IQDataServices.class);
                IQOLAPDataSet olapDataSet = null;
                try {
                    int contextType = 1;
                    olapDataSet = ConnectionUtil.newOLAPDataSet(businessModel, mdx, contextType, metaI, olapConnection);
                    olapDataSet.executeQuery();
                    ResultSetMetadataInterface resultSetMeta = ConnectionUtil.findResultSetMetadata(olapDataSet);
                    TupleInterface[] elements = resultSetMeta.getTuples(0, 0, -1);
                    this.extractTupleElements(returnList, elements);
                }
                catch (OLAPException oe) {
                    try {
                        MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.OLAPExceptionm.Message.txt", new Object[0]);
                        ArrayMessageFormatter msF1 = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, message, mdx);
                        _logger.error((Object)msF1);
                        throw new ExecutionException((MessageFormatter)msF1, (Throwable)oe);
                    }
                    catch (Throwable throwable) {
                        ConnectionResources.close(olapDataSet);
                        throw throwable;
                    }
                }
                ConnectionResources.close(olapDataSet);
                if (returnList.size() == 0) {
                    _logger.error(mdx);
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, dataItem, cubeName, IQDataServicesResourceBundle.getStringResource("OLAPConnectionInfoUtilBadDataSource.txt"));
                    throw new DataServicesException(msF);
                }
                if (temporaryDataSelection == null) break block28;
            }
            catch (MetadataException e) {
                try {
                    MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.MetadataException.Message.txt", new Object[0]);
                    ConnectionUtil.LoggerErrorWithObjects(_logger, message, businessModel, dataSelection, dataItem, e);
                    throw new DataServicesException(message, (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (temporaryDataSelection != null) {
                        temporaryDataSelection.dispose();
                    }
                    if (disposeDataSelection) {
                        dataSelection.dispose();
                    }
                    if (metaI != null) {
                        BusinessQueryOLAPUtil.releaseMetadataInterface(metaI);
                    }
                    if (olapConnection != null && acquireRelease) {
                        ConnectionResources.close(olapConnection);
                    }
                    throw throwable;
                }
            }
            temporaryDataSelection.dispose();
        }
        if (disposeDataSelection) {
            dataSelection.dispose();
        }
        if (metaI != null) {
            BusinessQueryOLAPUtil.releaseMetadataInterface(metaI);
        }
        if (olapConnection != null && acquireRelease) {
            ConnectionResources.close(olapConnection);
        }
        return returnList;
    }

    @SASScope
    public List<TupleElementInterface> getMembers(DataItem dataItem, int stepNumber, @Nonnull MetadataInterface metaI) throws DataServicesException {
        return this.getMembers(dataItem, stepNumber, null, metaI, null);
    }

    private List<TupleElementInterface> getMembers(@Nonnull DataItem dataItem, int stepNumber, String level, @Nonnull MetadataInterface metadataInterface, TupleElementInterface[] tupleElements) throws DataServicesException {
        Preconditions.ensureNonNull(dataItem, "dataItem");
        Preconditions.ensureNonNull(metadataInterface, "metadataInterface");
        ConnectionUtil.findMetadataInterfaceConnection(metadataInterface);
        Locale connectionLocale = ConnectionUtil.getConnectionLocale(metadataInterface);
        ArrayList<TupleElementInterface> returnList = new ArrayList<TupleElementInterface>();
        boolean disposeDataSelection = false;
        BusinessModel businessModel = null;
        DataSelection dataSelection = null;
        try {
            businessModel = OLAPUtilities.findBusinessModel(metadataInterface, null, dataItem);
            dataSelection = OLAPUtilities.findDataSelection(null, businessModel);
            if (dataSelection == null) {
                disposeDataSelection = true;
                dataSelection = OLAPUtilities.createDataSelection(businessModel, dataItem);
            }
        }
        catch (MetadataException e) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.MetadataException.Message.txt", new Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, businessModel, dataSelection, dataItem, e);
            throw new DataServicesException(message, (Throwable)e);
        }
        RetrievalPolicy policy = this.getQueryPolicy();
        boolean createOLAPValue = false;
        OLAPValues olapValues = null;
        try {
            IQOLAPDataSet olapDataSet;
            block26: {
                DataSourceCube dataCube = OLAPUtilities.findDataSourceCube(dataSelection);
                String cubeName = OLAPUtilities.findCubeName(dataCube);
                SoftwareServer softwareServer = OLAPUtilities.findSoftwareServer(dataCube);
                LogicalServerInterface logicalServer = OLAPUtilities.findLogicalServerInterface(softwareServer);
                SessionContextInterface sessionContext = businessModel.getSession();
                OLAPConnectionResource olapConnection = null;
                boolean filterCube = false;
                String cacheKey = null;
                if (metadataInterface instanceof IQMetadataInterface) {
                    IQMetadataInterface iqMeta = (IQMetadataInterface)metadataInterface;
                    cacheKey = iqMeta.getCacheKey();
                    OLAPConnectionResource olapConn = iqMeta.getRelatedConnection();
                    if (olapConn != null) {
                        PreFilterDLLGeneration prefill;
                        ISessionCacheContainer container = olapConn.getISessionContainerFromCache(cacheKey);
                        if (container != null && (prefill = container.getPreFilterContainer()) != null) {
                            olapValues = prefill.getOLAPValues();
                            olapConnection = olapConn;
                        }
                        if (olapValues == null) {
                            filterCube = true;
                        }
                    }
                }
                if (olapConnection == null) {
                    ConnectionRecycler recycler = ConnectionUtil.getConnectionRecycler(sessionContext);
                    Locale viewerLocale = LocaleUtilities.getDefaultViewerLocale(sessionContext);
                    viewerLocale = IOMServerUtils.negotiateStoredCubeLocale(dataCube, viewerLocale, dataSelection.getComputationalLocale());
                    UserContextInterface userContext = ConnectionUtil.getUserContext(sessionContext);
                    ConnectionInterface iqConnection = ConnectionUtil.findConnection(recycler, dataSelection, logicalServer, userContext, policy, viewerLocale);
                    ConnectionInterface pfsConnection = ConnectionUtil.findPfsConnection(iqConnection);
                    olapConnection = OLAPUtilities.findOlapConnectionResource(pfsConnection);
                    Locale cacheKeyLocale = olapConnection.getConnectionLocale(dataSelection);
                    cacheKey = MDXGenerationUtil.buildCacheKey(dataSelection, cacheKeyLocale, "DEFAULT_CONSTRUCTOR_BEHAVIOR");
                }
                if (olapValues == null) {
                    olapValues = this.buildOLAPValues(metadataInterface, dataSelection, dataItem);
                    createOLAPValue = true;
                }
                if (filterCube) {
                    this.validateDDLFilter(cacheKey, olapValues, cubeName, olapConnection, dataSelection);
                }
                int stepNumberOfDI = this.getStepNumberOfDataItem(stepNumber, dataItem);
                MDXVariable mdxVariable = this.buildMDXVariable(dataItem, metadataInterface, dataSelection, olapValues, stepNumberOfDI, true);
                boolean isNavigationStepPresent = false;
                for (StepInterface step : dataItem.getSteps()) {
                    if (!(step instanceof DataItemNavigationFilter)) continue;
                    isNavigationStepPresent = true;
                    break;
                }
                ConnectionUtil.findMetadataInterfaceConnection(metadataInterface);
                int contextType = 1;
                olapDataSet = null;
                String queryUsed = null;
                try {
                    olapDataSet = ConnectionUtil.newOLAPDataSet(businessModel, null, contextType, metadataInterface, olapConnection);
                    if (level == null) {
                        String mdx;
                        queryUsed = mdx = MDXGenerationUtil.buildMemberQuery(dataItem, cubeName, mdxVariable);
                        MDXGenerationUtil.applyDebugStatement("MDX generated for get members: " + queryUsed, IQDataServices.class);
                        try {
                            olapDataSet.setQueryStatement(queryUsed, null);
                            olapDataSet.executeQuery();
                            ResultSetMetadataInterface resultSetMeta = ConnectionUtil.findResultSetMetadata(olapDataSet);
                            TupleInterface[] elements = resultSetMeta.getTuples(0, 0, -1);
                            this.extractTupleElements(returnList, elements);
                            break block26;
                        }
                        catch (OLAPException oe) {
                            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.OLAPExceptionm.Message.txt", new Object[0]);
                            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, message, mdx);
                            _logger.error((Object)msF);
                            throw new ExecutionException((MessageFormatter)msF, (Throwable)oe);
                        }
                    }
                    String dimName = BusinessQueryOLAPUtil.getDimensionName(businessModel, dataItem);
                    ArrayList<String> slicersTextList = new ArrayList<String>();
                    String dataItemSlicerText = this.extractSlicerText(slicersTextList, dataSelection, dataItem, level, olapValues, connectionLocale);
                    String where = IQDataServices.buildWhereClauseForGetMembers(tupleElements, cubeName, slicersTextList, metadataInterface);
                    List<String> crossHiddenElement = this.extractCrossHiddenStepsText(dataItem, metadataInterface, dataSelection);
                    String setPhrase = this.buildGetMembersSetPhrase(mdxVariable, isNavigationStepPresent, dataItemSlicerText);
                    String mdx = this.buildGetMembersDecendantsQuery(cubeName, crossHiddenElement, setPhrase, dimName, level);
                    queryUsed = mdx + where;
                    MDXGenerationUtil.applyDebugStatement("MDX generated for get members: " + queryUsed, IQDataServices.class);
                    olapDataSet.setQueryStatement(queryUsed, null);
                    olapDataSet.executeQuery();
                    ResultSetMetadataInterface resultSetMeta1 = ConnectionUtil.findResultSetMetadata(olapDataSet);
                    TupleInterface[] elements1 = resultSetMeta1.getTuples(0, 0, -1);
                    this.extractTupleElements(returnList, elements1);
                    if (returnList.size() == 0) {
                        String goUpOneLevel = this.buildGetMemberAncestorsQuery(cubeName, crossHiddenElement, setPhrase, dimName, level);
                        queryUsed = goUpOneLevel + where;
                        MDXGenerationUtil.applyDebugStatement("MDX generated for get members: " + queryUsed, IQDataServices.class);
                        olapDataSet.setQueryStatement(queryUsed, null);
                        olapDataSet.executeQuery();
                        ResultSetMetadataInterface resultSetMeta2 = ConnectionUtil.findResultSetMetadata(olapDataSet);
                        TupleInterface[] elements2 = resultSetMeta2.getTuples(0, 0, -1);
                        this.extractTupleElements(returnList, elements2);
                    }
                    if (returnList.size() != 0) break block26;
                    _logger.warn(queryUsed + " for " + dimName + " " + level);
                }
                catch (OLAPException oe) {
                    try {
                        MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.OLAPExceptionm.Message.txt", new Object[0]);
                        ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, message, queryUsed);
                        _logger.error((Object)msF);
                        throw new ExecutionException((MessageFormatter)msF, (Throwable)oe);
                    }
                    catch (Throwable throwable) {
                        ConnectionResources.close(olapDataSet);
                        throw throwable;
                    }
                }
            }
            ConnectionResources.close(olapDataSet);
        }
        catch (MetadataException e) {
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, e, dataItem, IQDataServicesResourceBundle.getStringResource("DataServices.MetadataException.Message.txt"), IQDataServicesResourceBundle.getStringResource("DataServices.ErrorGettingMembers.Message.txt"));
            DataServicesException ee = new DataServicesException((MessageFormatter)msF, (Throwable)e);
            throw ee;
        }
        finally {
            if (disposeDataSelection) {
                dataSelection.dispose();
            }
            if (createOLAPValue) {
                olapValues.release();
            }
        }
        return returnList;
    }

    private String extractSlicerText(List<String> slicersTextList, DataSelection dataSelection, DataItem dataItem, String level, OLAPValues olapValues, Locale locale) throws GenerationException {
        String hierName;
        try {
            hierName = BusinessQueryOLAPUtil.getHierarchyName(dataSelection, dataItem, locale);
        }
        catch (MetadataException e1) {
            _logger.error((Object)e1);
            throw new GenerationException(e1);
        }
        String dataItemSlicerText = null;
        List<FilterItem> filterListForMDX = olapValues.getFilterListForMDX();
        for (FilterItem filter : filterListForMDX) {
            ExpressionInterface filterExpression = filter.getExpression();
            if (!(filterExpression instanceof MemberFilterExpression) || filterExpression instanceof BusinessGroupMemberFilterExpression) continue;
            MemberFilterExpression memberFilter = (MemberFilterExpression)filterExpression;
            ExpressionInterface whatToCompare = memberFilter.getWhatToCompare();
            String slicerString = IQDataServices.buildSlicerExpressionForGetMembers(dataSelection, filter, hierName, level);
            if (!(whatToCompare instanceof DataItem)) continue;
            DataItem dataWhatToCompare = (DataItem)whatToCompare;
            if (dataWhatToCompare.getLabel().equalsIgnoreCase(dataItem.getLabel())) {
                dataItemSlicerText = slicerString;
                continue;
            }
            if (slicersTextList.contains(slicerString)) continue;
            slicersTextList.add(slicerString);
        }
        return dataItemSlicerText;
    }

    private List<String> extractCrossHiddenStepsText(DataItem dataItem, MetadataInterface metaI, DataSelection dataSelection) throws MetadataException, InvalidIDException, GenerationException {
        List<DataItem> resultSetOfHidden = dataSelection.getResultItems(Role.HIDDEN);
        ArrayList<String> crossHiddenElement = new ArrayList<String>();
        for (DataItem hiddenItem : resultSetOfHidden) {
            if (hiddenItem.getStructure().equals(StructureOfDataItem.STRUCTURE_MEASURE) || hiddenItem.getID().equals(dataItem.getID()) || hiddenItem.getSteps().size() <= 0) continue;
            StepManager stepManager = new StepManager(hiddenItem);
            String buildOLAPExpression = BusinessQueryOLAPUtil.buildOLAPExpression(hiddenItem, metaI);
            String mdxHidden = stepManager.generateMDX(dataSelection, buildOLAPExpression);
            crossHiddenElement.add(mdxHidden);
        }
        return crossHiddenElement;
    }

    private String buildGetMembersSetPhrase(MDXVariable mdxVariable, boolean isNavigationStepPresent, String dataItemSlicerText) {
        String setPhrase = mdxVariable.getMDXExpression();
        if (dataItemSlicerText != null) {
            setPhrase = dataItemSlicerText;
        }
        if (isNavigationStepPresent) {
            Pattern p = Pattern.compile(".CHILDREN");
            StringBuffer sb = new StringBuffer(50);
            Matcher m = p.matcher(setPhrase);
            boolean found = m.find();
            if (found) {
                m.appendReplacement(sb, " ");
            }
            setPhrase = sb.toString();
        }
        return setPhrase;
    }

    private String buildGetMembersDecendantsQuery(String cubeName, List<String> crossHiddenElement, String setPhrase, String dimName, String level) throws GenerationException {
        StringBuilder descending = new StringBuilder();
        descending.append("GENERATE( {").append(setPhrase).append("}, {").append("DESCENDANTS").append("([").append(dimName).append("].CURRENTMEMBER,").append("[").append(dimName).append("].[").append(level).append("])}  )");
        String mdx = IQDataServices.buildGeneratedQuery(descending.toString(), cubeName, crossHiddenElement);
        return mdx;
    }

    private String buildGetMemberAncestorsQuery(String cubeName, List<String> crossHiddenElement, String setPhrase, String dimName, String level) throws GenerationException {
        StringBuilder ascending = new StringBuilder();
        ascending.append("GENERATE( {").append(setPhrase).append("}, {").append("ANCESTORS").append("([").append(dimName).append("].CURRENTMEMBER,").append("[").append(dimName).append("].[").append(level).append("])}  )");
        String goUpOneLevel = IQDataServices.buildGeneratedQuery(ascending.toString(), cubeName, crossHiddenElement);
        return goUpOneLevel;
    }

    private static String buildGeneratedQuery(String exprText, String cubeName, List<String> crossjoinHidden) throws GenerationException {
        StringBuilder mdx = new StringBuilder();
        mdx.append(" Select NON EMPTY ").append("{" + exprText + "}  on columns");
        int setsInCrossJoin = crossjoinHidden.size();
        boolean isUseNonNestedCJ = Boolean.valueOf(System.getProperty("SASQueryServices.useNonNestedCrossJoin", "true"));
        if (setsInCrossJoin > 0) {
            mdx.append(" , ");
            if (isUseNonNestedCJ) {
                if (setsInCrossJoin > 1) {
                    mdx.append("CROSSJOIN(");
                }
                for (String crossJoinSet : crossjoinHidden) {
                    mdx.append(crossJoinSet);
                    mdx.append(",");
                }
                mdx.setLength(mdx.length() - 1);
                if (setsInCrossJoin > 1) {
                    if (setsInCrossJoin > 2) {
                        mdx.append(", ").append(setsInCrossJoin);
                    }
                    mdx.append(")");
                }
            } else {
                int ct = crossjoinHidden.size();
                int cp = 0;
                Iterator<String> hiddenCrossjoin = crossjoinHidden.iterator();
                while (hiddenCrossjoin.hasNext()) {
                    if (ct > 1) {
                        mdx.append("CROSSJOIN(");
                        ++cp;
                    }
                    mdx.append(hiddenCrossjoin.next());
                    if (--ct <= 0) continue;
                    mdx.append(",");
                }
                for (int i = 0; i < cp; ++i) {
                    mdx.append(")");
                }
            }
            mdx.append(" on rows ");
        }
        mdx.append(" From ").append("[" + cubeName + "]");
        return mdx.toString();
    }

    public List<TupleElementInterface> getMembers(@Nonnull DataItem dataItem, @Nonnull MetadataInterface metadataInterface) throws DataServicesException {
        Preconditions.ensureNonNull(dataItem, "datItem");
        Preconditions.ensureNonNull(metadataInterface, "metadataInterface");
        return this.getMembers(dataItem, -999, metadataInterface);
    }

    public List<TupleElementInterface> getMembers(@Nonnull DataItem dataItem, @Nonnull String level, @Nonnull MetadataInterface metadataInterface, TupleElementInterface[] tupleElements) throws DataServicesException {
        Preconditions.ensureNonNull(dataItem, "dataItem");
        Preconditions.ensureNonNull(level, "level");
        Preconditions.ensureNonNull("metadataInterface");
        List<TupleElementInterface> returnList = null;
        try {
            DataItem clone = (DataItem)dataItem.clone();
            clone.setStartingLevelName(level);
            returnList = this.getMembers(clone, -999, level, metadataInterface, tupleElements);
        }
        catch (CloneNotSupportedException e) {
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, e, dataItem, level);
            DataServicesException ee = new DataServicesException((MessageFormatter)msF, (Throwable)e);
            throw ee;
        }
        catch (MetadataException e) {
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, e, dataItem, level);
            DataServicesException ee = new DataServicesException((MessageFormatter)msF, (Throwable)e);
            throw ee;
        }
        return returnList;
    }

    public List<PossibleFilterValue> getPossibleFilterValues(DataItem dataItem) throws DataServicesException {
        return this.getPossibleFilterValues(dataItem, null, false, false, 3, null);
    }

    public List<PossibleFilterValue> getPossibleFilterValues(DataItem dataItem, Governing governing) throws DataServicesException {
        return this.getPossibleFilterValues(dataItem, governing, false, false, 3, null);
    }

    public List<PossibleFilterValue> getPossibleFilterValues(DataItem dataItem, Governing governing, boolean honorFilters) throws DataServicesException {
        return this.getPossibleFilterValues(dataItem, governing, honorFilters, false, 3, null);
    }

    public List<PossibleFilterValue> getPossibleFilterValues(DataItem dataItem, Governing governing, boolean honorFilters, boolean ignoreFormattingForced, int dataToReturn) throws DataServicesException {
        return this.getPossibleFilterValues(dataItem, governing, honorFilters, ignoreFormattingForced, dataToReturn, null);
    }

    @SASScope
    public List<PossibleFilterValue> getPossibleFilterValues(@Nonnull DataItem dataItem, Governing governing, boolean honorFilters, boolean ignoreFormattingForced, int dataToReturn, StringBuffer sasLog) throws DataServicesException {
        List<PossibleFilterValue> returnList;
        Preconditions.ensureNonNull(dataItem, "datItem");
        if (dataToReturn != 1 && dataToReturn != 2 && dataToReturn != 3) {
            throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.BadDataToReturnParam.Message.txt", new Object[0]));
        }
        boolean isUsable = dataItem.isUsableInQuery();
        if (!isUsable) {
            List<Reason> reasons = dataItem.getReasonsUnusable();
            String id = null;
            try {
                id = dataItem.getID();
            }
            catch (InvalidIDException ie) {
                id = IQDataServicesResourceBundle.getStringResource("DataServices.UnknownDataItemID.Message.txt");
            }
            MessageFormatter message = this.formatReasonsBasedMessage("DataServices.InvalidDataItem.Message.fmt.txt", id, reasons);
            DataServicesException e = new DataServicesException(message, reasons);
            throw e;
        }
        Lookup lookup = dataItem.getLookupType();
        if (lookup instanceof LookupNotAllowed) {
            returnList = Collections.emptyList();
        } else if (lookup instanceof LookupByDataItem) {
            returnList = this.getValuesFromDataItem(dataItem, governing, honorFilters, ignoreFormattingForced, dataToReturn, sasLog);
        } else if (lookup instanceof LookupList) {
            returnList = this.getValuesFromStaticList(dataItem, ignoreFormattingForced, dataToReturn);
        } else {
            if (lookup instanceof LookupByQuery) {
                throw new UnsupportedOperationException(IQDataServicesResourceBundle.getStringResource("DataServices.LookupByQueryNotSupported.txt"));
            }
            returnList = Collections.emptyList();
            String message = IQDataServicesResourceBundle.getMessageString("DataServices.UnsupportedLookupType.Message.fmt.txt", dataItem.getLabel() + lookup.getClass().getName(), IQDataServices.class.toString());
            _logger.error(message);
        }
        return returnList;
    }

    private RetrievalPolicy getQueryPolicy() {
        RetrievalPolicy policy = null;
        if (this._queryConnector != null) {
            QueryConnector qc = (QueryConnector)this._queryConnector;
            policy = qc.getRetrievalPolicy();
        } else {
            policy = new RetrievalPolicy();
            policy.setPolicyValue(0);
            policy.getConnectionConfiguration().setConnectionLifetime(1);
        }
        return policy;
    }

    @SASScope
    public com.sas.iquery.execution2.ResultSetInterface getResultSet(DataItem dataItem) throws DataServicesException {
        com.sas.iquery.execution2.ResultSetInterface rsi = null;
        if (dataItem == null) {
            throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.NullDataItem.Message.txt", new Object[0]));
        }
        BusinessModel businessModel = dataItem.getBusinessModel();
        RetrievalPolicy policy = null;
        String mdx = "";
        if (this._queryConnector != null) {
            QueryConnector qc = (QueryConnector)this._queryConnector;
            policy = qc.getRetrievalPolicy();
        }
        if (policy == null) {
            policy = new RetrievalPolicy();
            policy.setPolicyValue(0);
            policy.getConnectionConfiguration().setConnectionLifetime(1);
        }
        try {
            DataSelection dataSelection = DataSelectionFactory.newDataSelection(businessModel);
            dataSelection.setLabel("1");
            DataItemReference dataItemReference = dataSelection.newDataItemReference(dataItem);
            dataSelection.addBusinessItem(dataItemReference);
            dataSelection.addResultItem(dataItemReference, Role.COLUMN);
            RequiredDataSources rds = dataSelection.newRequiredDataSources();
            rds.setDataSources(Collections.emptyList());
            dataSelection.addBusinessRule(rds);
            DataSourceCube cube = OLAPUtilities.findDataSourceCube(dataSelection);
            OLAPUtilities.findCubeName(cube);
            SoftwareServer softwareServer = OLAPUtilities.findSoftwareServer(cube);
            LogicalServerInterface logicalServer = OLAPUtilities.findLogicalServerInterface(softwareServer);
            mdx = MDXGenerationUtil.buildMDXOnFlyExpression(dataItem);
            if (_logger.isDebugEnabled()) {
                _logger.debug("MDX for getResultSet(): " + mdx);
            }
            if (dataSelection == null || logicalServer == null || mdx.length() == 0) {
                String message = IQDataServicesResourceBundle.getStringResource("IQDataServices.ArgumentsToCreateMDXNull.txt");
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, message, mdx, logicalServer, cube);
                _logger.error((Object)msF);
                DataServicesException ee = new DataServicesException(message);
                throw ee;
            }
            Integer contextOlap = 0;
            MDXInstruction mdxInstruction = new MDXInstruction(logicalServer, dataSelection, mdx, contextOlap);
            ExecutionContext context = new ExecutionContext(policy);
            mdxInstruction.setExecutionContext(context);
            mdxInstruction.execute();
            rsi = context.getResult();
            dataSelection.dispose();
        }
        catch (MetadataException me) {
            String message = IQDataServicesResourceBundle.getStringResource("DataServices.MetadataException.Message.txt");
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, message, mdx);
            _logger.error((Object)msF);
            throw new DataServicesException((MessageFormatter)msF, (Throwable)me);
        }
        return rsi;
    }

    private int getStepNumberOfDataItem(int stepNumber, DataItem dataItem) throws DataServicesException {
        int numOfSteps = 0;
        if (dataItem.hasSteps()) {
            if (stepNumber == -999) {
                List<StepInterface> dataItemSteps = dataItem.getSteps();
                numOfSteps = dataItemSteps.size();
            } else if (stepNumber != -1) {
                throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.IllegalStepNumber.Message.txt", new Object[0]));
            }
        }
        return numOfSteps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PossibleFilterValue> getValuesFromBusinessQuery(DataItem dataItem, BusinessQuery query, int dataToReturn, StringBuffer sasLog) throws DataServicesException {
        List<PossibleFilterValue> returnList = null;
        SessionContextInterface session = query.getBusinessModel().getSession();
        Map<String, com.sas.iquery.execution2.ResultSetInterface> resultMap = null;
        QueryConnectionInterface myQueryConnection = null;
        try {
            try {
                if (query.getResultItems().size() > 0) {
                    BusinessModel businessModel = query.getBusinessModel().getParentBusinessModel();
                    BusinessItem businessItem = query.getResultItems().get(0);
                    this.addHiddenItemIfNecessary(businessModel, businessItem, query);
                }
            }
            catch (MetadataException me) {
                throw new DataServicesException(me);
            }
            List<Reason> reasons = query.getReasonsNotValid();
            if (!reasons.isEmpty()) {
                String queryID = query.getID();
                MessageFormatter message = this.formatReasonsBasedMessage("DataServices.InvalidDataSelection.Message.fmt.txt", queryID, reasons);
                DataServicesException e = new DataServicesException(message, reasons);
                throw e;
            }
            myQueryConnection = this.getQueryConnector(session, 0);
            try {
                String showQueryProp = System.getProperty("SASQueryServices.ShowGPFVQuery", null);
                if (showQueryProp == null) {
                    showQueryProp = System.getProperty("SAS.IQ.ShowGPFVQuery");
                }
                if (showQueryProp != null && "true".equalsIgnoreCase(showQueryProp)) {
                    QueryConnector qc = (QueryConnector)myQueryConnection;
                    String sqlForQuery = qc.getPhysicalQuery(query);
                    _logger.debug("GPFV query:" + sqlForQuery);
                }
                resultMap = myQueryConnection.retrieveQueryResultMap(Collections.singletonList(query));
            }
            catch (IntelligentQueryException ie) {
                MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("DataServices.ErrorRetrievingValues.Message.txt", new Object[0]);
                _logger.error((Object)msg, (Throwable)ie);
                throw new DataServicesException(msg, (Throwable)ie);
            }
            com.sas.iquery.execution2.ResultSetInterface resultSet = resultMap.get(query.getID());
            Locale locale = resultSet.getComputationalLocale();
            if (locale == null) {
                locale = LocaleUtilities.getDefaultViewerLocale(query.getBusinessModel());
            }
            returnList = this.getValuesFromResultSet(resultSet, dataItem.getExpressionType(), dataToReturn, true, locale);
            if (sasLog != null) {
                String sasLogText;
                boolean stp = false;
                String stpLogText = resultSet.getStoredProcessLog();
                if (stpLogText != null && stpLogText.length() > 0) {
                    sasLog.append(stpLogText);
                    stp = true;
                }
                if ((sasLogText = resultSet.getSASLog()) != null && sasLogText.length() > 0) {
                    if (stp) {
                        sasLog.append('\n');
                    }
                    sasLog.append(sasLogText);
                }
            }
            this.closeMyQueryConnection(session, resultMap, myQueryConnection);
        }
        catch (Throwable throwable) {
            this.closeMyQueryConnection(session, resultMap, myQueryConnection);
            ((DataSelection)query).dispose();
            throw throwable;
        }
        ((DataSelection)query).dispose();
        return returnList;
    }

    private List<PossibleFilterValue> getValuesFromDataItem(DataItem dataItem, Governing governing, boolean honorFilters, boolean ignoreFormattingForced, int dataToReturn, StringBuffer sasLog) throws DataServicesException {
        BusinessModel businessModel = dataItem.getBusinessModel();
        SessionContextInterface session = businessModel.getSession();
        if (session == null) {
            throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.CannotGetSession.Message.txt", new Object[0]));
        }
        DataSelection selection = null;
        try {
            List<PossibleFilterValue> valuesFromBusinessQuery;
            BusinessModel busModel;
            DataItem secondDataItem;
            selection = DataSelectionFactory.newDataSelection(businessModel);
            selection.setLabel("ValuesFromDataItem");
            selection.setID("ValuesFromDataItem_" + dataItem.getID().replaceAll("[^\\w]", "_"));
            if (!this.isFormattingForced(dataItem, ignoreFormattingForced)) {
                selection.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, true);
            }
            if (!honorFilters && selection.isActionSupported(BusinessQueryActionType.PROPERTY_EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS)) {
                selection.setQueryProperty(BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS, true);
            }
            if (selection.isActionSupported(BusinessQueryActionType.PROPERTY_RETURN_DISTINCT_VALUES)) {
                selection.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
            }
            DataItemReference unformattedDetailDataItem = selection.getBusinessModel().newDataItemReference(dataItem);
            unformattedDetailDataItem.setLabel("UnformattedData");
            this.setCorrectUsage(unformattedDetailDataItem);
            if (!this.isFormattingForced(dataItem, ignoreFormattingForced)) {
                if (unformattedDetailDataItem.isActionSupported(DataItemActionType.OTHER_FORMAT)) {
                    unformattedDetailDataItem.setFormat(null);
                }
                if (unformattedDetailDataItem.getStructure() == StructureOfDataItem.STRUCTURE_COLUMN) {
                    unformattedDetailDataItem.setFormattingForced(false);
                }
            }
            selection.addBusinessItem(unformattedDetailDataItem);
            selection.addResultItem(unformattedDetailDataItem, Role.COLUMN);
            for (SelectedItem selectedItem : selection.getSelectedItems()) {
                selectedItem.setFormatType(1);
            }
            if (!selection.getStructure().isRelational()) {
                secondDataItem = null;
            } else if (dataToReturn == 2 && ignoreFormattingForced) {
                DataItemReference duplicateItem = selection.newDataItemReference(dataItem);
                this.setCorrectUsage(duplicateItem);
                duplicateItem.setFormattingForced(false);
                duplicateItem.setFormat(null);
                secondDataItem = duplicateItem;
            } else if (dataItem.isFormattingForced()) {
                DataItemReference dirForcedFormat = selection.newDataItemReference(dataItem);
                this.setCorrectUsage(dirForcedFormat);
                secondDataItem = dirForcedFormat;
            } else {
                RootDataItem newItem = selection.newDataItem();
                String sasFormat = dataItem.getFormat();
                boolean hasValidFormat = false;
                if (sasFormat != null) {
                    ExpressionInterface expression = unformattedDetailDataItem.getExpression();
                    DataItemActionType usage = unformattedDetailDataItem.getUsage();
                    Function aggregationFunction = unformattedDetailDataItem.getAggregationType();
                    hasValidFormat = DataItemImpl.isValidFormatForType(sasFormat, expression, usage, aggregationFunction);
                }
                if (sasFormat == null || sasFormat.length() == 0 || !hasValidFormat) {
                    sasFormat = GenerationUtil.generateFormat(unformattedDetailDataItem);
                }
                if (sasFormat == null || sasFormat.length() == 0 || dataItem.getStructure().isOLAP()) {
                    newItem.setExpression(dataItem.getExpression());
                } else {
                    String exprText = "<<" + unformattedDetailDataItem.getID() + ">>";
                    this.addHiddenItemIfNecessary(businessModel, unformattedDetailDataItem, selection);
                    RelationalDataSelectionProcessor dataSelectionProcessor = new RelationalDataSelectionProcessor(selection);
                    try {
                        dataSelectionProcessor.populate();
                    }
                    catch (GenerationException e) {
                        _logger.debug("Ignore populate error during setup", (Throwable)e);
                    }
                    String putCmd = GenerationUtil.generatePut(dataSelectionProcessor, exprText, sasFormat);
                    int exprType = 3;
                    ResourceScope scope = ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE;
                    ExpressionInterface putExp = StringExpressionUtil.getInstance().newExpression(selection, putCmd, exprType, scope);
                    newItem.setExpression(putExp);
                }
                this.setCorrectUsage(newItem);
                secondDataItem = newItem;
            }
            if (secondDataItem != null) {
                secondDataItem.setLabel("FormattedData");
                selection.addBusinessItem(secondDataItem);
                selection.addResultItem(secondDataItem, Role.COLUMN);
            }
            if (selection.getStructure().isRelational()) {
                Governing selectionGov = selection.newGoverning();
                if (governing == null) {
                    selectionGov.setOutputObservations(1000);
                } else {
                    selectionGov.copy(governing);
                }
                selection.addBusinessRule(selectionGov);
            }
            if (honorFilters && (busModel = dataItem.getBusinessModel()) instanceof BusinessQuery) {
                selection.setFilters(((BusinessQuery)((Object)busModel)).getEffectiveFilters());
                PromptValuesInterface parentPromptValues = ((BusinessQuery)((Object)busModel)).getPromptValues();
                PromptValuesInterface childPromptValues = selection.getPromptValues();
                Map parentValues = parentPromptValues.getPromptValues();
                Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(busModel);
                childPromptValues.setPromptValues(parentValues, computationalLocale);
            }
            List<PossibleFilterValue> list = valuesFromBusinessQuery = this.getValuesFromBusinessQuery(dataItem, selection, dataToReturn, sasLog);
            return list;
        }
        catch (MetadataException e) {
            throw new DataServicesException(e);
        }
        catch (InvalidPromptValueException e) {
            throw new DataServicesException(e);
        }
        finally {
            if (selection != null) {
                selection.dispose();
            }
        }
    }

    private List<PossibleFilterValue> getValuesFromResultSet(com.sas.iquery.execution2.ResultSetInterface rs, int valueExprType, int dataToReturn, boolean onlyUnique, Locale locale) throws DataServicesException {
        List<PossibleFilterValue> returnList = new ArrayList<PossibleFilterValue>();
        Object resultSet = rs.getResultSet();
        if (resultSet instanceof OLAPDataSetInterface) {
            OLAPDataSetInterface olapDataSet = (OLAPDataSetInterface)resultSet;
            boolean returnMemberInfo = false;
            boolean returnRawObject = false;
            boolean returnDeepestTuple = false;
            returnList = this.populate(olapDataSet, returnMemberInfo, returnRawObject, returnDeepestTuple, locale);
        } else if (resultSet instanceof ResultSet) {
            ResultSet jrs = (ResultSet)resultSet;
            returnList = this.populate(jrs, valueExprType, dataToReturn, locale);
        }
        if (onlyUnique) {
            returnList = this.makeValuesUnique(returnList, dataToReturn);
        }
        return returnList;
    }

    private List<PossibleFilterValue> populate(OLAPDataSetInterface olapDataSet, boolean returnMemberInfo, boolean returnRawObject, boolean returnDeepestTuple, Locale locale) throws DataServicesException {
        ArrayList<PossibleFilterValue> returnList = new ArrayList<PossibleFilterValue>();
        try {
            String formattedData;
            String unformattedData;
            ResultSetMetadataInterface rsmi = olapDataSet.getResultSetMetadata();
            MetadataInterface databaseMetadata = olapDataSet.getDatabaseMetadata();
            LinkedHashMap<String, MemberInterface> tupleMembers = new LinkedHashMap<String, MemberInterface>();
            LinkedHashMap<String, TupleElementInterface> uniqueTuples = new LinkedHashMap<String, TupleElementInterface>();
            AxisInterface axis = rsmi.getAxis(0);
            int tupleCount = axis.getTupleCount();
            for (int i = 0; i < tupleCount; ++i) {
                TupleInterface tuple = axis.getTuple(i);
                TupleElementInterface[] tupleElements = tuple.getElements(0, -1);
                TupleElementInterface deepestTuple = null;
                for (TupleElementInterface tupleElement : tupleElements) {
                    if (tupleElement.isContextual()) continue;
                    if (returnMemberInfo) {
                        MemberInterface[] members;
                        Filter filter = new Filter();
                        filter.setTreeOperator(Filter.ANCESTORS_TREE_OPERATOR | Filter.SELF_TREE_OPERATOR);
                        filter.setUniqueMemberName(tupleElement.getName());
                        filter.setCubeName(olapDataSet.getCubeName());
                        for (MemberInterface member : members = databaseMetadata.getMembers(filter, 0, -1)) {
                            tupleMembers.put(member.getUniqueName(), member);
                        }
                    }
                    if (returnDeepestTuple) {
                        deepestTuple = tupleElement;
                        continue;
                    }
                    uniqueTuples.put(tupleElement.getName(), tupleElement);
                }
                if (deepestTuple == null) continue;
                uniqueTuples.put(deepestTuple.getName(), deepestTuple);
            }
            if (returnMemberInfo) {
                for (String key : tupleMembers.keySet()) {
                    MemberInterface member = (MemberInterface)tupleMembers.get(key);
                    unformattedData = key;
                    if (returnRawObject) {
                        unformattedData = member;
                    }
                    formattedData = member.getLabel();
                    PossibleFilterValue distinctVal = new PossibleFilterValue(1111, unformattedData, formattedData, null);
                    returnList.add(distinctVal);
                }
            } else {
                for (String key : uniqueTuples.keySet()) {
                    TupleElementInterface tuple = (TupleElementInterface)uniqueTuples.get(key);
                    unformattedData = key;
                    if (returnRawObject) {
                        unformattedData = this.newEmbeddedTupleElement(tuple);
                    }
                    formattedData = tuple.getLabel();
                    PossibleFilterValue distinctVal = new PossibleFilterValue(1111, unformattedData, formattedData, null);
                    returnList.add(distinctVal);
                }
            }
        }
        catch (OLAPException e) {
            Throwable t = ChainedException.getRootException((Throwable)e);
            if (t == null) {
                t = e;
            }
            _logger.error(e.getMessage(), t);
            throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ErrorRetrievingValues.Message.txt", new Object[0]), (Throwable)e);
        }
        return returnList;
    }

    private TupleElement newEmbeddedTupleElement(TupleElementInterface deepestTuple) throws OLAPException {
        return OLAPConnectionInfoUtil.newEmbeddedTupleElement(deepestTuple);
    }

    private List<PossibleFilterValue> populate(ResultSet rs, int valueExprType, int dataToReturn, Locale locale) throws DataServicesException {
        ArrayList<PossibleFilterValue> returnList = new ArrayList<PossibleFilterValue>();
        TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
        try {
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            if (columnCount < 1) {
                throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.ErrorGettingGPFVResults.txt", new Object[0]));
            }
            boolean unformattedDataColumnIndex = true;
            int formattedDataColumnIndex = columnCount > 1 ? 2 : 1;
            String formattedData = null;
            rs.beforeFirst();
            while (rs.next() && !Thread.interrupted()) {
                MLSResultSetInterface mlsRs;
                Object mlsObject;
                ConstantExpression constantData;
                Thread.yield();
                int columnType = rsMetaData.getColumnType(1);
                Calendar calendar = Calendar.getInstance(gmtTimeZone, locale);
                Object unformattedData = columnType == 91 ? rs.getDate(1, calendar) : (columnType == 92 ? rs.getTime(1, calendar) : (columnType == 93 ? rs.getTimestamp(1, calendar) : rs.getObject(1)));
                formattedData = rs.getString(formattedDataColumnIndex);
                AbstractExpression unformattedValueExpression = null;
                if (unformattedData != null) {
                    if (unformattedData instanceof Double) {
                        long dateMillisecondValue;
                        SASFormat formatter;
                        String sasFormatText;
                        double sasDoubleValue = (Double)unformattedData;
                        int dataItemExpressionType = valueExprType;
                        if (dataItemExpressionType == 4) {
                            sasFormatText = StringExpressionUtil.getDefaultSASFormatText(4);
                            formatter = StringExpressionUtil.getSASFormat(sasFormatText, locale);
                            if (formatter instanceof SASDateTimeFormat) {
                                SASDateTimeFormat dateFormatter = (SASDateTimeFormat)formatter;
                                dateFormatter.setFormatTimeZone(gmtTimeZone);
                                dateMillisecondValue = dateFormatter.convertToJavaDate(sasDoubleValue);
                                unformattedData = new Date(dateMillisecondValue);
                            }
                        } else if (dataItemExpressionType == 5) {
                            sasFormatText = StringExpressionUtil.getDefaultSASFormatText(5);
                            formatter = StringExpressionUtil.getSASFormat(sasFormatText, locale);
                            if (formatter instanceof SASDateTimeFormat) {
                                SASDateTimeFormat timeFormatter = (SASDateTimeFormat)formatter;
                                timeFormatter.setFormatTimeZone(gmtTimeZone);
                                dateMillisecondValue = timeFormatter.convertToJavaDate(sasDoubleValue);
                                unformattedData = new Time(dateMillisecondValue);
                            }
                        } else if (dataItemExpressionType == 6 && (formatter = StringExpressionUtil.getSASFormat(sasFormatText = StringExpressionUtil.getDefaultSASFormatText(6), locale)) instanceof SASDateTimeFormat) {
                            SASDateTimeFormat datetimeFormatter = (SASDateTimeFormat)formatter;
                            datetimeFormatter.setFormatTimeZone(gmtTimeZone);
                            dateMillisecondValue = datetimeFormatter.convertToJavaDate(sasDoubleValue);
                            unformattedData = new Timestamp(dateMillisecondValue);
                        }
                    }
                    if (unformattedData instanceof Date) {
                        DateValueExpression dve = new DateValueExpression((Date)unformattedData);
                        dve.setExplicitDoubleValue(rs.getDouble(1));
                        unformattedValueExpression = dve;
                    } else if (unformattedData instanceof Timestamp) {
                        TimestampValueExpression tsve = new TimestampValueExpression((Timestamp)unformattedData);
                        tsve.setExplicitDoubleValue(rs.getDouble(1));
                        unformattedValueExpression = tsve;
                    } else if (unformattedData instanceof Time) {
                        TimeValueExpression tve = new TimeValueExpression((Time)unformattedData);
                        tve.setExplicitDoubleValue(rs.getDouble(1));
                        unformattedValueExpression = tve;
                    } else if (unformattedData instanceof Integer) {
                        constantData = new ConstantExpression();
                        double d = rs.getDouble(1);
                        constantData.setValue("" + d);
                        constantData.setExpressionType(valueExprType);
                        unformattedValueExpression = constantData;
                    } else {
                        constantData = new ConstantExpression();
                        constantData.setValue(unformattedData.toString());
                        constantData.setExpressionType(valueExprType);
                        unformattedValueExpression = constantData;
                    }
                } else {
                    constantData = new ConstantExpression();
                    constantData.setExpressionType(valueExprType);
                    if (valueExprType == 3 || valueExprType == 11) {
                        constantData.setValue(" ");
                    } else {
                        constantData.setValue(".");
                    }
                    unformattedValueExpression = constantData;
                }
                MLSValueInterface mlsValue = null;
                if (rs.isWrapperFor(MLSResultSetInterface.class) && (mlsObject = (mlsRs = rs.unwrap(MLSResultSetInterface.class)).getObject(1, locale)) instanceof MLSValueInterface) {
                    mlsValue = (MLSValueInterface)mlsObject;
                }
                PossibleFilterValue distinctVal = new PossibleFilterValue(columnType, unformattedValueExpression, formattedData, mlsValue);
                distinctVal = this.copyRequestedData(distinctVal, dataToReturn);
                returnList.add(distinctVal);
            }
        }
        catch (SQLException e) {
            Throwable t = ChainedException.getRootException((Throwable)e);
            if (t == null) {
                t = e;
            }
            _logger.error(e.getMessage(), t);
            throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.SQLExceptionGettingData.Message.txt", new Object[0]), (Throwable)e);
        }
        return returnList;
    }

    private List<PossibleFilterValue> getValuesFromStaticList(DataItem dataItem, boolean ignoreFormattingForced, int dataToReturn) throws DataServicesException {
        List<PossibleFilterValue> returnList = new ArrayList<PossibleFilterValue>();
        LookupList lookup = (LookupList)dataItem.getLookupType();
        List<LookupValue> valueList = lookup.getValuesList();
        for (int index = 0; index < valueList.size(); ++index) {
            int expressionType;
            int columnType;
            boolean isQuoted;
            LookupValue value = valueList.get(index);
            String formattedData = value.getFormattedValue();
            String unformattedData = null;
            unformattedData = this.isFormattingForced(dataItem, ignoreFormattingForced) ? value.getFormattedValue() : value.getUnformattedValue();
            boolean bl = isQuoted = value.isQuoted() || this.isFormattingForced(dataItem, ignoreFormattingForced) || !this.isReturnUnformattedData(dataToReturn);
            if (formattedData == null) continue;
            if (isQuoted) {
                columnType = 1;
                expressionType = 3;
            } else {
                columnType = 8;
                expressionType = 2;
            }
            ConstantExpression constantData = new ConstantExpression();
            if (unformattedData != null) {
                constantData.setValue(unformattedData);
            }
            constantData.setExpressionType(expressionType);
            PossibleFilterValue distinctVal = new PossibleFilterValue(columnType, constantData, formattedData, null);
            distinctVal = this.copyRequestedData(distinctVal, dataToReturn);
            returnList.add(distinctVal);
        }
        returnList = this.makeValuesUnique(returnList, dataToReturn);
        return returnList;
    }

    private boolean hasEmptyStringInExpression(BusinessItem item) throws MetadataException {
        ResourceAwareStringExpression rase;
        String expressionText;
        DataItem di;
        ExpressionInterface expr;
        boolean hasEmptyString = false;
        if (item instanceof DataItem && (expr = (di = (DataItem)item).getExpression()) instanceof ResourceAwareStringExpression && ((expressionText = (rase = (ResourceAwareStringExpression)expr).getText()) == null || expressionText.length() == 0 || expressionText.trim().length() == 0)) {
            hasEmptyString = true;
        }
        return hasEmptyString;
    }

    private boolean isFormattingForced(DataItem dataItem, boolean ignoreFormattingForced) {
        return dataItem.isFormattingForced() && !ignoreFormattingForced;
    }

    private boolean isReturnFormattedData(int dataToReturn) {
        return dataToReturn == 1 || dataToReturn == 3;
    }

    private boolean isReturnUnformattedData(int dataToReturn) {
        return dataToReturn == 2 || dataToReturn == 3;
    }

    private List<PossibleFilterValue> makeValuesUnique(List<PossibleFilterValue> valueList, int dataToReturn) throws DataServicesException {
        if (dataToReturn != 3) {
            LinkedHashSet<PossibleFilterValue> uniqueValues = new LinkedHashSet<PossibleFilterValue>(valueList);
            ArrayList<PossibleFilterValue> returnList = new ArrayList<PossibleFilterValue>(uniqueValues);
            return returnList;
        }
        List<PossibleFilterValue> returnList = valueList;
        return returnList;
    }

    public void setConnection(QueryConnectionInterface qc) {
        this._queryConnector = qc;
    }

    private void setCorrectUsage(DataItem dataItemReference) throws MetadataException {
        DataItemActionType usage = dataItemReference.getUsage();
        boolean isAMeasure = usage == DataItemActionType.USAGE_AGGREGATE;
        boolean isMeasureTypeDifThanDetailType = false;
        if (isAMeasure) {
            isMeasureTypeDifThanDetailType = GenerationUtil.isMeasureAndDetailTypeSame(dataItemReference);
        }
        if (!isMeasureTypeDifThanDetailType && dataItemReference.isActionSupported(DataItemActionType.USAGE_DETAIL)) {
            dataItemReference.setUsage(DataItemActionType.USAGE_DETAIL);
        }
    }

    public void setService(IntelligentQueryMetadataServiceInterface iqService) {
        this._iqService = iqService;
    }

    private void validateDDLFilter(String key, OLAPValues olapValues, String cubeName, OLAPConnectionResource olapConnection, DataSelection dataSelection) throws GenerationException, ExecutionException {
        if (!olapConnection.isFilterApplied(key, cubeName) && OLAPValues.isDLLFiltered(dataSelection)) {
            olapConnection.applyFilterStateOnCube(dataSelection, key, olapValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify(BusinessItem item) throws DataServicesException {
        if (item == null) {
            throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.InvalidItem.Message.txt", new Object[0]));
        }
        if (!(item instanceof DataItem) && !(item instanceof FilterItem)) {
            throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.InvalidItem.Message.txt", new Object[0]));
        }
        BusinessModel businessModel = item.getBusinessModel();
        SessionContextInterface session = businessModel.getSession();
        if (session == null) {
            throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.CannotGetSession.Message.txt", new Object[0]));
        }
        try {
            if (this.hasEmptyStringInExpression(item)) {
                throw new DataServicesException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.InvalidEmptyExpression.Message.txt", new Object[0]));
            }
        }
        catch (MetadataException e) {
            throw new DataServicesException(e);
        }
        StructureOfData structure = businessModel.getStructure();
        Level loggerSilence = _logger.getLevel();
        try {
            Configurator.setLevel((String)_logger.getName(), (Level)Level.OFF);
            if (structure.isOLAP()) {
                this._verifyOLAPItem(businessModel, item);
            } else {
                this._verifyRelationalItem(businessModel, item);
            }
        }
        finally {
            Configurator.setLevel((String)_logger.getName(), (Level)loggerSilence);
        }
    }

    public void verify(BusinessModel businessModel, ExpressionInterface expression) throws DataServicesException {
        DataSelection selection = DataSelectionFactory.newDataSelection(businessModel);
        try {
            RequiredDataSources rds = selection.newRequiredDataSources();
            rds.setDataSources(Collections.emptyList());
            selection.addBusinessRule(rds);
            RootDataItem item = selection.newDataItem();
            selection.addBusinessItem(item);
            item.setExpression(expression);
            this.verify(item);
        }
        catch (MetadataException e) {
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, IQDataServicesResourceBundle.getStringResource("DataServices.ErrorVerifyingQuery.Message.txt"));
            _logger.error((Object)msF, (Throwable)e);
            throw new DataServicesException((MessageFormatter)msF, (Throwable)e);
        }
        finally {
            selection.dispose();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SASScope
    public void verify(Join join) throws MetadataException, DataServicesException, DataRetrievalException {
        BusinessModel businessModel = join.getBusinessModel();
        DataSelection ds = DataSelectionFactory.newDataSelection(businessModel);
        SessionContextInterface session = businessModel.getSession();
        Map<String, com.sas.iquery.execution2.ResultSetInterface> resultMap = null;
        QueryConnectionInterface myQueryConnector = null;
        try {
            SimpleConditionalExpression_Comparison expression;
            RequiredDataSources rds = ds.newRequiredDataSources();
            rds.setDataSources(Collections.emptyList());
            ds.addBusinessRule(rds);
            RootDataItem diLeft = ds.newDataItem();
            ExpressionInterface expr = join.getLeftDataSource().getColumns().get(0);
            diLeft.setExpression(expr);
            ds.addResultItem(diLeft, Role.COLUMN);
            ds.addBusinessItem(diLeft);
            RootDataItem diRight = ds.newDataItem();
            expr = join.getRightDataSource().getColumns().get(0);
            diRight.setExpression(expr);
            ds.addResultItem(diRight, Role.COLUMN);
            ds.addBusinessItem(diRight);
            ConstantExpression right = new ConstantExpression();
            right.setValue("1");
            right.setExpressionType(2);
            ConstantExpression left = new ConstantExpression();
            left.setValue("0");
            left.setExpressionType(2);
            SimpleConditionalExpression_Comparison condExpr = expression = new SimpleConditionalExpression_Comparison();
            condExpr.setLeftExpression(left);
            condExpr.setComparisonOperator(ComparisonOperator.COMPARE_EQ);
            condExpr.setRightExpression(right);
            FilterItem myFilter = ds.newFilterItem();
            myFilter.setExpression(condExpr);
            myFilter.setLabel("BIQZeroEqOne");
            List<FilterItem> filters = ds.getFilters();
            filters.add(myFilter);
            ds.addBusinessItem(myFilter);
            ds.setFilters(filters);
            Governing governing = ds.newGoverning();
            governing.setOutputObservations(1);
            if (governing instanceof GoverningImpl) {
                ((GoverningImpl)governing).setInputObservations(0);
            }
            ds.addBusinessRule(governing);
            List<Reason> reasons = ds.getReasonsNotValid();
            if (!reasons.isEmpty()) {
                String queryID = ds.getID();
                MessageFormatter message = this.formatReasonsBasedMessage("DataServices.InvalidDataSelection.Message.fmt.txt", queryID, reasons);
                DataServicesException e = new DataServicesException(message, reasons);
                throw e;
            }
            myQueryConnector = this.getQueryConnector(session, 0);
            List<DataSelection> selections = Collections.singletonList(ds);
            resultMap = myQueryConnector.retrieveQueryResultMap(selections);
            this.closeMyQueryConnection(session, resultMap, myQueryConnector);
        }
        catch (IntelligentQueryException iqe) {
            try {
                MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.UnableToVerify.Message.fmt.txt", "Join");
                _logger.info((Object)message, (Throwable)iqe);
                throw new DataServicesException(message, (Throwable)iqe);
                catch (DataServicesException de) {
                    message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.UnableToVerify.Message.fmt.txt", "Join");
                    _logger.info((Object)message, (Throwable)de);
                    throw new DataServicesException(message, (Throwable)de);
                }
            }
            catch (Throwable throwable) {
                this.closeMyQueryConnection(session, resultMap, myQueryConnector);
                ds.dispose();
                throw throwable;
            }
        }
        ds.dispose();
    }

    private QueryConnectionInterface getQueryConnector(SessionContextInterface session, int connectionLifetime) {
        QueryConnectionInterface myQueryConnection = this._queryConnector == null ? IQDataServices.newQueryConnector(session, connectionLifetime, 0) : this._queryConnector;
        return myQueryConnection;
    }

    public static QueryConnectorInterface newQueryConnector(SessionContextInterface session, int connectionLifetime, int retrievalPolicy) {
        QueryConnector newQueryConnector = new QueryConnector();
        RetrievalPolicy policy = newQueryConnector.getRetrievalPolicy();
        if (retrievalPolicy != -1) {
            policy.setPolicyValue(retrievalPolicy);
        }
        if (connectionLifetime != -1) {
            policy.getConnectionConfiguration().setConnectionLifetime(connectionLifetime);
        }
        if (session != null) {
            try {
                SessionQueryConnectorsManager.registerQueryConnector(newQueryConnector, session);
            }
            catch (DataRetrievalException e) {
                _logger.warn((Object)e);
            }
        }
        return newQueryConnector;
    }

    public static void closeQueryConnector(QueryConnectorInterface queryConnector, SessionContextInterface sessionContext, Object resultOrResults) throws ExecutionException, DataRetrievalException {
        if (queryConnector != null && sessionContext != null) {
            queryConnector.closeResources(sessionContext, 15);
        }
        if (resultOrResults != null) {
            if (resultOrResults instanceof Map) {
                for (Object obj : ((Map)resultOrResults).values()) {
                    if (!(obj instanceof com.sas.iquery.execution2.ResultSetInterface)) continue;
                    IQDataServices.closeResultSet(queryConnector, (com.sas.iquery.execution2.ResultSetInterface)obj);
                }
            } else if (resultOrResults instanceof Collection) {
                for (Object obj : (Collection)resultOrResults) {
                    if (!(obj instanceof com.sas.iquery.execution2.ResultSetInterface)) continue;
                    IQDataServices.closeResultSet(queryConnector, (com.sas.iquery.execution2.ResultSetInterface)obj);
                }
            } else if (resultOrResults instanceof com.sas.iquery.execution2.ResultSetInterface) {
                IQDataServices.closeResultSet(queryConnector, (com.sas.iquery.execution2.ResultSetInterface)resultOrResults);
            }
        }
        if (queryConnector instanceof QueryConnector) {
            SessionQueryConnectorsManager.unRegisterQueryConnector((QueryConnector)queryConnector, sessionContext);
        }
    }

    public static void closeResultSet(QueryConnectionInterface queryConnector, @Nullable com.sas.iquery.execution2.ResultSetInterface resultSet) throws ExecutionException {
        if (resultSet != null) {
            Object rs = resultSet.getResultSet();
            if (rs instanceof OLAPDataSet) {
                OLAPDataSet olapDS = (OLAPDataSet)rs;
                try {
                    olapDS.close();
                }
                catch (OLAPException e) {
                    _logger.warn("Closing Olap DataSet encountered a problem.", (Throwable)e);
                }
            }
            resultSet.close();
            try {
                if (queryConnector instanceof QueryConnectorInterface) {
                    ((QueryConnectorInterface)queryConnector).closeResult(resultSet);
                }
            }
            catch (DataRetrievalException e) {
                _logger.warn("Query connector closing result set encountered a problem.", (Throwable)e);
            }
        }
    }

    public static void closeResultSets(QueryConnectorInterface queryConnector, Map<?, ?> results) throws ExecutionException {
        for (Object resultSet : results.values()) {
            if (!(resultSet instanceof com.sas.iquery.execution2.ResultSetInterface)) continue;
            IQDataServices.closeResultSet(queryConnector, (com.sas.iquery.execution2.ResultSetInterface)resultSet);
        }
    }
}

