/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataservices;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataUnresolvedException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.relational.DataItemRankFilter;
import com.sas.iquery.metadata.expr.ConstantExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.iqtextparser.ParseError;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNode;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNodeUtil;
import com.sas.iquery.metadata.expr.iqtextparser.ParserUtil;
import com.sas.iquery.metadata.expr.iqtextparser.TokenError;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.strategies.sas.oma.ExpandedProcSummaryStatement;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@SubjectToChange
public class DataRetrievalUtil {
    private static final Logger _logger = LogManager.getLogger((String)"DataRetrievalUtil.class");
    @SASScope
    public static int MAX_CATEGORIES_PER_ROLAP_QUERY = 31;

    public static boolean hasSummarizeableItems(DataSelection ds) throws GenerationException {
        return DataRetrievalUtil._hasSummarizeableItems(ds);
    }

    public static boolean hasSummarizeableItems(BusinessQuery bq) throws IllegalArgumentException {
        try {
            return DataRetrievalUtil._hasSummarizeableItems(bq);
        }
        catch (GenerationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static boolean _hasSummarizeableItems(@Nullable BusinessQuery bq) throws GenerationException {
        boolean hasSummarizeableItems = false;
        if (bq != null) {
            for (SelectedItem item : bq.getSelectedItems()) {
                Role role = item.getRole();
                if (!Role.isOutputResultRole(bq, role) || !DataRetrievalUtil.isSummarizableItem(item.getItem())) continue;
                hasSummarizeableItems = true;
                break;
            }
        }
        return hasSummarizeableItems;
    }

    public static boolean isItemToSummarize(DataItem item) throws IllegalArgumentException {
        try {
            return DataRetrievalUtil.isSummarizableItem(item);
        }
        catch (GenerationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isSummarizableItem(DataItem item) throws GenerationException {
        boolean returnBool = false;
        if (item != null) {
            int expressionType;
            DataItem numerator;
            if (FractionOfTotalUtilImpl.isFractionOfTotalItem(item) && DataRetrievalUtil.isItemToSummarize(numerator = FractionOfTotalUtilImpl.getFractionOfTotalNumerator(item))) {
                return true;
            }
            DataItemActionType itemUsage = item.getUsage();
            Function aggregationType = item.getAggregationType();
            FunctionNameID functionID = null;
            if (aggregationType != null) {
                functionID = aggregationType.getFunctionNameID();
            }
            if (functionID != null && (expressionType = item.getExpressionTypeIgnoringFormattingForced()) == 2 && (itemUsage == DataItemActionType.USAGE_AGGREGATE || itemUsage == DataItemActionType.USAGE_DETAIL)) {
                returnBool = true;
            }
        }
        return returnBool;
    }

    static boolean visualTotalStatistic(DataItemActionType itemUsage, FunctionNameID functionID) {
        boolean additiveStatistic = false;
        if (functionID != null) {
            if (itemUsage == DataItemActionType.USAGE_DETAIL) {
                additiveStatistic = functionID.equals(FunctionNameID.SUM) || functionID.equals(FunctionNameID.INTERNAL_AGGREGATION_ADDITIVE);
            } else if (itemUsage == DataItemActionType.USAGE_AGGREGATE) {
                additiveStatistic = functionID.equals(FunctionNameID.SUM) || functionID.equals(FunctionNameID.COUNT) || functionID.equals(FunctionNameID.FREQ) || functionID.equals(FunctionNameID.N) || functionID.equals(FunctionNameID.INTERNAL_AGGREGATION_ADDITIVE);
            }
        }
        return additiveStatistic;
    }

    public static boolean hasValidROLAPAggregation(DataItem item) {
        boolean isValid = false;
        if (item != null) {
            Function aggregation = item.getAggregationType();
            ExpressionInterface expression = item.getExpression();
            DataItemActionType actionType = item.getUsage();
            isValid = DataRetrievalUtil.isValidROLAPAggregation(actionType, expression, aggregation, item.getBusinessModel());
        }
        return isValid;
    }

    public static boolean isValidROLAPAggregation(DataItem item, Function aggregation) {
        boolean isValid = false;
        if (item != null) {
            ExpressionInterface expression = item.getExpression();
            DataItemActionType actionType = item.getUsage();
            isValid = DataRetrievalUtil.isValidROLAPAggregation(actionType, expression, aggregation, item.getBusinessModel());
        }
        return isValid;
    }

    static boolean isValidROLAPAggregation(DataItemActionType actionType, ExpressionInterface expression, Function aggregation, BusinessModel businessModel) {
        boolean isValid;
        block8: {
            int expressionType;
            isValid = false;
            if (actionType == DataItemActionType.USAGE_AGGREGATE && ((expressionType = IQModelImplUtilities.getExpressionTypeFactoringInAggregation(expression, actionType, aggregation)) == 3 || expressionType == 11)) {
                return false;
            }
            if (!(expression instanceof ConstantExpressionInterface) && aggregation != null) {
                isValid = DataRetrievalUtil.isValidROLAPAggregation(aggregation);
                FunctionNameID functionName = aggregation.getFunctionNameID();
                if (functionName != null && (functionName.equals(FunctionNameID.INTERNAL_AGGREGATION) || functionName.equals(FunctionNameID.INTERNAL_AGGREGATION_ADDITIVE))) {
                    try {
                        isValid = DataRetrievalUtil.containsValidUserTypedAggregation(expression, businessModel);
                        if (!isValid) {
                            ArrayList resources = new ArrayList();
                            int searchFlags = 65533;
                            Utils.addResource(resources, expression, DataItem.class, searchFlags);
                            if (resources.size() > 0) {
                                boolean recursiveTrue = true;
                                Iterator it = resources.iterator();
                                while (it.hasNext() && recursiveTrue) {
                                    recursiveTrue = DataRetrievalUtil.hasValidROLAPAggregation((DataItem)it.next());
                                }
                                isValid = recursiveTrue;
                            }
                        }
                    }
                    catch (MetadataException e) {
                        if (!_logger.isDebugEnabled()) break block8;
                        _logger.debug("Problem when checking for ROLAP aggregation.");
                    }
                }
            }
        }
        return isValid;
    }

    public static boolean isValidROLAPAggregation(Function aggregation) {
        if (aggregation == null) {
            return false;
        }
        FunctionNameID functionNameID = aggregation.getFunctionNameID();
        return DataRetrievalUtil.isValidROLAPAggregation(functionNameID);
    }

    @Deprecated
    @SASScope
    public static boolean isValidROLAPAggregation(String functionNameID) {
        return false;
    }

    public static boolean isValidROLAPAggregation(@Nullable FunctionNameID functionNameID) {
        if (functionNameID == null) {
            return false;
        }
        return ExpandedProcSummaryStatement.getStatisticText(functionNameID) != null;
    }

    public static boolean isModelROLAP(DataSelection dataSelection) throws GenerationException {
        if (dataSelection.getInputStructure().isOLAP()) {
            return false;
        }
        List<SelectedItem> selectedItems = dataSelection.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            Role role = selectedItem.getRole();
            if (role != Role.ROW) continue;
            return true;
        }
        return false;
    }

    @SASScope
    public static boolean isGrandRole(Role role) {
        if (role != null) {
            return role.equals(Role.COLUMN);
        }
        return false;
    }

    @SASScope
    public static boolean isGrandTotal(DataSelection dataSelection) {
        String totalType;
        boolean returnBool = false;
        if (dataSelection != null && (totalType = dataSelection.getTotalType(Role.COLUMN)) != null && (totalType.equals(BusinessQuery.GRANDTOTAL) || totalType.equals(BusinessQuery.AXISTOTAL) || totalType.equals(BusinessQuery.ALLTOTAL))) {
            returnBool = true;
        }
        return returnBool;
    }

    public static boolean isModelGrandTotal(DataSelection dataSelection) throws GenerationException {
        if (!DataRetrievalUtil.isGrandTotal(dataSelection)) {
            return false;
        }
        List<SelectedItem> selectedItems = dataSelection.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            Role role = selectedItem.getRole();
            boolean isOutputResultItem = Role.isOutputResultRole(dataSelection, role);
            if (!isOutputResultItem || DataRetrievalUtil.isGrandRole(role)) continue;
            return false;
        }
        return true;
    }

    public static boolean isModelRanked(@Nullable DataSelection model) {
        return DataRetrievalUtil.getRankedItemCount(model) > 0;
    }

    @SASScope
    public static int getRankedItemCount(@Nullable DataSelection selection) {
        int rankedItemsCount = 0;
        if (selection != null) {
            block0: for (DataItem item : selection.getResultItems()) {
                if (!item.hasSteps()) continue;
                for (StepInterface step : item.getSteps()) {
                    if (!(step instanceof DataItemRankFilter)) continue;
                    ++rankedItemsCount;
                    continue block0;
                }
            }
        }
        return rankedItemsCount;
    }

    @SASScope
    public static String generateFormat(DataItem di) throws MetadataException {
        try {
            return IQModelImplUtilities.generateDefaultFormat(di);
        }
        catch (MetadataUnresolvedException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataRetrievalUtil.CannotGenerateFormat.fmt.txt", di.getID()));
        }
    }

    public static boolean isNonAdditiveMeasure(DataItem resultItem) {
        FunctionNameID functionNameID;
        Function aggType;
        boolean nonAdditive = false;
        DataItemActionType usage = resultItem.getUsage();
        if (usage != DataItemActionType.USAGE_CATEGORY && (aggType = resultItem.getAggregationType()) != null && (functionNameID = aggType.getFunctionNameID()) != null && !DataRetrievalUtil.visualTotalStatistic(usage, functionNameID)) {
            nonAdditive = true;
        }
        return nonAdditive;
    }

    public static boolean isModelDetailed(@Nonnull DataSelection dataSelection) {
        boolean isDetailed = false;
        for (DataItem item : dataSelection.getResultItems()) {
            DataItemActionType usage = item.getUsage();
            if (usage != DataItemActionType.USAGE_DETAIL) continue;
            isDetailed = true;
            break;
        }
        return isDetailed;
    }

    private static boolean containsValidUserTypedAggregation(ExpressionInterface expression, BusinessModel businessModel) throws MetadataException {
        String text;
        boolean isValid = false;
        ServerProperties sp = businessModel.getServerProperties();
        if (sp != null && (text = StringExpressionUtil.getInstance().getText(expression, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, businessModel)) != null && text.trim().length() > 0) {
            ParsedNode node = DataRetrievalUtil.parse(sp, text);
            if (node == null) {
                _logger.debug("Could not parse expression text, evaluate it to not having a user typed aggregation.");
            } else {
                Set<ParsedNode> aggregateNodes;
                isValid = ParsedNodeUtil.isAggFunction(node);
                if (!isValid && (aggregateNodes = ParsedNodeUtil.getAggregateReferences(node).keySet()) != null && aggregateNodes.size() > 0) {
                    boolean allResourcesAggregated = true;
                    Set<ParsedNode> resourceNodes = ParsedNodeUtil.getResourceReferences(node).keySet();
                    Iterator<ParsedNode> iteratorResources = resourceNodes.iterator();
                    while (iteratorResources.hasNext() && allResourcesAggregated) {
                        ParsedNode resourceNode = iteratorResources.next();
                        boolean resourceIsAggregated = false;
                        ExpressionInterface resourceExpr = ParserUtil.newExpressionInterface(resourceNode, businessModel, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE);
                        if (resourceExpr instanceof DataItem) {
                            DataItem da = (DataItem)resourceExpr;
                            if (da.getUsage().equals(DataItemActionType.USAGE_AGGREGATE)) {
                                resourceIsAggregated = true;
                            }
                        } else {
                            Iterator<ParsedNode> iteratorAggregates = aggregateNodes.iterator();
                            while (iteratorAggregates.hasNext() && !resourceIsAggregated) {
                                ParsedNode aggregateNode = iteratorAggregates.next();
                                if (!aggregateNode.contains(resourceNode)) continue;
                                resourceIsAggregated = true;
                            }
                        }
                        if (resourceIsAggregated) continue;
                        allResourcesAggregated = false;
                    }
                    if (allResourcesAggregated) {
                        isValid = true;
                    }
                }
            }
        }
        return isValid;
    }

    private static ParsedNode parse(ServerProperties sp, String text) {
        ParsedNode node;
        block8: {
            node = null;
            try {
                try {
                    node = ParserUtil.parsePredicate(text, false, true, false, false);
                }
                catch (ParseError e) {
                    _logger.debug("Expression was not a valid SQL expression, attempting to parse it as a SAS Format.");
                    try {
                        node = ParserUtil.parseFormat(text, false, true, false, false);
                    }
                    catch (ParseError e2) {
                        _logger.debug("Could not parse as format: " + e.getMessage());
                        throw e;
                    }
                }
            }
            catch (TokenError e) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Could not parse as expression: " + e.getMessage());
                    _logger.debug("Parsing Options = {ignore comments, enable tuples, disable sets, disable object references}");
                    _logger.debug("Could not parse [" + text + "] for embedded user typed aggregation detection.");
                }
            }
            catch (ParseError e) {
                if (!_logger.isDebugEnabled()) break block8;
                _logger.debug("Could not parse as expression: " + e.getMessage());
                _logger.debug("Parsing Options = {ignore comments, enable tuples, disable sets, disable object references}");
                _logger.debug("Could not parse [" + text + "] for embedded user typed aggregation detection.", (Throwable)e);
            }
        }
        return node;
    }
}

