/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval.convenience.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.ISession;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.IQueryServicesIllegalStateException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataUnresolvedException;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryTotalModeType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.NonCalculatedValue;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.physical.CalculatedMember;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.NamedSet;
import com.sas.iquery.metadata.physical.OlapItem;
import com.sas.iquery.strategies.sas.oma.olap.step.StepManager;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.OLAPServerUtilities;
import com.sas.iquery.util.impl.OLAPUtilities;
import com.sas.storage.flattened.sasmdx.FlattenResultSet;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@SubjectToChange
public class ShowDetail {
    private static final String DESIRED_PREFIX = "SASQueryServices.";
    public static final int FORMAT_FORMATTED = 1;
    public static final int FORMAT_FORMATTEDNOEMPTY = 4;
    public static final int FORMAT_RAW = 0;
    public static final int FORMAT_RAWANDFORMATTED = 2;
    public static final int FORMAT_RAWANDFORMATTEDNOEMPTY = 5;
    public static final int FORMAT_RAWNOEMPTY = 3;
    @SASScope
    public static final String PROPERTY_ACTIVATE_SHOWDETAIL_ALWAYS_ON_TOTAL_CELL = "SASQueryServices.ShowDetailAlwaysOnTotalCell";
    @SASScope
    public static final String PROPERTY_ACTIVATE_SHOWDETAIL_SELECTIVE_ON_TOTAL_CELL = "SASQueryServices.ShowDetailSelectiveOnTotalCell";
    private static final Logger _logger = LogManager.getLogger(ShowDetail.class);
    private static final Logger _bqOLAPLogger = LogManager.getLogger(BusinessQueryOLAPUtil.class);
    private static final Level ERROR_LEVEL = Level.ERROR;

    private static String applyAxisFilter(TupleElementInterface[] tupleElements, BusinessQuery businessQuery, StringBuilder query, MetadataInterface metaI) {
        block12: {
            try {
                if (ShowDetail.isTotalSelected(tupleElements, businessQuery)) {
                    StepInterface step;
                    Iterator<StepInterface> rowAxisFilter = businessQuery.getSteps(Role.ROW).iterator();
                    Iterator<StepInterface> colAxisFilter = businessQuery.getSteps(Role.COLUMN).iterator();
                    if (ShowDetail.isGrandTotalSelected(tupleElements) && (rowAxisFilter.hasNext() || colAxisFilter.hasNext())) {
                        return query.toString();
                    }
                    while (rowAxisFilter.hasNext()) {
                        step = rowAxisFilter.next();
                        if (step instanceof BusinessQueryDataBasedFilter) {
                            if (ShowDetail.hasCalculatedMeasureOrTimeExpressionMeasureInAxisFilter(((BusinessQueryDataBasedFilter)step).getLeftExpression())) {
                                return query.toString();
                            }
                            return ShowDetail.getDataBaseMDXExpression((DataSelection)businessQuery, query.toString(), (BusinessQueryDataBasedFilter)step, metaI);
                        }
                        if (!(step instanceof BusinessQueryRankFilter)) continue;
                        if (ShowDetail.hasCalculatedMeasureOrTimeExpressionMeasureInAxisFilter(((BusinessQueryRankFilter)step).getRankQualifiers())) {
                            return query.toString();
                        }
                        return ShowDetail.getRankMDXExpression(query.toString(), (BusinessQueryRankFilter)step, metaI, tupleElements);
                    }
                    while (colAxisFilter.hasNext()) {
                        step = colAxisFilter.next();
                        if (step instanceof BusinessQueryDataBasedFilter) {
                            if (ShowDetail.hasCalculatedMeasureOrTimeExpressionMeasureInAxisFilter(((BusinessQueryDataBasedFilter)step).getLeftExpression())) {
                                return query.toString();
                            }
                            return ShowDetail.getDataBaseMDXExpression((DataSelection)businessQuery, query.toString(), (BusinessQueryDataBasedFilter)step, metaI);
                        }
                        if (!(step instanceof BusinessQueryRankFilter)) continue;
                        if (ShowDetail.hasCalculatedMeasureOrTimeExpressionMeasureInAxisFilter(((BusinessQueryRankFilter)step).getRankQualifiers())) {
                            return query.toString();
                        }
                        return ShowDetail.getRankMDXExpression(query.toString(), (BusinessQueryRankFilter)step, metaI, tupleElements);
                    }
                }
            }
            catch (GenerationException e) {
                if (!_logger.isEnabled(ERROR_LEVEL)) break block12;
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return query.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String buildExpression(ExpressionInterface expression, MetadataInterface metaI) throws GenerationException {
        StringBuffer coreExpression = new StringBuffer();
        if (expression instanceof Measure) {
            String measure = ShowDetail.getMeasureExpression((Measure)expression);
            coreExpression.append(measure);
            return coreExpression.toString();
        }
        if (!(expression instanceof DataItem)) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("BusinessQueryDataBasedBadTypeForDataItem.txt", new Object[0]);
            throw new GenerationException(mft);
        }
        DataItem da = (DataItem)expression;
        expression = da.getExpression();
        StructureOfDataItem struct = da.getStructure();
        if (struct != StructureOfDataItem.STRUCTURE_MEASURE) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("BusinessQueryDataBasedDataItemMustBeMeasure.txt", new Object[0]);
            throw new GenerationException(mft);
        }
        if (expression instanceof Measure) {
            String measure = ShowDetail.getMeasureExpression((Measure)expression);
            if (measure == null) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("BusinessQueryDataBasedBadTypeForDataItem.txt", new Object[0]);
                throw new GenerationException(mft);
            }
            coreExpression.append(measure);
            return coreExpression.toString();
        }
        if (!(expression instanceof ResourceAwareStringExpression)) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("BusinessQueryDataBasedBadTypeForDataItem.txt", new Object[0]);
            throw new GenerationException(mft);
        }
        try {
            String expressionString = ShowDetail.getCoreExpression(expression, metaI, da.getStartingLevelName());
            if (expressionString == null) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("BusinessQueryDataBasedBadTypeForDataItem.txt", new Object[0]);
                throw new GenerationException(mft);
            }
            coreExpression.append(expressionString);
            return coreExpression.toString();
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
    }

    private static String getCoreExpression(ExpressionInterface expression, MetadataInterface metaI, String startingLevel) {
        block24: {
            StringBuffer coreExpression = new StringBuffer();
            try {
                if (expression instanceof DataItem) {
                    expression = ((DataItem)expression).getExpression();
                }
                if (expression instanceof Dimension) {
                    String dimension = ShowDetail.getDimensionExpression((Dimension)expression);
                    coreExpression.append(dimension);
                } else if (expression instanceof Hierarchy) {
                    String hierarchy = ShowDetail.getHierarchyExpression((Hierarchy)expression, startingLevel, metaI);
                    coreExpression.append(hierarchy);
                } else if (expression instanceof NamedSet) {
                    NamedSet namedSet = (NamedSet)expression;
                    coreExpression.append(namedSet.getUniqueName());
                } else if (expression instanceof CalculatedMember) {
                    CalculatedMember calcMem = (CalculatedMember)expression;
                    coreExpression.append(calcMem.getUniqueName());
                } else if (expression instanceof com.sas.iquery.metadata.physical.Level) {
                    String level = ShowDetail.getLevelExpression((com.sas.iquery.metadata.physical.Level)expression);
                    coreExpression.append(level);
                } else if (expression instanceof Measure) {
                    String measure = ShowDetail.getMeasureExpression((Measure)expression);
                    coreExpression.append(measure);
                } else if (expression instanceof ResourceAwareStringExpression) {
                    ResourceAwareStringExpression resourceExp = (ResourceAwareStringExpression)expression;
                    try {
                        List<BusinessModelResource> resources = resourceExp.getResources(BusinessModelResource.class, 65535);
                        for (BusinessModelResource bmaResource : resources) {
                            if (bmaResource instanceof DataItem) {
                                DataItem di = (DataItem)bmaResource;
                                coreExpression.append(ShowDetail.getCoreExpression(di, metaI, di.getStartingLevelName()));
                                continue;
                            }
                            if (!(bmaResource instanceof Dimension) && !(bmaResource instanceof Hierarchy) && !(bmaResource instanceof NamedSet) && !(bmaResource instanceof CalculatedMember) && !(bmaResource instanceof com.sas.iquery.metadata.physical.Level) && !(bmaResource instanceof Measure)) continue;
                            OlapItem item = (OlapItem)((Object)bmaResource);
                            coreExpression.append(item.getUniqueName());
                            if (!(bmaResource instanceof Measure)) continue;
                            break;
                        }
                    }
                    catch (MetadataException me) {
                        if (_logger.isEnabled(ERROR_LEVEL)) {
                            _logger.error(me.getLocalizedMessage(), (Throwable)me);
                        }
                        return null;
                    }
                }
                return coreExpression.toString();
            }
            catch (MetadataUnresolvedException mdue) {
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(mdue.getLocalizedMessage(), (Throwable)mdue);
                }
            }
            catch (MetadataException me) {
                if (!_logger.isEnabled(ERROR_LEVEL)) break block24;
                _logger.error(me.getLocalizedMessage(), (Throwable)me);
            }
        }
        return null;
    }

    private static String getDataBaseMDXExpression(DataSelection dataSelection, String currentExpression, BusinessQueryDataBasedFilter step, MetadataInterface metaI) throws GenerationException {
        try {
            StringBuffer MDXExpression = new StringBuffer();
            List<ExpressionInterface> memberNames = step.getLeftExpression();
            List<NonCalculatedValue> memberValues = step.getRightExpression();
            if (memberNames.isEmpty()) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("DataBasedFilterNoLeft.txt", new Object[0]);
                throw new GenerationException(mft);
            }
            if (memberValues.isEmpty()) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("DataBasedFilterNoRight.txt", new Object[0]);
                throw new GenerationException(mft);
            }
            MDXExpression.append("Filter(").append(currentExpression).append(",(");
            MDXExpression.append("(");
            for (ExpressionInterface expression : memberNames) {
                if (expression instanceof StringExpression) {
                    MDXExpression.append(((StringExpression)expression).getText());
                } else {
                    String daCore = ShowDetail.buildExpression(expression, metaI);
                    if (daCore == null) {
                        return currentExpression;
                    }
                    MDXExpression.append(daCore);
                }
                MDXExpression.append(", ");
            }
            MDXExpression.setLength(MDXExpression.length() - 2);
            MDXExpression.append(")");
            MDXExpression.append(" ").append(step.getOperator().toString()).append(" ");
            ExpressionInterface value = (ExpressionInterface)((Object)memberValues.get(0));
            if (value instanceof StringExpression) {
                StringExpression s = (StringExpression)value;
                String eo = s.getText();
                List<DataItem> daList = value.getResources(DataItem.class, 0);
                if (daList.size() > 0) {
                    DataItem da = daList.get(0);
                    StructureOfDataItem st = da.getStructure();
                    if (st == StructureOfDataItem.STRUCTURE_MEASURE) {
                        String daCore = ShowDetail.buildExpression(da, metaI);
                        if (daCore == null) {
                            return currentExpression;
                        }
                        MDXExpression.append("(").append(daCore).append(")");
                    }
                } else {
                    MDXExpression.append(eo);
                }
            } else if (value instanceof ConstantExpression) {
                MDXExpression.append(((ConstantExpression)value).getValue());
            } else {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("BusinessQueryDataBasedFilterBadLeftExpression.fmt.txt", value.getClass().getName());
                _logger.error((Object)mft);
                throw new GenerationException(mft);
            }
            MDXExpression.append("))");
            return MDXExpression.toString();
        }
        catch (MetadataException ex) {
            throw new GenerationException(ex);
        }
    }

    @SASScope
    public static ResultSet getDetailData(OLAPDataSetInterface model, String[] uniqueIdentifiers) {
        StringBuilder query = new StringBuilder();
        try {
            String cubeName = OLAPUtilities.getCubeNameFromOLAPModel(model);
            if (cubeName == null || uniqueIdentifiers.length == 0) {
                Object[] msgArgs2 = new Object[]{"CubeName == " + cubeName, "UniqueIdentifier size == " + uniqueIdentifiers.length};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(msF.toString());
                }
                throw new IQueryServicesIllegalStateException(IQDataServicesResourceBundle.getMessageFormatter("ShowDetail.ShowDetailNullException.Message.txt", new Object[0]));
            }
            query = new StringBuilder();
            if (uniqueIdentifiers.length > 0) {
                query.append("DRILLTHROUGH SELECT FROM ").append("[" + cubeName + "]").append(" WHERE (");
                for (int i = 0; i < uniqueIdentifiers.length; ++i) {
                    query.append(uniqueIdentifiers[i]);
                    if (i >= uniqueIdentifiers.length - 1) continue;
                    query.append(", ");
                }
                query.append(")");
            }
            return ShowDetail.getFlatResultSet(model.getConnection(), query.toString(), 1);
        }
        catch (OLAPException se) {
            _logger.error((Object)se);
            MDXGenerationUtil.applyDebugStatement(query.toString(), ShowDetail.class);
            throw new IQueryServicesIllegalStateException(IQDataServicesResourceBundle.getMessageFormatter("ShowDetail.ShowDetailException.Message.txt", new Object[0]), (Throwable)se);
        }
        catch (MetadataException se) {
            _logger.error((Object)se);
            MDXGenerationUtil.applyDebugStatement(query.toString(), ShowDetail.class);
            throw new IQueryServicesIllegalStateException(IQDataServicesResourceBundle.getMessageFormatter("ShowDetail.ShowDetailException.Message.txt", new Object[0]), (Throwable)se);
        }
    }

    @SASScope
    public static ResultSet getDetailData(OLAPDataSetInterface model, TupleElementInterface[] tupleElements, int maxRow, int firstRowSet) {
        return ShowDetail.getDetailData(model, tupleElements, 1, maxRow, firstRowSet);
    }

    public static ResultSet getDetailData(OLAPDataSetInterface model, TupleElementInterface[] tupleElements) {
        return ShowDetail.getDetailData(model, tupleElements, 1, -1, -1);
    }

    public static ResultSet getDetailData(OLAPDataSetInterface model, TupleElementInterface[] tupleElements, int formatType) {
        return ShowDetail.getDetailData(model, tupleElements, formatType, -1, -1);
    }

    @SASScope
    public static ResultSet getDetailData(OLAPDataSetInterface model, TupleElementInterface[] tupleElements, int formatType, int maxRows, int firstRowSet) {
        String query = "";
        if (formatType != 1 && formatType != 4 && formatType != 0 && formatType != 2 && formatType != 5 && formatType != 3) {
            throw new IQueryServicesIllegalArgumentException(IQDataServicesResourceBundle.getMessageFormatter("ShowDetail.ShowDetailIllegalFormatArgument.Message.txt", new Object[0]));
        }
        try {
            query = ShowDetail.getQuery(model, tupleElements, maxRows, firstRowSet);
            MDXGenerationUtil.applyDebugStatement(query, ShowDetail.class);
            Object connection = model.getConnection();
            return ShowDetail.getFlatResultSet(connection, query, formatType);
        }
        catch (OLAPException se) {
            _logger.error(query, (Throwable)se);
            throw new IQueryServicesIllegalStateException(IQDataServicesResourceBundle.getMessageFormatter("ShowDetail.ShowDetailException.Message.txt", new Object[0]));
        }
    }

    private static String getDimensionExpression(Dimension dimension) throws MetadataException {
        List<com.sas.iquery.metadata.physical.Level> levels;
        StringBuilder buildExpression = new StringBuilder();
        String defaultHierarchyName = dimension.getDefaultHierarchy();
        List<Hierarchy> hierarchies = dimension.getHierarchies();
        Iterator<Hierarchy> iterator = hierarchies.iterator();
        Hierarchy hierarchy = null;
        while (iterator.hasNext()) {
            hierarchy = iterator.next();
            String uniqueName = hierarchy.getHierarchyUniqueName();
            if (defaultHierarchyName != null && !defaultHierarchyName.equalsIgnoreCase(uniqueName)) continue;
            break;
        }
        if (hierarchy != null && (levels = hierarchy.getLevels()).size() > 0) {
            com.sas.iquery.metadata.physical.Level topLevel = levels.get(0);
            String levelName = topLevel.getLevelName();
            if (levelName.startsWith("All") && levels.size() > 1) {
                topLevel = levels.get(1);
            }
            buildExpression.append(topLevel.getUniqueName()).append(".").append("MEMBERS");
        }
        return buildExpression.toString();
    }

    private static String getDimNameFromUniqueLevelName(String uniqueLevelName) {
        String key = uniqueLevelName.substring(0, uniqueLevelName.indexOf("."));
        key = key.replace('[', ' ');
        key = key.replace(']', ' ');
        key = key.trim();
        return key;
    }

    private static FlattenResultSet getFlatResultSet(Object connection, String query, int formatType) {
        FlattenResultSet flatResultSet = null;
        try {
            if (connection instanceof IMDXServer) {
                flatResultSet = new FlattenResultSet((IMDXServer)connection, null, formatType);
            } else if (connection instanceof ISession) {
                flatResultSet = new FlattenResultSet((ISession)connection, null, formatType);
            } else {
                _logger.error(query);
                _logger.error(connection);
                throw new IQueryServicesIllegalStateException(IQDataServicesResourceBundle.getMessageFormatter("ShowDetail.ShowDetailNoConnectionException.Message.txt", new Object[0]));
            }
            flatResultSet.executeQuery(query);
            if (flatResultSet.getQueryStatement() == null) {
                flatResultSet.setQueryStatement(query);
            }
        }
        catch (SQLException e) {
            _logger.error(query, (Throwable)e);
            throw new IQueryServicesIllegalStateException(e);
        }
        return flatResultSet;
    }

    private static String getHierarchyExpression(Hierarchy hierarchy, String startingLevelName, MetadataInterface metaI) throws MetadataException {
        StringBuilder buildExpression = new StringBuilder();
        OLAPServerUtilities olapServerUtil = OLAPServerUtilities.getInstance();
        olapServerUtil.setMetadataInterace(metaI);
        String hierName = null;
        hierName = olapServerUtil.getHierarchyExpression(hierarchy, startingLevelName);
        if (hierName == null) {
            if (_bqOLAPLogger.isEnabled(ERROR_LEVEL)) {
                _logger.error(hierarchy.toString());
            }
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("BusinessqueryOLAPNullHier.txt", new Object[0]));
        }
        buildExpression.append(hierName).append(".MEMBERS");
        return buildExpression.toString();
    }

    private static String getLevelExpression(com.sas.iquery.metadata.physical.Level level) throws MetadataException {
        StringBuilder buildExpression = new StringBuilder();
        buildExpression.append(level.getLevelUniqueName()).append(".MEMBERS");
        return buildExpression.toString();
    }

    private static String getMeasureExpression(Measure measure) {
        String measureName = null;
        try {
            measureName = measure.getUniqueName();
        }
        catch (MetadataException e) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
                _logger.error((Object)IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationMeasureLevelNameException.txt", new Object[0]));
            }
            return null;
        }
        return measureName;
    }

    private static LinkedHashMap<String, ArrayList<String>> getMemberElementMap(OLAPDataSetInterface model, MetadataInterface olapMeta, TupleElementInterface[] tupleElementsForAllAxis, BusinessQuery businessQuery, String cubeName, LinkedHashMap<String, ArrayList<String>> totalTupleMembers, TupleElementInterface[] selectedTupleElements) {
        LinkedHashMap<String, ArrayList<String>> elementMap = new LinkedHashMap<String, ArrayList<String>>(5);
        ArrayList<String> hiddenDataItems = new ArrayList<String>();
        try {
            HashMap<String, String> possibleListOfFilterConditions = new HashMap<String, String>();
            HashMap<String, String> listOfDataLocators = new HashMap<String, String>();
            HashMap<String, Object> listOfRASEValues = new HashMap<String, Object>();
            ArrayList<String> dimensionsSelected = new ArrayList<String>();
            List<DataItem> resultItemsInBusinessQuery = businessQuery.getResultItems();
            for (DataItem dataItem : resultItemsInBusinessQuery) {
                ExpressionInterface exp;
                String dimensionName = BusinessQueryOLAPUtil.getDimensionName(dataItem.getBusinessModel(), dataItem);
                String dimensionNameKey = "[" + dimensionName + "]";
                dimensionsSelected.add(dimensionName);
                Role role = businessQuery.getResultItemRole(dataItem);
                if (role.equals(Role.HIDDEN) || role.equals(Role.BACKGROUND)) {
                    hiddenDataItems.add(dimensionNameKey);
                }
                if ((exp = dataItem.getExpression()) instanceof ResourceAwareStringExpression) {
                    ResourceAwareStringExpression resourceExp = (ResourceAwareStringExpression)exp;
                    List<BusinessModelResource> resources = resourceExp.getResources(BusinessModelResource.class, 65535);
                    if (resources.isEmpty()) {
                        Object value = resourceExp.getText();
                        List<StepInterface> stepForDataItem = dataItem.getSteps();
                        if (stepForDataItem.size() > 0 && businessQuery instanceof DataSelection) {
                            StepManager stepManager = new StepManager(dataItem);
                            value = stepManager.generateMDX((DataSelection)businessQuery, (String)value);
                            if (_logger.isDebugEnabled()) {
                                _logger.debug("  Filter found in ShowDetail with RASE: " + (String)value);
                            }
                        }
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("  RASE in ShowDetail Found: " + (String)value);
                        }
                        listOfRASEValues.put(dimensionNameKey, value);
                        continue;
                    }
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("  RASE in ShowDetail Found: " + resourceExp.getText());
                    }
                    for (BusinessModelResource bmaResource : resources) {
                        if (!(bmaResource instanceof Hierarchy) && !(bmaResource instanceof com.sas.iquery.metadata.physical.Level) && !(bmaResource instanceof Dimension)) continue;
                        String definitionOfExpression = " ";
                        if (bmaResource instanceof Hierarchy) {
                            definitionOfExpression = ShowDetail.getHierarchyExpression((Hierarchy)bmaResource, dataItem.getStartingLevelName(), model.getDatabaseMetadata());
                        } else if (bmaResource instanceof NamedSet) {
                            NamedSet namedSet = (NamedSet)bmaResource;
                            definitionOfExpression = namedSet.getUniqueName();
                        } else if (bmaResource instanceof CalculatedMember) {
                            CalculatedMember calcMem = (CalculatedMember)bmaResource;
                            definitionOfExpression = calcMem.getUniqueName();
                        } else if (bmaResource instanceof Dimension) {
                            definitionOfExpression = ShowDetail.getDimensionExpression((Dimension)bmaResource);
                        } else if (bmaResource instanceof com.sas.iquery.metadata.physical.Level) {
                            definitionOfExpression = ShowDetail.getLevelExpression((com.sas.iquery.metadata.physical.Level)bmaResource);
                        }
                        List<StepInterface> stepForDataItem = dataItem.getSteps();
                        if (stepForDataItem.size() > 0 && businessQuery instanceof DataSelection) {
                            StepManager stepManager = new StepManager(dataItem);
                            if (definitionOfExpression.length() <= 0) continue;
                            String valueOfStep = stepManager.generateMDX((DataSelection)businessQuery, definitionOfExpression);
                            possibleListOfFilterConditions.put(dimensionNameKey, valueOfStep);
                            if (!_logger.isDebugEnabled()) continue;
                            _logger.debug("  Filter found in ShowDetail with RASE: " + valueOfStep);
                            continue;
                        }
                        String value = MDXGenerationUtil.buildMDXOnFlyExpression(dataItem);
                        listOfRASEValues.put(dimensionNameKey, value);
                    }
                    continue;
                }
                if (!(exp instanceof Hierarchy)) continue;
                Hierarchy hierarchyOfDataItem = (Hierarchy)exp;
                String hieraryExpression = ShowDetail.getHierarchyExpression(hierarchyOfDataItem, dataItem.getStartingLevelName(), olapMeta);
                listOfDataLocators.put(dimensionNameKey, hieraryExpression);
                if (dataItem.getSteps().size() <= 0 || !(businessQuery instanceof DataSelection)) continue;
                StepManager stepManager = new StepManager(dataItem);
                String valueOfStep = stepManager.generateMDX((DataSelection)businessQuery, hieraryExpression);
                possibleListOfFilterConditions.put(dimensionNameKey, valueOfStep);
                MDXGenerationUtil.applyDebugStatement("  Filter found in ShowDetail: " + valueOfStep, ShowDetail.class);
            }
            for (int index = 0; index < tupleElementsForAllAxis.length; ++index) {
                Filter filter1 = new Filter();
                filter1.setCubeName(cubeName);
                String uniqueLevelName = tupleElementsForAllAxis[index].getUniqueLevelName();
                filter1.setUniqueLevelName(uniqueLevelName);
                ArrayList<Object> tupleL = null;
                LevelInterface level = olapMeta.getLevel(filter1);
                DimensionInterface dimension = level.getHierarchy().getDimension();
                String dimName = dimension.getName();
                if (dimensionsSelected.contains(dimName)) {
                    ArrayList<String> listOfTotalMembers;
                    String dimNameKey = "[" + dimName + "]";
                    String tupleName = tupleElementsForAllAxis[index].getName();
                    if (tupleElementsForAllAxis[index].getType() != TupleElementType.TOTAL && tupleElementsForAllAxis[index].getType() != TupleElementType.SUBTOTAL && tupleElementsForAllAxis[index].getType() != TupleElementType.MEASURE) {
                        tupleL = elementMap.containsKey(dimName) ? elementMap.get(dimName) : new ArrayList();
                        if (!tupleL.contains(tupleName)) {
                            if (possibleListOfFilterConditions.containsKey(dimNameKey) && hiddenDataItems.contains(dimNameKey)) {
                                Object obj = possibleListOfFilterConditions.get(dimNameKey);
                                if (obj != null) {
                                    String filterValue = (String)obj;
                                    tupleL.add(filterValue);
                                } else {
                                    tupleL.add(tupleName);
                                }
                            } else {
                                tupleL.add(tupleName);
                            }
                        }
                        elementMap.put(dimName, tupleL);
                    } else {
                        String key = uniqueLevelName.substring(0, uniqueLevelName.indexOf("."));
                        if (possibleListOfFilterConditions.containsKey(key)) {
                            if (elementMap.containsKey(dimName)) {
                                tupleL = elementMap.get(dimName);
                            } else {
                                tupleL = new ArrayList();
                                tupleL.add((String)possibleListOfFilterConditions.get(key));
                            }
                            elementMap.put(dimName, tupleL);
                        } else if (!listOfDataLocators.containsKey(key)) {
                            tupleL = elementMap.containsKey(dimName) ? elementMap.get(dimName) : new ArrayList();
                            if (listOfRASEValues.containsKey(key)) {
                                tupleL.add((String)listOfRASEValues.get(key));
                                elementMap.put(dimName, tupleL);
                            }
                        }
                    }
                    if (totalTupleMembers.containsKey(dimName) && !(listOfTotalMembers = totalTupleMembers.get(dimName)).isEmpty()) {
                        ArrayList<String> tupleMember = new ArrayList<String>();
                        for (String member : listOfTotalMembers) {
                            tupleMember.add(member);
                        }
                        elementMap.put(dimName, tupleMember);
                    }
                }
                MDXGenerationUtil.applyDebugStatement("  DimList: " + elementMap, ShowDetail.class);
            }
        }
        catch (OLAPException oe) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(oe.getLocalizedMessage(), (Throwable)oe);
            }
            throw new IQueryServicesIllegalStateException(IQDataServicesResourceBundle.getMessageFormatter("ShowDetail.ShowDetailException.Message.txt", new Object[0]));
        }
        catch (MetadataException oe) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(oe.getLocalizedMessage(), (Throwable)oe);
            }
            throw new IQueryServicesIllegalStateException(IQDataServicesResourceBundle.getMessageFormatter("ShowDetail.ShowDetailException.Message.txt", new Object[0]));
        }
        catch (GenerationException oe) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(oe.getLocalizedMessage(), (Throwable)oe);
            }
            throw new IQueryServicesIllegalStateException(IQDataServicesResourceBundle.getMessageFormatter("ShowDetail.ShowDetailException.Message.txt", new Object[0]));
        }
        return elementMap;
    }

    private static String getQuery(OLAPDataSetInterface model, TupleElementInterface[] selectedTupleElements, int maxRows, int firstRowSet) {
        StringBuilder query = new StringBuilder();
        try {
            LinkedHashMap<String, ArrayList<String>> totalAllTupleMembers;
            String cubeName = OLAPUtilities.getCubeNameFromOLAPModel(model);
            if (cubeName == null) {
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(query.toString());
                }
                throw new IQueryServicesIllegalStateException(IQDataServicesResourceBundle.getMessageFormatter("ShowDetail.ShowDetailNullException.Message.txt", new Object[0]));
            }
            BusinessQuery businessQuery = null;
            if (!(model instanceof BusinessQueryProviderInterface)) {
                MDXGenerationUtil.applyDebugStatement(model.toString(), ShowDetail.class);
                throw new IQueryServicesIllegalStateException(IQDataServicesResourceBundle.getMessageFormatter("ShowDetail.ShowDetailBadModelException.Message.txt", new Object[0]));
            }
            businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            MetadataInterface olapMeta = model.getDatabaseMetadata();
            AxisInterface[] axes = OLAPUtilities.getAxisDefinition(model);
            if (axes == null) {
                throw new IQueryServicesIllegalStateException("Axes is null for " + cubeName);
            }
            LinkedHashMap<String, ArrayList<String>> totalTupleMembers = ShowDetail.getTotalMembersInTuples(axes, selectedTupleElements);
            totalTupleMembers = ShowDetail.getSubtotalElements(selectedTupleElements, totalTupleMembers);
            TupleElementInterface[] tupleElementForAllAxis = OLAPUtilities.getTupleElements(axes, selectedTupleElements, cubeName, olapMeta, businessQuery);
            LinkedHashMap<String, ArrayList<String>> elementMap = ShowDetail.getMemberElementMap(model, olapMeta, tupleElementForAllAxis, businessQuery, cubeName, totalTupleMembers, selectedTupleElements);
            if (elementMap.size() == 0 && (elementMap = ShowDetail.getMemberElementMap(model, olapMeta, tupleElementForAllAxis, businessQuery, cubeName, totalAllTupleMembers = ShowDetail.getAllTotalMembersInTuples(axes, selectedTupleElements), selectedTupleElements)).size() == 0) {
                throw new IQueryServicesIllegalStateException(IQDataServicesResourceBundle.getMessageFormatter("ShowDetail.ShowDetailNullException.Message.txt", new Object[0]));
            }
            boolean isUseNonNestedCJ = Boolean.valueOf(System.getProperty("SASQueryServices.useNonNestedCrossJoin", "true"));
            boolean isMeasureInDrillThru = Boolean.valueOf(System.getProperty("SASQueryServices.measureInDrillThru", "true"));
            String crossJoinString = "";
            crossJoinString = isUseNonNestedCJ ? ShowDetail.buildNonNestedCrossJoin(elementMap) : ShowDetail.buildNestedCrossJoin(elementMap);
            query.append(crossJoinString);
            StringBuilder lastQuery = new StringBuilder();
            if (maxRows > 0 && firstRowSet > 0) {
                lastQuery.append("DRILLTHROUGH MAXROWS ").append(maxRows).append(" FIRSTROWSET ").append(firstRowSet).append(" SELECT ").append(ShowDetail.applyAxisFilter(selectedTupleElements, businessQuery, query, olapMeta)).append(" ON COLUMNS FROM [" + cubeName + "]");
            } else {
                lastQuery.append("DRILLTHROUGH SELECT ").append(ShowDetail.applyAxisFilter(selectedTupleElements, businessQuery, query, olapMeta)).append(" ON COLUMNS FROM [" + cubeName + "]");
            }
            if (isMeasureInDrillThru) {
                for (int i = 0; i < selectedTupleElements.length; ++i) {
                    if (selectedTupleElements[i].getType() != TupleElementType.MEASURE) continue;
                    String tupleName = selectedTupleElements[i].getLabel();
                    String measureUniqueName = "";
                    List<DataItem> resultItems = businessQuery.getResultItems();
                    for (DataItem dataItem : resultItems) {
                        if (!dataItem.getLabel().equals(tupleName)) continue;
                        ExpressionInterface expression = dataItem.getExpression();
                        if (!(expression instanceof Measure)) break;
                        Measure measure = (Measure)expression;
                        try {
                            measureUniqueName = measure.getMeasureUniqueName();
                        }
                        catch (MetadataException e) {
                            if (!_logger.isEnabled(Level.ERROR)) break;
                            _logger.error(e.getLocalizedMessage() + ":" + measureUniqueName, (Throwable)e);
                        }
                        break;
                    }
                    if (measureUniqueName.isEmpty()) break;
                    lastQuery.append(" WHERE (" + measureUniqueName + ")");
                    break;
                }
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("query===" + lastQuery);
            }
            return lastQuery.toString();
        }
        catch (OLAPException se) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(query.toString());
                _logger.error(se.getLocalizedMessage(), (Throwable)se);
            }
            throw new IQueryServicesIllegalStateException(se.getLocalizedMessage());
        }
        catch (MetadataException se) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(query.toString());
                _logger.error(se.getLocalizedMessage(), (Throwable)se);
            }
            throw new IQueryServicesIllegalStateException(se.getLocalizedMessage());
        }
    }

    private static String buildNonNestedCrossJoin(LinkedHashMap<String, ArrayList<String>> elementMap) {
        int numberOfDimensions = elementMap.size();
        StringBuilder temporaryQueryString = new StringBuilder();
        if (numberOfDimensions > 1) {
            temporaryQueryString.append("CROSSJOIN(");
        }
        for (String dimensionName : elementMap.keySet()) {
            ArrayList<String> elementList = elementMap.get(dimensionName);
            temporaryQueryString.append("{");
            int count = 0;
            for (int i = 0; i < elementList.size(); ++i) {
                String elementString = elementList.get(i);
                if (elementString.length() <= 0) continue;
                temporaryQueryString.append(elementString).append(", ");
                ++count;
            }
            if (count <= 0) continue;
            temporaryQueryString.setLength(temporaryQueryString.length() - 2);
            temporaryQueryString.append("}");
            if (numberOfDimensions <= 1) continue;
            temporaryQueryString.append(",");
        }
        if (numberOfDimensions > 2) {
            temporaryQueryString.append(numberOfDimensions);
            temporaryQueryString.append(")");
        } else if (numberOfDimensions == 2) {
            int lastCommaIndex = temporaryQueryString.lastIndexOf(",");
            temporaryQueryString.setLength(lastCommaIndex);
            temporaryQueryString.append(")");
        }
        return temporaryQueryString.toString();
    }

    private static String buildNestedCrossJoin(LinkedHashMap<String, ArrayList<String>> elementMap) {
        int numberOfDimensions = elementMap.size();
        StringBuilder temporaryQueryString = new StringBuilder();
        int countOfCrossjoins = 0;
        for (String dimensionName : elementMap.keySet()) {
            ArrayList<String> elementList = elementMap.get(dimensionName);
            if (numberOfDimensions >= 2 && elementList.size() > 0) {
                temporaryQueryString.append("CROSSJOIN(").append("{");
                ++countOfCrossjoins;
            } else if (numberOfDimensions < 2) {
                temporaryQueryString.append("{");
            }
            int count = 0;
            --numberOfDimensions;
            for (int i = 0; i < elementList.size(); ++i) {
                String elementString = elementList.get(i);
                if (elementString.length() <= 0) continue;
                temporaryQueryString.append(elementString).append(", ");
                ++count;
            }
            if (count <= 0) continue;
            temporaryQueryString.setLength(temporaryQueryString.length() - 2);
            temporaryQueryString.append("}");
            if (numberOfDimensions <= 0) continue;
            temporaryQueryString.append(",");
        }
        for (int i = 0; i < countOfCrossjoins; ++i) {
            temporaryQueryString.append(")");
        }
        return temporaryQueryString.toString();
    }

    private static String getRankMDXExpression(String currentExpression, BusinessQueryRankFilter step, MetadataInterface metaI, TupleElementInterface[] tupleElements) {
        String includeTiesError = IQDataServicesResourceBundle.getStringResource("RankFilterIncludeTiesError.txt");
        String rankOrderError = IQDataServicesResourceBundle.getStringResource("RankFilterRankOrderError.txt");
        String rankTypeError = IQDataServicesResourceBundle.getStringResource("RankFilterRankTypeError.txt");
        if (step.isIncludeTies() && !step.getRankType().equalsIgnoreCase("Count")) {
            _logger.error(includeTiesError);
            return currentExpression;
        }
        StringBuffer MDXExpression = new StringBuffer();
        if (step.getRankOrder().equals("Top")) {
            MDXExpression.append("Top");
        } else if (step.getRankOrder().equals("Bottom")) {
            MDXExpression.append("Bottom");
        } else {
            _logger.error(rankOrderError);
            return currentExpression;
        }
        if (step.getRankType().equals("Count")) {
            MDXExpression.append("Count(");
        } else if (step.getRankType().equals("Percent")) {
            MDXExpression.append("Percent(");
        } else if (step.getRankType().equals("Sum")) {
            MDXExpression.append("Sum(");
        } else {
            _logger.error(rankTypeError);
            return currentExpression;
        }
        MDXExpression.append("{").append(currentExpression).append("}").append(", ");
        ArrayList<String> byNames = null;
        List byRankQualifier = step.getRankQualifiers();
        if (byRankQualifier != null) {
            byNames = new ArrayList<String>();
            for (int i = 0; i < byRankQualifier.size(); ++i) {
                String daCore;
                block30: {
                    Object obj = byRankQualifier.get(i);
                    if (obj instanceof StringExpression) {
                        StringExpression s = (StringExpression)obj;
                        String ss = null;
                        try {
                            ss = s.getText();
                        }
                        catch (MetadataException metadataException) {
                            // empty catch block
                        }
                        if (ss == null) continue;
                        byNames.add(ss);
                        continue;
                    }
                    if (!(obj instanceof ExpressionInterface)) continue;
                    ExpressionInterface da = (ExpressionInterface)obj;
                    daCore = null;
                    try {
                        daCore = ShowDetail.buildExpression(da, metaI);
                    }
                    catch (GenerationException e) {
                        if (!_logger.isEnabled(ERROR_LEVEL)) break block30;
                        _logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if (daCore == null) continue;
                byNames.add(daCore);
            }
        }
        MDXExpression.append(step.getValue());
        if (byNames == null) {
            if (step.isIncludeTies()) {
                MDXExpression.append(", TRUE");
            }
            MDXExpression.append(")");
            return MDXExpression.toString();
        }
        if (byNames.size() == 1) {
            String itemByNames = (String)byNames.get(0);
            if (itemByNames != null) {
                MDXExpression.append(", ").append(itemByNames);
            }
        } else {
            StringBuffer RankNameBuf = new StringBuffer();
            int numOfRankNames = 0;
            for (int i = 0; i < byNames.size(); ++i) {
                String rankName;
                if (i == 0) {
                    MDXExpression.append(", ");
                }
                if ((rankName = (String)byNames.get(i)) == null) {
                    i = byNames.size();
                    continue;
                }
                if (i > 0) {
                    RankNameBuf.append(", ");
                }
                RankNameBuf.append((String)byNames.get(i));
                ++numOfRankNames;
            }
            if (numOfRankNames > 1) {
                MDXExpression.append("(");
            }
            MDXExpression.append(RankNameBuf.toString());
            if (numOfRankNames > 1) {
                MDXExpression.append(")");
            }
        }
        if (step.isIncludeTies()) {
            MDXExpression.append(", TRUE");
        }
        MDXExpression.append(")");
        return MDXExpression.toString();
    }

    private static LinkedHashMap<String, ArrayList<String>> getSubtotalElements(TupleElementInterface[] selectedTuples, LinkedHashMap<String, ArrayList<String>> totalMembers) throws OLAPException {
        for (int aSingleTupleIndex = 0; aSingleTupleIndex < selectedTuples.length; ++aSingleTupleIndex) {
            if (selectedTuples[aSingleTupleIndex].getType() != TupleElementType.SUBTOTAL || selectedTuples[aSingleTupleIndex].getLevelDepth() <= 0 || selectedTuples[aSingleTupleIndex].isContextual()) continue;
            String dimName = ShowDetail.getDimNameFromUniqueLevelName(selectedTuples[aSingleTupleIndex].getUniqueLevelName());
            TupleInterface singleTupleFromSelection = selectedTuples[aSingleTupleIndex].getTuple();
            int tupleDepthIndex = singleTupleFromSelection.getTupleDepth() - 1;
            TupleInterface[] allMemberElementsOnAxisForTuple = singleTupleFromSelection.getAxis().getTuples(-12, -18);
            int lastIndex = selectedTuples[aSingleTupleIndex].getTupleElementIndex();
            int maxCoord = selectedTuples[aSingleTupleIndex].getMaximumCoordinate();
            TupleElementInterface[] elems = singleTupleFromSelection.getElement(tupleDepthIndex).getTuple().getElements(0, -1);
            if (elems.length <= 1) continue;
            String subTotalElement = elems[lastIndex].getName();
            if (allMemberElementsOnAxisForTuple.length <= 1) continue;
            ArrayList<String> insideMembers = new ArrayList<String>();
            TupleElementInterface[] maxCoordTupleElements = allMemberElementsOnAxisForTuple[maxCoord].getElements(0, -1);
            int subTotalElementIndex = 0;
            for (int a = 0; a < maxCoordTupleElements.length; ++a) {
                if (!maxCoordTupleElements[a].getName().equalsIgnoreCase(subTotalElement)) continue;
                subTotalElementIndex = a;
                break;
            }
            for (int b = maxCoord; b >= 0; --b) {
                String dimNameFromTuple;
                if (allMemberElementsOnAxisForTuple[b].getTupleDepth() <= subTotalElementIndex) continue;
                String singleTupleElementName = allMemberElementsOnAxisForTuple[b].getElement(subTotalElementIndex).getName();
                if (!singleTupleElementName.equalsIgnoreCase(subTotalElement)) break;
                TupleElementInterface insideElements = allMemberElementsOnAxisForTuple[b].getElement(allMemberElementsOnAxisForTuple[b].getTupleDepth() - 1);
                if (insideElements.getType() == TupleElementType.SUBTOTAL || !(dimNameFromTuple = ShowDetail.getDimNameFromUniqueLevelName(insideElements.getUniqueLevelName())).equals(dimName)) continue;
                insideMembers.add(insideElements.getName());
            }
            if (insideMembers.isEmpty()) continue;
            totalMembers.put(dimName, insideMembers);
        }
        return totalMembers;
    }

    private static LinkedHashMap<String, ArrayList<String>> getTotalMembersInTuples(AxisInterface[] axes, TupleElementInterface[] tupleSelected) {
        LinkedHashMap<String, ArrayList<String>> totalTupleMembers;
        block5: {
            totalTupleMembers = new LinkedHashMap<String, ArrayList<String>>();
            try {
                for (int indexOfTupleSelected = 0; indexOfTupleSelected < tupleSelected.length; ++indexOfTupleSelected) {
                    String uniqueLevelName = tupleSelected[indexOfTupleSelected].getUniqueLevelName();
                    String dimNameFromUniqueLevel = ShowDetail.getDimNameFromUniqueLevelName(uniqueLevelName);
                    TupleInterface singleTuple = tupleSelected[indexOfTupleSelected].getTuple();
                    if (singleTuple.getAxis().getAxisNumber() == -1 || tupleSelected[indexOfTupleSelected].isContextual() || tupleSelected[indexOfTupleSelected].getType() != TupleElementType.TOTAL && tupleSelected[indexOfTupleSelected].getType() != TupleElementType.SUBTOTAL) continue;
                    TupleElementInterface[] elementsOfSingleTuple = singleTuple.getElements(0, -1);
                    for (int indexOfElements = 0; indexOfElements < elementsOfSingleTuple.length; ++indexOfElements) {
                        String subTotalNAme;
                        String uniqueLevelNameEI = elementsOfSingleTuple[indexOfElements].getUniqueLevelName();
                        String dimNameFromTupleElement = ShowDetail.getDimNameFromUniqueLevelName(uniqueLevelNameEI);
                        if (!dimNameFromUniqueLevel.equalsIgnoreCase(dimNameFromTupleElement) || elementsOfSingleTuple[indexOfElements].isContextual() || elementsOfSingleTuple[indexOfElements].getLevelDepth() <= 0 || elementsOfSingleTuple[indexOfElements].getType() != TupleElementType.TOTAL && elementsOfSingleTuple[indexOfElements].getType() != TupleElementType.SUBTOTAL) continue;
                        ArrayList<String> membersOfTotalDimension = totalTupleMembers.get(dimNameFromTupleElement);
                        if (membersOfTotalDimension == null) {
                            membersOfTotalDimension = new ArrayList();
                        }
                        if (membersOfTotalDimension.contains(subTotalNAme = elementsOfSingleTuple[indexOfElements].getName())) continue;
                        membersOfTotalDimension.add(subTotalNAme);
                        totalTupleMembers.put(dimNameFromTupleElement, membersOfTotalDimension);
                    }
                }
            }
            catch (OLAPException e) {
                if (!_logger.isEnabled(ERROR_LEVEL)) break block5;
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return totalTupleMembers;
    }

    private static LinkedHashMap<String, ArrayList<String>> getAllTotalMembersInTuples(AxisInterface[] axes, TupleElementInterface[] tupleSelected) {
        LinkedHashMap<String, ArrayList<String>> totalTupleMembers;
        block5: {
            totalTupleMembers = new LinkedHashMap<String, ArrayList<String>>();
            try {
                for (int indexOfTupleSelected = 0; indexOfTupleSelected < tupleSelected.length; ++indexOfTupleSelected) {
                    String uniqueLevelName = tupleSelected[indexOfTupleSelected].getUniqueLevelName();
                    String dimNameFromUniqueLevel = ShowDetail.getDimNameFromUniqueLevelName(uniqueLevelName);
                    TupleInterface singleTuple = tupleSelected[indexOfTupleSelected].getTuple();
                    if (singleTuple.getAxis().getAxisNumber() == -1 || tupleSelected[indexOfTupleSelected].isContextual() || tupleSelected[indexOfTupleSelected].getType() != TupleElementType.TOTAL && tupleSelected[indexOfTupleSelected].getType() != TupleElementType.SUBTOTAL) continue;
                    TupleElementInterface[] elementsOfSingleTuple = singleTuple.getElements(0, -1);
                    for (int indexOfElements = 0; indexOfElements < elementsOfSingleTuple.length; ++indexOfElements) {
                        String subTotalNAme;
                        String uniqueLevelNameEI = elementsOfSingleTuple[indexOfElements].getUniqueLevelName();
                        String dimNameFromTupleElement = ShowDetail.getDimNameFromUniqueLevelName(uniqueLevelNameEI);
                        if (!dimNameFromUniqueLevel.equalsIgnoreCase(dimNameFromTupleElement) || elementsOfSingleTuple[indexOfElements].isContextual() || elementsOfSingleTuple[indexOfElements].getType() != TupleElementType.TOTAL && elementsOfSingleTuple[indexOfElements].getType() != TupleElementType.SUBTOTAL) continue;
                        ArrayList<String> membersOfTotalDimension = totalTupleMembers.get(dimNameFromTupleElement);
                        if (membersOfTotalDimension == null) {
                            membersOfTotalDimension = new ArrayList();
                        }
                        if (membersOfTotalDimension.contains(subTotalNAme = elementsOfSingleTuple[indexOfElements].getName())) continue;
                        membersOfTotalDimension.add(subTotalNAme);
                        totalTupleMembers.put(dimNameFromTupleElement, membersOfTotalDimension);
                    }
                }
            }
            catch (OLAPException e) {
                if (!_logger.isEnabled(ERROR_LEVEL)) break block5;
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return totalTupleMembers;
    }

    private static boolean hasCalculatedMeasureOrTimeExpressionMeasureInAxisFilter(List listOfMeasures) {
        boolean returnValue = false;
        for (Object object : listOfMeasures) {
            ExpressionInterface expression;
            if (object instanceof TimeExpressionMeasure || object instanceof ResourceAwareStringExpression) {
                returnValue = true;
                break;
            }
            if (!(object instanceof DataItem) || !((expression = ((DataItem)object).getExpression()) instanceof TimeExpressionMeasure) && !(expression instanceof ResourceAwareStringExpression)) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    private static boolean isGrandTotalSelected(TupleElementInterface[] tupleElems) {
        boolean returnValue;
        block6: {
            returnValue = false;
            try {
                TupleElementType firstType = tupleElems[0].getType();
                TupleElementType lastType = tupleElems[tupleElems.length - 1].getType();
                if (firstType == TupleElementType.TOTAL && lastType == TupleElementType.TOTAL) {
                    returnValue = true;
                } else if (firstType == TupleElementType.TOTAL && lastType == TupleElementType.SUBTOTAL) {
                    TupleInterface tuplesOnLastTupleElement = tupleElems[tupleElems.length - 1].getTuple();
                    TupleElementInterface[] tuplesInStackOnLast = tuplesOnLastTupleElement.getElements(0, -1);
                    TupleElementType firstTypeLastTuple = tuplesInStackOnLast[0].getType();
                    TupleElementType lastTypeLastTuple = tuplesInStackOnLast[tuplesInStackOnLast.length - 1].getType();
                    if (firstTypeLastTuple == TupleElementType.TOTAL && (lastTypeLastTuple == TupleElementType.SUBTOTAL || lastTypeLastTuple == TupleElementType.TOTAL)) {
                        returnValue = true;
                    }
                }
            }
            catch (OLAPException e) {
                if (!_logger.isEnabled(ERROR_LEVEL)) break block6;
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return returnValue;
    }

    private static boolean isShowDetailAlwaysOnTotalCell(String showDetailAlwaysOnTotalCell) {
        boolean returnValue = false;
        String value = System.getProperty(showDetailAlwaysOnTotalCell);
        if (value != null && (value.toUpperCase().startsWith("Y") || value.toUpperCase().startsWith("T"))) {
            returnValue = true;
        }
        return returnValue;
    }

    private static boolean isShowDetailSelectiveOnTotalCell(String showDetailSelectiveOnTotalCell) {
        boolean returnValue = false;
        String value = System.getProperty(showDetailSelectiveOnTotalCell);
        if (value != null && (value.toUpperCase().startsWith("Y") || value.toUpperCase().startsWith("T"))) {
            returnValue = true;
        }
        return returnValue;
    }

    @SASScope
    public static boolean isShowDetailValid(OLAPDataSetInterface model, TupleElementInterface[] tupleElements) {
        boolean returnValue = true;
        BusinessQuery businessQuery = null;
        if (model instanceof BusinessQueryProviderInterface && (businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery()) == null) {
            _logger.error("This is not a businessQuery. ", new Throwable());
        }
        if (businessQuery == null) {
            returnValue = false;
        } else if (ShowDetail.isTotalSelected(tupleElements, businessQuery)) {
            Iterator<StepInterface> rowAxisFilter = businessQuery.getSteps(Role.ROW).iterator();
            Iterator<StepInterface> colAxisFilter = businessQuery.getSteps(Role.COLUMN).iterator();
            if (ShowDetail.isShowDetailSelectiveOnTotalCell(PROPERTY_ACTIVATE_SHOWDETAIL_SELECTIVE_ON_TOTAL_CELL) && !ShowDetail.isShowDetailAlwaysOnTotalCell(PROPERTY_ACTIVATE_SHOWDETAIL_ALWAYS_ON_TOTAL_CELL) && (rowAxisFilter.hasNext() || colAxisFilter.hasNext())) {
                returnValue = false;
            } else if (!ShowDetail.isShowDetailAlwaysOnTotalCell(PROPERTY_ACTIVATE_SHOWDETAIL_ALWAYS_ON_TOTAL_CELL) && !ShowDetail.isShowDetailSelectiveOnTotalCell(PROPERTY_ACTIVATE_SHOWDETAIL_SELECTIVE_ON_TOTAL_CELL)) {
                returnValue = false;
            }
        }
        return returnValue;
    }

    private static boolean isTotalSelected(TupleElementInterface[] tupleElems, BusinessQuery model) {
        boolean returnValue = false;
        if (model.getTotalMode().equals(BusinessQueryTotalModeType.VISUAL_VALUES)) {
            for (int index = 0; index < tupleElems.length; ++index) {
                try {
                    TupleElementType type = tupleElems[index].getType();
                    if (type != TupleElementType.TOTAL && type != TupleElementType.SUBTOTAL) continue;
                    returnValue = true;
                    break;
                }
                catch (OLAPException e) {
                    if (!_logger.isEnabled(ERROR_LEVEL)) continue;
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return returnValue;
    }
}

